define("qtype_coderunner/outputdisplayarea",["exports","core/ajax","core/str"],(function(_exports,_ajax,_str){var obj;
/**
   * A module used for running code using the Coderunner webservice (CRWS) and displaying output. Originally
   * developed for use in the Scratchpad UI. It has three modes of operation:
   * - 'text': Just display the output as text, html escaped.
   * - 'json': The recommended way to display programs that use stdin or output images (or both).
   *      - Accepts JSON in the CRWS response output with fields:
   *          - "returncode": Error/return code from running program.
   *          - "stdout": Stdout text from running program.
   *          - "stderr": Error text from running program.
   *          - "files": An object containing filenames mapped to base64 encoded images.
   *                     These will be displayed below any stdout text.
   *      - When input from stdin is required the returncode 42 should be returned, raise this
   *        any time the program asks for input. An (html) input will be added after the last stdout received.
   *        When enter is pressed, runCode is called with value of the input added to the stdin string.
   *        This repeats until returncode is no longer 42.
   * - 'html': Display program output as raw html inside the output area.
   *      - This can be used to show images and insert other HTML tags (and beyond).
   *      - Giving an <input> tag the class 'coderunner-run-input' will add an event that
   *        on pressing enter will call the runCode method again with the value of that input field added to stdin.
   *        This method of receiving stdin is harder to use but more flexible than JSON, enter at your own risk.
   *
   * @module qtype_coderunner/outputdisplayarea
   * @copyright  James Napier, 2023, The University of Canterbury
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.OutputDisplayArea=void 0,_ajax=(obj=_ajax)&&obj.__esModule?obj:{default:obj};const JSON_DISPLAY_PROPS=["returncode","stdout","stderr","files"],setLangString=async _ref=>{let{stringName:stringName,callback:callback,node:node}=_ref;const langString=await(async stringName=>await(0,_str.get_string)(stringName,"qtype_coderunner"))(stringName);callback instanceof Function?callback(langString):node.innerText=langString},combinedOutput=response=>response.cmpinfo+response.output+response.stderr,getImage=function(base64){let type=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"png";const image=document.createElement("img");return image.src="data:image/".concat(type,";base64,").concat(base64),image};_exports.OutputDisplayArea=class{constructor(displayAreaId,outputMode,lang,sandboxParams){this.displayAreaId=displayAreaId,this.lang=lang,this.mode=outputMode,this.sandboxParams=sandboxParams,this.textDisplay=document.getElementById(displayAreaId+"-text"),this.imageDisplay=document.getElementById(displayAreaId+"-images"),this.prevRunSettings=null}clearDisplay(){this.textDisplay.innerHTML="",this.imageDisplay.innerHTML="",this.textDisplay.style.backgroundColor="#eff",this.imageDisplay.style.backgroundColor="#eff"}displayText(response){this.textDisplay.innerText=combinedOutput(response)}displayHtml(response){this.textDisplay.innerHTML=combinedOutput(response);const inputEl=this.textDisplay.querySelector(".coderunner-run-input");inputEl&&this.addInputEvents(inputEl)}displayJson(response){const result=this.validateJson(response.output);if(null===result)return;let text=result.stdout;42!==result.returncode&&(text+=result.stderr),13==result.returncode&&setLangString({stringName:"error_timeout",callback:langString=>{this.textDisplay.innerText+="*** ".concat(langString," ***\n")}});const numImages=this.displayImages(result.files);""===text.trim()&&42!==result.returncode?0==numImages&&this.displayNoOutput(null):this.textDisplay.innerText=text,42===result.returncode&&this.addInput()}displayError(error_msg){this.textDisplay.style.backgroundColor="#faa",this.textDisplay.innerText=error_msg}validateJson(jsonString){let result=null;try{result=JSON.parse(jsonString)}catch(e){return setLangString({stringName:"outputdisplayarea_invalid_json",callback:langString=>{this.displayError("".concat(langString,"\n")+"".concat(jsonString,"\n")+"".concat(e.message," \n"))}}),null}const missing=((obj,props)=>props.filter((prop=>!obj.hasOwnProperty(prop))))(result,JSON_DISPLAY_PROPS);return missing.length>0?(setLangString({stringName:"outputdisplayarea_missing_json_fields",callback:langString=>{this.displayError("".concat(langString,"\n")+"".concat(missing.join()))}}),null):result}displayNoOutput(response){const isNoOutput=!response||0===combinedOutput(response).length;if(isNoOutput||null===response){const span=document.createElement("span");span.style.color="red",setLangString({stringName:"nooutput",node:span}),this.clearDisplay(),this.textDisplay.append(span)}return isNoOutput}display(response){const error=(response=>{const ERROR_RESPONSES=[[1,0,"error_access_denied"],[2,0,"error_unknown_language"],[3,0,"error_access_denied"],[4,0,"error_submission_limit_reached"],[5,0,"error_sandbox_server_overload"],[0,11,""],[0,12,""],[0,13,"error_timeout"],[0,15,""],[0,17,"error_memory_limit"],[0,21,"error_sandbox_server_overload"],[0,30,"error_excessive_output"]];for(let i=0;i<ERROR_RESPONSES.length;i++){let row=ERROR_RESPONSES[i];if(row[0]==response.error&&(0!=response.error||response.result==row[1]))return row[2]}return"error_unknown_runtime"})(response);""===error?this.displayNoOutput(response)||("json"===this.mode?this.displayJson(response):"html"===this.mode?this.displayHtml(response):"text"===this.mode?this.displayText(response):setLangString({stringName:"outputdisplayarea_invalid_mode",callback:langString=>{this.displayError(langString+" "+this.mode)}})):setLangString({stringName:error,callback:langString=>{this.textDisplay.innerText="*** ".concat(langString," ***\n")}})}runCode(code,stdin){let shouldClearDisplay=arguments.length>2&&void 0!==arguments[2]&&arguments[2];this.prevRunSettings=[code,stdin],shouldClearDisplay&&this.clearDisplay(),_ajax.default.call([{methodname:"qtype_coderunner_run_in_sandbox",args:{contextid:M.cfg.contextid,sourcecode:code,language:this.lang,stdin:stdin,params:JSON.stringify(this.sandboxParams)},done:responseJson=>{const response=JSON.parse(responseJson);this.display(response)},fail:error=>{this.displayError(error.message)}}])}runCodeDirect(code,stdin,jobeServers,apiKeys){let shouldClearDisplay=arguments.length>4&&void 0!==arguments[4]&&arguments[4];this.prevRunSettings=[code,stdin],shouldClearDisplay&&this.clearDisplay();const lang=this.lang.toLowerCase(),runspec={run_spec:{language_id:lang,sourcecode:code,sourcefilename:"java"===lang?this.getJavaFilename(code):"__tester__.".concat(lang),input:stdin}},xhr=new XMLHttpRequest,t=this;xhr.onreadystatechange=function(){if(xhr.readyState==XMLHttpRequest.DONE)if(200===xhr.status||203===xhr.status){const sandboxResponse=t.convertToSandboxFormat(xhr.responseText);t.display(sandboxResponse)}else setLangString({stringName:"scratchpad_ui_request_failed",callback:langString=>{t.displayError(langString+" ".concat(xhr.status,": ").concat(xhr.statusText,". ").concat(xhr.responseText))}})},xhr.onerror=function(){setLangString({stringName:"scratchpad_ui_error",callback:langString=>{t.displayError(langString)}})};const index=Math.floor(Math.random()*jobeServers.length),jobeServer=jobeServers[index].toLowerCase();jobeServer.startsWith("http://")||jobeServer.startsWith("https://")?apiKeys&&jobeServers.length!=apiKeys.length?setLangString({stringName:"scratchpad_ui_bad_api_keys",callback:langString=>{t.displayError(langString)}}):(xhr.open("POST","".concat(jobeServer,"/jobe/index.php/restapi/runs"),!0),xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept","application/json"),apiKeys&&xhr.setRequestHeader("X-API-KEY",apiKeys[index]),xhr.send(JSON.stringify(runspec))):setLangString({stringName:"scratchpad_ui_no_protocol",callback:langString=>{t.displayError(langString)}})}getJavaFilename(code){const matches=code.match(/(^|\W)public\s+class\s+(\w+)[^{]*\{.*?((public\s([a-z]*\s)*static)|(static\s([a-z]*\s)*public))\s([a-z]*\s)*void\s+main\s*\(\s*String/ms);return matches?matches[2]+".java":"NO_PUBLIC_CLASS_FOUND.java"}convertToSandboxFormat(responseText){let response="";try{response=JSON.parse(responseText)}catch(e){return{error:7,stderr:"HTTP response was ".concat(JSON.stringify(responseText))}}if(21===response.outcome)return{error:9};{const stderr=response.stderr.trim();return{error:0,stderr:stderr,result:stderr?12:response.outcome,signal:0,cmpinfo:response.cmpinfo,output:response.stdout}}}addInput(){const inputId="".concat(this.displayAreaId,"-input-field");this.textDisplay.innerHTML+='<input type="text" id="'.concat(inputId,'" class="').concat("coderunner-run-input",'">');const inputEl=document.getElementById(inputId);setLangString({stringName:"enter_to_submit",callback:langString=>{inputEl.placeholder+=langString}}),this.addInputEvents(inputEl)}addInputEvents(inputEl){inputEl.focus(),inputEl.addEventListener("keydown",(e=>{"Enter"===e.key&&e.preventDefault()})),inputEl.addEventListener("keyup",(e=>{if("Enter"===e.key){const line=inputEl.value;inputEl.remove(),this.textDisplay.innterHTML+=line,this.prevRunSettings[1]+=line+"\n",this.runCode(...this.prevRunSettings,!1)}}))}displayImages(files){let numImages=0;for(const[fname,fcontents]of Object.entries(files)){const fileType=fname.split(".")[1];if(fileType){const image=getImage(fcontents,fileType);this.imageDisplay.append(image),numImages+=1}else setLangString({stringName:"outputdisplayarea_missing_image_extension",callback:langString=>{this.imageDisplay("".concat(langString," ")+fname)}})}return numImages}}}));

//# sourceMappingURL=outputdisplayarea.min.js.map