/******************************************************************************
 *
 * A module for use by ui_graph, defining classes Node, Link, SelfLink,
 * StartLink and TemporaryLink
 *
 * @module qtype_coderunner/graphelements
 * @copyright  Richard Lobb, 2015, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_coderunner/graphelements",["qtype_coderunner/graphutil"],(function(util){function Node(parent,x,y){this.parent=parent,this.x=x,this.y=y,this.mouseOffsetX=0,this.mouseOffsetY=0,this.isAcceptState=!1,this.textBox=new TextBox("",this),this.caretPosition=0}function Link(parent,a,b){this.parent=parent,this.nodeA=a,this.nodeB=b,this.textBox=new TextBox("",this),this.lineAngleAdjust=0,this.caretPosition=0,this.parallelPart=.5,this.perpendicularPart=0}function SelfLink(parent,node,mouse){this.parent=parent,this.node=node,this.anchorAngle=0,this.mouseOffsetAngle=0,this.textBox=new TextBox("",this),mouse&&this.setAnchorPoint(mouse.x,mouse.y)}function StartLink(parent,node,start){this.parent=parent,this.node=node,this.deltaX=0,this.deltaY=0,start&&this.setAnchorPoint(start.x,start.y)}function TemporaryLink(parent,from,to){this.parent=parent,this.from=from,this.to=to}function Button(parent,topX,topY,text){this.BUTTON_WIDTH=60,this.BUTTON_HEIGHT=25,this.TEXT_OFFSET_X=30,this.TEXT_OFFSET_Y=17,this.topX=topX,this.topY=topY,this.parent=parent,this.text=text,this.highLighted=!1}function HelpBox(parent,topX,topY){Button.call(this,parent,topX,topY,"Help"),this.helpOpen=!1,this.LINE_HEIGHT=18,this.HELP_INDENT=5}function TextBox(text,parent){this.text=text,this.parent=parent,this.caretPosition=text.length,this.relDist=.5,this.offset=parent.parent.textOffset(),this.dragged=!1,this.boundingBox={}}return Node.prototype.setMouseStart=function(mouseX,mouseY){this.mouseOffsetX=this.x-mouseX,this.mouseOffsetY=this.y-mouseY},Node.prototype.setAnchorPoint=function(x,y){this.x=x+this.mouseOffsetX,this.y=y+this.mouseOffsetY},Node.prototype.trackMouse=function(mouseX,mouseY){this.x=this.mouseOffsetX+mouseX,this.y=this.mouseOffsetY+mouseY},Node.prototype.draw=function(c){c.beginPath(),c.arc(this.x,this.y,this.parent.nodeRadius(),0,2*Math.PI,!1),c.stroke(),this.textBox.draw(this.x,this.y,null,this),this.isAcceptState&&(c.beginPath(),c.arc(this.x,this.y,this.parent.nodeRadius()-6,0,2*Math.PI,!1),c.stroke())},Node.prototype.closestPointOnCircle=function(x,y){var dx=x-this.x,dy=y-this.y,scale=Math.sqrt(dx*dx+dy*dy);return{x:this.x+dx*this.parent.nodeRadius()/scale,y:this.y+dy*this.parent.nodeRadius()/scale}},Node.prototype.containsPoint=function(x,y){return(x-this.x)*(x-this.x)+(y-this.y)*(y-this.y)<this.parent.nodeRadius()*this.parent.nodeRadius()},Node.prototype.neighbours=function(links){for(var link,neighbours=[],i=0;i<links.length;i++)(link=links[i])instanceof Link&&(link.nodeA!==this||neighbours.includes(link.nodeB)?link.nodeB!==this||neighbours.includes(link.nodeA)||neighbours.push(link.nodeA):neighbours.push(link.nodeB));return neighbours},Node.prototype.traverseGraph=function(links,visited){var neighbours,neighbour;if(!visited.includes(this)){visited.push(this),neighbours=this.neighbours(links);for(var i=0;i<neighbours.length;i++)neighbour=neighbours[i],visited.includes(neighbour)||neighbour.traverseGraph(links,visited)}return visited},Link.prototype.getAnchorPoint=function(){var dx=this.nodeB.x-this.nodeA.x,dy=this.nodeB.y-this.nodeA.y,scale=Math.sqrt(dx*dx+dy*dy);return{x:this.nodeA.x+dx*this.parallelPart-dy*this.perpendicularPart/scale,y:this.nodeA.y+dy*this.parallelPart+dx*this.perpendicularPart/scale}},Link.prototype.setAnchorPoint=function(x,y){var dx=this.nodeB.x-this.nodeA.x,dy=this.nodeB.y-this.nodeA.y,scale=Math.sqrt(dx*dx+dy*dy);this.parallelPart=(dx*(x-this.nodeA.x)+dy*(y-this.nodeA.y))/(scale*scale),this.perpendicularPart=(dx*(y-this.nodeA.y)-dy*(x-this.nodeA.x))/scale,this.parallelPart>0&&this.parallelPart<1&&Math.abs(this.perpendicularPart)<this.parent.SNAP_TO_PADDING&&(this.lineAngleAdjust=(this.perpendicularPart<0)*Math.PI,this.perpendicularPart=0)},Link.prototype.getEndPointsAndCircle=function(){if(0===this.perpendicularPart){var midX=(this.nodeA.x+this.nodeB.x)/2,midY=(this.nodeA.y+this.nodeB.y)/2,start=this.nodeA.closestPointOnCircle(midX,midY),end=this.nodeB.closestPointOnCircle(midX,midY);return{hasCircle:!1,startX:start.x,startY:start.y,endX:end.x,endY:end.y}}var anchor=this.getAnchorPoint(),circle=util.circleFromThreePoints(this.nodeA.x,this.nodeA.y,this.nodeB.x,this.nodeB.y,anchor.x,anchor.y),isReversed=this.perpendicularPart>0,reverseScale=isReversed?1:-1,rRatio=reverseScale*this.parent.nodeRadius()/circle.radius,startAngle=Math.atan2(this.nodeA.y-circle.y,this.nodeA.x-circle.x)-rRatio,endAngle=Math.atan2(this.nodeB.y-circle.y,this.nodeB.x-circle.x)+rRatio;return{hasCircle:!0,startX:circle.x+circle.radius*Math.cos(startAngle),startY:circle.y+circle.radius*Math.sin(startAngle),endX:circle.x+circle.radius*Math.cos(endAngle),endY:circle.y+circle.radius*Math.sin(endAngle),startAngle:startAngle,endAngle:endAngle,circleX:circle.x,circleY:circle.y,circleRadius:circle.radius,reverseScale:reverseScale,isReversed:isReversed}},Link.prototype.draw=function(c){var textX,textY,textAngle,relDist,linkInfo=this.getEndPointsAndCircle();if(c.beginPath(),linkInfo.hasCircle?c.arc(linkInfo.circleX,linkInfo.circleY,linkInfo.circleRadius,linkInfo.startAngle,linkInfo.endAngle,linkInfo.isReversed):(c.moveTo(linkInfo.startX,linkInfo.startY),c.lineTo(linkInfo.endX,linkInfo.endY)),c.stroke(),linkInfo.hasCircle?this.parent.arrowIfReqd(c,linkInfo.endX,linkInfo.endY,linkInfo.endAngle-linkInfo.reverseScale*(Math.PI/2)):this.parent.arrowIfReqd(c,linkInfo.endX,linkInfo.endY,Math.atan2(linkInfo.endY-linkInfo.startY,linkInfo.endX-linkInfo.startX)),relDist=this.textBox.relDist,linkInfo.hasCircle){var startAngle=linkInfo.startAngle,endAngle=linkInfo.endAngle;endAngle<startAngle&&(endAngle+=2*Math.PI),textAngle=(1-relDist)*startAngle+relDist*endAngle,linkInfo.isReversed&&(textAngle+=(1-relDist)*(2*Math.PI)),textX=linkInfo.circleX+linkInfo.circleRadius*Math.cos(textAngle),textY=linkInfo.circleY+linkInfo.circleRadius*Math.sin(textAngle),this.textBox.draw(textX,textY,textAngle,this)}else textX=(1-relDist)*linkInfo.startX+relDist*linkInfo.endX,textY=(1-relDist)*linkInfo.startY+relDist*linkInfo.endY,textAngle=Math.atan2(linkInfo.endX-linkInfo.startX,linkInfo.startY-linkInfo.endY),this.textBox.draw(textX,textY,textAngle+this.lineAngleAdjust,this)},Link.prototype.containsPoint=function(x,y){var dx,dy,distance,linkInfo=this.getEndPointsAndCircle();if(!linkInfo.hasCircle){dx=linkInfo.endX-linkInfo.startX,dy=linkInfo.endY-linkInfo.startY;var length=Math.sqrt(dx*dx+dy*dy),percent=(dx*(x-linkInfo.startX)+dy*(y-linkInfo.startY))/(length*length);return distance=(dx*(y-linkInfo.startY)-dy*(x-linkInfo.startX))/length,percent>0&&percent<1&&Math.abs(distance)<this.parent.HIT_TARGET_PADDING}if(dx=x-linkInfo.circleX,dy=y-linkInfo.circleY,distance=Math.sqrt(dx*dx+dy*dy)-linkInfo.circleRadius,Math.abs(distance)<this.parent.HIT_TARGET_PADDING){var angle=Math.atan2(dy,dx),startAngle=linkInfo.startAngle,endAngle=linkInfo.endAngle;if(linkInfo.isReversed){var temp=startAngle;startAngle=endAngle,endAngle=temp}return endAngle<startAngle&&(endAngle+=2*Math.PI),angle<startAngle?angle+=2*Math.PI:angle>endAngle&&(angle-=2*Math.PI),angle>startAngle&&angle<endAngle}return!1},SelfLink.prototype.setMouseStart=function(x,y){this.mouseStartX=x,this.mouseStartY=y},SelfLink.prototype.setAnchorPoint=function(x,y){this.anchorAngle=Math.atan2(y-this.node.y,x-this.node.x)+this.mouseOffsetAngle;var snap=Math.round(this.anchorAngle/(Math.PI/2))*(Math.PI/2);Math.abs(this.anchorAngle-snap)<.1&&(this.anchorAngle=snap),this.anchorAngle<-Math.PI&&(this.anchorAngle+=2*Math.PI),this.anchorAngle>Math.PI&&(this.anchorAngle-=2*Math.PI)},SelfLink.prototype.getEndPointsAndCircle=function(){var circleX=this.node.x+1.5*this.parent.nodeRadius()*Math.cos(this.anchorAngle),circleY=this.node.y+1.5*this.parent.nodeRadius()*Math.sin(this.anchorAngle),circleRadius=.75*this.parent.nodeRadius(),startAngle=this.anchorAngle-.8*Math.PI,endAngle=this.anchorAngle+.8*Math.PI;return{hasCircle:!0,startX:circleX+circleRadius*Math.cos(startAngle),startY:circleY+circleRadius*Math.sin(startAngle),endX:circleX+circleRadius*Math.cos(endAngle),endY:circleY+circleRadius*Math.sin(endAngle),startAngle:startAngle,endAngle:endAngle,circleX:circleX,circleY:circleY,circleRadius:circleRadius}},SelfLink.prototype.draw=function(c){var linkInfo=this.getEndPointsAndCircle();c.beginPath(),c.arc(linkInfo.circleX,linkInfo.circleY,linkInfo.circleRadius,linkInfo.startAngle,linkInfo.endAngle,!1),c.stroke();var relDist=this.textBox.relDist,textAngle=linkInfo.startAngle*(1-relDist)+linkInfo.endAngle*relDist,textX=linkInfo.circleX+linkInfo.circleRadius*Math.cos(textAngle),textY=linkInfo.circleY+linkInfo.circleRadius*Math.sin(textAngle);this.textBox.draw(textX,textY,textAngle,this),this.parent.arrowIfReqd(c,linkInfo.endX,linkInfo.endY,linkInfo.endAngle+.4*Math.PI)},SelfLink.prototype.containsPoint=function(x,y){var linkInfo=this.getEndPointsAndCircle(),dx=x-linkInfo.circleX,dy=y-linkInfo.circleY,distance=Math.sqrt(dx*dx+dy*dy)-linkInfo.circleRadius;return Math.abs(distance)<this.parent.HIT_TARGET_PADDING},StartLink.prototype.setAnchorPoint=function(x,y){this.deltaX=x-this.node.x,this.deltaY=y-this.node.y,Math.abs(this.deltaX)<this.parent.SNAP_TO_PADDING&&(this.deltaX=0),Math.abs(this.deltaY)<this.parent.SNAP_TO_PADDING&&(this.deltaY=0)},StartLink.prototype.getEndPoints=function(){var startX=this.node.x+this.deltaX,startY=this.node.y+this.deltaY,end=this.node.closestPointOnCircle(startX,startY);return{startX:startX,startY:startY,endX:end.x,endY:end.y}},StartLink.prototype.draw=function(c){var endPoints=this.getEndPoints();c.beginPath(),c.moveTo(endPoints.startX,endPoints.startY),c.lineTo(endPoints.endX,endPoints.endY),c.stroke(),this.parent.arrowIfReqd(c,endPoints.endX,endPoints.endY,Math.atan2(-this.deltaY,-this.deltaX))},StartLink.prototype.containsPoint=function(x,y){var endPoints=this.getEndPoints(),dx=endPoints.endX-endPoints.startX,dy=endPoints.endY-endPoints.startY,length=Math.sqrt(dx*dx+dy*dy),percent=(dx*(x-endPoints.startX)+dy*(y-endPoints.startY))/(length*length),distance=(dx*(y-endPoints.startY)-dy*(x-endPoints.startX))/length;return percent>0&&percent<1&&Math.abs(distance)<this.parent.HIT_TARGET_PADDING},TemporaryLink.prototype.draw=function(c){c.beginPath(),c.moveTo(this.to.x,this.to.y),c.lineTo(this.from.x,this.from.y),c.stroke(),this.parent.arrowIfReqd(c,this.to.x,this.to.y,Math.atan2(this.to.y-this.from.y,this.to.x-this.from.x))},Button.prototype.containsPoint=function(x,y){return util.isInside({x:x,y:y},{x:this.topX,y:this.topY,width:this.BUTTON_WIDTH,height:this.BUTTON_HEIGHT})},Button.prototype.draw=function(c){this.highLighted?c.fillStyle="#FFFFFF":c.fillStyle="#F0F0F0",c.fillRect(this.topX,this.topY,this.BUTTON_WIDTH,this.BUTTON_HEIGHT),c.lineWidth=.5,c.strokeStyle="#000000",c.strokeRect(this.topX,this.topY,this.BUTTON_WIDTH,this.BUTTON_HEIGHT),c.font="12pt Arial",c.fillStyle="#000000",c.textAlign="center",c.fillText(this.text,this.topX+this.TEXT_OFFSET_X,this.topY+this.TEXT_OFFSET_Y),c.textAlign="left"},Button.prototype.onClick=function(){},HelpBox.prototype=new Button,HelpBox.prototype.draw=function(c){var lines,i,y,helpText;if(Button.prototype.draw.call(this,c),this.helpOpen)for(helpText=this.parent.helpText,c.font="12pt Arial",lines=helpText.split("\n"),y=this.topY+this.BUTTON_HEIGHT,i=0;i<lines.length;i+=1)y+=this.LINE_HEIGHT,c.fillText(lines[i],this.topX+this.HELP_INDENT,y)},HelpBox.prototype.onClick=function(){this.helpOpen=!this.helpOpen,this.parent.draw()},TextBox.prototype.insertChar=function(char){this.text=this.text.slice(0,this.caretPosition)+char+this.text.slice(this.caretPosition),this.caretRight()},TextBox.prototype.deleteChar=function(){this.caretPosition>0&&(this.text=this.text.slice(0,this.caretPosition-1)+this.text.slice(this.caretPosition),this.caretLeft())},TextBox.prototype.caretLeft=function(){this.caretPosition>0&&this.caretPosition--},TextBox.prototype.caretRight=function(){this.caretPosition<this.text.length&&this.caretPosition++},TextBox.prototype.containsPoint=function(x,y){var point={x:x,y:y};return util.isInside(point,this.boundingBox)},TextBox.prototype.setMouseStart=function(x,y){this.mouseOffsetX=this.position.x-x,this.mouseOffsetY=this.position.y-y},TextBox.prototype.setAnchorPoint=function(x,y){x+=this.mouseOffsetX||0,y+=this.mouseOffsetY||0;var relDist,offset,linkInfo=this.parent.getEndPointsAndCircle();if(linkInfo.hasCircle){var textAngle=Math.atan2(y-linkInfo.circleY,x-linkInfo.circleX);textAngle<linkInfo.startAngle&&(textAngle+=2*Math.PI),linkInfo.endAngle<linkInfo.startAngle&&(linkInfo.endAngle+=2*Math.PI),relDist=linkInfo.isReversed?(textAngle-linkInfo.startAngle-2*Math.PI)/(linkInfo.endAngle-linkInfo.startAngle-2*Math.PI):(textAngle-linkInfo.startAngle)/(linkInfo.endAngle-linkInfo.startAngle),offset=util.vectorMagnitude({x:x-linkInfo.circleX,y:y-linkInfo.circleY})-linkInfo.circleRadius}else{var textVector={x:x-linkInfo.startX,y:y-linkInfo.startY},linkVector={x:linkInfo.endX-linkInfo.startX,y:linkInfo.endY-linkInfo.startY},projection=util.scalarProjection(textVector,linkVector);relDist=projection/util.vectorMagnitude(linkVector),offset=Math.sqrt(Math.pow(util.vectorMagnitude(textVector),2)-Math.pow(projection,2));var ccw=util.isCCW(textVector,linkVector),reversed=0!=this.parent.lineAngleAdjust;(!ccw&&reversed||ccw&&!reversed)&&(offset*=-1)}relDist>0&&relDist<1&&(this.relDist=relDist,this.offset=Math.round(offset),this.dragged=!0)},TextBox.prototype.draw=function(x,y,angleOrNull,parentObject){var graph=parentObject.parent,c=graph.getCanvas().getContext("2d");c.font=graph.fontSize()+"px Arial";var beforeCaretText=util.convertLatexShortcuts(this.text.slice(0,this.caretPosition)),afterCaretText=util.convertLatexShortcuts(this.text.slice(this.caretPosition)),width=c.measureText(beforeCaretText+afterCaretText).width,dy=Math.round(graph.fontSize()/2);if(null!==angleOrNull){var cos=Math.cos(angleOrNull),sin=Math.sin(angleOrNull);if(x+=this.offset*cos,y+=this.offset*sin,!this.dragged){var cornerPointX=width/2*(cos>0?1:-1),cornerPointY=dy/2*(sin>0?1:-1),slide=sin*Math.pow(Math.abs(sin),40)*cornerPointX-cos*Math.pow(Math.abs(cos),10)*cornerPointY;x+=cornerPointX-sin*slide,y+=cornerPointY+cos*slide}this.position={x:Math.round(x),y:Math.round(y)}}if(x-=width/2,x=Math.round(x),y=Math.round(y),"advancedFillText"in c)c.advancedFillText(this.text,this.text,x+width/2,y,angleOrNull);else{var prevStyle=c.fillStyle;c.fillStyle="rgba(255, 255, 255, 0.7)",c.fillRect(x,y-dy,width,2*dy),c.fillStyle=prevStyle,dy=Math.round(graph.fontSize()/3),c.fillText(beforeCaretText,x,y+dy);var caretX=x+c.measureText(beforeCaretText).width;c.fillText(afterCaretText,caretX,y+dy),dy=Math.round(graph.fontSize()/2),parentObject==graph.selectedObject&&graph.caretVisible&&graph.hasFocus()&&document.hasFocus()&&(c.beginPath(),c.moveTo(caretX,y-dy),c.lineTo(caretX,y+dy),c.stroke())}this.boundingBox={x:x,y:y-dy,height:2*dy,width:width}},{Node:Node,Link:Link,SelfLink:SelfLink,TemporaryLink:TemporaryLink,StartLink:StartLink,Button:Button,HelpBox:HelpBox,TextBox:TextBox}}));

//# sourceMappingURL=graphelements.min.js.map