/**
 * JavaScript for handling UI actions in the question authoring form.
 *
 * @module qtype_coderunner/authorform
 * @copyright  Richard Lobb, 2015, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_coderunner/authorform",["qtype_coderunner/userinterfacewrapper","core/str"],(function(ui,str){let currentQtype="";var JSON_TO_FORM_MAP={template:["#id_template","value",""],iscombinatortemplate:["#id_iscombinatortemplate","checked","",function(value){return"1"===value}],cputimelimitsecs:["#id_cputimelimitsecs","value",""],memlimitmb:["#id_memlimitmb","value",""],sandbox:["#id_sandbox","value","DEFAULT"],sandboxparams:["#id_sandboxparams","value",""],testsplitterre:["#id_testsplitterre","value","",function(splitter){return splitter.replace("\n","\\n")}],allowmultiplestdins:["#id_allowmultiplestdins","checked","",function(value){return"1"===value}],grader:["#id_grader","value","EqualityGrader"],resultcolumns:["#id_resultcolumns","value",""],language:["#id_language","value",""],acelang:["#id_acelang","value",""],uiplugin:["#id_uiplugin","value","ace"]};return{initEditForm:function(){var typeCombo=document.getElementById("id_coderunnertype"),prototypeDisplay=document.getElementById("id_isprototype"),template=document.getElementById("id_template"),evaluatePerStudent=document.getElementById("id_templateparamsevalpertry"),globalextra=document.getElementById("id_globalextra"),prototypeextra=document.getElementById("id_prototypeextra"),useace=document.getElementById("id_useace"),language=document.getElementById("id_language"),acelang=document.getElementById("id_acelang"),customise=document.getElementById("id_customise"),isCombinator=document.getElementById("id_iscombinatortemplate"),testSplitterRe=document.getElementById("id_testsplitterre"),allowMultipleStdins=document.getElementById("id_allowmultiplestdins"),customisationFieldSet=document.getElementById("id_customisationheader"),advancedCustomisation=document.getElementById("id_advancedcustomisationheader"),isCustomised=customise.checked,prototypeType=document.getElementById("id_prototypetype"),preloadHdr=document.getElementById("id_answerpreloadhdr"),courseIdInput=document.querySelector('input[name="courseid"]'),courseId=courseIdInput?courseIdInput.value:"",questiontypeHelpDiv=document.getElementById("qtype-help"),precheck=document.querySelector("select#id_precheck"),testtypedivs=document.querySelectorAll("div.testtype"),testsection=document.getElementById("id_testcasehdr"),brokenQuestion=document.getElementById("id_broken_question"),badQuestionLoad=document.getElementById("id_bad_question_load"),uiplugin=document.getElementById("id_uiplugin"),uiparameters=document.getElementById("id_uiparameters");function setUi(taId,uiname){var lang,uiWrapper,ta=document.getElementById(taId),paramsJson=ta.getAttribute("data-params"),params={},testcode0=document.getElementById("id_testcode_0");ta.setAttribute("data-prototypeextra",prototypeextra.value),ta.setAttribute("data-globalextra",globalextra.value),ta.setAttribute("data-test0",testcode0?testcode0.value:"");try{params=paramsJson?JSON.parse(paramsJson):{}}catch(err){}"none"===(uiname=uiname.toLowerCase())&&(uiname=""),"id_templateparams"==taId||"id_uiparameters"==taId?lang="":(lang=language.value,"id_template"!==taId&&acelang.value&&(lang=function(acelang){var langs,i;if(acelang.indexOf(",")<0)return acelang;for(langs=acelang.split(","),i=0;i<langs.length;i++)if(langs[i].endsWith("*"))return langs[i].substring(0,langs[i].length-1);return langs.length>0?langs[0]:""}(acelang.value))),uiWrapper=ta.current_ui_wrapper,ta.setAttribute("data-lang",lang),uiWrapper?(params.lang=lang,uiWrapper.loadUi(uiname,params)):uiWrapper=new ui.InterfaceWrapper(uiname,taId)}function setUis(){let uiname=uiplugin.value,answer=document.getElementById("id_answer"),enableUi=!0;if("html"===uiname&&""!==answer.getAttribute("data-params"))try{!1===JSON.parse(answer.getAttribute("data-params")).enable_in_editor&&(enableUi=!1)}catch(error){alert("Invalid UI parameters.")}enableUi&&(setUi("id_answer",uiname),setUi("id_answerpreload",uiname))}function setCustomisationVisibility(isVisible){var display=isVisible?"block":"none";customisationFieldSet.style.display=display,advancedCustomisation.style.display=display,isVisible&&useace.checked&&setUi("id_template","ace")}function copyFieldsFromQuestionType(newType,response){var formspecifier,attrval,isCombinatorEnabled;for(var key in function(stateOn){var uiWrapper,taIds=["id_template","id_uiparameters"];if(useace.checked)for(var i=0;i<taIds.length;i++)(uiWrapper=document.getElementById(taIds[i]).current_ui_wrapper)&&stateOn?uiWrapper.restart():uiWrapper&&!stateOn&&uiWrapper.stop()}(!1),JSON_TO_FORM_MAP){formspecifier=JSON_TO_FORM_MAP[key],attrval=response[key]?response[key]:formspecifier[2],formspecifier.length>3&&(attrval=(0,formspecifier[3])(attrval));const element=document.querySelector(formspecifier[0]);element&&("checked"===formspecifier[1]?element.checked=attrval:element[formspecifier[1]]=attrval)}customise.checked=!1,str.get_string("coderunner_question_type","qtype_coderunner").then((function(s){var title,coderunner_descr,html,resultHtml;questiontypeHelpDiv.innerHTML=(title=newType,coderunner_descr=s,html=response.questiontext,resultHtml='<p class="question-type-details-header">',resultHtml+=coderunner_descr,resultHtml+=title+"</p>\n"+html)})),setCustomisationVisibility(!1),isCombinatorEnabled=isCombinator.checked,testSplitterRe.disabled=!isCombinatorEnabled,allowMultipleStdins.disabled=!isCombinatorEnabled}function langStringAlert(key,extra){window.hasOwnProperty("behattesting")&&window.behattesting||str.get_string(key,"qtype_coderunner").then((function(s){var message=s.replace(/\n/g," ");extra&&(message+="\n"+extra),alert(message)}))}function loadCustomisationFields(){let newType=typeCombo.options[typeCombo.selectedIndex].text;if(""!==newType&&"Undefined"!==newType){typeCombo.options[0]&&(typeCombo.options[0].disabled=!0);const url=new URL(M.cfg.wwwroot+"/question/type/coderunner/ajax.php");url.searchParams.set("qtype",newType),url.searchParams.set("courseid",courseId),url.searchParams.set("sesskey",M.cfg.sesskey),fetch(url).then((response=>response.json())).then((outcome=>{const warningDiv=document.getElementById("id_qtype_coderunner_warning_div");if(warningDiv&&(warningDiv.innerHTML=""),outcome.success){copyFieldsFromQuestionType(newType,outcome),setUis(),loadUiParametersDescription(),currentQtype=newType;const errorDiv=document.getElementById("id_qtype_coderunner_error_div");errorDiv&&(errorDiv.innerHTML="")}else{const errorObject=function(questionType,error){const errorObject=JSON.parse(error);return str.get_string("prototype_error","qtype_coderunner").then((function(s){str.get_string(errorObject.alert,"qtype_coderunner",questionType).then((function(str){langStringAlert("prototype_load_failure",str);let errorMessage=s+"\n";errorMessage+=str+"\n",errorMessage+="CourseId: "+courseId+", qtype: "+questionType,template.value=errorMessage}))})),errorObject}(newType,outcome.error);currentQtype!==newType&&"duplicateprototype"===errorObject.error&&(!function(currentType,errorObject,newType){str.get_string("loadprototypeerror","qtype_coderunner",{oldtype:currentType,crtype:newType,outputstring:errorObject.extras}).then((function(str){let warningPara=document.createElement("p");warningPara.textContent=str,document.getElementById("id_qtype_coderunner_warning_div").appendChild(warningPara)}))}(currentQtype,errorObject,newType),typeCombo.value=currentQtype)}})).catch((()=>{langStringAlert("error_loading_prototype"),template.value="*** AJAX ERROR. DON'T SAVE THIS! ***",str.get_string("ajax_error","qtype_coderunner").then((function(s){template.value=s}))}))}}function updateUiParamsDescription(uiInfo){let currentuiparameters=uiparameters.value,paramDescriptionDiv=document.querySelector(".ui_parameters_descr"),uiParamGroup=document.getElementById("fgroup_id_uiparametergroup");if(uiParamGroup.style.display="",paramDescriptionDiv.innerHTML="",null===uiInfo||0==uiInfo.uiparamstable.length&&""===currentuiparameters.trim())uiParamGroup.style.display="none";else{paramDescriptionDiv.append(uiInfo.header);let showhidebutton=document.createElement("button");if(showhidebutton.type="button",showhidebutton.className="toggleuidetails",showhidebutton.textContent=uiInfo.showdetails,0!=uiInfo.uiparamstable.length){paramDescriptionDiv.append(showhidebutton);let tableDiv=document.createElement("div");tableDiv.className="uiparamtablediv",tableDiv.innerHTML=function(uiParamInfo){var param,i,html='<table class="uiparamtable">\n',hdrs=uiParamInfo.columnheaders;for(html+="<tr><th>"+hdrs[0]+"</th><th>"+hdrs[1]+"</th><th>"+hdrs[2]+"</th></tr>\n",i=0;i<uiParamInfo.uiparamstable.length;i++)html+="<tr><td>"+(param=uiParamInfo.uiparamstable[i])[0]+"</td><td>"+param[1]+"</td><td>"+param[2]+"</td></tr>\n";return html+"</table>\n"}(uiInfo),paramDescriptionDiv.append(tableDiv),tableDiv.style.display="none",showhidebutton.addEventListener("click",(function(){showhidebutton.textContent==uiInfo.showdetails?(tableDiv.style.display="block",showhidebutton.textContent=uiInfo.hidedetails):(tableDiv.style.display="none",showhidebutton.textContent=uiInfo.showdetails)}))}useace.checked&&setUi("id_uiparameters","ace")}}function loadUiParametersDescription(){let newUi=uiplugin.options[uiplugin.selectedIndex].text;if(""===newUi||"none"===newUi)updateUiParamsDescription(null);else{const url=new URL(M.cfg.wwwroot+"/question/type/coderunner/ajax.php");url.searchParams.set("uiplugin",newUi),url.searchParams.set("courseid",courseId),url.searchParams.set("sesskey",M.cfg.sesskey),fetch(url).then((response=>response.json())).then(updateUiParamsDescription).catch((()=>{langStringAlert("error_loading_ui_descr","UI: ".concat(newUi))}))}}function set_testtype_visibilities(){"3"===precheck.value?testtypedivs.forEach((div=>{div.style.display="block"})):testtypedivs.forEach((div=>{div.style.display="none"}))}function check_ace_lang(){"ace"===uiplugin.value&&setUis()}0!=prototypeType.value&&(testsection.style.display="none",prototypeDisplay.removeAttribute("hidden"),1==prototypeType.value&&(str.get_string("proceed_at_own_risk","qtype_coderunner").then((function(s){alert(s)})),prototypeType.disabled=!0,customise.disabled=!0)),function(){let messagePara=null;""!==brokenQuestion.value&&(messagePara=document.createElement("p"),messagePara.textContent=brokenQuestion.value,document.getElementById("id_qtype_coderunner_error_div").appendChild(messagePara))}(),badQuestionLoad.hidden=!0,currentQtype=typeCombo.options[typeCombo.selectedIndex].text,setCustomisationVisibility(isCustomised),isCustomised?(setUis(),str.get_string("info_unavailable","qtype_coderunner").then((function(s){questiontypeHelpDiv.innerHTML="<p>"+s+"</p>"}))):loadCustomisationFields(),set_testtype_visibilities(),useace.checked&&(setUi("id_templateparams","ace"),setUi("id_uiparameters","ace")),loadUiParametersDescription(),customise.addEventListener("change",(function(){customise.checked?setCustomisationVisibility(!0):str.get_string("confirm_proceed","qtype_coderunner").then((function(s){window.confirm(s)?setCustomisationVisibility(!1):customise.checked=!0}))})),acelang.addEventListener("change",check_ace_lang),language.addEventListener("change",(function(){useace.checked&&setUi("id_template","ace"),check_ace_lang()})),typeCombo.addEventListener("change",(function(){customise.checked?str.get_string("question_type_changed","qtype_coderunner").then((function(s){window.confirm(s)&&loadCustomisationFields()})):loadCustomisationFields()})),useace.addEventListener("change",(function(){useace.checked?(setUi("id_template","ace"),setUi("id_templateparams","ace"),setUi("id_uiparameters","ace")):(setUi("id_template",""),setUi("id_templateparams",""),setUi("id_uiparameters",""))})),evaluatePerStudent.addEventListener("change",(function(){evaluatePerStudent.checked&&langStringAlert("templateparamsusingsandbox")})),uiplugin.addEventListener("change",(function(){setUis(),loadUiParametersDescription()})),precheck.addEventListener("change",set_testtype_visibilities),prototypeType.addEventListener("change",(function(){"0"==prototypeType.value?(testsection.style.display="block",prototypeDisplay.setAttribute("hidden","1")):(testsection.style.display="none",prototypeDisplay.removeAttribute("hidden"))}));var observer=new MutationObserver((function(){setUis()}));preloadHdr&&observer.observe(preloadHdr,{attributes:!0,attributeFilter:["class"]}),document.addEventListener("click",(function(event){if(event.target.matches("button.replaceexpectedwithgot")){for(var gotPre=event.target.previousElementSibling;gotPre&&(!gotPre.matches("pre")||!gotPre.id.startsWith("id_got_"));)gotPre=gotPre.previousElementSibling;if(gotPre){var testCaseId=gotPre.id.replace("id_got_",""),expectedField=document.getElementById("id_expected_"+testCaseId),expectedFailField=document.getElementById("id_fail_expected_"+testCaseId),failRow=document.querySelector(".failrow_"+testCaseId);expectedField&&(expectedField.value=gotPre.textContent),expectedFailField&&(expectedFailField.innerHTML=gotPre.textContent),failRow&&failRow.classList.add("fixed"),event.target.disabled=!0}}})),document.addEventListener("click",(function(event){event.target.matches(".btn-primary")&&(typeCombo.disabled=!1)}))}}}));

//# sourceMappingURL=authorform.min.js.map