/**
 * Connection status module for the admin settings page.
 *
 * Handles status display and polling using Mustache templates
 * for dynamic UI updates.
 *
 * @module     local_mc_plugin/local/admin/connection_status
 * @copyright  2025 Kerem Can Akdag
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_mc_plugin/local/admin/connection_status",["local_mc_plugin/local/admin/selectors","local_mc_plugin/local/admin/repository","local_mc_plugin/local/admin/event_selector","local_mc_plugin/local/admin/templates","core/str"],(function(Selectors,Repository,EventSelector,TemplateHelper,Str){let config={},eventInputId="",statusContainer=null,statusContent=null;const updateStatus=async(connected,siteName,syncedCount,syncedEvents,message)=>{if(!statusContent)return;let statusText;EventSelector.setSyncedEvents(syncedEvents);let syncStatus=null;connected?(statusText=await Str.get_string("status_connected","local_mc_plugin"),syncStatus=await(async syncedCount=>0===syncedCount?await Str.get_string("status_events_not_synced","local_mc_plugin"):await Str.get_string("status_events_synced","local_mc_plugin",syncedCount))(syncedCount),eventInputId&&EventSelector.refreshCounter(eventInputId)):statusText=message||await Str.get_string("status_not_connected","local_mc_plugin");const context=TemplateHelper.buildConnectionStatusContext(connected,statusText,siteName,syncStatus);await TemplateHelper.renderConnectionStatus(statusContent,context)};return{testConnection:async function(autoSync){if(autoSync=autoSync||!1,!statusContent)return;const loadingContext={connected:!1,statusclass:"text-muted",dotclass:"text-muted",statustext:await Str.get_string("connect_initializing","local_mc_plugin"),hassitename:!1,hassyncstatus:!1};await TemplateHelper.renderConnectionStatus(statusContent,loadingContext);try{const data=await Repository.getConnectionStatus(config.syncUrl,config.sesskey);if(data.connected)await updateStatus(!0,data.site_name,data.synced_event_count||0,data.synced_events||[]),autoSync&&await(async()=>{try{if((await Repository.syncAllEvents(config.syncUrl,config.sesskey)).success){const data=await Repository.getConnectionStatus(config.syncUrl,config.sesskey);data.connected&&await updateStatus(!0,data.site_name,data.synced_event_count||0,data.synced_events||[])}}catch(err){}})();else if(data.error)await updateStatus(!1,null,0,[],data.error);else if(data.configured){const msg=await Str.get_string("status_click_connect","local_mc_plugin");await updateStatus(!1,null,0,[],msg)}else{const msg=await Str.get_string("status_click_connect_link","local_mc_plugin");await updateStatus(!1,null,0,[],msg)}}catch(err){await updateStatus(!1,null,0,[],err.message)}},updateStatusWithError:async function(errorMessage){if(!statusContent)return;const context={connected:!1,statusclass:"text-danger",dotclass:"text-danger",statustext:await Str.get_string("status_sync_failed","local_mc_plugin"),hassitename:!1,syncstatus:errorMessage,hassyncstatus:!0};await TemplateHelper.renderConnectionStatus(statusContent,context)},init:function(cfg){cfg=cfg||null,statusContainer=document.querySelector(Selectors.status.container),statusContainer?(config={syncUrl:statusContainer.dataset.syncurl||cfg&&cfg.syncUrl||"",sesskey:statusContainer.dataset.sesskey||cfg&&cfg.sesskey||""},eventInputId=statusContainer.dataset.eventinputid||cfg&&cfg.eventInputId||"",statusContent=statusContainer.querySelector(Selectors.status.content)):cfg&&(config=cfg,eventInputId=cfg.eventInputId||""),this.testConnection(!0)}}}));

//# sourceMappingURL=connection_status.min.js.map