/**
 * Action buttons module for the admin settings page.
 *
 * Handles the Save & Sync button functionality using Mustache templates
 * for result message display.
 *
 * @module     local_mc_plugin/local/admin/action_buttons
 * @copyright  2025 Kerem Can Akdag
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_mc_plugin/local/admin/action_buttons",["local_mc_plugin/local/admin/selectors","local_mc_plugin/local/admin/repository","local_mc_plugin/local/admin/connection_status","local_mc_plugin/local/admin/templates","core/str"],(function(Selectors,Repository,ConnectionStatus,TemplateHelper,Str){let config={},btnLabel="",container=null,resultDiv=null,primaryBtn=null,btnSpinner=null,btnTextEl=null;const showResult=async(success,message)=>{if(!resultDiv)return;const context=TemplateHelper.buildActionResultContext(success,message);await TemplateHelper.renderActionResult(resultDiv,context)},setLoading=loading=>{primaryBtn&&(primaryBtn.disabled=loading),btnSpinner&&(loading?btnSpinner.classList.remove("d-none"):btnSpinner.classList.add("d-none"))},setBtnText=text=>{btnTextEl&&(btnTextEl.textContent=text)},handleSaveSync=async()=>{resultDiv&&(resultDiv.innerHTML=""),setLoading(!0);const savingText=await Str.get_string("btn_saving","local_mc_plugin");setBtnText(savingText);try{const values=(()=>{const values={},siteKeyInput=document.querySelector(Selectors.inputs.siteKey);siteKeyInput&&siteKeyInput.value&&(values.siteKey=siteKeyInput.value);const siteSecretInput=document.querySelector(Selectors.inputs.siteSecret);siteSecretInput&&siteSecretInput.value&&(values.siteSecret=siteSecretInput.value);const eventsInput=document.querySelector(Selectors.inputs.monitoredEvents);eventsInput&&(values.monitoredEvents=eventsInput.value);const debugInput=document.querySelector(Selectors.inputs.debugMode);return debugInput&&(values.debugMode=debugInput.checked?1:0),values})(),saveResult=await Repository.saveSettings(config.ajaxSaveUrl,config.sesskey,values);if(!saveResult.success)return setLoading(!1),setBtnText(btnLabel),void await showResult(!1,saveResult.message||"Failed to save settings");const syncingText=await Str.get_string("btn_syncing","local_mc_plugin");setBtnText(syncingText);const syncResult=await Repository.syncEvents(config.syncUrl,config.sesskey);if(setLoading(!1),setBtnText(btnLabel),syncResult.success){const successMsg=await Str.get_string("sync_success","local_mc_plugin",syncResult.event_count||0);await showResult(!0,successMsg),ConnectionStatus.testConnection()}else{const failMsg=await Str.get_string("sync_failed","local_mc_plugin",syncResult.message);await showResult(!1,failMsg),ConnectionStatus.updateStatusWithError(syncResult.message)}}catch(err){setLoading(!1),setBtnText(btnLabel),await showResult(!1,"Error: ".concat(err.message))}};return{init:async function(cfg){cfg=cfg||null,container=document.querySelector(Selectors.actions.container),container?(config={syncUrl:container.dataset.syncurl||cfg&&cfg.syncUrl||"",ajaxSaveUrl:container.dataset.ajaxsaveurl||cfg&&cfg.ajaxSaveUrl||"",sesskey:container.dataset.sesskey||cfg&&cfg.sesskey||""},resultDiv=container.querySelector(Selectors.actions.resultDiv),primaryBtn=container.querySelector(Selectors.actions.primaryBtn),btnSpinner=container.querySelector(Selectors.actions.btnSpinner),btnTextEl=container.querySelector(Selectors.actions.btnText)):cfg&&(config=cfg,resultDiv=document.querySelector(Selectors.actions.legacyResultDiv),primaryBtn=document.querySelector(Selectors.actions.legacyPrimaryBtn),btnSpinner=document.querySelector(Selectors.actions.legacyBtnSpinner),btnTextEl=document.querySelector(Selectors.actions.legacyBtnText)),btnLabel=await Str.get_string("btn_save_sync","local_mc_plugin"),primaryBtn&&primaryBtn.addEventListener("click",handleSaveSync)}}}));

//# sourceMappingURL=action_buttons.min.js.map