/**
 * MoodleConnect OAuth-style connection flow.
 *
 * This module handles:
 * - Opening the MoodleConnect tab with connection token
 * - Polling for connection completion
 * - Storing credentials on success
 *
 * Uses data-* attributes from connect_button.mustache template.
 *
 * @module     local_mc_plugin/connect
 * @copyright  2025 Kerem Can Akdag
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_mc_plugin/connect",["local_mc_plugin/local/admin/selectors","local_mc_plugin/local/admin/repository","local_mc_plugin/local/admin/connection_status","core/str"],(function(Selectors,Repository,ConnectionStatus,Str){let config={},strings={},pollTimer=null,pollAttempts=0,currentToken=null,isConnected=!1,connectBtn=null,btnText=null,btnSpinner=null,statusDiv=null,statusIcon=null,statusText=null;const showStatus=(type,message)=>{statusDiv&&(statusDiv.classList.remove("d-none"),statusDiv.style.display="block",statusDiv.classList.remove("alert-warning","alert-success","alert-danger"),"waiting"===type?(statusDiv.classList.add("alert-warning"),statusIcon&&(statusIcon.innerHTML='<span class="spinner-border spinner-border-sm mr-2"></span>')):"success"===type?(statusDiv.classList.add("alert-success"),statusIcon&&(statusIcon.innerHTML="✓ ")):"error"===type&&(statusDiv.classList.add("alert-danger"),statusIcon&&(statusIcon.innerHTML="✗ ")),statusText&&(statusText.textContent=message))},setLoading=loading=>{connectBtn&&(connectBtn.disabled=loading),btnSpinner&&(loading?btnSpinner.classList.remove("d-none"):btnSpinner.classList.add("d-none"))},setBtnText=text=>{btnText&&(btnText.textContent=text)},stopPolling=()=>{pollTimer&&(clearInterval(pollTimer),pollTimer=null)},pollStatus=async()=>{if(pollAttempts++,pollAttempts>60)return stopPolling(),setLoading(!1),void showStatus("error",strings.timeout);try{const data=await Repository.pollConnectionStatus(config.apiUrl,currentToken);"completed"===data.status?(stopPolling(),data.site_key&&data.site_secret?(async(siteKey,siteSecret)=>{showStatus("waiting",strings.saving);try{const data=await Repository.saveCredentials(config.saveUrl,config.sesskey,siteKey,siteSecret);setLoading(!1),data.success?(showStatus("success",strings.success),setBtnText(strings.reconnectBtn),connectBtn&&(connectBtn.classList.remove("btn-primary"),connectBtn.classList.add("btn-outline-primary")),isConnected=!0,setTimeout((()=>{ConnectionStatus.testConnection(!0)}),500)):showStatus("error",data.message||strings.saveFailed)}catch(err){setLoading(!1),showStatus("error","".concat(strings.saveFailed,": ").concat(err.message))}})(data.site_key,data.site_secret):(setLoading(!1),showStatus("error",strings.credentialsRetrieved))):"expired"===data.status&&(stopPolling(),setLoading(!1),showStatus("error",strings.tokenExpired))}catch(e){}},resetButtonState=()=>{setLoading(!1),setBtnText(isConnected?strings.reconnectBtn:strings.connectBtn)},startConnection=async()=>{statusDiv&&(statusDiv.classList.add("d-none"),statusDiv.style.display="none"),setLoading(!0),setBtnText(strings.initializing),pollAttempts=0;try{const data=await Repository.initConnection(config.connectUrl,config.sesskey);data.success&&data.token?(data=>{currentToken=data.token;const connectPageUrl="".concat(config.frontendUrl,"/connect?token=").concat(encodeURIComponent(data.token));if(!window.open(connectPageUrl,"_blank"))return resetButtonState(),void showStatus("error",strings.popupBlocked);setBtnText(strings.waitingBtn),showStatus("waiting",strings.waiting),pollTimer=setInterval(pollStatus,3e3)})(data):(resetButtonState(),showStatus("error",data.message||strings.initFailed))}catch(err){resetButtonState(),showStatus("error","".concat(strings.initFailed,": ").concat(err.message))}},getConfigValue=(dataAttr,cfgKey,cfg)=>connectBtn&&connectBtn.dataset[dataAttr]?connectBtn.dataset[dataAttr]:cfg&&cfg[cfgKey]?cfg[cfgKey]:"";return{init:async function(cfg){cfg=cfg||null,await(async()=>{const results=await Str.get_strings([{key:"connect_initializing",component:"local_mc_plugin"},{key:"connect_waiting",component:"local_mc_plugin"},{key:"connect_waiting_btn",component:"local_mc_plugin"},{key:"connect_saving",component:"local_mc_plugin"},{key:"connect_success",component:"local_mc_plugin"},{key:"connect_popup_blocked",component:"local_mc_plugin"},{key:"connect_init_failed",component:"local_mc_plugin"},{key:"connect_timeout",component:"local_mc_plugin"},{key:"connect_token_expired",component:"local_mc_plugin"},{key:"connect_credentials_retrieved",component:"local_mc_plugin"},{key:"connect_save_failed",component:"local_mc_plugin"},{key:"connect_button",component:"local_mc_plugin"},{key:"reconnect_button",component:"local_mc_plugin"}]);strings={initializing:results[0],waiting:results[1],waitingBtn:results[2],saving:results[3],success:results[4],popupBlocked:results[5],initFailed:results[6],timeout:results[7],tokenExpired:results[8],credentialsRetrieved:results[9],saveFailed:results[10],connectBtn:results[11],reconnectBtn:results[12]}})(),(()=>{const container=document.querySelector(Selectors.connect.container);container?(connectBtn=container.querySelector(Selectors.connect.button),btnText=container.querySelector(Selectors.connect.buttonText),btnSpinner=container.querySelector(Selectors.connect.buttonSpinner),statusDiv=container.querySelector(Selectors.connect.statusDiv),statusIcon=container.querySelector(Selectors.connect.statusIcon),statusText=container.querySelector(Selectors.connect.statusText)):(connectBtn=document.querySelector(Selectors.connect.legacyButton),btnText=document.querySelector(Selectors.connect.legacyButtonText),btnSpinner=document.querySelector(Selectors.connect.legacyButtonSpinner),statusDiv=document.querySelector(Selectors.connect.legacyStatusDiv),statusIcon=document.querySelector(Selectors.connect.legacyStatusIcon),statusText=document.querySelector(Selectors.connect.legacyStatusText))})(),config=(cfg=>({connectUrl:getConfigValue("connecturl","connectUrl",cfg),saveUrl:getConfigValue("saveurl","saveUrl",cfg),apiUrl:getConfigValue("apiurl","apiUrl",cfg),frontendUrl:getConfigValue("frontendurl","frontendUrl",cfg),sesskey:getConfigValue("sesskey","sesskey",cfg)}))(cfg),connectBtn?(isConnected=connectBtn.classList.contains("btn-outline-primary")||Boolean(cfg&&cfg.isConnected),connectBtn.addEventListener("click",startConnection)):cfg&&(isConnected=Boolean(cfg.isConnected))}}}));

//# sourceMappingURL=connect.min.js.map