<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * English language pack for local_learnwise
 *
 * @package    local_learnwise
 * @category   string
 * @copyright  2025 LearnWise <help@learnwise.ai>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesstoken'] = 'Access Token';
$string['aiassessment'] = 'Ai Assessment';
$string['aiassessment_desc'] = 'This allows the assistant to assist in assignment grading';
$string['apidisabled'] = 'API disabled';
$string['assessmenthost'] = 'Host';
$string['assistantid'] = 'Assistant ID';
$string['cleanuptokentask'] = 'Clean up tokens task';
$string['clientid'] = 'Client ID';
$string['clientsecret'] = 'Client Secret';
$string['completed'] = 'Completed';
$string['copied'] = 'Copied!';
$string['coursecontentsintegration'] = 'Course Contents Integration';
$string['coursecontentsintegration_desc'] = 'This allows the assistant to ingest the course contents from Moodle, allowing to answer questions about the contents of a course.';
$string['coursecontentsintegration_label'] = 'Enable webservice for course content ingestion';
$string['courseids'] = 'Course IDs';
$string['courseids_desc'] = 'Enter courseids as comma-separated values (e.g. 2,3,5).';
$string['donotdelete'] = 'DO NOT DELETE';
$string['enableaiassessment'] = 'Enable AI assessment';
$string['enableliveapiintegration'] = 'Enable Live API Integration';
$string['enablelti'] = 'Enable LTI';
$string['enablelti_tooltip'] = 'Please specify Assistant ID to configure LTI';
$string['enterassistantid'] = 'Enter Assistant ID';
$string['entercourseids'] = 'Enter Courseids';
$string['environment'] = 'Environment';
$string['environment_desc'] = 'Always use Production, unless directed otherwise by Learnwise.';
$string['environmentdevelopment'] = 'Development';
$string['environmentproduction'] = 'Production';
$string['environmentsandbox'] = 'Sandbox';
$string['externaltoken'] = 'Token';
$string['fieldvalidationerror'] = 'The value of "{$a->field}" is not valid';
$string['floatingbuttonconfig'] = 'Floating Button Configuration';
$string['floatingbuttonconfigdesc'] = 'This allows showing the Learnwise assistant as a floating chat button that opens a small frame on the bottom of the screen.';
$string['gradingdisabled'] = 'Grading disabled';
$string['integration_listpage'] = 'Learnwise Integration';
$string['learnwise:roledescription'] = 'Role for Learnwise AI Assistant integration';
$string['learnwise:rolename'] = 'Learnwise Assistant';
$string['liveapiintegration'] = 'Live API Integration';
$string['liveapiintegration_desc'] = 'This allows the assistant to dynamically query the Moodle API to get up-to-date information that is user-specific for answering user queries.';
$string['lticonfig'] = 'LTI Configuration';
$string['lticonfig_desc'] = 'This allows configuring the assistant as an LTI application that can be included within course activities.';
$string['lticonfig_note'] = 'Note: It is possible to configure separate assistants for LTI and floating button, although not recommended.';
$string['onlygraded'] = 'graded';
$string['onlysubmitted'] = 'submitted';
$string['permission_list'] = '<p>This will allow the assistant to give you personal questions about your upcoming assignments, announcements, course contents, and much more.</p>';
$string['permission_question'] = '<p>Do you want to allow Learnwise to access your Moodle account?</p>';
$string['pluginname'] = 'Learnwise';
$string['privacy:metadata:external:assignments'] = 'Assignments of course';
$string['privacy:metadata:external:assignments:closedate'] = 'Close date';
$string['privacy:metadata:external:assignments:course_id'] = 'Course ID';
$string['privacy:metadata:external:assignments:description'] = 'Assignment description';
$string['privacy:metadata:external:assignments:name'] = 'Activity name';
$string['privacy:metadata:external:assignments:opendate'] = 'Open date';
$string['privacy:metadata:external:assignments:sectionname'] = 'Section name of assignment';
$string['privacy:metadata:external:assignments:timedue'] = 'Due date';
$string['privacy:metadata:external:calendarevents'] = 'Calendar event send to provider';
$string['privacy:metadata:external:calendarevents:action'] = 'Actions information related to event';
$string['privacy:metadata:external:calendarevents:candelete'] = 'Whether user can delete event';
$string['privacy:metadata:external:calendarevents:canedit'] = 'Whether user can edit event';
$string['privacy:metadata:external:calendarevents:category'] = 'Category type of event';
$string['privacy:metadata:external:calendarevents:course'] = 'Course related to event';
$string['privacy:metadata:external:calendarevents:formattedlocation'] = 'Location of event';
$string['privacy:metadata:external:calendarevents:formattedtime'] = 'Time of event';
$string['privacy:metadata:external:calendarevents:groupname'] = 'Name of course group related to event';
$string['privacy:metadata:external:calendarevents:subscription'] = 'Subscription information of event';
$string['privacy:metadata:external:coursemodules'] = 'Course modules of course';
$string['privacy:metadata:external:coursemodules:completionstatus'] = 'User completion status of course module';
$string['privacy:metadata:external:coursemodules:name'] = 'Name of course module';
$string['privacy:metadata:external:coursemodules:type'] = 'Module type like assignment or lesson etc.';
$string['privacy:metadata:external:courses'] = 'Courses of user';
$string['privacy:metadata:external:courses:completiondate'] = 'Completion date of course';
$string['privacy:metadata:external:courses:completionstatus'] = 'Completion status of course';
$string['privacy:metadata:external:courses:enddate'] = 'End date of course';
$string['privacy:metadata:external:courses:name'] = 'Name of course';
$string['privacy:metadata:external:courses:participants'] = 'Number of participants in course';
$string['privacy:metadata:external:courses:shortname'] = 'Shortname of course';
$string['privacy:metadata:external:courses:startdate'] = 'Start date of course';
$string['privacy:metadata:external:courses:url'] = 'Url of course page';
$string['privacy:metadata:external:forumdiscussions'] = 'Discussion of forum';
$string['privacy:metadata:external:forumdiscussions:name'] = 'Topic of discussion';
$string['privacy:metadata:external:forumdiscussions:posts'] = 'Posts of discussion';
$string['privacy:metadata:external:forums'] = 'Forums of course';
$string['privacy:metadata:external:forums:name'] = 'Name of forum';
$string['privacy:metadata:external:scorms'] = 'Scorms of course';
$string['privacy:metadata:external:scorms:name'] = 'Name of scorm';
$string['privacy:metadata:external:scorms:packageurl'] = 'Package secure path of scorm';
$string['privacy:metadata:external:scorms:sha1hash'] = 'SHA hash of package';
$string['privacy:metadata:external:scorms:type'] = 'Type of scorm';
$string['privacy:metadata:external:userdetails'] = 'Plugin provides user information to provider';
$string['privacy:metadata:external:userdetails:address'] = 'Postal address of user';
$string['privacy:metadata:external:userdetails:auth'] = 'Auth type of user';
$string['privacy:metadata:external:userdetails:calendartype'] = 'Calendar type of user';
$string['privacy:metadata:external:userdetails:city'] = 'Home city of the user';
$string['privacy:metadata:external:userdetails:confirmed'] = 'Confirmation of user';
$string['privacy:metadata:external:userdetails:country'] = 'Home country code of the user';
$string['privacy:metadata:external:userdetails:customfields'] = 'Custom data related to user';
$string['privacy:metadata:external:userdetails:department'] = 'Department';
$string['privacy:metadata:external:userdetails:description'] = 'Profile description of user';
$string['privacy:metadata:external:userdetails:descriptionformat'] = 'Profile description format of user';
$string['privacy:metadata:external:userdetails:email'] = 'Email address of user';
$string['privacy:metadata:external:userdetails:firstaccess'] = 'First access of site';
$string['privacy:metadata:external:userdetails:firstname'] = 'First name of user';
$string['privacy:metadata:external:userdetails:fullname'] = 'Fullname of user';
$string['privacy:metadata:external:userdetails:idnumber'] = 'ID number';
$string['privacy:metadata:external:userdetails:institution'] = 'Institution';
$string['privacy:metadata:external:userdetails:interests'] = 'Interests of user';
$string['privacy:metadata:external:userdetails:lang'] = 'Language of user';
$string['privacy:metadata:external:userdetails:lastaccess'] = 'Last access of site';
$string['privacy:metadata:external:userdetails:lastname'] = 'Last name of user';
$string['privacy:metadata:external:userdetails:mailformat'] = 'Mail format preference of user';
$string['privacy:metadata:external:userdetails:phone1'] = 'Phone 1';
$string['privacy:metadata:external:userdetails:phone2'] = 'Phone 2';
$string['privacy:metadata:external:userdetails:preferences'] = 'Preferences';
$string['privacy:metadata:external:userdetails:profileimageurl'] = 'User image profile URL - big version';
$string['privacy:metadata:external:userdetails:profileimageurlsmall'] = 'User image profile URL - small version';
$string['privacy:metadata:external:userdetails:suspended'] = 'Suspended account flag';
$string['privacy:metadata:external:userdetails:theme'] = 'Theme of user';
$string['privacy:metadata:external:userdetails:timezone'] = 'Timezone of user';
$string['privacy:metadata:external:userdetails:trackforums'] = 'User forum tracking setting';
$string['privacy:metadata:external:userdetails:username'] = 'Username';
$string['privacy:metadata:local_learnwise_accesstoken'] = 'Information about the access tokens issued to users.';
$string['privacy:metadata:local_learnwise_accesstoken:timeexpiry'] = 'The expiration time of the access token.';
$string['privacy:metadata:local_learnwise_accesstoken:token'] = 'The access token issued to the user.';
$string['privacy:metadata:local_learnwise_authcode'] = 'Information about the authorization codes issued to users.';
$string['privacy:metadata:local_learnwise_authcode:code'] = 'The authorization code issued to the user.';
$string['privacy:metadata:local_learnwise_authcode:timeexpiry'] = 'The expiration time of the authorization code.';
$string['privacy:metadata:local_learnwise_authcode:token'] = 'The token issued to the user.';
$string['privacy:metadata:local_learnwise_refreshtoken'] = 'Information about the refresh tokens issued to users.';
$string['privacy:metadata:local_learnwise_refreshtoken:timeexpiry'] = 'The expiration time of the refresh token.';
$string['privacy:metadata:local_learnwise_refreshtoken:token'] = 'The refresh token issued to the user.';
$string['privacy:metadata:local_learnwise_userauth'] = 'Information about user has granted to an OAuth2 client.';
$string['privacy:metadata:local_learnwise_userauth:clientid'] = 'The ID of the OAuth2 client.';
$string['privacy:metadata:local_learnwise_userauth:userid'] = 'The ID of the user who granted client.';
$string['privacy:request:notexportedsecurity'] = 'Not exported for security reasons';
$string['redirecturl'] = 'Redirect URL';
$string['redirecturl_desc'] = 'Input multiple redirect URL in new lines';
$string['region'] = 'Region';
$string['removelticonfig'] = 'Remove LTI Configuration';
$string['removelticonfig_desc'] = 'Are you sure you want to disable LTI? This will break any existing LTI placements that are currently configured in your courses.';
$string['removelticonfig_no'] = 'Cancel';
$string['removelticonfig_yes'] = 'Remove LTI';
$string['removeltisetup'] = 'Remove LTI Setup';
$string['removetoken'] = 'Remove webservice';
$string['savechanges'] = 'Save changes';
$string['setupltisetup'] = 'Set-up LTI Placements';
$string['setuptoken'] = 'Setup webservice';
$string['showfloatingbutton'] = 'Show floating button';
$string['showfloatingbuttontooltip'] = 'Please specify Assistant ID to enable floating button';
$string['statusdisabled'] = 'Disabled';
$string['statusenabled'] = 'Enabled';
$string['submitted'] = 'Submitted';
$string['toolnotconfigured'] = 'This tool is not configured correctly, please contact your institution';
$string['unsubmitted'] = 'unsubmitted';
