<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'Lees mij bij het selecteren van het thema.';
$string['missingidandcmid'] = 'Ontbrekende id en cmid';
$string['modulename'] = 'stekkerNontmoeten';
$string['modulename_help'] = 'Gebruik de plugNmeet-module voor...';
$string['modulenameplural'] = 'stekkerNmeets';
$string['newmodulename'] = 'plugNmeet naam';
$string['newmodulename_help'] = 'Dit is de inhoud van de help-tooltip die is gekoppeld aan het plugNmeet-veld';
$string['newmodulesettings'] = 'Instellingen';
$string['nonewmodules'] = 'Geen plugNmeet';
$string['pluginadministration'] = 'plugNmeet-administratie';
$string['pluginname'] = 'stekkerNontmoeten';
$string['pluginname_help'] = 'Help-tekst bij het toevoegen van dit vraagtype.';
$string['pluginnameadding'] = 'Gerendeerd bij het toevoegen van dit vraagtype.';
$string['pluginnameediting'] = 'Gerendeerd bij het bewerken van dit vraagtype.';
$string['pluginnamesummary'] = 'Gerendeerd bij het kiezen van het vraagtype dat moet worden toegevoegd.';
$string['plugnmeet:access'] = 'Toegang tot inhoud';
$string['plugnmeet:addinstance'] = 'Een nieuwe plugNmeet-activiteit toevoegen';
$string['plugnmeet:edit'] = 'PlugNmeet bewerken';
$string['plugnmeet:enrol'] = 'Gebruikers inschrijven';
$string['plugnmeet:manage'] = 'Gebruikers beheren';
$string['plugnmeet:unenrol'] = 'Gebruikers uitschrijven';
$string['plugnmeet:upload'] = 'Inhoud uploaden';
$string['plugnmeet:useeditor'] = 'Inhoud bewerken';
$string['plugnmeet:view'] = 'Bekijk plugNmeet';
$string['privacy:metadata:plugnmeet'] = 'Om te integreren met een externe plugnmeet-server, moeten gebruikersgegevens met die server worden uitgewisseld.';
$string['privacy:metadata:plugnmeet:userid'] = 'De userid wordt verzonden vanuit Moodle om u toegang te geven tot uw gegevens op het externe systeem.';
$string['privacy:metadata:plugnmeet:fullname'] = 'Uw volledige naam wordt naar het externe systeem gestuurd om een betere gebruikerservaring mogelijk te maken.';

$string['view'] = 'Bekijken';
$string['yes'] = 'Ja';
$string['no'] = 'Nee';
$string['join'] = 'Verbinden';
$string['plugnmeetname'] = 'stekkerNontmoeten';
$string['plugnmeetname_help'] = 'Help';
$string['plugnmeet_viewed'] = 'plugNmeet-activiteit bekeken';
$string['joined_session'] = 'Deelnemende sessie';

$string['plugnmeetconfig'] = 'plugNmeet-configuratie';
$string['plugnmeet_server_url'] = 'URL van de PlugNmeet-server';
$string['plugnmeet_server_url_des'] = 'Voer de URL van de plugNmeet-server in';
$string['plugnmeet_api_key'] = 'plugnmeet API-sleutel';
$string['plugnmeet_api_key_des'] = 'Voer de plugnmeet API-sleutel in';
$string['plugnmeet_secret'] = 'plugnmeet Geheim';
$string['plugnmeet_secret_des'] = 'Voer plugnmeet Secret in';
$string['livekit_server_url'] = 'URL van de Livekit-server';
$string['livekit_server_url_des'] = 'Voer de URL van de Livekit-server in';
$string['custom_logo'] = 'Aangepast logo';
$string['custom_logo_des'] = 'Aangepast logo voor vergaderruimte';

$string['plugnmeetoptions'] = 'plugNmeet-opties';
$string['enable_dynacast'] = 'Dynacast inschakelen';
$string['enable_dynacast_des'] = 'Dynacast inschakelen';
$string['enable_simulcast'] = 'Simulcast inschakelen';
$string['enable_simulcast_des'] = 'Simulcast inschakelen';
$string['stop_mic_track_on_mute'] = 'Stop microfoontrack bij dempen';
$string['stop_mic_track_on_mute_des'] = 'Stop microfoontrack bij dempen';
$string['video_codec'] = 'Videocodec';
$string['video_codec_des'] = 'Videocodec';
$string['default_webcam_resolution'] = 'Standaard webcamresolutie';
$string['default_webcam_resolution_des'] = 'Standaard webcamresolutie';
$string['default_screen_share_resolution'] = 'Standaard resolutie voor schermdeling';
$string['default_screen_share_resolution_des'] = 'Standaard resolutie voor schermdeling';
$string['default_audio_preset'] = 'Audio voorinstelling';
$string['default_audio_preset_des'] = 'Audio-voorinstelling voor microfoon';
$string['copyright_display'] = 'Weergave van auteursrechten inschakelen';
$string['copyright_display_des'] = 'Indien ingeschakeld, wordt de onderstaande tekst weergegeven';
$string['copyright_text'] = 'Copyright tekst';
$string['copyright_text_des'] = 'Deze tekst kan worden ingesteld als de configuratie van de server toestaat om te overschrijven';

$string['roomtitle'] = 'Titel van de kamer';
$string['welcome_message'] = 'Welkomst bericht';
$string['max_participants'] = 'Maximum aantal deelnemers (0 = onbeperkt)';

$string['room_features'] = 'Kenmerken van de kamer';
$string['roomfeatures'] = 'Kenmerken van de kamer';
$string['allow_webcams'] = 'Webcams toestaan';
$string['mute_on_start'] = 'Dempen bij starten';
$string['allow_screen_share'] = 'Schermdeling toestaan';
$string['allow_rtmp'] = 'RTMP toestaan';
$string['allow_view_other_webcams'] = 'Weergave van andere webcams toestaan';
$string['allow_view_other_users_list'] = 'Weergave van andere gebruikers toestaan';
$string['admin_only_webcams'] = 'Alleen webcams voor beheerders';
$string['allow_polls'] = 'Peilingen toestaan';
$string['room_duration'] = 'Duur van de kamer (in minuten, 0 = onbeperkt)';
$string['moderator_join_first'] = 'Moderator doe eerst mee';
$string['moderator_join_first_error'] = 'De vergadering is nog niet begonnen, kom later terug';
$string['enable_analytics'] = 'Analyse inschakelen';
$string['allow_virtual_bg'] = 'Virtuele achtergrond toestaan';
$string['allow_raise_hand'] = 'Sta hand opsteken toe';
$string['auto_gen_user_id'] = 'Gebruikers-ID automatisch genereren';

$string['other_features'] = 'Geavanceerde functies';

$string['recordingfeatures'] = 'Opname functies';
$string['allow_recording'] = 'Opname toestaan';
$string['allow_cloud_recording'] = 'Opnemen in de cloud toestaan';
$string['enable_auto_cloud_recording'] = 'Schakel automatisch starten van cloudopname in';
$string['allow_local_recording'] = 'Lokale opname toestaan';
$string['is_allow_view_recording'] = 'Sta studenten toe om de opname te bekijken';
$string['is_allow_download_recording'] = 'Sta studenten toe om opname te downloaden';

$string['chatfeatures'] = 'Chat-functies';
$string['allow_chat'] = 'Chat toestaan';
$string['allow_file_upload'] = 'Uploaden van bestanden toestaan';

$string['shared_note_pad_features'] = 'Functies van gedeeld kladblok';
$string['allow_shared_notepad'] = 'Gedeeld kladblok toestaan';

$string['whiteboard_features'] = 'Whiteboard-functies';
$string['allow_whiteboard'] = 'Whiteboard toestaan';

$string['external_media_player_features'] = 'Functies van externe mediaspeler';
$string['allowed_external_media_player'] = 'Externe mediaspeler toestaan';

$string['waiting_room_features'] = 'Kenmerken van de wachtkamer';
$string['activate_waiting_room'] = 'Wachtkamer activeren';
$string['waiting_room_msg'] = 'Bericht in de wachtkamer';

$string['breakout_room_features'] = 'Kenmerken van de aparte vergaderruimte';
$string['allow_breakout_rooms'] = 'Aparte vergaderruimten toestaan';
$string['allowed_number_rooms'] = 'Aantal kamers';

$string['display_external_link_features'] = 'Functies voor externe koppelingen weergeven';
$string['allow_display_external_link_features'] = 'Weergave van functies voor externe links toestaan';
$string['allow_ingress_features'] = 'Toestaan om toegang te creëren';

$string['defaultlock'] = 'Standaard vergrendelingsinstellingen';
$string['lock_microphone'] = 'Microfoon vergrendelen';
$string['lock_webcam'] = 'Webcam vergrendelen';
$string['lock_screen_sharing'] = 'Scherm delen vergrendelen';
$string['lock_whiteboard'] = 'Whiteboard vergrendelen';
$string['lock_shared_notepad'] = 'Gedeeld kladblok vergrendelen';
$string['lock_chat'] = 'Chat vergrendelen';
$string['lock_chat_send_message'] = 'Bericht verzenden vergrendelen';
$string['lock_chat_file_share'] = 'Bestandsdeling vergrendelen';
$string['lock_private_chat'] = 'Privéchat vergrendelen';

$string['available'] = 'Beschikbaar vanaf';
$string['deadline'] = 'Termijn';

$string['extraoption'] = 'Extra opties';

$string['client_load'] = 'Clientbelasting van';
$string['client_load_des'] = 'Standaardinstelling: Afstandsbediening';
$string['remote'] = 'Afgelegen';
$string['local'] = 'Lokaal';

$string['client_download_url'] = 'Download-URL voor lokale client';
$string['client_download_url_des'] = 'Download-URL voor lokale client. Standaard github';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">Download de nieuwste client</button>';
$string['error_file_open'] = 'Fout in zip-bestand openen';
$string['client_updated_success'] = 'Client succesvol geüpdatet';
$string['client_updated_failed'] = 'Kan client niet bijwerken';

$string['join'] = 'Verbinden';
$string['end'] = 'Einde';
$string['recordings'] = 'Opnamen';
$string['recording_date'] = 'Datum van opname';
$string['meeting_date'] = 'Datum van de zitting';
$string['file_size'] = 'Bestandsgrootte (MB)';
$string['play'] = 'Spelen';
$string['download'] = 'Downloaden';
$string['delete'] = 'Verwijderen';
$string['sure_to_delete'] = 'Weet je zeker dat je gaat verwijderen?';

$string['design_customization'] = 'Aanpassing van het ontwerp';
$string['custom_css_url'] = 'Aangepaste CSS-URL';
$string['custom_css_url_des'] = 'Moet de https direct CSS-bestands-url zijn';
$string['primary_color'] = 'Primaire kleur';
$string['primary_color_des'] = 'Primaire kleur voor interface';
$string['secondary_color'] = 'Secundaire kleur';
$string['secondary_color_des'] = 'Secundaire kleur voor interface';
$string['background_color'] = 'Achtergrondkleur';
$string['background_color_des'] = 'Interface achtergrondkleur';
$string['background_image'] = 'Achtergrondafbeelding';
$string['background_image_des'] = 'Moet 1920X1080 groot zijn voor het beste resultaat.';
$string['header_color'] = 'Header Kleur';
$string['header_color_des'] = 'Interface Header Kleur';
$string['footer_color'] = 'Voettekst Kleur';
$string['footer_color_des'] = 'Interface Footer Kleur';
$string['left_color'] = 'Kleur linkerkant';
$string['left_color_des'] = 'Kleur linkerzijbalk';
$string['side_panel_bg_color'] = 'Achtergrondkleur van het zijpaneel';
$string['side_panel_bg_color_des'] = 'Achtergrondkleur rechter zijpaneel';
$string['column_camera_position'] = 'Kolom camera positie';
$string['column_camera_position_des'] = 'Kolom camera positie. Standaardinstelling: links';
$string['column_camera_width'] = 'Breedte kolomcamera';
$string['column_camera_width_des'] = 'Breedte kolomcamera';

$string['allow_speech_to_text_translation_features'] = 'Spraak-naar-tekst/vertaalfuncties toestaan';
$string['allow_speech_translation'] = 'Vertaling toestaan';

$string['enable_end_to_end_encryption_features'] = 'End-to-end-versleuteling inschakelen (E2EE)';
$string['enabled_self_insert_encryption_key'] = 'Schakel de handmatige E2EE-toets in';
$string['included_e2ee_chat_messages'] = "Versleuteling inschakelen voor chat";
$string['included_e2ee_whiteboard'] = "Versleuteling inschakelen voor whiteboard";

$string['insights_features'] = 'Insights AI';
$string['insights_features_is_allow'] = 'Inzichtsfuncties inschakelen';
$string['insights_transcription_features_is_allow'] = 'Transcriptie toestaan';
$string['insights_transcription_features_is_allow_translation'] = 'Transcriptievertaling mogelijk';
$string['insights_transcription_features_is_allow_speech_synthesis'] = 'Spraaksynthese mogelijk maken';
$string['insights_chat_translation_features_is_allow'] = 'Staat chatvertaling toe';
$string['insights_ai_features_is_allow'] = 'Sta AI-functies toe';
$string['insights_ai_text_chat_features_is_allow'] = 'Sta AI-tekstchat toe';
$string['insights_ai_meeting_summarization_features_is_allow'] = 'Sta AI-vergaderingssamenvatting mogelijk';
