<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'Leggimi quando si seleziona il tema.';
$string['missingidandcmid'] = 'ID e cmid mancanti';
$string['modulename'] = 'plugNmeet';
$string['modulename_help'] = 'Usa il modulo plugNmeet per...';
$string['modulenameplural'] = 'plugNmeets';
$string['newmodulename'] = 'nome plugNmeet';
$string['newmodulename_help'] = 'Questo è il contenuto del tooltip della guida associato al campo plugNmeet';
$string['newmodulesettings'] = 'Impostazioni';
$string['nonewmodules'] = 'No plugNmeet';
$string['pluginadministration'] = 'Amministrazione di plugNmeet';
$string['pluginname'] = 'plugNmeet';
$string['pluginname_help'] = 'Testo di aiuto quando si aggiunge questo tipo di domanda.';
$string['pluginnameadding'] = 'Visualizzato quando si aggiunge questo tipo di domanda.';
$string['pluginnameediting'] = 'Visualizzato durante la modifica di questo tipo di domanda.';
$string['pluginnamesummary'] = 'Visualizzato quando si sceglie il tipo di domanda da aggiungere.';
$string['plugnmeet:access'] = 'Accedi ai contenuti';
$string['plugnmeet:addinstance'] = 'Aggiungere una nuova attività plugNmeet';
$string['plugnmeet:edit'] = 'Modifica plugNmeet';
$string['plugnmeet:enrol'] = 'Iscrivi gli utenti';
$string['plugnmeet:manage'] = 'Gestire gli utenti';
$string['plugnmeet:unenrol'] = 'Annulla l\'iscrizione degli utenti';
$string['plugnmeet:upload'] = 'Caricare contenuti';
$string['plugnmeet:useeditor'] = 'Modifica il contenuto';
$string['plugnmeet:view'] = 'Visualizza plugNmeet';
$string['privacy:metadata:plugnmeet'] = 'Per l\'integrazione con un server plugnmeet remoto, i dati dell\'utente devono essere scambiati con tale server.';
$string['privacy:metadata:plugnmeet:userid'] = 'L\'userid viene inviato da Moodle per consentire l\'accesso ai propri dati sul sistema remoto.';
$string['privacy:metadata:plugnmeet:fullname'] = 'Il tuo nome completo viene inviato al sistema remoto per consentire una migliore esperienza utente.';

$string['view'] = 'Vista';
$string['yes'] = 'Sì';
$string['no'] = 'No';
$string['join'] = 'Unire';
$string['plugnmeetname'] = 'plugNmeet';
$string['plugnmeetname_help'] = 'Guida';
$string['plugnmeet_viewed'] = 'attività di plugNmeet visualizzata';
$string['joined_session'] = 'Sessione partecipata';

$string['plugnmeetconfig'] = 'Configurazione di plugNmeet';
$string['plugnmeet_server_url'] = 'URL del server PlugnMeet';
$string['plugnmeet_server_url_des'] = 'Inserisci l\'URL del server plugNmeet';
$string['plugnmeet_api_key'] = 'Chiave API plugnmeet';
$string['plugnmeet_api_key_des'] = 'Inserisci la chiave API plugnmeet';
$string['plugnmeet_secret'] = 'plugnmeet Segreto';
$string['plugnmeet_secret_des'] = 'Inserisci plugnmeet Secret';
$string['livekit_server_url'] = 'URL del server Livekit';
$string['livekit_server_url_des'] = 'Inserisci l\'URL del server Livekit';
$string['custom_logo'] = 'Logo personalizzato';
$string['custom_logo_des'] = 'Logo personalizzato per sala conferenze';

$string['plugnmeetoptions'] = 'Opzioni di plugNmeet';
$string['enable_dynacast'] = 'Abilita dynacast';
$string['enable_dynacast_des'] = 'Abilita dynacast';
$string['enable_simulcast'] = 'Abilita simulcast';
$string['enable_simulcast_des'] = 'Abilita simulcast';
$string['stop_mic_track_on_mute'] = 'Interrompi la traccia del microfono in modalità silenziosa';
$string['stop_mic_track_on_mute_des'] = 'Interrompi la traccia del microfono in modalità silenziosa';
$string['video_codec'] = 'Codec video';
$string['video_codec_des'] = 'Codec video';
$string['default_webcam_resolution'] = 'Risoluzione predefinita della webcam';
$string['default_webcam_resolution_des'] = 'Risoluzione predefinita della webcam';
$string['default_screen_share_resolution'] = 'Risoluzione predefinita per la condivisione dello schermo';
$string['default_screen_share_resolution_des'] = 'Risoluzione predefinita per la condivisione dello schermo';
$string['default_audio_preset'] = 'Preimpostazione audio';
$string['default_audio_preset_des'] = 'Preimpostazione audio per microfono';
$string['copyright_display'] = 'Abilita la visualizzazione del copyright';
$string['copyright_display_des'] = 'Se abilitato, verrà visualizzato il testo sottostante';
$string['copyright_text'] = 'Testo protetto da copyright';
$string['copyright_text_des'] = 'Questo testo può essere impostato se la configurazione del server consente di sovrascrivere';

$string['roomtitle'] = 'Titolo della camera';
$string['welcome_message'] = 'Messaggio di benvenuto';
$string['max_participants'] = 'Numero massimo di partecipanti (0 = illimitato)';

$string['room_features'] = 'Caratteristiche della camera';
$string['roomfeatures'] = 'Caratteristiche della camera';
$string['allow_webcams'] = 'Consenti webcam';
$string['mute_on_start'] = 'Disattiva all\'avvio';
$string['allow_screen_share'] = 'Consenti condivisione schermo';
$string['allow_rtmp'] = 'Consenti RTMP';
$string['allow_view_other_webcams'] = 'Consenti la visualizzazione di altre webcam';
$string['allow_view_other_users_list'] = 'Consenti visualizzazione altri utenti';
$string['admin_only_webcams'] = 'Webcam solo per amministratori';
$string['allow_polls'] = 'Consenti sondaggi';
$string['room_duration'] = 'Durata della stanza (in minuti, 0 = illimitato)';
$string['moderator_join_first'] = 'Il moderatore si unisce per primo';
$string['moderator_join_first_error'] = 'La riunione non è ancora iniziata, si prega di tornare più tardi';
$string['enable_analytics'] = 'Abilita l\'analisi';
$string['allow_virtual_bg'] = 'Consenti sfondo virtuale';
$string['allow_raise_hand'] = 'Consentire di alzare la mano';
$string['auto_gen_user_id'] = 'Genera automaticamente l\'ID utente';

$string['other_features'] = 'Funzionalità avanzate';

$string['recordingfeatures'] = 'Funzioni di registrazione';
$string['allow_recording'] = 'Consenti registrazione';
$string['allow_cloud_recording'] = 'Consenti registrazione cloud';
$string['enable_auto_cloud_recording'] = 'Abilita l\'avvio automatico della registrazione su cloud';
$string['allow_local_recording'] = 'Consenti registrazione locale';
$string['is_allow_view_recording'] = 'Consenti agli studenti di visualizzare la registrazione';
$string['is_allow_download_recording'] = 'Consenti agli studenti di scaricare la registrazione';

$string['chatfeatures'] = 'Funzionalità di chat';
$string['allow_chat'] = 'Consenti chat';
$string['allow_file_upload'] = 'Consenti caricamento file';

$string['shared_note_pad_features'] = 'Funzionalità del blocco note condiviso';
$string['allow_shared_notepad'] = 'Consenti blocco note condiviso';

$string['whiteboard_features'] = 'Caratteristiche della lavagna';
$string['allow_whiteboard'] = 'Consenti lavagna';

$string['external_media_player_features'] = 'Funzionalità del lettore multimediale esterno';
$string['allowed_external_media_player'] = 'Consenti lettore multimediale esterno';

$string['waiting_room_features'] = 'Caratteristiche della sala d\'attesa';
$string['activate_waiting_room'] = 'Attiva sala d\'attesa';
$string['waiting_room_msg'] = 'Messaggio sala d\'attesa';

$string['breakout_room_features'] = 'Caratteristiche della sala riunioni';
$string['allow_breakout_rooms'] = 'Consenti gruppi di lavoro';
$string['allowed_number_rooms'] = 'Numero di camere';

$string['display_external_link_features'] = 'Visualizzare le funzioni dei collegamenti esterni';
$string['allow_display_external_link_features'] = 'Consenti la visualizzazione delle funzioni di collegamento esterno';
$string['allow_ingress_features'] = 'Consenti di creare l\'ingresso';

$string['defaultlock'] = 'Impostazioni di blocco predefinite';
$string['lock_microphone'] = 'Blocca microfono';
$string['lock_webcam'] = 'Blocca webcam';
$string['lock_screen_sharing'] = 'Condivisione dello schermo di blocco';
$string['lock_whiteboard'] = 'Blocca lavagna';
$string['lock_shared_notepad'] = 'Bloccare il blocco note condiviso';
$string['lock_chat'] = 'Blocca la chat';
$string['lock_chat_send_message'] = 'Blocca l\'invio del messaggio';
$string['lock_chat_file_share'] = 'Bloccare la condivisione file';
$string['lock_private_chat'] = 'Blocca la chat privata';

$string['available'] = 'Disponibile dal';
$string['deadline'] = 'Scadenza';

$string['extraoption'] = 'Opzioni extra';

$string['client_load'] = 'Carico client da';
$string['client_load_des'] = 'Predefinito: Remoto';
$string['remote'] = 'Remoto';
$string['local'] = 'Locale';

$string['client_download_url'] = 'URL di download del client locale';
$string['client_download_url_des'] = 'URL di download del client locale. Github predefinito';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">Scarica l\'ultimo client</button>';
$string['error_file_open'] = 'Errore nell\'apertura del file zip';
$string['client_updated_success'] = 'Client aggiornato correttamente';
$string['client_updated_failed'] = 'Impossibile aggiornare il client';

$string['join'] = 'Unire';
$string['end'] = 'Fine';
$string['recordings'] = 'Registrazioni';
$string['recording_date'] = 'Data di registrazione';
$string['meeting_date'] = 'Data dell\'incontro';
$string['file_size'] = 'Dimensione del file (MB)';
$string['play'] = 'Giocare';
$string['download'] = 'Scaricare';
$string['delete'] = 'Cancellare';
$string['sure_to_delete'] = 'Sei sicuro di eliminare?';

$string['design_customization'] = 'Personalizzazione del design';
$string['custom_css_url'] = 'URL CSS personalizzato';
$string['custom_css_url_des'] = 'Dovrebbe essere l\'URL del file CSS diretto https';
$string['primary_color'] = 'Colore primario';
$string['primary_color_des'] = 'Colore primario per l\'interfaccia';
$string['secondary_color'] = 'Colore secondario';
$string['secondary_color_des'] = 'Colore secondario per l\'interfaccia';
$string['background_color'] = 'Colore di sfondo';
$string['background_color_des'] = 'Colore di sfondo dell\'interfaccia';
$string['background_image'] = 'Immagine di sfondo';
$string['background_image_des'] = 'Dovrebbe avere una dimensione di 1920X1080 per ottenere il miglior risultato.';
$string['header_color'] = 'Colore intestazione';
$string['header_color_des'] = 'Colore dell\'intestazione dell\'interfaccia';
$string['footer_color'] = 'Colore piè di pagina';
$string['footer_color_des'] = 'Colore del piè di pagina dell\'interfaccia';
$string['left_color'] = 'Colore lato sinistro';
$string['left_color_des'] = 'Colore della barra laterale sinistra';
$string['side_panel_bg_color'] = 'Colore di sfondo del pannello laterale';
$string['side_panel_bg_color_des'] = 'Colore dello sfondo del pannello laterale destro';
$string['column_camera_position'] = 'Posizione della telecamera a colonna';
$string['column_camera_position_des'] = 'Posizione della telecamera a colonna. Impostazione predefinita: sinistra';
$string['column_camera_width'] = 'Larghezza della telecamera a colonna';
$string['column_camera_width_des'] = 'Larghezza della telecamera a colonna';

$string['allow_speech_to_text_translation_features'] = 'Consenti funzionalità di sintesi vocale/traduzione';
$string['allow_speech_translation'] = 'Consenti traduzione';

$string['enable_end_to_end_encryption_features'] = 'Abilita crittografia end-to-end (E2EE)';
$string['enabled_self_insert_encryption_key'] = 'Abilita il tasto manuale E2EE';
$string['included_e2ee_chat_messages'] = "Abilita la crittografia per la chat";
$string['included_e2ee_whiteboard'] = "Abilita la crittografia per la lavagna";

$string['insights_features'] = 'Insight AI';
$string['insights_features_is_allow'] = 'Abilita le funzionalità di insight';
$string['insights_transcription_features_is_allow'] = 'Consentire la trascrizione';
$string['insights_transcription_features_is_allow_translation'] = 'Consentire la traduzione della trascrizione';
$string['insights_transcription_features_is_allow_speech_synthesis'] = 'Consentire la sintesi vocale';
$string['insights_chat_translation_features_is_allow'] = 'Consentire la traduzione della chat';
$string['insights_ai_features_is_allow'] = 'Consentire funzionalità di IA';
$string['insights_ai_text_chat_features_is_allow'] = 'Consenti chat testuale con IA';
$string['insights_ai_meeting_summarization_features_is_allow'] = 'Permette la sintesi delle riunioni tramite IA';
