<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'Readme bei der Auswahl des Themes.';
$string['missingidandcmid'] = 'Fehlende ID und cmid';
$string['modulename'] = 'plugNmeet';
$string['modulename_help'] = 'Verwenden Sie das plugNmeet-Modul für...';
$string['modulenameplural'] = 'plugNmeets';
$string['newmodulename'] = 'plugNmeet Name';
$string['newmodulename_help'] = 'Dies ist der Inhalt des Hilfe-Tooltips, der dem Feld plugNmeet zugeordnet ist';
$string['newmodulesettings'] = 'Einstellungen';
$string['nonewmodules'] = 'Kein PlugNmeet';
$string['pluginadministration'] = 'plugNmeet Verwaltung';
$string['pluginname'] = 'plugNmeet';
$string['pluginname_help'] = 'Hilfetext beim Hinzufügen dieses Fragetyps.';
$string['pluginnameadding'] = 'Wird beim Hinzufügen dieses Fragetyps gerendert.';
$string['pluginnameediting'] = 'Wird beim Bearbeiten dieses Fragetyps gerendert.';
$string['pluginnamesummary'] = 'Wird bei der Auswahl des hinzuzufügenden Fragetyps gerendert.';
$string['plugnmeet:access'] = 'Zugriff auf Inhalte';
$string['plugnmeet:addinstance'] = 'Hinzufügen einer neuen plugNmeet-Aktivität';
$string['plugnmeet:edit'] = 'plugNmeet bearbeiten';
$string['plugnmeet:enrol'] = 'Benutzer einschreiben';
$string['plugnmeet:manage'] = 'Verwalten von Benutzern';
$string['plugnmeet:unenrol'] = 'Benutzer abmelden';
$string['plugnmeet:upload'] = 'Inhalte hochladen';
$string['plugnmeet:useeditor'] = 'Bearbeiten von Inhalten';
$string['plugnmeet:view'] = 'plugNmeet anzeigen';
$string['privacy:metadata:plugnmeet'] = 'Um sich in einen Remote-Plugnmeet-Server zu integrieren, müssen Benutzerdaten mit diesem Server ausgetauscht werden.';
$string['privacy:metadata:plugnmeet:userid'] = 'Die Benutzer-ID wird von Moodle gesendet, damit Sie auf Ihre Daten auf dem Remote-System zugreifen können.';
$string['privacy:metadata:plugnmeet:fullname'] = 'Ihr vollständiger Name wird an das Remote-System gesendet, um eine bessere Benutzererfahrung zu ermöglichen.';

$string['view'] = 'Ansehen';
$string['yes'] = 'Ja';
$string['no'] = 'Nein';
$string['join'] = 'Verbinden';
$string['plugnmeetname'] = 'plugNmeet';
$string['plugnmeetname_help'] = 'Hilfe';
$string['plugnmeet_viewed'] = 'Angezeigte plugNmeet-Aktivität';
$string['joined_session'] = 'Beteiligte Sitzung';

$string['plugnmeetconfig'] = 'plugNmeet-Konfiguration';
$string['plugnmeet_server_url'] = 'PlugnMeet-Server-URL';
$string['plugnmeet_server_url_des'] = 'Geben Sie die plugNmeet Server-URL ein';
$string['plugnmeet_api_key'] = 'plugnmeet API-Schlüssel';
$string['plugnmeet_api_key_des'] = 'Geben Sie den Plugnmeet-API-Schlüssel ein';
$string['plugnmeet_secret'] = 'plugnmeet Geheimnis';
$string['plugnmeet_secret_des'] = 'Geben Sie plugnmeet Secret ein';
$string['livekit_server_url'] = 'URL des Livekit-Servers';
$string['livekit_server_url_des'] = 'Geben Sie die Livekit-Server-URL ein';
$string['custom_logo'] = 'Benutzerdefiniertes Logo';
$string['custom_logo_des'] = 'Individuelles Logo für den Konferenzraum';

$string['plugnmeetoptions'] = 'plugNmeet-Optionen';
$string['enable_dynacast'] = 'Aktivieren von Dynacast';
$string['enable_dynacast_des'] = 'Aktivieren von Dynacast';
$string['enable_simulcast'] = 'Simulcast aktivieren';
$string['enable_simulcast_des'] = 'Simulcast aktivieren';
$string['stop_mic_track_on_mute'] = 'Stoppen Sie die Mikrofonspur bei Stummschaltung';
$string['stop_mic_track_on_mute_des'] = 'Stoppen Sie die Mikrofonspur bei Stummschaltung';
$string['video_codec'] = 'Video-Codec';
$string['video_codec_des'] = 'Video-Codec';
$string['default_webcam_resolution'] = 'Standardauflösung der Webcam';
$string['default_webcam_resolution_des'] = 'Standardauflösung der Webcam';
$string['default_screen_share_resolution'] = 'Standardauflösung für die Bildschirmfreigabe';
$string['default_screen_share_resolution_des'] = 'Standardauflösung für die Bildschirmfreigabe';
$string['default_audio_preset'] = 'Audio-Voreinstellung';
$string['default_audio_preset_des'] = 'Audio-Preset für Mikrofon';
$string['copyright_display'] = 'Copyright-Anzeige aktivieren';
$string['copyright_display_des'] = 'Wenn diese Option aktiviert ist, wird der folgende Text angezeigt.';
$string['copyright_text'] = 'Copyright-Text';
$string['copyright_text_des'] = 'Dieser Text kann gesetzt werden, wenn die Konfiguration des Servers überschrieben werden darf';

$string['roomtitle'] = 'Titel des Raumes';
$string['welcome_message'] = 'Willkommensnachricht';
$string['max_participants'] = 'Maximale Teilnehmerzahl (0 = unbegrenzt)';

$string['room_features'] = 'Zimmerausstattung';
$string['roomfeatures'] = 'Zimmerausstattung';
$string['allow_webcams'] = 'Webcams zulassen';
$string['mute_on_start'] = 'Stummschaltung beim Start';
$string['allow_screen_share'] = 'Bildschirmfreigabe zulassen';
$string['allow_rtmp'] = 'RTMP zulassen';
$string['allow_view_other_webcams'] = 'Andere Webcams anzeigen zulassen';
$string['allow_view_other_users_list'] = 'Zulassen, dass andere Benutzer angezeigt werden';
$string['admin_only_webcams'] = 'Webcams nur für Administratoren';
$string['allow_polls'] = 'Umfragen zulassen';
$string['room_duration'] = 'Raumdauer (in Minuten, 0 = unbegrenzt)';
$string['moderator_join_first'] = 'Moderator zuerst beitreten';
$string['moderator_join_first_error'] = 'Das Treffen hat noch nicht begonnen, bitte kommen Sie später zurück';
$string['enable_analytics'] = 'Aktivieren von Analysen';
$string['allow_virtual_bg'] = 'Virtuellen Hintergrund zulassen';
$string['allow_raise_hand'] = 'Erlauben Sie das Heben der Hand';
$string['auto_gen_user_id'] = 'Benutzer-ID automatisch generieren';

$string['other_features'] = 'Erweiterte Funktionen';

$string['recordingfeatures'] = 'Funktionen für die Aufzeichnung';
$string['allow_recording'] = 'Aufzeichnung zulassen';
$string['allow_cloud_recording'] = 'Cloud-Aufzeichnung zulassen';
$string['enable_auto_cloud_recording'] = 'Aktivieren Sie den automatischen Start der Cloud-Aufzeichnung';
$string['allow_local_recording'] = 'Lokale Aufzeichnung zulassen';
$string['is_allow_view_recording'] = 'Schülern erlauben, Aufzeichnungen anzusehen';
$string['is_allow_download_recording'] = 'Erlauben Sie den Schülern, Aufzeichnungen herunterzuladen';

$string['chatfeatures'] = 'Chat-Funktionen';
$string['allow_chat'] = 'Chat zulassen';
$string['allow_file_upload'] = 'Hochladen von Dateien zulassen';

$string['shared_note_pad_features'] = 'Freigegebene Notepad-Funktionen';
$string['allow_shared_notepad'] = 'Freigegebenen Notizblock zulassen';

$string['whiteboard_features'] = 'Whiteboard-Funktionen';
$string['allow_whiteboard'] = 'Whiteboard zulassen';

$string['external_media_player_features'] = 'Funktionen des externen Mediaplayers';
$string['allowed_external_media_player'] = 'Externen Mediaplayer zulassen';

$string['waiting_room_features'] = 'Merkmale des Wartezimmers';
$string['activate_waiting_room'] = 'Wartezimmer aktivieren';
$string['waiting_room_msg'] = 'Nachricht im Wartezimmer';

$string['breakout_room_features'] = 'Funktionen des Breakout-Raums';
$string['allow_breakout_rooms'] = 'Breakout-Räume zulassen';
$string['allowed_number_rooms'] = 'Anzahl der Zimmer';

$string['display_external_link_features'] = 'Anzeigen von Features für externe Links';
$string['allow_display_external_link_features'] = 'Anzeige von Features für externe Verknüpfungen zulassen';
$string['allow_ingress_features'] = 'Erstellen von Ingress zulassen';

$string['defaultlock'] = 'Standardeinstellungen für die Sperre';
$string['lock_microphone'] = 'Mikrofon sperren';
$string['lock_webcam'] = 'Webcam sperren';
$string['lock_screen_sharing'] = 'Bildschirmfreigabe sperren';
$string['lock_whiteboard'] = 'Whiteboard sperren';
$string['lock_shared_notepad'] = 'Freigegebenen Notizblock sperren';
$string['lock_chat'] = 'Chat sperren';
$string['lock_chat_send_message'] = 'Sperren Sie das Senden einer Nachricht';
$string['lock_chat_file_share'] = 'Sperren von Dateifreigaben';
$string['lock_private_chat'] = 'Privaten Chat sperren';

$string['available'] = 'Verfügbar ab';
$string['deadline'] = 'Stichtag';

$string['extraoption'] = 'Zusätzliche Optionen';

$string['client_load'] = 'Client-Last von';
$string['client_load_des'] = 'Standard: remote';
$string['remote'] = 'Abgelegen';
$string['local'] = 'Lokal';

$string['client_download_url'] = 'Download-URL des lokalen Clients';
$string['client_download_url_des'] = 'Download-URL des lokalen Clients. Standard-Github';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">Neuesten Client herunterladen</button>';
$string['error_file_open'] = 'Fehler beim Öffnen der Zip-Datei';
$string['client_updated_success'] = 'Client erfolgreich aktualisiert';
$string['client_updated_failed'] = 'Fehler beim Aktualisieren des Clients';

$string['join'] = 'Verbinden';
$string['end'] = 'Ende';
$string['recordings'] = 'Aufnahmen';
$string['recording_date'] = 'Datum der Aufnahme';
$string['meeting_date'] = 'Datum des Treffens';
$string['file_size'] = 'Dateigröße (MB)';
$string['play'] = 'Spielen';
$string['download'] = 'Herunterladen';
$string['delete'] = 'Löschen';
$string['sure_to_delete'] = 'Sind Sie sicher, dass Sie löschen möchten?';

$string['design_customization'] = 'Design-Anpassung';
$string['custom_css_url'] = 'Benutzerdefinierte CSS-URL';
$string['custom_css_url_des'] = 'Sollte die direkte URL der CSS-Datei https sein';
$string['primary_color'] = 'Primärfarbe';
$string['primary_color_des'] = 'Primärfarbe für die Benutzeroberfläche';
$string['secondary_color'] = 'Sekundäre Farbe';
$string['secondary_color_des'] = 'Sekundäre Farbe für die Schnittstelle';
$string['background_color'] = 'Hintergrundfarbe';
$string['background_color_des'] = 'Hintergrundfarbe der Benutzeroberfläche';
$string['background_image'] = 'Hintergrundbild';
$string['background_image_des'] = 'Sollte für ein optimales Ergebnis eine Größe von 1920 x 1080 haben.';
$string['header_color'] = 'Farbe der Kopfzeile';
$string['header_color_des'] = 'Farbe der Kopfzeile der Benutzeroberfläche';
$string['footer_color'] = 'Farbe der Fußzeile';
$string['footer_color_des'] = 'Farbe der Fußzeile der Benutzeroberfläche';
$string['left_color'] = 'Farbe der linken Seite';
$string['left_color_des'] = 'Farbe der linken Seitenleiste';
$string['side_panel_bg_color'] = 'Hintergrundfarbe des Seitenpanels';
$string['side_panel_bg_color_des'] = 'Hintergrundfarbe des rechten Seitenpanels';
$string['column_camera_position'] = 'Position der Säulenkamera';
$string['column_camera_position_des'] = 'Position der Spaltenkamera. Standardeinstellung: links';
$string['column_camera_width'] = 'Kamerabreite der Spalte';
$string['column_camera_width_des'] = 'Kamerabreite der Spalte';

$string['allow_speech_to_text_translation_features'] = 'Sprach-zu-Text-/Übersetzungsfunktionen zulassen';
$string['allow_speech_translation'] = 'Übersetzung zulassen';

$string['enable_end_to_end_encryption_features'] = 'Aktivieren der Ende-zu-Ende-Verschlüsselung (E2EE)';
$string['enabled_self_insert_encryption_key'] = 'Manuelle E2EE-Taste aktivieren';
$string['included_e2ee_chat_messages'] = "Aktivieren der Verschlüsselung für den Chat";
$string['included_e2ee_whiteboard'] = "Aktivieren der Verschlüsselung für Whiteboards";

$string['insights_features'] = 'Insights-KI';
$string['insights_features_is_allow'] = 'Aktivieren Sie Insights-Funktionen';
$string['insights_transcription_features_is_allow'] = 'Transkription erlauben';
$string['insights_transcription_features_is_allow_translation'] = 'Erlauben Sie Transkriptionsübersetzung';
$string['insights_transcription_features_is_allow_speech_synthesis'] = 'Sprachsynthese erlauben';
$string['insights_chat_translation_features_is_allow'] = 'Chat-Übersetzung erlauben';
$string['insights_ai_features_is_allow'] = 'KI-Funktionen erlauben';
$string['insights_ai_text_chat_features_is_allow'] = 'KI-Textchat erlauben';
$string['insights_ai_meeting_summarization_features_is_allow'] = 'KI-Zusammenfassung von Sitzungen ermöglichen';
