define("tiny_cursive/scatter_chart",["exports","core/chartjs","core/str"],(function(_exports,_chartjs,_str){var obj;
/**
   * A module that creates a scatter chart to visualize student effort data using Chart.js.
   * The chart displays effort scores against time spent, with tooltips showing additional metrics.
   *
   * @module     tiny_cursive/scatter_chart
   * @copyright  2025 Cursive Technology, Inc. <info@cursivetechnology.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_chartjs=(obj=_chartjs)&&obj.__esModule?obj:{default:obj};_exports.init=async(data,apiKey,caption)=>{const ctx=document.getElementById("effortScatterChart").getContext("2d");data&&(data=JSON.parse(document.getElementById("scatter-chart-data").dataset.data));let display=!0,isEmpty="";var dataset=[];const[applyFilter,noSubmission,noPayload,freemium]=await(0,_str.get_strings)([{key:"apply_filter",component:"tiny_cursive"},{key:"no_submission",component:"tiny_cursive"},{key:"nopaylod",component:"tiny_cursive"},{key:"freemium",component:"tiny_cursive"},{key:"chart_result",component:"tiny_cursive"}]);Array.isArray(data)&&!data.state&&apiKey&&(dataset=data,isEmpty=data.some((ds=>Array.isArray(ds.data)&&ds.data.some((point=>point&&"object"==typeof point&&Object.keys(point).length>0))))),apiKey&&0!==data.length&&isEmpty&&!1!==data||(display=!1);const fallbackMessagePlugin={id:"fallbackMessagePlugin",afterDraw(chart){apiKey?"apply_filter"!=data.state?"no_submission"!==data.state?isEmpty||data.state||drawMessage("⚠ "+noPayload,chart):drawMessage("⚠ "+noSubmission,chart):drawMessage("⚠ "+applyFilter,chart):drawMessage("⚠ "+freemium,chart)}};function formatTime(value){const minutes=Math.floor(value/60),seconds=value%60;return`${String(minutes).padStart(2,"0")}:${String(seconds).padStart(2,"0")}`}function drawMessage(text,chart){const{ctx:ctx,chartArea:{left:left,right:right,top:top,bottom:bottom}}=chart;ctx.save(),ctx.textAlign="center",ctx.textBaseline="middle",ctx.font='bold 16px "Segoe UI", Arial',ctx.fillStyle="#666";const centerX=(left+right)/2,centerY=(top+bottom)/2;ctx.fillText(text,centerX,centerY),ctx.restore()}new _chartjs.default(ctx,{type:"scatter",data:{datasets:dataset},options:{plugins:{title:{display:display,text:caption,font:{size:16,weight:"bold"},color:"#333",padding:{top:10,bottom:20},align:"center"},legend:{display:!0,position:"bottom",labels:{usePointStyle:!0,pointStyle:"circle",padding:20}},tooltip:{backgroundColor:"rgba(252, 252, 252, 0.8)",titleColor:"#000",bodyColor:"#000",borderColor:"#cccccc",borderWidth:1,displayColors:!1,callbacks:{title:function(context){return context[0].raw.label},label:function(context){const d=context.raw;return[`Time: ${formatTime(d.x)}`,`Effort: ${Math.round(100*d.effort*100)/100}%`,`Words: ${d.words}`,`WPM: ${d.wpm}`]}}}},scales:{x:{title:{display:!0,text:"Time Spent (mm:ss)"},min:0,ticks:{callback:function(value){return formatTime(value)}}},y:{title:{display:!0,text:"Effort Score"},min:0,ticks:{stepSize:.5}}}},plugins:[fallbackMessagePlugin]})}}));

//# sourceMappingURL=scatter_chart.min.js.map