define("tiny_cursive/replay",["exports","core/ajax","core/templates","jquery","core/str"],(function(_exports,_ajax,_templates,_jquery,Str){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_templates=_interopRequireDefault(_templates),_jquery=_interopRequireDefault(_jquery),Str=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(Str);return _exports.default=class{constructor(elementId,filePath){let speed=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1,loop=arguments.length>3&&void 0!==arguments[3]&&arguments[3],controllerId=arguments.length>4?arguments[4]:void 0;this.controllerId=controllerId||"",this.replayInProgress=!1,this.speed=parseFloat(speed),this.loop=loop,this.highlightedChars=[],this.deletedChars=[],this.cursorPosition=0,this.currentEventIndex=0,this.totalEvents=0,this.currentTime=0,this.totalDuration=0,this.usercomments=[],this.pasteTimestamps=[],this.isPasteEvent=!1,this.isControlKeyPressed=!1,this.isShiftKeyPressed=!1,this.isMetaKeyPressed=!1,this.text="",this.pastedEvents=[],this.currentPasteIndex=0,this.pastedChars=[],this.aiEvents=[],this.currentAiIndex=0,this.aiChars=[],this.undoTimestamps=[],this.undoChars=[];const element=document.getElementById(elementId);if(!element)throw new Error(`Element with id '${elementId}' not found`);this.outputElement=element,this.loadJSON(filePath).then((data=>(data.status?(this.processData(data),this.totalEvents=this.logData.length,this.identifyPasteEvents(),this.identifyUndoEvents(),this.controllerId&&this.logData&&this.constructController(this.controllerId),this.startReplay()):this.handleNoSubmission(),data))).catch((error=>{this.handleNoSubmission(),window.console.error("Error loading JSON file:",error.message)})),localStorage.getItem("nopasteevent")&&localStorage.getItem("pasteEvent")||(Str.get_string("nopasteevent","tiny_cursive").then((str=>(localStorage.setItem("nopasteevent",str),str))).catch((error=>window.console.log(error))),Str.get_string("pasteEvent","tiny_cursive").then((str=>(localStorage.setItem("pasteEvent",str),str))).catch((error=>window.console.log(error))))}processData(data){this.logData=JSON.parse(data.data),data.comments&&(this.usercomments=Array.isArray(JSON.parse(data.comments))?JSON.parse(data.comments):[]),"data"in this.logData&&(this.logData=this.logData.data),"payload"in this.logData&&(this.logData=this.logData.payload);for(let i=0;i<this.logData.length;i++){const event=this.logData[i];"Paste"===event.event&&"string"==typeof event.pastedContent&&""!==event.pastedContent.trim()&&this.pastedEvents.push(event.pastedContent),"aiInsert"===event.event&&event.aiContent&&this.aiEvents.push(event.aiContent)}if(this.logData.length>0&&this.logData[0].unixTimestamp){const startTime=this.logData[0].unixTimestamp;this.logData=this.logData.map((event=>({...event,normalizedTime:event.unixTimestamp-startTime}))),this.totalDuration=this.logData[this.logData.length-1].normalizedTime}}async handleNoSubmission(){try{const[html,str]=await Promise.all([_templates.default.render("tiny_cursive/no_submission"),Str.get_string("warningpayload","tiny_cursive")]),newElement=(0,_jquery.default)(html).text(str);return(0,_jquery.default)(".tiny_cursive").html(newElement)}catch(error){return window.console.error(error),!1}}stopReplay(){if(this.replayInProgress&&(clearTimeout(this.replayTimeout),this.replayInProgress=!1,this.playButton)){const playSvg=document.createElement("img");playSvg.src=M.util.image_url("playicon","tiny_cursive"),this.playButton.querySelector(".play-icon").innerHTML=playSvg.outerHTML}}constructController(controllerId){var _controlContainer$que;this.replayInProgress=!1,this.currentPosition=0,this.speed=1,this.replayIntervalId&&(clearInterval(this.replayIntervalId),this.replayIntervalId=null);const container=document.getElementById(controllerId);if(!container)return void window.console.error("Container not found with ID:",controllerId);const controlContainer=container.querySelector(".tiny_cursive_replay_control");controlContainer?(controlContainer.innerHTML='<span class="tiny_cursive_loading_spinner"></span>',this.buildControllerUI(controlContainer,container),null===(_controlContainer$que=controlContainer.querySelector(".tiny_cursive_loading_spinner"))||void 0===_controlContainer$que||_controlContainer$que.remove()):window.console.error("Replay control container not found in:",controllerId)}buildControllerUI(controlContainer,container){const topRow=document.createElement("div");topRow.classList.add("tiny_cursive_top_row"),this.playButton=this.createPlayButton(),topRow.appendChild(this.playButton);const scrubberContainer=this.createScrubberContainer();topRow.appendChild(scrubberContainer),this.timeDisplay=this.createTimeDisplay(),topRow.appendChild(this.timeDisplay);const bottomRow=document.createElement("div");bottomRow.classList.add("tiny_cursive_bottom_row");const speedContainer=this.createSpeedControls();bottomRow.appendChild(speedContainer);const pasteEventsToggle=this.createPasteEventsToggle(container);bottomRow.appendChild(pasteEventsToggle),controlContainer.appendChild(topRow),controlContainer.appendChild(bottomRow),container.appendChild(this.pasteEventsPanel)}createPlayButton(){const playButton=document.createElement("button");playButton.classList.add("tiny_cursive_play_button");const playSvg=document.createElement("i");return playButton.innerHTML=`<span class="play-icon">${playSvg.outerHTML}</span>`,playButton.addEventListener("click",(()=>{this.replayInProgress?this.stopReplay():this.startReplay(!1),(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),(0,_jquery.default)('a[id^="rep"]').addClass("active")})),playButton}createScrubberContainer(){const scrubberContainer=document.createElement("div");return scrubberContainer.classList.add("tiny_cursive_scrubber_container"),this.scrubberElement=document.createElement("input"),this.scrubberElement.classList.add("tiny_cursive_timeline_scrubber","timeline-scrubber"),this.scrubberElement.type="range",this.scrubberElement.max="100",this.scrubberElement.min="0",this.scrubberElement.value="0",this.scrubberElement.addEventListener("input",(()=>{this.skipToTime(parseInt(this.scrubberElement.value,10))})),scrubberContainer.appendChild(this.scrubberElement),scrubberContainer}createTimeDisplay(){const timeDisplay=document.createElement("div");return timeDisplay.classList.add("tiny_cursive_time_display"),timeDisplay.textContent="00:00 / 00:00",timeDisplay}createSpeedControls(){const speedContainer=document.createElement("div");speedContainer.classList.add("tiny_cursive_speed_controls","speed-controls");const speedLabel=document.createElement("span");speedLabel.classList.add("tiny_cursive_speed_label"),speedLabel.textContent="Speed: ",speedContainer.appendChild(speedLabel);const speedGroup=document.createElement("div");return speedGroup.classList.add("tiny_cursive_speed_group"),[1,1.5,2,5,10].forEach((speed=>{const speedBtn=document.createElement("button");speedBtn.textContent=`${speed}x`,speedBtn.classList.add("tiny_cursive_speed_btn","speed-btn"),parseFloat(speed)===this.speed&&speedBtn.classList.add("active"),speedBtn.dataset.speed=speed,speedBtn.addEventListener("click",(()=>{document.querySelectorAll(".tiny_cursive_speed_btn").forEach((btn=>btn.classList.remove("active"))),speedBtn.classList.add("active"),this.speed=parseFloat(speedBtn.dataset.speed),this.replayInProgress&&(this.stopReplay(),this.startReplay(!1))})),speedGroup.appendChild(speedBtn)})),speedContainer.appendChild(speedGroup),speedContainer}createPasteEventsToggle(container){const pasteEventsToggle=document.createElement("div");pasteEventsToggle.classList.add("tiny_cursive_paste_events_toggle","paste-events-toggle");const pasteEventsIcon=document.createElement("span"),pasteIcon=document.createElement("img");pasteIcon.src=M.util.image_url("pasteicon","tiny_cursive"),pasteEventsIcon.innerHTML=pasteIcon.outerHTML,pasteEventsIcon.classList.add("tiny_cursive_paste_events_icon");const pasteEventsText=document.createElement("span");pasteEventsText.textContent=localStorage.getItem("pasteEvent"),this.pasteEventCount=document.createElement("span"),this.pasteEventCount.textContent=`(${this.pasteTimestamps.length})`,this.pasteEventCount.className="paste-event-count",this.pasteEventCount.style.marginLeft="2px";const chevronIcon=document.createElement("span"),chevron=document.createElement("i");return chevron.className="fa fa-chevron-down",chevronIcon.innerHTML=chevron.outerHTML,chevronIcon.style.marginLeft="5px",chevronIcon.style.transition="transform 0.3s ease",pasteEventsToggle.appendChild(pasteEventsIcon),pasteEventsToggle.appendChild(pasteEventsText),pasteEventsToggle.appendChild(this.pasteEventCount),pasteEventsToggle.appendChild(chevronIcon),this.pasteEventsPanel=this.createPasteEventsPanel(container),pasteEventsToggle.addEventListener("click",(()=>{const isHidden="none"===this.pasteEventsPanel.style.display;this.pasteEventsPanel.style.display=isHidden?"block":"none",chevronIcon.style.transform=isHidden?"rotate(180deg)":"rotate(0deg)"})),pasteEventsToggle}createPasteEventsPanel(container){const existingPanel=container.querySelector(".paste-events-panel");existingPanel&&existingPanel.remove();const pasteEventsPanel=document.createElement("div");return pasteEventsPanel.classList.add("tiny_cursive_paste_events_panel","paste-events-panel"),pasteEventsPanel.style.display="none",this.populatePasteEventsPanel(pasteEventsPanel),pasteEventsPanel}identifyPasteEvents(){this.pasteTimestamps=[];let controlPressed=!1,metaPressed=!1,shiftPressed=!1,pasteCount=0;for(let i=0;i<this.logData.length;i++){var _event$event;const event=this.logData[i];if("keydown"===(null===(_event$event=event.event)||void 0===_event$event?void 0:_event$event.toLowerCase()))if("Control"===event.key)controlPressed=!0;else if("Meta"===event.key)metaPressed=!0;else if("Shift"===event.key)shiftPressed=!0;else if("v"!==event.key&&"V"!==event.key||!controlPressed&&!metaPressed)controlPressed=!1,shiftPressed=!1,metaPressed=!1;else{if(this.pastedEvents[pasteCount]){const timestamp=event.normalizedTime||0;this.pasteTimestamps.push({index:pasteCount,time:timestamp,formattedTime:this.formatTime(timestamp),pastedText:this.pastedEvents[pasteCount],timestamp:timestamp})}pasteCount++,controlPressed=!1,shiftPressed=!1,metaPressed=!1}}this.pasteEventsPanel&&this.populatePasteEventsPanel(this.pasteEventsPanel)}identifyUndoEvents(){this.undoTimestamps=[];let controlPressed=!1,metaPressed=!1,undoCount=0;for(let i=0;i<this.logData.length;i++){var _event$event2;const event=this.logData[i];if("keydown"===(null===(_event$event2=event.event)||void 0===_event$event2?void 0:_event$event2.toLowerCase()))if("Control"===event.key)controlPressed=!0;else if("Meta"===event.key)metaPressed=!0;else if("z"!==event.key&&"Z"!==event.key||!controlPressed&&!metaPressed)controlPressed=!1,metaPressed=!1;else{const timestamp=event.normalizedTime||0;this.undoTimestamps.push({index:undoCount,time:timestamp,formattedTime:this.formatTime(timestamp),timestamp:timestamp}),undoCount++,controlPressed=!1,metaPressed=!1}}}populatePasteEventsPanel(panel){if(panel.innerHTML="",panel.classList.add("tiny_cursive_event_panel"),!this.pasteTimestamps.length){const noEventsMessage=document.createElement("div");return noEventsMessage.className="no-paste-events-message p-3",noEventsMessage.textContent=localStorage.getItem("nopasteevent"),void panel.appendChild(noEventsMessage)}const carouselContainer=document.createElement("div");carouselContainer.classList.add("tiny_cursive_paste_events_carousel","paste-events-carousel");const navigationRow=document.createElement("div");navigationRow.classList.add("paste-events-navigation","tiny_cursive_navigation_row");const counterDisplay=document.createElement("div");counterDisplay.classList.add("paste-events-counter","tiny_cursive_counter_display"),counterDisplay.textContent="Paste Events";const navButtons=document.createElement("div");navButtons.classList.add("tiny_cursive_nav_buttons");const prevButton=document.createElement("button");prevButton.classList.add("paste-event-prev-btn","tiny_cursive_nav_button"),prevButton.innerHTML='<i class="fa fa-chevron-left"></i>';const nextButton=document.createElement("button");nextButton.classList.add("paste-event-next-btn","tiny_cursive_nav_button"),nextButton.innerHTML='<i class="fa fa-chevron-right"></i>',nextButton.disabled=this.pasteTimestamps.length<=1,navButtons.appendChild(prevButton),navButtons.appendChild(nextButton),navigationRow.appendChild(counterDisplay),navigationRow.appendChild(navButtons);const contentContainer=document.createElement("div");contentContainer.className="paste-events-content tiny_cursive_content_container",contentContainer.appendChild(this.createPasteEventDisplay(this.pasteTimestamps[0])),carouselContainer.appendChild(navigationRow),carouselContainer.appendChild(contentContainer),panel.appendChild(carouselContainer);let currentIndex=0;const updateDisplay=()=>{contentContainer.innerHTML="",contentContainer.appendChild(this.createPasteEventDisplay(this.pasteTimestamps[currentIndex])),counterDisplay.textContent="Paste Events",prevButton.disabled=0===currentIndex,prevButton.style.opacity=0===currentIndex?"0.5":"1",nextButton.disabled=currentIndex===this.pasteTimestamps.length-1,nextButton.style.opacity=currentIndex===this.pasteTimestamps.length-1?"0.5":"1"};prevButton.addEventListener("click",(()=>{currentIndex>0&&(currentIndex--,updateDisplay())})),nextButton.addEventListener("click",(()=>{currentIndex<this.pasteTimestamps.length-1&&(currentIndex++,updateDisplay())}))}createPasteEventDisplay(pasteEvent){const eventRow=document.createElement("div");eventRow.className="tiny_cursive_event_row";const headerRow=document.createElement("div");headerRow.className="tiny_cursive_header_row";const textContainer=document.createElement("div");textContainer.className="tiny_cursive_text_container";const timestampContainer=document.createElement("div");timestampContainer.className="paste-event-timestamp tiny_cursive_paste_event_timestamp",timestampContainer.textContent=pasteEvent.formattedTime;const pastedTextContainer=document.createElement("div");pastedTextContainer.className="paste-event-text tiny_cursive_pasted_text_container",pastedTextContainer.textContent=pasteEvent.pastedText,textContainer.appendChild(timestampContainer),textContainer.appendChild(pastedTextContainer);const playButton=document.createElement("button");playButton.className="paste-event-play-btn tiny_cursive_seekplay_button";const playIcon=document.createElement("img");return playIcon.src=M.util.image_url("seekplayicon","tiny_cursive"),playButton.innerHTML=playIcon.outerHTML,playButton.addEventListener("click",(()=>this.jumpToTimestamp(pasteEvent.timestamp))),headerRow.appendChild(textContainer),headerRow.appendChild(playButton),eventRow.appendChild(headerRow),eventRow}jumpToTimestamp(timestamp){const percentage=this.totalDuration>0?timestamp/this.totalDuration*100:0;this.skipToTime(percentage),this.replayInProgress||this.startReplay(!1)}setScrubberVal(value){if(this.scrubberElement&&(this.scrubberElement.value=String(value),this.timeDisplay)){const displayTime=Math.min(this.currentTime,this.totalDuration);this.timeDisplay.textContent=`${this.formatTime(displayTime)} / ${this.formatTime(this.totalDuration)}`}}loadJSON(filePath){return(0,_ajax.call)([{methodname:"cursive_get_reply_json",args:{filepath:filePath}}])[0].done((response=>response)).fail((error=>{throw new Error(`Error loading JSON file: ${error.message}`)}))}formatTime(ms){const seconds=Math.floor(ms/1e3),remainingSeconds=seconds%60;return`${Math.floor(seconds/60).toString().padStart(2,"0")}:${remainingSeconds.toString().padStart(2,"0")}`}startReplay(){let reset=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];this.replayInProgress&&clearTimeout(this.replayTimeout);if((this.totalDuration>0&&this.currentTime>=this.totalDuration||this.currentEventIndex>=this.totalEvents)&&!reset&&(reset=!0),this.replayInProgress=!0,reset&&(this.outputElement.innerHTML="",this.text="",this.cursorPosition=0,this.currentEventIndex=0,this.currentTime=0,this.highlightedChars=[],this.deletedChars=[],this.isControlKeyPressed=!1,this.isMetaKeyPressed=!1,this.currentPasteIndex=0,this.pastedChars=[],this.currentAiIndex=0,this.aiChars=[]),this.playButton){const pauseSvg=document.createElement("i");pauseSvg.className="fa fa-pause",this.playButton.querySelector(".play-icon").innerHTML=pauseSvg.outerHTML}this.replayLog()}replayLog(){if(this.replayInProgress){for(;this.currentEventIndex<this.logData.length;){var _event$event3;const event=this.logData[this.currentEventIndex];if(event.normalizedTime&&event.normalizedTime>this.currentTime)break;let text=this.text||"",cursor=this.cursorPosition,updatedHighlights=[...this.highlightedChars],updatedDeleted=[...this.deletedChars];void 0===event.rePosition||0!==this.currentEventIndex&&"mouseDown"!==event.event&&"mouseUp"!==event.event||(cursor=Math.max(0,Math.min(event.rePosition,text.length))),"keydown"===(null===(_event$event3=event.event)||void 0===_event$event3?void 0:_event$event3.toLowerCase())?({text:text,cursor:cursor,updatedHighlights:updatedHighlights,updatedDeleted:updatedDeleted}=this.processKeydownEvent(event,text,cursor,updatedHighlights,updatedDeleted)):"aiInsert"===event.event&&({text:text,cursor:cursor,updatedHighlights:updatedHighlights,updatedDeleted:updatedDeleted}=this.processAiInsertEvent(event,text,cursor,updatedHighlights,updatedDeleted)),this.text=text,this.cursorPosition=cursor,this.highlightedChars=updatedHighlights.filter((h=>!h.expiresAt||h.expiresAt>this.currentTime)),this.deletedChars=updatedDeleted.filter((d=>!d.expiresAt||d.expiresAt>this.currentTime)),this.currentEventIndex++}if(this.updateDisplayText(this.text,this.cursorPosition,this.highlightedChars,this.deletedChars),this.totalDuration>0){const percentComplete=Math.min(this.currentTime/this.totalDuration*100,100);this.setScrubberVal(percentComplete)}if(this.replayInProgress){const baseIncrement=100,incrementTime=baseIncrement/this.speed;this.currentTime+=baseIncrement,this.currentEventIndex>=this.totalEvents?this.loop?this.startReplay(!0):(this.stopReplay(),this.updateDisplayText(this.text,this.cursorPosition,[],[])):this.replayTimeout=setTimeout((()=>this.replayLog()),incrementTime)}}else this.updateDisplayText(this.text,this.cursorPosition,[],[])}getLineAndColumn(text,pos){const before=text.substring(0,pos);return{lineIndex:before.split("\n").length-1,col:before.length-before.lastIndexOf("\n")-1}}processAiInsertEvent(event,text,cursor,highlights,deletions){if(this.aiEvents&&this.currentAiIndex<this.aiEvents.length){const aiContent=this.aiEvents[this.currentAiIndex],targetPosition=event.rePosition;({text:text,cursor:cursor}=this.handleAiReplacement(aiContent,text,targetPosition,cursor,deletions)),this.currentAiIndex++}return{text:text,cursor:cursor,updatedHighlights:highlights,updatedDeleted:deletions}}handleAiReplacement(aiContent,text,targetPosition,currentCursor,deletions){const insertText=aiContent||"",aiWords=insertText.trim().split(/\s+/),isMultiWord=aiWords.length>1,isNewLineInsertion=insertText.startsWith("\n")||insertText.endsWith("\n"),{wordStart:wordStart,wordEnd:wordEnd}=this.findWordToReplace(text,targetPosition,currentCursor,aiWords,isMultiWord,isNewLineInsertion),wordToReplace=text.substring(wordStart,wordEnd);this.markCharsAsDeleted(wordToReplace,wordStart,deletions);const replacedLength=wordToReplace.length;text=text.substring(0,wordStart)+insertText+text.substring(wordEnd);const positionDiff=insertText.length-replacedLength,newCursor=this.calculateNewCursorPosition(currentCursor,targetPosition,wordStart,wordEnd,insertText,isNewLineInsertion);return this.updateCharacterIndices(wordStart,wordEnd,positionDiff,insertText),{text:text,cursor:newCursor}}findWordToReplace(text,targetPosition,currentCursor,aiWords,isMultiWord,isNewLineInsertion){if(isNewLineInsertion)return{wordStart:currentCursor,wordEnd:currentCursor};const{lineStart:lineStart,lineEnd:lineEnd}=this.findLineRange(text,targetPosition),lineText=text.substring(lineStart,lineEnd),words=this.extractWordsFromLine(lineText,lineStart);return 0===words.length?{wordStart:currentCursor,wordEnd:currentCursor}:isMultiWord?this.findMultiWordMatch(words,aiWords,targetPosition):this.findSingleWordMatch(words,aiWords[0],targetPosition)}findLineRange(text,targetPosition){let lineStart=0;for(let i=targetPosition-1;i>=0;i--)if("\n"===text[i]){lineStart=i+1;break}let lineEnd=text.length;for(let i=targetPosition;i<text.length;i++)if("\n"===text[i]){lineEnd=i;break}return{lineStart:lineStart,lineEnd:lineEnd}}extractWordsFromLine(lineText,lineStart){const words=[];let pos=0;for(;pos<lineText.length;){for(;pos<lineText.length&&" "===lineText[pos];)pos++;if(pos>=lineText.length)break;const start=pos;for(;pos<lineText.length&&" "!==lineText[pos];)pos++;pos>start&&words.push({text:lineText.substring(start,pos),start:lineStart+start,end:lineStart+pos})}return words}findMultiWordMatch(words,aiWords,targetPosition){let bestMatch={start:-1,end:-1,score:-1,wordCount:0,similarityScore:0};for(let i=0;i<words.length;i++){const matchResult=this.evaluateMultiWordSequence(words,aiWords,i,targetPosition);(matchResult.totalScore>bestMatch.score||matchResult.totalScore===bestMatch.score&&matchResult.similarityScore>bestMatch.similarityScore)&&(bestMatch=matchResult)}if(bestMatch.score>10)return{wordStart:bestMatch.start,wordEnd:bestMatch.end};{const closest=this.findClosestWord(words,targetPosition);return{wordStart:closest.start,wordEnd:closest.end}}}evaluateMultiWordSequence(words,aiWords,startIndex,targetPosition){const seqWords=[];for(let j=0;j<aiWords.length&&startIndex+j<words.length;j++)seqWords.push(words[startIndex+j]);if(0===seqWords.length)return{start:-1,end:-1,score:-1,wordCount:0,similarityScore:0};const similarityScore=this.calculateSequenceSimilarity(aiWords,seqWords),totalScore=similarityScore+this.calculatePositionScore(seqWords,targetPosition)+seqWords.length;return{start:seqWords[0].start,end:seqWords[seqWords.length-1].end,score:totalScore,wordCount:seqWords.length,similarityScore:similarityScore}}calculateSequenceSimilarity(aiWords,seqWords){let similarityScore=0;const compareLength=Math.min(seqWords.length,aiWords.length);for(let k=0;k<compareLength;k++){const ai=aiWords[k].toLowerCase(),seq=seqWords[k].text.toLowerCase();if(ai===seq)similarityScore+=10;else{similarityScore+=10*this.calculateSimilarity(ai,seq)}}return similarityScore}calculatePositionScore(seqWords,targetPosition){let positionScore=0;const seqStart=seqWords[0].start,seqEndPos=seqWords[seqWords.length-1].end;return targetPosition>=seqStart&&targetPosition<=seqEndPos&&(positionScore+=10,targetPosition>=seqWords[0].start&&targetPosition<=seqWords[0].end&&(positionScore+=5)),positionScore}findSingleWordMatch(words,aiWord,targetPosition){const aiWordLower=aiWord.toLowerCase(),bestSimilarityMatch=this.findBestSimilarityMatch(words,aiWordLower);if(bestSimilarityMatch.score>.5)return{wordStart:bestSimilarityMatch.word.start,wordEnd:bestSimilarityMatch.word.end};const bestPositionMatch=this.findBestPositionMatch(words,aiWordLower,targetPosition);return bestPositionMatch.word?{wordStart:bestPositionMatch.word.start,wordEnd:bestPositionMatch.word.end}:this.findWordBoundaryAtPosition(words[0].start,words[words.length-1].end,targetPosition,this.text)}findBestSimilarityMatch(words,aiWordLower){let bestMatch={word:null,score:0};for(const word of words){let similarity=this.calculateSimilarity(aiWordLower,word.text.toLowerCase());const wordLower=word.text.toLowerCase();wordLower.length<.5*aiWordLower.length&&aiWordLower.startsWith(wordLower)&&(similarity*=.3),similarity>bestMatch.score&&(bestMatch={word:word,score:similarity})}return bestMatch}findBestPositionMatch(words,aiWordLower,targetPosition){let bestMatch={word:null,score:-1};for(const word of words){let score=this.calculateWordScore(word,aiWordLower,targetPosition);score>bestMatch.score&&(bestMatch={word:word,score:score})}return bestMatch}calculateWordScore(word,aiWordLower,targetPosition){let score=0;if(targetPosition>=word.start&&targetPosition<=word.end)score+=30;else{const distance=Math.min(Math.abs(targetPosition-word.start),Math.abs(targetPosition-word.end));score+=Math.max(0,20-distance)}let similarity=this.calculateSimilarity(aiWordLower,word.text.toLowerCase());const wordLower=word.text.toLowerCase();return wordLower.length<.5*aiWordLower.length&&aiWordLower.startsWith(wordLower)&&(similarity*=.3),score+=10*similarity,score}findWordBoundaryAtPosition(lineStart,lineEnd,targetPosition,text){let wordStart=targetPosition;for(;wordStart>lineStart&&" "!==text[wordStart-1]&&"\n"!==text[wordStart-1];)wordStart--;let wordEnd=targetPosition;for(;wordEnd<lineEnd&&" "!==text[wordEnd]&&"\n"!==text[wordEnd];)wordEnd++;return{wordStart:wordStart,wordEnd:wordEnd}}markCharsAsDeleted(wordToReplace,wordStart,deletions){if(wordToReplace.length>0)for(let i=0;i<wordToReplace.length;i++)deletions.push({index:wordStart+i,chars:wordToReplace[i],time:this.currentTime,expiresAt:this.currentTime+2e3})}calculateNewCursorPosition(currentCursor,targetPosition,wordStart,wordEnd,insertText,isNewLineInsertion){if(isNewLineInsertion)return wordStart+insertText.length;if(targetPosition>=wordStart&&targetPosition<=wordEnd)return wordStart+insertText.length;const positionDiff=insertText.length-(wordEnd-wordStart);return currentCursor>=wordEnd?currentCursor+positionDiff:currentCursor>wordStart&&currentCursor<wordEnd?wordStart+insertText.length:currentCursor}updateCharacterIndices(wordStart,wordEnd,positionDiff,insertText){this.updatePastedCharIndices(wordStart,wordEnd,positionDiff),this.markCharsAsAiInserted(wordStart,insertText),this.updateAiCharIndices(wordStart,wordEnd,positionDiff,insertText)}updatePastedCharIndices(wordStart,wordEnd,positionDiff){this.pastedChars&&(this.pastedChars=this.pastedChars.map((p=>p.index>=wordEnd?{...p,index:p.index+positionDiff}:p.index>=wordStart&&p.index<wordEnd?null:p)).filter((p=>null!==p)))}markCharsAsAiInserted(wordStart,insertText){if(this.aiChars||(this.aiChars=[]),""!==insertText.trim())for(let i=0;i<insertText.length;i++)this.aiChars.push({index:wordStart+i,chars:insertText[i]})}updateAiCharIndices(wordStart,wordEnd,positionDiff,insertText){const justAddedIndices=new Set;for(let i=0;i<insertText.length;i++)justAddedIndices.add(wordStart+i);this.aiChars=this.aiChars.map((p=>{if(!justAddedIndices.has(p.index)){if(p.index>=wordEnd)return{...p,index:p.index+positionDiff};if(p.index>=wordStart&&p.index<wordEnd)return null}return p})).filter((p=>null!==p))}calculateSimilarity(str1,str2){if(str1===str2)return 1;if(0===str1.length||0===str2.length)return 0;if(str1.startsWith(str2)||str2.startsWith(str1))return.8;const len1=str1.length,len2=str2.length,matrix=Array(len2+1).fill(null).map((()=>Array(len1+1).fill(0)));for(let i=0;i<=len1;i++)matrix[0][i]=i;for(let j=0;j<=len2;j++)matrix[j][0]=j;for(let j=1;j<=len2;j++)for(let i=1;i<=len1;i++){const cost=str1[i-1]===str2[j-1]?0:1;matrix[j][i]=Math.min(matrix[j][i-1]+1,matrix[j-1][i]+1,matrix[j-1][i-1]+cost)}const maxLen=Math.max(len1,len2);return 1-matrix[len2][len1]/maxLen}findClosestWord(words,targetPosition){if(0===words.length)return{start:targetPosition,end:targetPosition};let closest=words[0],minDistance=Math.min(Math.abs(targetPosition-words[0].start),Math.abs(targetPosition-words[0].end));for(const word of words){if(targetPosition>=word.start&&targetPosition<=word.end)return word;const distance=Math.min(Math.abs(targetPosition-word.start),Math.abs(targetPosition-word.end));distance<minDistance&&(minDistance=distance,closest=word)}return closest}processKeydownEvent(event,text,cursor,highlights,deletions){const key=event.key,charToInsert=this.applyKey(key);if(this.isCopyOperation(key))return{text:text,cursor:cursor,updatedHighlights:highlights,updatedDeleted:deletions};if(this.isUndoOperation(key))return this.handleUndoOperation(event,text,cursor,highlights,deletions);const currentEventIndex=this.currentEventIndex,selection=this.detectSelection(currentEventIndex);return this.isPasteOperation(key,event)?this.handlePasteOperation(event,selection,text,cursor,highlights,deletions):(this.updateModifierStates(key),this.isSelectionDeletion(key,selection)?(({text:text,cursor:cursor}=this.handleSelectionDeletion(selection,text,cursor,deletions)),{text:text,cursor:cursor,updatedHighlights:highlights,updatedDeleted:deletions}):this.processKeyOperation(key,charToInsert,text,cursor,highlights,deletions,selection))}isCopyOperation(key){return("c"===key||"C"===key)&&(this.isControlKeyPressed||this.isMetaKeyPressed)}isUndoOperation(key){return("z"===key||"Z"===key)&&(this.isControlKeyPressed||this.isMetaKeyPressed)}handleUndoOperation(event,text,cursor,highlights,deletions){const nextEventIndex=this.currentEventIndex+1;if(nextEventIndex<this.logData.length){const nextEvent=this.logData[nextEventIndex];if("keyUp"===nextEvent.event&&("z"===nextEvent.key||"Z"===nextEvent.key)){const newPosition=nextEvent.rePosition;if(newPosition<cursor&&text.length>0){const textBeforeUndo=text;text=text.substring(0,newPosition)+text.substring(cursor),cursor=newPosition;for(let i=0;i<textBeforeUndo.length&&i<cursor;i++)deletions.push({index:newPosition,chars:textBeforeUndo[i],time:this.currentTime,expiresAt:this.currentTime+2e3})}}}return this.isControlKeyPressed=!1,this.isMetaKeyPressed=!1,{text:text,cursor:cursor,updatedHighlights:highlights,updatedDeleted:deletions}}isPasteOperation(key,event){return!("v"!==key&&"V"!==key||!this.isControlKeyPressed&&!this.isMetaKeyPressed)&&(event.pastedContent&&""!==event.pastedContent.trim()||this.pastedEvents&&this.currentPasteIndex<this.pastedEvents.length)}handlePasteOperation(event,selection,text,cursor,highlights,deletions){const pastedContent=event.pastedContent||this.pastedEvents[this.currentPasteIndex];return selection&&({text:text,cursor:cursor}=this.handleSelectionDeletion(selection,text,cursor,deletions)),({text:text,cursor:cursor}=this.handlePasteInsert(pastedContent,text,cursor)),this.currentPasteIndex++,this.resetModifierStates(),this.isPasteEvent=!1,{text:text,cursor:cursor,updatedHighlights:highlights,updatedDeleted:deletions}}resetModifierStates(){this.isControlKeyPressed=!1,this.isShiftKeyPressed=!1,this.isMetaKeyPressed=!1}isSelectionDeletion(key,selection){return("Backspace"===key||"Delete"===key)&&selection&&selection.length>1}processKeyOperation(key,charToInsert,text,cursor,highlights,deletions,selection){return this.isCtrlBackspace(key,cursor)?({text:text,cursor:cursor}=this.handleCtrlBackspace(text,cursor,deletions)):this.isCtrlDelete(key,cursor,text)?({text:text}=this.handleCtrlDelete(text,cursor,deletions)):this.isCtrlArrowMove(key)?cursor=this.handleCtrlArrowMove(key,text,cursor):this.isRegularBackspace(key,cursor)?({text:text,cursor:cursor}=this.handleBackspace(text,cursor,deletions)):this.isRegularDelete(key,cursor,text)?({text:text}=this.handleDelete(text,cursor,deletions)):this.isArrowUp(key)?cursor=this.handleArrowUp(text,cursor):this.isArrowDown(key)?cursor=this.handleArrowDown(text,cursor):this.isRegularArrowMove(key)?cursor=this.handleArrowMove(key,text,cursor):charToInsert&&charToInsert.length>0&&(selection&&selection.length>0&&({text:text,cursor:cursor}=this.handleSelectionDeletion(selection,text,cursor,deletions)),({text:text,cursor:cursor}=this.handleCharacterInsert(charToInsert,text,cursor,highlights))),{text:text,cursor:cursor,updatedHighlights:highlights,updatedDeleted:deletions}}detectSelection(eventIndex){var _currentEvent$event;const currentEvent=this.logData[eventIndex];if("keydown"===(null===(_currentEvent$event=currentEvent.event)||void 0===_currentEvent$event?void 0:_currentEvent$event.toLowerCase())&&("Backspace"===currentEvent.key||"Delete"===currentEvent.key)){const currentPos=currentEvent.rePosition;return this.processDetection(currentPos,currentEvent,eventIndex)}return null}processDetection(currentPos,currentEvent,eventIndex){for(let i=eventIndex+1;i<this.logData.length;i++){var _nextEvent$event;const nextEvent=this.logData[i];if("keyup"===(null===(_nextEvent$event=nextEvent.event)||void 0===_nextEvent$event?void 0:_nextEvent$event.toLowerCase())&&nextEvent.key===currentEvent.key){const nextPos=nextEvent.rePosition,positionDiff=Math.abs(currentPos-nextPos);if(positionDiff>1)return{start:Math.min(currentPos,nextPos),end:Math.max(currentPos,nextPos),length:positionDiff};if(1===positionDiff)return"Backspace"===currentEvent.key?{start:nextPos,end:currentPos,length:1}:{start:currentPos,end:nextPos,length:1};break}}return null}handleSelectionDeletion(selection,text,cursor,deletions){const{start:start,end:end,length:length}=selection;for(let i=start;i<end&&i<text.length;i++)deletions.push({index:start,chars:text[i],time:this.currentTime,expiresAt:this.currentTime+2e3});return text=text.substring(0,start)+text.substring(end),this.shiftPastedCharsIndices(start,length),{text:text,cursor:start}}handlePasteInsert(pastedContent,text,cursor){const insertText=pastedContent||"";if(text=text.substring(0,cursor)+insertText+text.substring(cursor),""!==insertText.trim())for(let i=0;i<insertText.length;i++)this.pastedChars||(this.pastedChars=[]),this.pastedChars.push({index:cursor+i,chars:insertText[i]});return{text:text,cursor:cursor+insertText.length}}shiftPastedCharsIndices(startIndex,numDeleted){this.pastedChars=this.pastedChars.map((p=>p.index>=startIndex+numDeleted?{...p,index:p.index-numDeleted}:p.index>=startIndex&&p.index<startIndex+numDeleted?null:p)).filter((p=>null!==p)),this.aiChars&&(this.aiChars=this.aiChars.map((p=>p.index>=startIndex+numDeleted?{...p,index:p.index-numDeleted}:p.index>=startIndex&&p.index<startIndex+numDeleted?null:p)).filter((p=>null!==p)))}updateModifierStates(key){"Control"===key?this.isControlKeyPressed=!0:"Shift"===key?this.isShiftKeyPressed=!0:"Meta"===key?this.isMetaKeyPressed=!0:"v"!==key&&"V"!==key||!this.isControlKeyPressed&&!this.isMetaKeyPressed?["Control","Meta","Backspace","Delete","ArrowLeft","ArrowRight"].includes(key)||(this.isControlKeyPressed=!1,this.isShiftKeyPressed=!1,this.isMetaKeyPressed=!1,this.isPasteEvent=!1):this.isPasteEvent=!0}isCtrlBackspace(key,cursor){return"Backspace"===key&&this.isControlKeyPressed&&cursor>0}isCtrlDelete(key,cursor,text){return"Delete"===key&&this.isControlKeyPressed&&cursor<text.length}isCtrlArrowMove(key){return this.isControlKeyPressed&&("ArrowLeft"===key||"ArrowRight"===key)}isRegularBackspace(key,cursor){return"Backspace"===key&&!this.isPasteEvent&&cursor>0}isRegularDelete(key,cursor,text){return"Delete"===key&&!this.isControlKeyPressed&&cursor<text.length}isRegularArrowMove(key){return!this.isControlKeyPressed&&("ArrowLeft"===key||"ArrowRight"===key)}isArrowUp(key){return"ArrowUp"===key}isArrowDown(key){return"ArrowDown"===key}handleCtrlArrowMove(key,text,cursor){return"ArrowLeft"===key?this.findPreviousWordBoundary(text,cursor):this.findNextWordBoundary(text,cursor)}handleBackspace(text,cursor,deletions){return deletions.push({index:cursor-1,chars:text[cursor-1],time:this.currentTime,expiresAt:this.currentTime+2e3}),this.shiftPastedCharsIndices(cursor-1,1),{text:text.substring(0,cursor-1)+text.substring(cursor),cursor:cursor-1}}handleDelete(text,cursor,deletions){return deletions.push({index:cursor,chars:text[cursor],time:this.currentTime,expiresAt:this.currentTime+2e3}),this.shiftPastedCharsIndices(cursor,1),{text:text.substring(0,cursor)+text.substring(cursor+1),cursor:cursor}}handleArrowMove(key,text,cursor){return"ArrowLeft"===key?Math.max(0,cursor-1):Math.min(text.length,cursor+1)}handleCharacterInsert(charToInsert,text,cursor,highlights){return text=text.substring(0,cursor)+charToInsert+text.substring(cursor),this.pastedChars&&(this.pastedChars=this.pastedChars.map((p=>p.index>=cursor?{...p,index:p.index+1}:p))),this.aiChars&&(this.aiChars=this.aiChars.map((p=>p.index>=cursor?{...p,index:p.index+1}:p))),""!==charToInsert.trim()&&highlights.push({index:cursor,chars:charToInsert,time:this.currentTime,expiresAt:this.currentTime+1500}),{text:text,cursor:cursor+1}}handleCtrlDelete(text,cursor,deletions){const wordEnd=this.findNextWordBoundary(text,cursor),wordToDelete=text.substring(cursor,wordEnd);for(let i=0;i<wordToDelete.length;i++)deletions.push({index:cursor+i,chars:wordToDelete[i],time:this.currentTime,expiresAt:this.currentTime+2e3});return this.shiftPastedCharsIndices(cursor,wordToDelete.length),{text:text.substring(0,cursor)+text.substring(wordEnd),cursor:cursor}}handleArrowUp(text,cursor){const lines=text.split("\n"),{lineIndex:lineIndex,col:col}=this.getLineAndColumn(text,cursor);if(lineIndex>0){const prevLine=lines[lineIndex-1];cursor=lines.slice(0,lineIndex-1).join("\n").length+1+Math.min(col,prevLine.length)}else cursor=0;return cursor}handleArrowDown(text,cursor){const lines=text.split("\n"),{lineIndex:lineIndex,col:col}=this.getLineAndColumn(text,cursor);if(lineIndex<lines.length-1){const nextLine=lines[lineIndex+1];cursor=lines.slice(0,lineIndex+1).join("\n").length+1+Math.min(col,nextLine.length)}else cursor=text.length;return cursor}handleCtrlBackspace(text,cursor,deletions){let wordStart=cursor;for(;wordStart>0&&" "===text[wordStart-1];)wordStart--;for(;wordStart>0&&" "!==text[wordStart-1];)wordStart--;const wordToDelete=text.substring(wordStart,cursor);for(let i=0;i<wordToDelete.length;i++)deletions.push({index:wordStart+i,chars:wordToDelete[i],time:this.currentTime,expiresAt:this.currentTime+2e3});return this.shiftPastedCharsIndices(wordStart,wordToDelete.length),{text:text.substring(0,wordStart)+text.substring(cursor),cursor:wordStart}}findNextWordBoundary(text,cursor){if(!text||cursor>=text.length)return cursor;if(" "===text[cursor])for(;cursor<text.length&&" "===text[cursor];)cursor++;if(cursor>=text.length){let lastNonSpace=text.length-1;for(;lastNonSpace>=0&&" "===text[lastNonSpace];)lastNonSpace--;return lastNonSpace+1}let wordEnd=cursor;for(;wordEnd<text.length&&" "!==text[wordEnd];)wordEnd++;return wordEnd}findPreviousWordBoundary(text,cursor){if(cursor<=0)return 0;let pos=cursor-1;for(;pos>0&&(" "===text[pos]||"\n"===text[pos]);)pos--;for(;pos>0&&" "!==text[pos-1]&&"\n"!==text[pos-1];)pos--;return pos}skipToEnd(){this.replayInProgress&&(this.replayInProgress=!1);let textOutput="";this.logData.forEach((event=>{"keydown"===event.event.toLowerCase()&&(textOutput=this.applyKey(event.key,textOutput))})),this.outputElement.innerHTML=textOutput.slice(0,-1),this.setScrubberVal(100)}skipToTime(percentage){const wasPlaying=this.replayInProgress;this.stopReplay();const targetTime=this.totalDuration*percentage/100;this.currentTime=targetTime,this.currentEventIndex=0,this.text="",this.cursorPosition=0,this.highlightedChars=[],this.deletedChars=[],this.isControlKeyPressed=!1,this.isMetaKeyPressed=!1,this.isPasteEvent=!1,this.pastedChars=[],this.currentPasteIndex=0,this.currentAiIndex=0,this.aiChars=[];let text="",cursor=0,highlights=[],deletions=[],pasteIndex=0,aiIndex=0;for(let i=0;i<this.logData.length;i++){var _event$event4;const event=this.logData[i];if(event.normalizedTime&&event.normalizedTime>targetTime){this.currentEventIndex=i;break}void 0===event.rePosition||0!==this.currentEventIndex&&"mouseDown"!==event.event&&"mouseUp"!==event.event||(cursor=Math.max(0,Math.min(event.rePosition,text.length))),"keydown"===(null===(_event$event4=event.event)||void 0===_event$event4?void 0:_event$event4.toLowerCase())?(this.currentPasteIndex=pasteIndex,"v"!==event.key&&"V"!==event.key||!this.isControlKeyPressed&&!this.isMetaKeyPressed||pasteIndex++,({text:text,cursor:cursor,updatedHighlights:highlights,updatedDeleted:deletions}=this.processKeydownEvent(event,text,cursor,highlights,deletions))):"aiInsert"===event.event&&(this.currentAiIndex=aiIndex,({text:text,cursor:cursor,updatedHighlights:highlights,updatedDeleted:deletions}=this.processAiInsertEvent(event,text,cursor,highlights,deletions)),aiIndex++),this.currentEventIndex=i+1}this.currentPasteIndex=pasteIndex,this.currentAiIndex=aiIndex,this.text=text,this.cursorPosition=cursor,this.highlightedChars=highlights.filter((h=>!h.expiresAt||h.expiresAt>targetTime)),this.deletedChars=deletions.filter((d=>!d.expiresAt||d.expiresAt>targetTime)),this.updateDisplayText(this.text,this.cursorPosition,this.highlightedChars,this.deletedChars),this.setScrubberVal(percentage),wasPlaying&&(this.replayInProgress=!0,this.replayLog())}updateDisplayText(text,cursorPosition,highlights,deletions){let html="";const highlightMap={},deletionMap={},pastedMap={},aiMap={},currentTime=this.currentTime;highlights.forEach((h=>{let opacity=1;h.expiresAt&&h.expiresAt-currentTime<500&&(opacity=Math.max(0,(h.expiresAt-currentTime)/500)),highlightMap[h.index]={chars:h.chars,opacity:opacity}})),deletions.forEach((d=>{let opacity=.5;d.expiresAt&&d.expiresAt-currentTime<500&&(opacity=Math.max(0,(d.expiresAt-currentTime)/500*.5)),deletionMap[d.index]={chars:d.chars,opacity:opacity}})),this.pastedChars&&this.pastedChars.forEach((p=>{p.index<text.length&&(pastedMap[p.index]=!0)})),this.aiChars&&this.aiChars.forEach((p=>{p.index<text.length&&(aiMap[p.index]=!0)}));const outOfRangeDeletions=deletions.filter((d=>d.index>=text.length)),textLines=text.split("\n");let currentPosition=0;for(let lineIndex=0;lineIndex<textLines.length;lineIndex++){const line=textLines[lineIndex];for(let i=0;i<line.length;i++){currentPosition===cursorPosition&&(html+='<span class="tiny_cursive-cursor"></span>');const char=line[i];deletionMap[currentPosition]&&(html+=`<span class="tiny_cursive-deleted-char" style="opacity:\n                        ${deletionMap[currentPosition].opacity};">${deletionMap[currentPosition].chars}</span>`);const isPasted=pastedMap[currentPosition],isAi=aiMap[currentPosition],isHighlighted=highlightMap[currentPosition]&&" "!==char;html+=isPasted&&isHighlighted?`<span class="tiny_cursive-pasted-char tiny_cursive-highlighted-char" style="opacity:\n                        ${highlightMap[currentPosition].opacity};">${char}</span>`:isAi&&isHighlighted?`<span class="tiny_cursive-ai-char tiny_cursive-highlighted-char" style="opacity:\n                        ${highlightMap[currentPosition].opacity};">${char}</span>`:isPasted?`<span class="tiny_cursive-pasted-char">${" "===char?" ":this.escapeHtml(char)}</span>`:isAi?`<span class="tiny_cursive-ai-char">${" "===char?" ":this.escapeHtml(char)}</span>`:isHighlighted?`<span class="tiny_cursive-highlighted-char" style="opacity:\n                        ${highlightMap[currentPosition].opacity};">${char}</span>`:" "===char?" ":this.escapeHtml(char),currentPosition++}currentPosition===cursorPosition&&(html+='<span class="tiny_cursive-cursor"></span>'),lineIndex<textLines.length-1&&(html+="<br>",currentPosition++)}if(cursorPosition!==text.length||html.endsWith('<span class="tiny_cursive-cursor"></span>')||(html+='<span class="tiny_cursive-cursor"></span>'),outOfRangeDeletions.length>0){outOfRangeDeletions.sort(((a,b)=>a.index-b.index));const cursorHTML='<span class="tiny_cursive-cursor"></span>',cursorPos=html.lastIndexOf(cursorHTML);if(-1!==cursorPos){let deletedWordHTML='<span class="tiny_cursive-deleted-char" style="opacity: 0.5;">';outOfRangeDeletions.forEach((d=>{deletedWordHTML+=d.chars})),deletedWordHTML+="</span>",html=html.substring(0,cursorPos)+deletedWordHTML+html.substring(cursorPos)}}const wasScrolledToBottom=this.outputElement.scrollHeight-this.outputElement.clientHeight<=this.outputElement.scrollTop+1;this.outputElement.innerHTML=html,(wasScrolledToBottom||this.isCursorBelowViewport())&&(this.outputElement.scrollTop=this.outputElement.scrollHeight)}isCursorBelowViewport(){const cursorElement=this.outputElement.querySelector(".tiny_cursive-cursor:last-of-type");if(!cursorElement)return!1;const cursorRect=cursorElement.getBoundingClientRect(),outputRect=this.outputElement.getBoundingClientRect();return cursorRect.bottom>outputRect.bottom}escapeHtml(unsafe){return unsafe.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")}applyKey(key){switch(key){case"Enter":return"\n";case"Backspace":case"Delete":case"ControlBackspace":return"";case" ":return" ";default:return["Shift","Ctrl","Alt","ArrowDown","ArrowUp","Control","ArrowRight","ArrowLeft","Meta","CapsLock","Tab","Escape","Delete","PageUp","PageDown","Insert","Home","End","NumLock","AudioVolumeUp","AudioVolumeDown","MediaPlayPause","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12","PrintScreen","UnIdentified"].includes(key)?"":key}}},_exports.default}));

//# sourceMappingURL=replay.min.js.map