define("tiny_cursive/analytic_events",["exports","./analytic_modal","core/ajax","jquery","core/str","core/templates"],(function(_exports,_analytic_modal,_ajax,_jquery,_str,_templates){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Module for handling analytics events in the Tiny Cursive plugin.
   * Provides functionality for displaying analytics data, replaying writing,
   * checking differences and showing quality metrics.
   *
   * @module     tiny_cursive/analytic_events
   * @copyright  2024 CTI <info@cursivetechnology.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_analytic_modal=_interopRequireDefault(_analytic_modal),_jquery=_interopRequireDefault(_jquery),_templates=_interopRequireDefault(_templates);return _exports.default=class{constructor(){(0,_str.get_string)("notenoughtinfo","tiny_cursive").then((str=>(localStorage.setItem("notenoughtinfo",str),str))).catch((error=>window.console.log(error)))}createModal(userid,context){let questionid=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",replayInstances=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null,authIcon=arguments.length>4?arguments[4]:void 0;const self=this;(0,_jquery.default)("#analytics"+userid+questionid).on("click",(function(e){e.preventDefault();const isReplayButton=(0,_jquery.default)(this).find(".tiny_cursive-replay-button").length>0;_analytic_modal.default.create({templateContext:context}).then((modal=>{(0,_jquery.default)("#content"+userid+" .tiny_cursive_table  tbody tr:first-child td:nth-child(2)").html(authIcon),modal.show(),isReplayButton&&setTimeout((()=>{(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active");const replayTab=(0,_jquery.default)("#rep"+userid+questionid);replayTab.length&&(replayTab.trigger("click"),replayTab.addClass("active"))}),50);let moreBtn=(0,_jquery.default)("body #more"+userid+questionid);return moreBtn.length>0&&((0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),(0,_jquery.default)("#analytic"+userid+questionid).prop("disabled",!0),(0,_jquery.default)("#diff"+userid+questionid).prop("disabled",!0),(0,_jquery.default)("#analytic"+userid+questionid).css({"background-color":"rgba(168, 168, 168, 0.133)",cursor:"not-allowed"}),(0,_jquery.default)("#diff"+userid+questionid).css({"background-color":"rgba(168, 168, 168, 0.133)",cursor:"not-allowed"}),moreBtn.on("click",(function(e){e.preventDefault(),self.learnMore((0,_jquery.default)(this),context,userid,questionid,replayInstances)}))),!0})).catch((error=>{window.console.error("Failed to create modal:",error)}))}))}analytics(userid,templates,context){let questionid=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"",replayInstances=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null,authIcon=arguments.length>5?arguments[5]:void 0;(0,_jquery.default)("body").on("click","#analytic"+userid+questionid,(function(e){(0,_jquery.default)("#rep"+userid+questionid).prop("disabled",!1),(0,_jquery.default)("#quality"+userid+questionid).prop("disabled",!1),(0,_jquery.default)("#content"+userid).attr("data-label","analytics"),(0,_jquery.default)("#player_"+userid+questionid).css({display:"none"}),(0,_jquery.default)("#content"+userid).removeClass("tiny_cursive_outputElement").addClass("tiny_cursive").attr("data-label","analytics"),e.preventDefault(),(0,_jquery.default)("#content"+userid).html((0,_jquery.default)("<div>").addClass("d-flex justify-content-center my-5").append((0,_jquery.default)("<div>").addClass("tiny_cursive-loader"))),replayInstances&&replayInstances[userid]&&replayInstances[userid].stopReplay(),(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),(0,_jquery.default)(this).addClass("active"),templates.render("tiny_cursive/analytics_table",context).then((function(html){return(0,_jquery.default)("#content"+userid).html(html),(0,_jquery.default)("#content"+userid+" .tiny_cursive_table  tbody tr:first-child td:nth-child(2)").html(authIcon),!0})).fail((function(error){window.console.error("Failed to render template:",error)}))}))}checkDiff(userid,fileid){let questionid=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",replayInstances=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null;const nodata=document.createElement("p");nodata.classList.add("tiny_cursive_nopayload","bg-light"),(0,_str.get_string)("nopaylod","tiny_cursive").then((str=>(nodata.textContent=str,!0))).catch((error=>window.console.log(error))),(0,_jquery.default)("body").on("click","#diff"+userid+questionid,(function(e){if((0,_jquery.default)("#rep"+userid+questionid).prop("disabled",!1),(0,_jquery.default)("#quality"+userid+questionid).prop("disabled",!1),(0,_jquery.default)("#content"+userid).attr("data-label","diff"),(0,_jquery.default)("#player_"+userid+questionid).css({display:"none"}),(0,_jquery.default)("#content"+userid).removeClass("tiny_cursive_outputElement").addClass("tiny_cursive").attr("data-label","diff"),e.preventDefault(),(0,_jquery.default)("#content"+userid).html((0,_jquery.default)("<div>").addClass("d-flex justify-content-center my-5").append((0,_jquery.default)("<div>").addClass("tiny_cursive-loader"))),(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),(0,_jquery.default)(this).addClass("active"),replayInstances&&replayInstances[userid]&&replayInstances[userid].stopReplay(),!fileid)throw(0,_jquery.default)("#content"+userid).html(nodata),new Error("Missing file id or Difference Content not received yet");(0,_ajax.call)([{methodname:"cursive_get_writing_differences",args:{fileid:fileid}}])[0].done((response=>{let responsedata=JSON.parse(response.data);if(responsedata){let submittedText=atob(responsedata.submitted_text);(0,_str.get_strings)([{key:"original_text",component:"tiny_cursive"},{key:"editspastesai",component:"tiny_cursive"}]).done((strings=>{const originalTextString=strings[0],editsPastesAIString=strings[1],commentBox=(0,_jquery.default)('<div class="p-2 border rounded mb-2">');var pasteCountDiv=(0,_jquery.default)("<div></div>");(0,_str.get_string)("pastecount","tiny_cursive").then((str=>(pasteCountDiv.append("<div><strong>"+str+" :</strong> "+responsedata.commentscount+"</div>"),!0))).catch((error=>window.console.log(error)));var commentsDiv=(0,_jquery.default)('<div class="border-bottom"></div>');(0,_str.get_string)("comments","tiny_cursive").then((str=>(commentsDiv.append("<strong>"+str+"</strong>"),!0))).catch((error=>window.console.error(error)));var commentsList=(0,_jquery.default)("<div></div>");let comments=responsedata.comments;for(let index in comments){var commentDiv=(0,_jquery.default)('<div style="word-wrap: break-word; word-break: break-word"\n                                class="shadow-sm p-1 my-1"></div>').text(comments[index].usercomment);commentsList.append(commentDiv)}commentBox.append(pasteCountDiv).append(commentsDiv).append(commentsList);const $legend=(0,_jquery.default)('<div class="d-flex p-2 border rounded mb-2">'),$attributedItem=(0,_jquery.default)("<div>",{class:"tiny_cursive-legend-item"}),$attributedBox=(0,_jquery.default)("<div>",{class:"tiny_cursive-box attributed"}),$attributedText=(0,_jquery.default)("<span>").text(originalTextString);$attributedItem.append($attributedBox).append($attributedText);const $unattributedItem=(0,_jquery.default)("<div>",{class:"tiny_cursive-legend-item"}),$unattributedBox=(0,_jquery.default)("<div>",{class:"tiny_cursive-box tiny_cursive_added"}),$unattributedText=(0,_jquery.default)("<span>").text(editsPastesAIString);$unattributedItem.append($unattributedBox).append($unattributedText),$legend.append($attributedItem).append($unattributedItem);let contents=(0,_jquery.default)("<div>").addClass("tiny_cursive-comparison-content"),textBlock2=(0,_jquery.default)("<div>").addClass("tiny_cursive-text-block").append((0,_jquery.default)("<div>").attr("id","tiny_cursive-reconstructed_text").html(JSON.parse(submittedText)));contents.append(commentBox,$legend,textBlock2),(0,_jquery.default)("#content"+userid).html(contents)})).fail((error=>{window.console.error("Failed to load language strings:",error),(0,_jquery.default)("#content"+userid).html(nodata)}))}else(0,_jquery.default)("#content"+userid).html(nodata)})).fail((error=>{throw(0,_jquery.default)("#content"+userid).html(nodata),new Error("Error loading JSON file: "+error.message)}))}))}replyWriting(userid,filepath){let questionid=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",replayInstances=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null;(0,_jquery.default)("body").on("click","#rep"+userid+questionid,(function(e){filepath&&((0,_jquery.default)("#replayControls_"+userid+questionid).removeClass("d-none"),(0,_jquery.default)("#content"+userid).addClass("tiny_cursive_outputElement")),(0,_jquery.default)(this).prop("disabled",!0),(0,_jquery.default)("#quality"+userid+questionid).prop("disabled",!1),(0,_jquery.default)("#content"+userid).attr("data-label","replay"),(0,_jquery.default)("#player_"+userid+questionid).css({display:"block","padding-right":"8px"}),e.preventDefault(),(0,_jquery.default)("#content"+userid).html((0,_jquery.default)("<div>").addClass("d-flex justify-content-center my-5").append((0,_jquery.default)("<div>").addClass("tiny_cursive-loader"))),(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),(0,_jquery.default)(this).addClass("active"),replayInstances&&replayInstances[userid]&&replayInstances[userid].stopReplay(),questionid?video_playback(userid,filepath,questionid):video_playback(userid,filepath)}))}learnMore(moreBtn,context,userid,questionid,replayInstances){(0,_jquery.default)(".tiny_cursive-nav-tab").find(".active").removeClass("active"),moreBtn.addClass("active"),(0,_jquery.default)("#rep"+userid+questionid).prop("disabled",!1),replayInstances&&replayInstances[userid]&&replayInstances[userid].stopReplay(),(0,_jquery.default)("#content"+userid+questionid).removeClass("tiny_cursive_outputElement"),(0,_jquery.default)("#replayControls_"+userid+questionid).addClass("d-none"),_templates.default.render("tiny_cursive/learn_more",context).then((function(html){return(0,_jquery.default)("#content"+userid+questionid).html(html),!0})).fail((function(error){window.console.error("Failed to render template:",error)}))}formatedTime(data){if(data.total_time_seconds){let totalTimeSeconds=data.total_time_seconds;return`${Math.floor(totalTimeSeconds/3600).toString().padStart(2,0)}h ${Math.floor(totalTimeSeconds%3600/60).toString().padStart(2,0)}m ${(totalTimeSeconds%60).toString().padStart(2,0)}s`}return"0h 0m 0s"}authorshipStatus(firstFile,score,scoreSetting){var icon="fa fa-circle-o",color="font-size:32px;color:black";return score=parseFloat(score),firstFile?(icon="fa fa-solid fa-info-circle",color="font-size:32px;color:#000000"):score>=scoreSetting&&(icon="fa fa-check-circle",color="font-size:32px;color:green"),score<scoreSetting?(icon="fa fa-question-circle",color="font-size:32px;color:#A9A9A9",(0,_jquery.default)("<i>").addClass(icon).attr("style",color).attr("title",localStorage.getItem("notenoughtinfo"))):(0,_jquery.default)("<i>").addClass(icon).attr("style",color)}},_exports.default}));

//# sourceMappingURL=analytic_events.min.js.map