define("ivplugin_chapter/main",["exports","jquery","mod_interactivevideo/type/base"],(function(_exports,_jquery,_base){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Interactive video chapter type script
   *
   * @module     ivplugin_chapter/main
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_base=_interopRequireDefault(_base);class Chapter extends _base.default{init(){if(this.isEditMode())return;let self=this,chapters=this.annotations.filter((annotation=>"chapter"==annotation.type));(0,_jquery.default)("#chaptertoggle").removeClass("d-none"),chapters.sort(((a,b)=>a.timestamp-b.timestamp)),chapters[0].timestamp>this.start&&chapters.unshift({id:0,title:M.util.get_string("startchapter","ivplugin_chapter"),formattedtitle:M.util.get_string("startchapter","ivplugin_chapter"),timestamp:this.start}),chapters.forEach(((chapter,index)=>{chapter.start=chapter.timestamp,index<chapters.length-1?chapter.end=chapters[index+1].timestamp:chapter.end=this.end}));const $chapterlists=(0,_jquery.default)("[data-region=chapterlists]");$chapterlists.empty(),chapters.forEach((chapter=>{$chapterlists.append('<li class="p-0 flex-column border-'.concat(self.isBS5?"start":"left","-0\n                 border-").concat(self.isBS5?"end":"start",'-0 chapter\n            list-group-item bg-transparent d-flex justify-content-between align-items-center cursor-pointer"\n            data-id="').concat(chapter.id,'" data-start="').concat(chapter.start,'" data-end="').concat(chapter.end,'">\n            <div class="w-100 d-flex align-items-center justify-content-between p-2">\n            <span class="flex-grow-1 text-truncate iv-font-weight-bold"><i class="bi bi-chevron-down iv-mr-2 toggle"></i>\n            <span class="chapter-title">').concat(chapter.formattedtitle,'</span></span><span class="small iv-badge-primary iv-badge-pill">\n            ').concat((seconds=>{const h=Math.floor(seconds/3600),m=Math.floor(seconds%3600/60),s=Math.floor(seconds%3600%60);return(h>0?h+":":"")+(m<10?"0":"")+m+":"+(s<10?"0":"")+s})(chapter.start-this.start),'</span></div>\n            <ul class="annolistinchapter w-100 p-0"></ul></li>'))})),(0,_jquery.default)(document).off("timeupdate.chapter").on("timeupdate.chapter",(async function(e){if(!self.main)return;const currenttime=e.originalEvent.detail.time,currentchapter=chapters.find((chapter=>currenttime>=chapter.start&&currenttime<chapter.end));if(currentchapter&&currentchapter){const settings=JSON.parse(currentchapter.advanced||"{}");let locked=!1;if(!self.isEditMode()&&!self.isPreviewMode()&&!(0,_jquery.default)("body").hasClass("editorview")&&settings.lock&&""!=settings.lock)if("untilprevious"==settings.lock){let previousIndex=chapters.findIndex((chapter=>chapter.id==currentchapter.id))-1;if(previousIndex<0)locked=!1;else{let previouschapter=chapters[previousIndex];locked=!self.annotations.filter((annotation=>annotation.timestamp>=previouschapter.start&&annotation.timestamp<previouschapter.end&&"1"==annotation.hascompletion)).every((annotation=>annotation.completed))}}else if("untilallprevious"==settings.lock){locked=!self.annotations.filter((annotation=>annotation.timestamp<currentchapter.start&&"1"==annotation.hascompletion)).every((annotation=>annotation.completed))}else"untilcomplete"==settings.lock&&0==self.options.isCompleted&&(locked=!0);if(locked){let lockstring=M.util.get_string(settings.lock,"ivplugin_chapter");self.addNotification(M.util.get_string("chapterlocked","ivplugin_chapter",lockstring),"danger"),(0,_jquery.default)("body").addClass("chapter-locked"),self.player.pause(),self.player.seek(currentchapter.start-.3)}$chapterlists.find(".chapter").removeClass("active-chapter"),$chapterlists.find(".chapter[data-id=".concat(currentchapter.id,"]")).addClass("active-chapter"),0!=currentchapter.id?(0,_jquery.default)("#controller #chaptertitle").html(locked?'<i class="fa fa-lock mx-2"></i>':currentchapter.formattedtitle):(0,_jquery.default)("#controller #chaptertitle").text("")}})),self.isEditMode()||self.isPreviewMode()||(0,_jquery.default)("body").hasClass("editorview")||(0,_jquery.default)(document).on("chapterrendered",(e=>{let annotations=e.originalEvent.detail.annotations;chapters.forEach((chapter=>{let settings=JSON.parse(chapter.advanced||"{}"),locked=!1;if(settings.lock&&""!=settings.lock)if("untilprevious"==settings.lock){let previousIndex=chapters.findIndex((c=>c.id==chapter.id))-1;if(previousIndex<0)locked=!1;else{let previouschapter=chapters[previousIndex];locked=!annotations.filter((annotation=>annotation.timestamp>=previouschapter.start&&annotation.timestamp<previouschapter.end&&"1"==annotation.hascompletion)).every((annotation=>annotation.completed))}}else if("untilallprevious"==settings.lock){locked=!annotations.filter((annotation=>annotation.timestamp<chapter.start&&"1"==annotation.hascompletion)).every((annotation=>annotation.completed))}else"untilcomplete"==settings.lock&&0==self.options.isCompleted&&(locked=!0);if(locked){$chapterlists.find(".chapter[data-id=".concat(chapter.id,"]")).addClass("locked"),$chapterlists.find(".chapter[data-id=".concat(chapter.id,"] .annolistinchapter")).hide(),(0,_jquery.default)("#video-nav ul li[data-id=".concat(chapter.id,"]")).html('<div class="item locked"\n                             data'.concat(self.isBS5?"-bs":"",'-toggle="tooltip"\n                    data').concat(self.isBS5?"-bs":"",'-container="#wrapper"\n                    data').concat(self.isBS5?"-bs":"",'-trigger="hover"\n                    data').concat(self.isBS5?"-bs":"",'-html="true"\n                    data').concat(self.isBS5?"-bs":"",'-title=\'<i class="fa fa-lock iv-mr-1"></i>\n                    ').concat(M.util.get_string(settings.lock,"ivplugin_chapter"),'\'>\n                        <i class="fa fa-lock"></i></div>'));annotations.filter((annotation=>annotation.timestamp>=chapter.start&&annotation.timestamp<chapter.end)).forEach((annotation=>{(0,_jquery.default)("#interactions-nav li[data-id=".concat(annotation.id,"]")).remove()}))}else $chapterlists.find(".chapter[data-id=".concat(chapter.id,"]")).removeClass("locked"),$chapterlists.find(".chapter[data-id=".concat(chapter.id,"] .annolistinchapter")).show(),(0,_jquery.default)("#video-nav ul li[data-id=".concat(chapter.id,"] .item i")).remove()}))})),$chapterlists.on("click",".chapter .chapter-title",(function(e){e.preventDefault(),(0,_jquery.default)("#start-screen").fadeOut(300),(0,_jquery.default)("#end-screen").fadeOut(300);let starttime=(0,_jquery.default)(this).closest("li").data("start");self.player.seek(starttime),self.player.play(),(0,_jquery.default)(this).closest("#chapter-container-left").length>0&&(0,_jquery.default)("#chaptertoggle .btn").trigger("click")})),(0,_jquery.default)(document).on("click","#chaptertoggle .btn",(function(e){e.preventDefault(),(0,_jquery.default)("#interactivevideo-container").toggleClass("chapter-open"),(0,_jquery.default)(this).find("i").toggleClass("bi-collection bi-collection-fill")})),(0,_jquery.default)(document).on("click","#closechapter",(function(e){e.preventDefault(),(0,_jquery.default)("#chaptertoggle .btn").trigger("click")})),(0,_jquery.default)(document).on("click",".chapter i.toggle.bi",(function(e){e.preventDefault(),(0,_jquery.default)(this).closest(".chapter").find(".annolistinchapter").slideToggle(300),(0,_jquery.default)(this).toggleClass("bi-chevron-down bi-chevron-right")}))}renderEditItem(annotations,listItem,item){(listItem=super.renderEditItem(annotations,listItem,item)).find(".type-name").addClass("justify-content-center"),listItem.find(".type-icon i").remove(),(Number(item.timestamp)>this.end||Number(item.timestamp)<this.start||this.isSkipped(item.timestamp))&&listItem.find(".title").addClass("text-muted");let lock=JSON.parse(item.advanced).lock;return JSON.parse(item.advanced).lock&&""!=JSON.parse(item.advanced).lock&&listItem.find(".type-name").before('<i class="fa fa-lock iv-ml-2" title="'.concat(M.util.get_string(lock,"ivplugin_chapter"),'"></i>')),listItem}renderItemOnVideoNavigation(annotation){let self=this;if(annotation.hide)return;if(annotation.timestamp<this.start||annotation.timestamp>this.end)return;this.totaltime=this.totaltime||this.end-this.start;const percentage=(Number(annotation.timestamp)-this.start)/this.totaltime*100;if(this.isVisible(annotation)){let classes=annotation.type+" annotation li-draggable ";annotation.completed&&(classes+="completed "),this.isClickable(annotation)||(classes+="no-pointer-events "),this.isSkipped(annotation.timestamp)&&(classes+="skipped ");let container=self.isEditMode()?"#timeline":"#wrapper",placement="top",title=annotation.formattedtitle;title=title.replace(/'/g,"&apos;").replace(/"/g,"&quot;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/&/g,"&amp;"),(0,_jquery.default)("#video-nav ul").append('<li class="'.concat(classes,'" data-timestamp="').concat(annotation.timestamp,'"\n              data-id="').concat(annotation.id,'" style="left: calc(').concat(percentage,'% - 5px)">\n        <div class="item" data').concat(self.isBS5?"-bs":"",'-toggle="tooltip" data').concat(self.isBS5?"-bs":"",'-container="').concat(container,'"\n        data').concat(self.isBS5?"-bs":"",'-trigger="hover" data').concat(self.isBS5?"-bs":"",'-html="true"\n        data').concat(self.isBS5?"-bs":"",'-placement="').concat(placement,'"\n        title=\'<i class="').concat(this.prop.icon,' iv-mr-1"></i>').concat(title,"'></div></li>"))}}async runInteraction(annotation){if(this.main){if((0,_jquery.default)("body").hasClass("chapter-locked"))return await this.player.pause(),void this.player.seek(annotation.timestamp-.3);if("1"!=annotation.char1)return this.player.play(),(0,_jquery.default)("#video-nav ul li[data-id="+annotation.id+"] .item").tooltip("show"),void setTimeout((()=>{(0,_jquery.default)("#video-nav ul li[data-id="+annotation.id+"] .item").tooltip("hide")}),2e3);await this.player.pause(),(0,_jquery.default)("#controler").addClass("no-pointer-events"),(0,_jquery.default)("#video-wrapper").append('<h2 id="message" style="z-index:105" class="chapter position-absolute w-100 py-4\n        px-3 m-0 justify-content-start no-pointer"><span class="text-truncate">'.concat(annotation.formattedtitle,"</span></h2>")),(0,_jquery.default)("#video-wrapper #message").append('<div id="chapterprogress" class="position-absolute w-100">\n        <div class="progress-bar"></div></div>'),(0,_jquery.default)("#message span").animate({top:"1em"},300,"swing"),(0,_jquery.default)("#chapterprogress .progress-bar").animate({width:"100%"},3e3,"linear",(()=>{(0,_jquery.default)("h2#message").remove(),this.isEditMode()||((0,_jquery.default)("#message span").css("top","0"),(0,_jquery.default)("body").hasClass("chapter-locked")||this.player.play(),(0,_jquery.default)("#controler").removeClass("no-pointer-events"))}))}}}return _exports.default=Chapter,_exports.default}));

//# sourceMappingURL=main.min.js.map