/**
 * Handle opening a modal for step icon selection.
 *
 * @module     mod_roadmap/stepiconselect
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_roadmap/step_icon_select",["jquery","core/str","core/notification","core/templates","core/ajax","core/modal_save_cancel","core/modal_events"],(function($,Str,Notification,Templates,Ajax,ModalSaveCancel,ModalEvents){var SELECTORS_SELECT_ICON_BUTTON=".btn_icon_selector",StepIconSelector=function(){this.registerEventListeners()};return StepIconSelector.prototype.registerEventListeners=function(){var trigger=$(SELECTORS_SELECT_ICON_BUTTON),stringkeys=[{key:"selecticon",component:"mod_roadmap"},{key:"saveselection",component:"mod_roadmap"}];trigger.off("click").on("click",function(e){let stepId=$(e.target).parent(".btn_icon_selector").data("stepid");Str.get_strings(stringkeys).then(function(strings){return Promise.all([ModalSaveCancel.create({title:strings[0],body:""}),strings[1]]).then(function(_ref){let[modal,string]=_ref;return this.setupFormModal(modal,stepId,string),modal}.bind(this))}.bind(this)).catch(Notification.exception)}.bind(this))},StepIconSelector.prototype.getBody=function(){var iconsData=JSON.parse($('input[name="icon_data"]').val());return $(".step-wrapper .step-container .step-icon-display img.step-icon").each((function(){let iconfilename=$(this).data("iconfilename"),iconsrc=$(this).attr("src"),usedicon={file:iconfilename,iconurl:iconsrc};iconsData.categories[0].icons.some((icon=>icon.file===iconfilename))||iconsData.categories[0].icons.push(usedicon)})),Templates.render("mod_roadmap/configuration_iconselect",iconsData)},StepIconSelector.prototype.setupFormModal=function(modal,stepId,saveText){modal.setLarge(),modal.setSaveButtonText(saveText),modal.getRoot().on(ModalEvents.hidden,this.destroy.bind(this)),modal.setBody(this.getBody()),modal.getRoot().on("click","img.icon",function(e){let iconFileName=$(e.target).data("iconfilename");$(".modal-body .icon-container img.icon.selected").removeClass("selected"),$(e.target).addClass("selected"),$("#current-selected-icon").val(iconFileName),this.updatePreviewIcons(iconFileName)}.bind(this)),modal.getRoot().on(ModalEvents.bodyRendered,(function(){var iconFileName=$("input[name=step-"+stepId+"-icon]").val();$(".modal-body .icon-container img.icon[data-iconfilename="+iconFileName+"]").addClass("selected"),$("#current-selected-icon").val(iconFileName),$("#step-id").val(stepId),StepIconSelector.prototype.updatePreviewIcons(iconFileName)})).bind(this),modal.getRoot().on(ModalEvents.save,this.submitForm.bind(this)),this.modal=modal,modal.show()},StepIconSelector.prototype.updatePreviewIcons=function(iconFileName){let iconUrl=$('input[name="icon_url"]').val();$("div.selected-icon-container > span.img-incomplete > img.icon").attr("src",iconUrl+"?name="+iconFileName+"&percent=0"),$("div.selected-icon-container > span.img-partial > img.icon").attr("src",iconUrl+"?name="+iconFileName+"&percent=66"),$("div.selected-icon-container > span.img-alert > img.icon").attr("src",iconUrl+"?name="+iconFileName+"&percent=66&flags=a"),$("div.selected-icon-container > span.img-complete > img.icon").attr("src",iconUrl+"?name="+iconFileName+"&percent=100"),$("div.selected-icon-container > span.img-ontime > img.icon").attr("src",iconUrl+"?name="+iconFileName+"&percent=100&flags=s")},StepIconSelector.prototype.submitForm=function(e){e.preventDefault();let iconUrl=$('input[name="icon_url"]').val(),iconFileName=$("#current-selected-icon").val(),stepId=$("#step-id").val(),inputStep=$('input[name="step-'+stepId+'-icon"]'),imgStep=inputStep.parent(".step-icon-display").find("img").first();imgStep.attr("src",iconUrl+"?name="+iconFileName+"&percent=100&flags=n"),imgStep.removeAttr("data-iconfilename").removeData("iconfilename"),imgStep.attr("data-iconfilename",iconFileName),inputStep.val(iconFileName),inputStep.trigger("change"),this.destroy()},StepIconSelector.prototype.destroy=function(){this.modal.destroy()},StepIconSelector.prototype.initIconConfig=function(popup){this.popup=popup,$(popup.getContent()).on("click",'[data-action="cancel"]',(function(){popup.close()}))},{init:function(){return new StepIconSelector},rebindButtons:function(){StepIconSelector.prototype.registerEventListeners()}}}));

//# sourceMappingURL=step_icon_select.min.js.map