/**
 * Handle the configuration of the roadmap.
 *
 * @module     mod_roadmap/roadmapconfig
 * @copyright  2021 Steve Bader <smbader@ncsu.edu>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_roadmap/roadmap_config",["jquery","core/notification","core/templates","mod_roadmap/expand_contract","mod_roadmap/learningobjectivesconfig","mod_roadmap/step_icon_select","mod_roadmap/step_activity_select","mod_roadmap/step_save","mod_roadmap/cycle_save","mod_roadmap/phase_save","mod_roadmap/repository","core/modal_delete_cancel","core/modal_events"],(($,notification,templates,expandContract,learningObjectives,stepIconSelect,stepActivitySelect,stepSave,cycleSave,phaseSave,roadmapRepo,ModalDeleteCancel,ModalEvents)=>{const showDeleteConfirmModal=function(message){let title=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"Confirm delete";return ModalDeleteCancel.create({title:title,body:message}).then((modal=>new Promise((resolve=>{modal.show(),modal.getRoot().on(ModalEvents.delete,(()=>{resolve(!0),modal.hide()})),modal.getRoot().on(ModalEvents.cancel,(()=>{resolve(!1),modal.hide()})),modal.getRoot().on(ModalEvents.hidden,(()=>{modal.destroy()}))}))))},getMaxValue=dataType=>{const ids=[];return $(".".concat(dataType,"-wrapper")).each((function(){const id=parseInt($(this).data("".concat(dataType,"id")),10);isNaN(id)||ids.push(id)})),ids.length?Math.max(...ids):0},moveWrapper=(wrapper,direction)=>{if("up"===direction){const prev=wrapper.prev();prev.length&&wrapper.insertBefore(prev)}else if("down"===direction){const next=wrapper.next();next.length&&wrapper.insertAfter(next)}};let colorPatternCache={};class RoadmapConfig{constructor(inputSelector,inputConfig){this.inputSelector=inputSelector,this.configContainer=$(inputConfig),this.initForm()}initForm(){let config,inputConfigVal=this.configContainer.val();inputConfigVal||(inputConfigVal=JSON.stringify({phases:[]}),this.configContainer.val(inputConfigVal));try{config=JSON.parse(inputConfigVal)}catch(e){notification.exception(e),config={phases:[]}}config.phases.forEach((phase=>{phase.configuration=JSON.stringify(phase),(phase.cycles||[]).forEach((cycle=>{cycle.configuration=JSON.stringify(cycle),(cycle.steps||[]).forEach((step=>{step.configuration=JSON.stringify(step)}))}))})),templates.render("mod_roadmap/configuration_phases",config).then(((html,js)=>(templates.prependNodeContents(this.inputSelector,html,js),this.bindExpandCollapseControls(),$("#roadmapconfiguration").off("click","a[data-action]").on("click","a[data-action]",(e=>this.clickHandler(e))),this.phaseColorChange($('select[name="phasecolorpattern"]')),learningObjectives.refreshChecklists(),stepIconSelect.rebindButtons(),stepActivitySelect.rebindButtons(),stepSave.rebindInputs(),cycleSave.rebindInputs(),phaseSave.rebindInputs(),this.bindConfigSave(),require(["theme_boost/loader"]),null))).catch(notification.exception),$('select[name="phasecolorpattern"]').off("change").on("change",(e=>{this.phaseColorChange($(e.target))}))}clickHandler(event){const node=$(event.currentTarget),action=node.data("action"),actionMap={collapse_all_phases:()=>this.collapsePhases(),expand_all_phases:()=>this.expandPhases(),collapse_all_cycles:()=>this.collapseCycles(node.closest(".phase-wrapper").find(".phase-cycles-container").first()),expand_all_cycles:()=>this.expandCycles(node.closest(".phase-wrapper").find(".phase-cycles-container").first()),collapse_all_steps:()=>this.collapseSteps(node.parent(".step-container-controls").next(".cycle-steps-container")),expand_all_steps:()=>this.expandSteps(node.parent(".step-container-controls").next(".cycle-steps-container")),phase_collapse_control:()=>this.collapsePhase(node),cycle_collapse_control:()=>this.collapseCycle(node),step_collapse_control:()=>this.collapseStep(node),phase_delete_control:()=>this.deletePhase(node),cycle_delete_control:()=>this.deleteCycle(node),step_delete_control:()=>this.deleteStep(node),add_phase:()=>this.addPhase(),phase_up_control:()=>this.upPhase(node),phase_down_control:()=>this.downPhase(node),add_phase_cycle:()=>this.addCycle(node),cycle_up_control:()=>this.upCycle(node),cycle_down_control:()=>this.downCycle(node),add_cycle_step:()=>this.addStep(node),step_up_control:()=>this.upStep(node),step_down_control:()=>this.downStep(node)};if(actionMap[action])return actionMap[action]()}phaseColorChange(node){const colorId=node.val();colorPatternCache[colorId]?this.applyColorSet(colorPatternCache[colorId]):roadmapRepo.fetchColorPattern(colorId).then((colors=>(colorPatternCache[colorId]=colors,this.applyColorSet(colors),colors))).catch(notification.exception)}applyColorSet(colors){$(".phase-color-display").remove();const colorTable=$("<div>").addClass("phase-color-display");colors.forEach((color=>{colorTable.append('<div class="color" style="background-color:'.concat(color,'"></div>'))})),$('select[name="phasecolorpattern"]').parent().append(colorTable),$("#roadmapconfiguration #phase-container > .phase-wrapper > div.row").each((function(i){const idxColor=i%colors.length;$(this).css("border-bottom","solid 1px ".concat(colors[idxColor]))}))}bindConfigSave(){$("input.phase-configuration").off("change").on("change",(()=>this.configSave()))}configSave(){const phaseContainer=$("#phase-container"),roadmapData=[];let index=0;phaseContainer.find(".phase-wrapper .phase-configuration").each((function(){const phaseData=$(this).val()||"{}",phaseDataObj=JSON.parse(phaseData);phaseDataObj.index=index++,roadmapData.push(phaseDataObj)})),$('input[name="roadmapconfiguration"]').val(JSON.stringify({phases:roadmapData,phaseDeletes:$("#phase-deletes").val(),cycleDeletes:$("#cycle-deletes").val(),stepDeletes:$("#step-deletes").val()}))}addPhase(){const roadmapConfigInput=$('input[name="roadmapconfiguration"]'),config=JSON.parse(roadmapConfigInput.val()),nextIndex=config.phases.length,newPhase={id:getMaxValue("phase")+1,index:nextIndex,number:nextIndex+1,title:"Phase ".concat(nextIndex+1),subtitle:"Subtitle ".concat(nextIndex+1)};return config.phases.push(newPhase),roadmapConfigInput.val(JSON.stringify(config)),templates.render("mod_roadmap/configuration_phase",newPhase).then(((html,js)=>(templates.appendNodeContents("#phase-container",html,js),phaseSave.rebindInputs(),this.bindConfigSave(),this.phaseColorChange($('select[name="phasecolorpattern"]')),null))).catch(notification.exception)}addCycle(node){const cycleContainer=node.closest(".phase-container").children(".phase-cycles-container"),nextCycleIndex=cycleContainer.children(".cycle-wrapper").length,newCycle={id:getMaxValue("cycle")+1,index:nextCycleIndex,number:nextCycleIndex+1,title:"Cycle ".concat(nextCycleIndex+1),subtitle:"Subtitle ".concat(nextCycleIndex+1)};return templates.render("mod_roadmap/configuration_cycle",newCycle).then(((html,js)=>(templates.appendNodeContents(cycleContainer,html,js),learningObjectives.refreshChecklists(),cycleSave.rebindInputs(),phaseSave.rebindInputs(),null))).catch(notification.exception)}addStep(node){const stepsContainer=node.closest(".cycle-container").children(".cycle-steps-container"),nextStepIndex=stepsContainer.children(".step-wrapper").length,maxStepId=getMaxValue("step"),iconUrl=$('input[name="icon_url"]').val(),newStep={id:maxStepId+1,index:nextStepIndex,number:nextStepIndex+1,stepicon:"icon-10",iconurl:"".concat(iconUrl,"?name=icon-10&percent=100&flags=n")};return templates.render("mod_roadmap/configuration_step",newStep).then(((html,js)=>(templates.appendNodeContents(stepsContainer,html,js),stepIconSelect.rebindButtons(),stepActivitySelect.rebindButtons(),stepSave.rebindInputs(),cycleSave.rebindInputs(),null))).catch(notification.exception)}bindExpandCollapseControls(){$(".expand-collapse-controls .collapse_everything").off("click").on("click",(e=>{e.preventDefault(),this.collapseEverything()})),$(".expand-collapse-controls .expand_everything").off("click").on("click",(e=>{e.preventDefault(),this.expandEverything()}))}expandPhases(){this.expandChildrenClass($("#roadmapconfiguration"),"phase")}expandCycles(node){this.expandChildrenClass(node,"cycle")}expandSteps(node){this.expandChildrenClass(node,"step")}collapsePhases(){const node=$("#roadmapconfiguration");this.collapseCycles(node),this.collapseChildrenClass(node,"phase")}collapseCycles(node){this.collapseSteps(node),this.collapseChildrenClass(node,"cycle")}collapseSteps(node){this.collapseChildrenClass(node,"step")}expandChildrenClass(parent,className){parent.find('a[data-action="'.concat(className,'_collapse_control"]')).each((function(){$(this).closest(".".concat(className,"-wrapper")).children(".".concat(className,"-container")).hasClass("hide")&&$(this).click()}))}collapseChildrenClass(parent,className){parent.find('a[data-action="'.concat(className,'_collapse_control"]')).each((function(){$(this).closest(".".concat(className,"-wrapper")).children(".".concat(className,"-container")).hasClass("visible")&&$(this).click()}))}collapsePhase(node){const container=node.closest(".phase-wrapper").children(".phase-container");expandContract.expandCollapse(container,node)}collapseCycle(node){const container=node.closest(".cycle-wrapper").children(".cycle-container");expandContract.expandCollapse(container,node)}collapseStep(node){const container=node.closest(".step-wrapper").children(".step-container");expandContract.expandCollapse(container,node)}deletePhase(node){return showDeleteConfirmModal("Are you sure you want to delete this Phase?","Confirm delete").then((confirmed=>{if(confirmed){const wrapper=node.closest(".phase-wrapper");if(!wrapper.length)return null;const phaseId=wrapper.data("phaseid"),phaseDeletes=$("#phase-deletes");phaseDeletes.val(phaseDeletes.val()+phaseId+","),wrapper.remove(),this.configSave(),this.phaseColorChange($('select[name="phasecolorpattern"]'))}return null}))}deleteCycle(node){return showDeleteConfirmModal("Are you sure you want to delete this Cycle?","Confirm delete").then((confirmed=>{if(confirmed){const wrapper=node.closest(".cycle-wrapper");if(!wrapper.length)return null;const phaseContainer=node.closest(".phase-container"),cycleId=wrapper.data("cycleid"),cycleDeletes=$("#cycle-deletes");cycleDeletes.val(cycleDeletes.val()+cycleId+","),wrapper.remove(),phaseContainer.find(".phase-title").triggerHandler("change")}return null}))}deleteStep(node){return showDeleteConfirmModal("Are you sure you want to delete this Step?","Confirm delete").then((confirmed=>{if(confirmed){const wrapper=node.closest(".step-wrapper");if(!wrapper.length)return null;const cycleContainer=node.closest(".cycle-container"),stepId=wrapper.data("stepid"),stepDeletes=$("#step-deletes");stepDeletes.val(stepDeletes.val()+stepId+","),wrapper.remove(),cycleContainer.find(".cycle-title").triggerHandler("change")}return null}))}upPhase(node){const wrapper=node.closest(".phase-wrapper");moveWrapper(wrapper,"up"),this.configSave(),this.phaseColorChange($('select[name="phasecolorpattern"]'))}downPhase(node){const wrapper=node.closest(".phase-wrapper");moveWrapper(wrapper,"down"),this.configSave(),this.phaseColorChange($('select[name="phasecolorpattern"]'))}upCycle(node){const wrapper=node.closest(".cycle-wrapper"),phaseContainer=node.closest(".phase-container");moveWrapper(wrapper,"up"),phaseContainer.find(".phase-title").triggerHandler("change")}downCycle(node){const wrapper=node.closest(".cycle-wrapper"),phaseContainer=node.closest(".phase-container");moveWrapper(wrapper,"down"),phaseContainer.find(".phase-title").triggerHandler("change")}upStep(node){const wrapper=node.closest(".step-wrapper"),cycleContainer=node.closest(".cycle-container");moveWrapper(wrapper,"up"),cycleContainer.find(".cycle-title").triggerHandler("change")}downStep(node){const wrapper=node.closest(".step-wrapper"),cycleContainer=node.closest(".cycle-container");moveWrapper(wrapper,"down"),cycleContainer.find(".cycle-title").triggerHandler("change")}expandEverything(){this.expandPhases()}collapseEverything(){this.collapsePhases()}}return{init:(inputSelector,inputConfig)=>new RoadmapConfig(inputSelector,inputConfig)}}));

//# sourceMappingURL=roadmap_config.min.js.map