/**
 * Handle the configuration of learning objectives.
 *
 * @module     mod_roadmap/learningobjectivesconfig
 * @copyright  2021 Steve Bader <smbader@ncsu.edu>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_roadmap/learningobjectivesconfig",["jquery","core/notification","core/templates","mod_roadmap/cycle_save"],(function($,notification,templates,cyclesave){var LearningObjectivesConfig=function(inputSelector,inputConfig){this.inputSelector=$(inputSelector),this.configContainer=$(inputConfig),this.showConfig(this)};return LearningObjectivesConfig.prototype.showConfig=async function(){var inputConfigVal=this.configContainer.val();""===inputConfigVal&&(inputConfigVal=JSON.stringify({learningobjectives:[]}),this.configContainer.val(inputConfigVal));var config=JSON.parse(inputConfigVal);config.learningobjectives.forEach((function(learningobjective){learningobjective.number=learningobjective.index+1}));try{const{html:html,js:js}=await templates.renderForPromise("mod_roadmap/configuration_learningobjectives",config);await templates.prependNodeContents(this.inputSelector,html,js),$("#add-learning-objective").click((async function(e){e.preventDefault();var nextloIndex=$("#learningobjective-container").children(".learningobjective").length,newLo={id:nextloIndex,number:nextloIndex+1};try{const{html:html,js:js}=await templates.renderForPromise("mod_roadmap/configuration_learningobjective",newLo);await templates.appendNodeContents("#learningobjective-container",html,js),LearningObjectivesConfig.prototype.rebindInputs(),LearningObjectivesConfig.prototype.saveConfig()}catch(err){notification.exception(err)}})),LearningObjectivesConfig.prototype.rebindInputs()}catch(err){notification.exception(err)}},LearningObjectivesConfig.prototype.rebindInputs=function(){$(".learning-objective-name").unbind("change").change((function(){LearningObjectivesConfig.prototype.saveConfig()})),$(".learningobjective-delete-control").unbind("click").click((function(e){LearningObjectivesConfig.prototype.deleteLearningObjective(e)})),$(".learningobjective-up-control").unbind("click").click((function(e){LearningObjectivesConfig.prototype.upLearningObjective(e)})),$(".learningobjective-down-control").unbind("click").click((function(e){LearningObjectivesConfig.prototype.downLearningObjective(e)})),$('input[name="cloprefix"]').unbind("change").change((function(){LearningObjectivesConfig.prototype.refreshChecklists()}))},LearningObjectivesConfig.prototype.saveConfig=function(){var arrlo=[];$("#learningobjective-container").children(".learningobjective").each((function(index){let lonode=$("#learningobjective-container").children(".learningobjective")[index],id=$(lonode).data("id"),name=$(lonode).find("input.learning-objective-name").val();$(lonode).find("span.number").html(index+1),arrlo.push({index:index,id:id,name:name})})),$('input[name="learningobjectivesconfiguration"]').val(JSON.stringify({learningobjectives:arrlo})),LearningObjectivesConfig.prototype.refreshChecklists(),cyclesave.rebindInputs(),$('.chk-learning-objectives input[type="checkbox"]').trigger("change")},LearningObjectivesConfig.prototype.refreshChecklists=function(){var config=JSON.parse($('input[name="learningobjectivesconfiguration"]').val()),chkAreas=$(".chk-learning-objectives");$(chkAreas).each((function(i,e){let selectedIds=[],configVal=$(this).closest(".cycle-container").children(".cycle-configuration").val();if(""!==configVal){let stepConfig=JSON.parse(configVal);stepConfig.learningobjectives||(stepConfig.learningobjectives=""),selectedIds=stepConfig.learningobjectives.split(",").map((x=>parseInt(x)))}$(e).empty();let prefix=$('input[name="cloprefix"]').val();config.learningobjectives.forEach((function(learningobjective){var li=$("<li/>").attr("data-id",learningobjective.id).appendTo($(e));$("<input/>").attr("type","checkbox").attr("value",learningobjective.id).attr("checked",$.inArray(learningobjective.id,selectedIds)>=0).appendTo(li),$("<span>").text(" "+prefix+" "+(learningobjective.index+1)+": "+learningobjective.name).appendTo(li)}))}))},LearningObjectivesConfig.prototype.deleteLearningObjective=function(event){event.preventDefault(),event.stopPropagation(),notification.confirm("Are you sure you want to delete this Learning Objective?",(function(){$(event.currentTarget).closest(".learningobjective").remove(),LearningObjectivesConfig.prototype.saveConfig()}))},LearningObjectivesConfig.prototype.upLearningObjective=function(event){event.preventDefault(),event.stopPropagation();var loItem=$(event.currentTarget).closest(".learningobjective"),prevloItem=loItem.prev();loItem.insertBefore(prevloItem),LearningObjectivesConfig.prototype.saveConfig()},LearningObjectivesConfig.prototype.downLearningObjective=function(event){event.preventDefault(),event.stopPropagation();var loItem=$(event.currentTarget).closest(".learningobjective"),nextloItem=loItem.next();loItem.insertAfter(nextloItem),LearningObjectivesConfig.prototype.saveConfig()},{init:function(inputSelector,inputConfig){return new LearningObjectivesConfig(inputSelector,inputConfig)},refreshChecklists:function(){LearningObjectivesConfig.prototype.refreshChecklists()}}}));

//# sourceMappingURL=learningobjectivesconfig.min.js.map