<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Reorder all of the positions of all sections and subsections.
 *
 * @package   mod_trainingevaluation
 * @copyright Pelorus Labs
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

define('CLI_SCRIPT', true);

require(__DIR__ . '/../../../config.php');

// Subsections.
$sections = \mod_trainingevaluation\local\section::get_records();
foreach ($sections as $section) {
    $section->reorder_subsection_positions();
}

// Top levels.
$position = 0;
foreach (\mod_trainingevaluation\local\section::get_records(['parentsection' => null], 'position') as $subsection) {
    $subsection->set('position', $position);
    $subsection->update();
    $position++;

    $itempos = 0;
    foreach ($subsection->get_items() as $item) {
        $item->set('position', $itempos);
        $item->update();
        $itempos++;
    }
}
