define("mod_trainingevaluation/evaluate_sections",["exports","core/str","core/ajax","core/notification","core/modal_factory","core/modal_events"],(function(_exports,_str,_ajax,_notification,_modal_factory,_modal_events){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * JavaScript for a user evaluating a training evaluation instance.
   *
   * @module      mod_trainingevaluation/manage_sections
   * @copyright   Pelorus Labs
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification),_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events);_exports.init=(trainingevaluationId,userId)=>{initTextInputForms(userId),initSelectMenuForms(userId),initDatePickerForms(userId),initFinaliseButton(trainingevaluationId,userId),initNewEvaluation(trainingevaluationId,userId)};const initSelectMenuForms=userId=>{document.querySelectorAll(".mod-trainingevaluation-selectmenu-option-label").forEach((label=>{const itemContainer=label.closest("[data-item-id]");if(!itemContainer)return;const itemId=parseInt(itemContainer.dataset.itemId);label.addEventListener("click",(()=>{const optionId=document.getElementById(label.getAttribute("for")).dataset.optionId;saveResponse(itemId,userId,optionId)}))}))},initTextInputForms=userId=>{document.querySelectorAll(".mod-trainingevaluation-textinput-form").forEach((textarea=>{const itemContainer=textarea.closest("[data-item-id]");if(!itemContainer)return;const itemId=parseInt(itemContainer.dataset.itemId);let saveTimeout=null;textarea.addEventListener("input",(()=>{saveTimeout&&clearTimeout(saveTimeout),saveTimeout=setTimeout((()=>{textarea.value!==textarea.dataset.originalValue&&(saveResponse(itemId,userId,textarea.value),textarea.dataset.originalValue=textarea.value)}),500)})),textarea.addEventListener("blur",(()=>{saveTimeout&&(clearTimeout(saveTimeout),saveTimeout=null),textarea.value!==textarea.dataset.originalValue&&(saveResponse(itemId,userId,textarea.value),textarea.dataset.originalValue=textarea.value)})),textarea.dataset.originalValue=textarea.value}))},initDatePickerForms=userId=>{document.querySelectorAll(".mod-trainingevaluation-datepicker-form").forEach((datepicker=>{const itemContainer=datepicker.closest("[data-item-id]");if(!itemContainer)return;const itemId=parseInt(itemContainer.dataset.itemId);datepicker.addEventListener("change",(event=>{saveResponse(itemId,userId,event.target.value)}))}))},saveResponse=async(itemId,userId,responseData)=>{try{const response=await _ajax.default.call([{methodname:"mod_trainingevaluation_save_response",args:{itemid:itemId,userid:userId,response:responseData}}])[0];if(response.error)throw new Error(response.exception);showSaveFeedback(itemId,!0)}catch(error){showSaveFeedback(itemId,!1),_notification.default.exception(error)}},showSaveFeedback=async(itemId,success)=>{const itemContainer=document.querySelector('[data-item-id="'.concat(itemId,'"]'));if(!itemContainer)return;const contentElement=itemContainer.querySelector(".mod-trainingevaluation-item-content");if(!contentElement)return;const existingFeedback=itemContainer.querySelector(".mod-trainingevaluation-save-feedback");existingFeedback&&existingFeedback.remove();const feedbackSpan=document.createElement("span");feedbackSpan.className="mod-trainingevaluation-save-feedback mod-trainingevaluation-save-feedback--"+(success?"success":"error"),feedbackSpan.textContent="",feedbackSpan.style.opacity="1",feedbackSpan.textContent=success?await(0,_str.get_string)("saved","mod_trainingevaluation"):await(0,_str.get_string)("errorsaving","mod_trainingevaluation"),contentElement.insertAdjacentElement("afterend",feedbackSpan),setTimeout((()=>{feedbackSpan.style.opacity="0",setTimeout((()=>{feedbackSpan.remove()}),500)}),success?1e3:2500)},initNewEvaluation=(trainingevaluationId,userId)=>{const newEvaluationButton=document.getElementById("mod-trainingevaluation-new-evaluation-btn");newEvaluationButton&&newEvaluationButton.addEventListener("click",(async()=>{const confirmMessage=await(0,_str.get_string)("confirmnewevaluate","trainingevaluation"),confirmTitle=await(0,_str.get_string)("confirm","core"),modal=await _modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:confirmTitle,body:confirmMessage});await modal.setSaveButtonText(confirmTitle),modal.getRoot().on(_modal_events.default.save,(async()=>{try{const result=await _ajax.default.call([{methodname:"mod_trainingevaluation_new_evaluation",args:{wtid:trainingevaluationId,userid:userId}}])[0];if(result.version){const url=new URL(window.location.href);url.searchParams.set("version",result.version),window.location.href=url.toString()}else _notification.default.alert("Error",result.message,"OK")}catch(error){_notification.default.exception(error)}})),modal.getRoot().on(_modal_events.default.hidden,(()=>{modal.destroy()})),modal.show()}))},initFinaliseButton=(trainingevaluationId,userId)=>{const finaliseButton=document.getElementById("mod-trainingevaluation-finalise-btn");finaliseButton&&finaliseButton.addEventListener("click",(async()=>{const confirmMessage=await(0,_str.get_string)("confirmfinalise","trainingevaluation"),confirmTitle=await(0,_str.get_string)("confirm","core"),modal=await _modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:confirmTitle,body:confirmMessage});await modal.setSaveButtonText(confirmTitle),modal.getRoot().on(_modal_events.default.save,(async()=>{try{const result=await _ajax.default.call([{methodname:"mod_trainingevaluation_finalise_evaluation",args:{wtid:trainingevaluationId,userid:userId}}])[0];result.error?_notification.default.alert("Error",result.message,"OK"):window.location.reload()}catch(error){_notification.default.exception(error)}})),modal.getRoot().on(_modal_events.default.hidden,(()=>{modal.destroy()})),modal.show()}))}}));

//# sourceMappingURL=evaluate_sections.min.js.map