<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file contains helixmedia mobile code
 *
 * @package    assignsubmission_helixassign
 * @subpackage helixmedia
 * @author     Tim Williams (For Streaming LTD)
 * @copyright  MEDIAL
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace assignsubmission_helixassign\output;

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/mod/helixmedia/lib.php');
require_once($CFG->dirroot . '/mod/helixmedia/locallib.php');

use context_module;
use assignsubmission_helixassign_external;


/**
 * Mobile handler for MEDIAL submissions
 **/
class mobile {
    /**
     * Returns the helixmedia course view for the mobile app.
     * @param  array $args Arguments from tool_mobile_get_content WS
     *
     * @return array       HTML, javascript and otherdata
     */
    public static function mobile_get_helixmedia($args) {
        global $CFG;

        return [
            'templates' => [
                [
                    'id' => 'main',
                    'html' => file_get_contents($CFG->dirroot .
                        '/mod/assign/submission/helixassign/mobile/addon-assignsubmission-helixmedia.html'),
                ],
            ],
            'javascript' => file_get_contents($CFG->dirroot . '/mod/assign/submission/helixassign/mobile/mobile.js'),
        ];
    }

    /**
     * Gets a random code
     * @param int $length The length required
     * @return string random code
     */
    private static function random_code($length) {
        $chars = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        $clen   = strlen($chars) - 1;
        $id  = '';
        for ($i = 0; $i < $length; $i++) {
            $id .= $chars[mt_rand(0, $clen)];
        }
        return $id;
    }
}
