/**
 * Tutor-IA Chat - Drawer and chat functionality (based on aiplacement_courseassist)
 *
 * @module     local_dttutor/tutor_ia_chat
 * @copyright  2025 Datacurso
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_dttutor/tutor_ia_chat",["jquery","core/ajax","core/notification","core/pubsub","local_dttutor/error_modal"],(function($,Ajax,Notification,PubSub,ErrorModal){const SELECTORS_TOGGLE_BTN='[data-action="tutor-ia-toggle"]',SELECTORS_DRAWER=".tutor-ia-drawer",SELECTORS_CLOSE_BTN=".tutor-ia-close-button",SELECTORS_MESSAGES='[data-region="tutor-ia-messages"]',SELECTORS_INPUT='[data-region="tutor-ia-input"]',SELECTORS_SEND_BTN='[data-action="send-message"]',SELECTORS_PAGE="#page",SELECTORS_JUMP_TO="#jump-to",SELECTORS_BODY="body";class TutorIAChat{constructor(root,uniqueId,courseId,cmId,userId){this.root=$(root),this.uniqueId=uniqueId,this.courseId=courseId,this.cmId=cmId,this.userId=userId,this.streaming=!1,this.currentEventSource=null,this.currentSessionId=null,this.currentAIMessageEl=null,this.currentAIMessageContainer=null,this.historyOffset=0,this.historyLimit=20,this.isLoadingHistory=!1,this.hasMoreHistory=!0,this.historyLoaded=!1,this.welcomeMessage=root.getAttribute("data-welcomemessage")||"",this.isConfigured="1"===root.getAttribute("data-is-configured")||"true"===root.getAttribute("data-is-configured"),this.drawerElement=document.querySelector(SELECTORS_DRAWER),this.pageElement=document.querySelector(SELECTORS_PAGE),this.bodyElement=document.querySelector(SELECTORS_BODY),this.toggleButton=document.querySelector(SELECTORS_TOGGLE_BTN),this.closeButton=document.querySelector(SELECTORS_CLOSE_BTN),this.jumpTo=document.querySelector(SELECTORS_JUMP_TO),this.position=this.drawerElement&&this.drawerElement.getAttribute("data-position")||"right",this.pageClass="left"===this.position?"show-drawer-left":"show-drawer-right",this.bodyClass="left"===this.position?"tutor-ia-drawer-open-left":"tutor-ia-drawer-open-right",this.pageContext=this.detectPageContext(),this.adjustDrawerTopPosition(),this.init()}adjustDrawerTopPosition(){if(!this.drawerElement)return;const navbarSelectors=[".navbar.fixed-top",".fixed-top.navbar","#page-header.fixed-top","nav.fixed-top",".navbar-fixed-top"];let navbarHeight=60;for(const selector of navbarSelectors){const navbar=document.querySelector(selector);if(navbar&&(navbarHeight=navbar.offsetHeight,navbarHeight>0))break}this.drawerElement.style.setProperty("--tutor-ia-drawer-top",navbarHeight+"px"),window.addEventListener("resize",(()=>{const navbar=document.querySelector(navbarSelectors[0]);if(navbar){const newHeight=navbar.offsetHeight;this.drawerElement.style.setProperty("--tutor-ia-drawer-top",newHeight+"px")}}))}detectPageContext(){const context={};if("undefined"!=typeof M&&M.cfg&&M.cfg.pagetype&&(context.pagetype=M.cfg.pagetype),!context.pagetype){const bodyId=document.body.id;bodyId&&(context.pagetype=bodyId.replace("page-",""))}if(!context.pagetype){const pathMatch=document.body.className.match(/path-([\w-]+)/);pathMatch&&(context.pagetype=pathMatch[1])}const urlParams=new URLSearchParams(window.location.search);return context.pagetype&&context.pagetype.includes("forum")?(urlParams.has("d")&&(context.discussionid=parseInt(urlParams.get("d"),10)),urlParams.has("f")&&(context.forumid=parseInt(urlParams.get("f"),10))):context.pagetype&&context.pagetype.includes("quiz")?urlParams.has("attempt")&&(context.attemptid=parseInt(urlParams.get("attempt"),10)):context.pagetype&&context.pagetype.includes("assign")?urlParams.has("id")&&(context.assignid=parseInt(urlParams.get("id"),10)):context.pagetype&&context.pagetype.includes("wiki")&&urlParams.has("pageid")&&(context.pageid=parseInt(urlParams.get("pageid"),10)),context}init(){this.registerEventListeners(),window.addEventListener("beforeunload",(()=>this.cleanup()))}registerEventListeners(){this.toggleButton&&this.toggleButton.addEventListener("click",(e=>{e.preventDefault(),this.toggleDrawer()})),this.closeButton&&this.closeButton.addEventListener("click",(e=>{e.preventDefault(),this.closeDrawer()})),this.root.find(SELECTORS_SEND_BTN).on("click",(()=>{this.sendMessage()}));const input=this.root.find(SELECTORS_INPUT);input.on("keydown",(e=>{"Enter"!==e.key||e.shiftKey||(e.preventDefault(),this.sendMessage())})),input.on("input",(function(){this.style.height="auto",this.style.height=Math.min(this.scrollHeight,120)+"px"}));this.root.find(SELECTORS_MESSAGES).on("scroll",(()=>{this.handleHistoryScroll()})),document.addEventListener("keydown",(e=>{this.isDrawerOpen()&&"Escape"===e.key&&this.closeDrawer()})),PubSub.subscribe("core_message/drawer_shown",(()=>{this.isDrawerOpen()&&this.closeDrawer()})),this.jumpTo&&this.jumpTo.addEventListener("focus",(()=>{this.closeButton&&this.closeButton.focus()}))}isDrawerOpen(){return this.drawerElement&&this.drawerElement.classList.contains("show")}openDrawer(){this.drawerElement&&(PubSub.publish("core_message/hide",{}),this.drawerElement.classList.add("show"),this.drawerElement.setAttribute("tabindex","0"),this.toggleButton&&this.toggleButton.setAttribute("aria-expanded","true"),this.pageElement&&!this.pageElement.classList.contains(this.pageClass)&&this.pageElement.classList.add(this.pageClass),this.bodyElement&&!this.bodyElement.classList.contains(this.bodyClass)&&this.bodyElement.classList.add(this.bodyClass),this.jumpTo&&(this.jumpTo.setAttribute("tabindex",0),this.jumpTo.focus()),this.isConfigured&&this.loadChatHistory())}closeDrawer(){this.drawerElement&&(this.drawerElement.classList.remove("show"),this.drawerElement.setAttribute("tabindex","-1"),this.toggleButton&&this.toggleButton.setAttribute("aria-expanded","false"),this.pageElement&&this.pageElement.classList.contains(this.pageClass)&&this.pageElement.classList.remove(this.pageClass),this.bodyElement&&this.bodyElement.classList.contains(this.bodyClass)&&this.bodyElement.classList.remove(this.bodyClass),this.jumpTo&&this.jumpTo.setAttribute("tabindex",-1),this.toggleButton&&this.toggleButton.focus())}toggleDrawer(){this.isDrawerOpen()?this.closeDrawer():this.openDrawer()}loadChatHistory(){if(this.isLoadingHistory||!this.hasMoreHistory)return;this.isLoadingHistory=!0;const messagesContainer=this.root.find(SELECTORS_MESSAGES),scrollHeightBefore=messagesContainer[0].scrollHeight,scrollTopBefore=messagesContainer[0].scrollTop;this.showHistoryLoading();Ajax.call([{methodname:"local_dttutor_get_chat_history",args:{courseid:parseInt(this.courseId,10),limit:this.historyLimit,offset:this.historyOffset}}])[0].then((data=>{if(this.hideHistoryLoading(),data.success&&data.messages&&data.messages.length>0){const isInitialLoad=0===this.historyOffset;if(this.displayHistoryMessages(data.messages,isInitialLoad),this.historyOffset+=data.messages.length,this.hasMoreHistory=data.pagination.has_more,isInitialLoad)this.scrollToBottom();else{const scrollDiff=messagesContainer[0].scrollHeight-scrollHeightBefore;messagesContainer[0].scrollTop=scrollTopBefore+scrollDiff}}else this.hasMoreHistory=!1;return this.historyLoaded=!0,this.isLoadingHistory=!1,data})).catch((err=>{this.hideHistoryLoading(),this.isLoadingHistory=!1;const errorMessage=this.getFriendlyErrorMessage(err),isConfigError=this.isWebserviceConfigError(err),configUrl=this.extractConfigUrl(err);isConfigError?ErrorModal.showConfigError(errorMessage,configUrl):ErrorModal.showGeneralError(errorMessage)}))}handleHistoryScroll(){this.root.find(SELECTORS_MESSAGES)[0].scrollTop<100&&!this.isLoadingHistory&&this.hasMoreHistory&&this.loadChatHistory()}displayHistoryMessages(messages,isInitialLoad){const messagesContainer=this.root.find(SELECTORS_MESSAGES);if(isInitialLoad&&this.welcomeMessage&&messagesContainer.find('.tutor-ia-message.ai:contains("'+this.welcomeMessage+'")').remove(),isInitialLoad)for(let i=messages.length-1;i>=0;i--){const messageDiv=this.createMessageElement(messages[i]);messagesContainer.append(messageDiv)}else messages.forEach((msg=>{const messageDiv=this.createMessageElement(msg);messagesContainer.prepend(messageDiv)}))}createMessageElement(msg){const messageDiv=$("<div>").addClass("tutor-ia-message").addClass("user"===msg.role?"user":"ai").attr("data-message-id",msg.id),contentDiv=$("<div>").addClass("message-content").text(msg.content),timestampDiv=$("<div>").addClass("message-timestamp").text(this.formatTimestamp(msg.timestamp));return messageDiv.append(contentDiv),messageDiv.append(timestampDiv),messageDiv}formatTimestamp(timestamp){const date=new Date(1e3*timestamp),today=new Date,messageDate=new Date(date.getFullYear(),date.getMonth(),date.getDate()),todayDate=new Date(today.getFullYear(),today.getMonth(),today.getDate()),yesterday=new Date(todayDate);yesterday.setDate(yesterday.getDate()-1);const hours=date.getHours().toString().padStart(2,"0"),minutes=date.getMinutes().toString().padStart(2,"0"),time="".concat(hours,":").concat(minutes);if(messageDate.getTime()===todayDate.getTime())return time;if(messageDate.getTime()===yesterday.getTime())return"Yesterday ".concat(time);const day=date.getDate().toString().padStart(2,"0"),month=(date.getMonth()+1).toString().padStart(2,"0"),year=date.getFullYear();return"".concat(day,"/").concat(month,"/").concat(year," ").concat(time)}showHistoryLoading(){const messagesContainer=this.root.find(SELECTORS_MESSAGES);if(!messagesContainer.find(".history-loading").length){const loadingDiv=$("<div>").addClass("history-loading").text("Loading...");messagesContainer.prepend(loadingDiv)}}hideHistoryLoading(){this.root.find(".history-loading").remove()}sendMessage(){if(!this.isConfigured)return;const input=this.root.find(SELECTORS_INPUT),sendBtn=this.root.find(SELECTORS_SEND_BTN),messageText=input.val().trim();if(messageText&&!this.streaming)if("."!==messageText)if(messageText.length>4e3)this.addMessage("[Error] Message is too long. Maximum 4000 characters.","ai");else try{this.closeCurrentStream(),sendBtn.prop("disabled",!0),this.addMessage(messageText,"user"),input.val(""),input.css("height","auto"),this.scrollToBottom(),this.showTypingIndicator();const metaData={user_role:"Student",timestamp:Math.floor(Date.now()/1e3)};this.pageContext.pagetype&&(metaData.page=this.pageContext.pagetype),this.pageContext.discussionid&&(metaData.discussionid=this.pageContext.discussionid),this.pageContext.forumid&&(metaData.forumid=this.pageContext.forumid),this.pageContext.attemptid&&(metaData.attemptid=this.pageContext.attemptid),this.pageContext.assignid&&(metaData.assignid=this.pageContext.assignid),this.pageContext.pageid&&(metaData.pageid=this.pageContext.pageid),this.cmId&&(metaData.cmid=parseInt(this.cmId,10));Ajax.call([{methodname:"local_dttutor_create_chat_message",args:{courseid:parseInt(this.courseId,10),message:this.sanitizeString(messageText.substring(0,4e3)),meta:JSON.stringify(metaData)}}])[0].then((data=>{if(!data||!data.stream_url)throw new Error("Stream URL missing in response");return this.currentSessionId=data.session_id,this.startSSE(data.stream_url,sendBtn),data})).catch((err=>{if(this.hideTypingIndicator(),this.isNoCreditsError(err)){const errorHtml=err.message||"Insufficient AI credits available.";this.showNoCreditsWarning(errorHtml);this.root.find(SELECTORS_INPUT).prop("disabled",!0),sendBtn.prop("disabled",!0)}else{sendBtn.prop("disabled",!1);const errorMessage=this.getFriendlyErrorMessage(err),isConfigError=this.isWebserviceConfigError(err),configUrl=this.extractConfigUrl(err);isConfigError?ErrorModal.showConfigError(errorMessage,configUrl):ErrorModal.showGeneralError(errorMessage)}}))}catch(error){this.hideTypingIndicator(),sendBtn.prop("disabled",!1),ErrorModal.showGeneralError("Internal error: "+error.message)}else this.addMessage("[Error] Please enter a valid message.","ai")}startSSE(streamUrl,sendBtn){try{const es=new EventSource(streamUrl);this.currentEventSource=es,this.streaming=!0;let firstToken=!0,messageCompleted=!1;es.addEventListener("token",(ev=>{try{const payload=JSON.parse(ev.data),text=payload.t||payload.content||"";firstToken&&(firstToken=!1,this.ensureAIMessageEl(),this.hideTypingIndicator()),this.appendToAIMessage(text)}catch(e){}})),es.addEventListener("done",(()=>{messageCompleted=!0,this.finalizeStream(sendBtn)})),es.addEventListener("message_completed",(()=>{messageCompleted=!0,this.finalizeStream(sendBtn)})),es.addEventListener("error",(()=>{messageCompleted||(this.appendToAIMessage("\n[Connection interrupted]"),this.finalizeStream(sendBtn))}))}catch(error){this.addMessage("[Error] Could not establish SSE connection","ai"),this.finalizeStream(sendBtn)}}ensureAIMessageEl(){if(this.currentAIMessageEl)return this.currentAIMessageEl;const messages=this.root.find(SELECTORS_MESSAGES);let messageContainer;const typingEl=messages.find(".tutor-ia-typing");typingEl.length?(messageContainer=typingEl,messageContainer.removeClass("tutor-ia-typing"),messageContainer.addClass("tutor-ia-message ai"),messageContainer.html("")):(messageContainer=$('<div class="tutor-ia-message ai"></div>'),messages.append(messageContainer));const contentDiv=$("<div>").addClass("message-content");return messageContainer.append(contentDiv),this.currentAIMessageEl=contentDiv[0],this.currentAIMessageContainer=messageContainer[0],this.currentAIMessageEl}appendToAIMessage(text){if(this.currentAIMessageEl||this.ensureAIMessageEl(),!this.currentAIMessageEl||"string"!=typeof text)return;const currentText=this.currentAIMessageEl.textContent||"";if(currentText.length+text.length>1e4){const remaining=1e4-currentText.length;remaining>0&&(this.currentAIMessageEl.textContent+=text.substring(0,remaining)+"...")}else this.currentAIMessageEl.textContent+=text,this.scrollToBottom()}addMessage(text,type){if(!text||"string"!=typeof text)return;const messages=this.root.find(SELECTORS_MESSAGES),messageEl=$("<div></div>").addClass("tutor-ia-message").addClass(type),contentDiv=$("<div>").addClass("message-content").text(text.substring(0,1e4)),currentTimestamp=Math.floor(Date.now()/1e3),timestampDiv=$("<div>").addClass("message-timestamp").text(this.formatTimestamp(currentTimestamp));messageEl.append(contentDiv),messageEl.append(timestampDiv),messages.append(messageEl),this.scrollToBottom()}showTypingIndicator(){const messages=this.root.find(SELECTORS_MESSAGES);if(messages.find(".tutor-ia-typing").length)return;const typing=$('<div class="tutor-ia-message ai tutor-ia-typing"></div>').html('<span class="dot"></span><span class="dot"></span><span class="dot"></span>');messages.append(typing),this.scrollToBottom()}hideTypingIndicator(){this.root.find(".tutor-ia-typing").remove()}showNoCreditsWarning(errorHtml){const messages=this.root.find(SELECTORS_MESSAGES);messages.find(".tutor-ia-no-credits-warning").remove();const warningDiv=$('<div class="tutor-ia-no-credits-warning"></div>'),alertDiv=$('<div class="alert alert-danger"></div>');alertDiv.html('<i class="fa fa-exclamation-circle"></i> <div class="warning-content"><strong>No Credits Available</strong><p>'+errorHtml+"</p></div>"),warningDiv.append(alertDiv),messages.append(warningDiv),this.scrollToBottom()}scrollToBottom(){const messages=this.root.find(SELECTORS_MESSAGES);messages.scrollTop(messages[0].scrollHeight)}closeCurrentStream(){if(this.currentEventSource)try{this.currentEventSource.close()}catch(e){}this.currentEventSource=null,this.streaming=!1,this.currentAIMessageEl=null,this.currentAIMessageContainer=null,this.hideTypingIndicator()}finalizeStream(sendBtn){if(this.currentAIMessageContainer){const currentTimestamp=Math.floor(Date.now()/1e3),timestampDiv=$("<div>").addClass("message-timestamp").text(this.formatTimestamp(currentTimestamp));$(this.currentAIMessageContainer).append(timestampDiv),this.currentAIMessageContainer=null}this.closeCurrentStream(),sendBtn&&sendBtn.prop("disabled",!1)}sanitizeString(str){return"string"!=typeof str?"":str.replace(/[<>]/g,"")}isWebserviceConfigError(err){if(!err||!err.message)return!1;const message=err.message.toLowerCase();return message.includes("webservice_not_configured")||message.includes("webservice not configured")||message.includes("error_webservice_not_configured")}isNoCreditsError(err){if(!err||!err.message)return!1;const message=err.message.toLowerCase();return message.includes("notenoughtokens")||message.includes("insufficient ai credits")||message.includes("no credits")||message.includes("out of credits")}getFriendlyErrorMessage(err){return err?this.isWebserviceConfigError(err)?err.message||err.error||"Configuration error":err.message?err.message:err.error?err.error:"An error occurred. Please try again later.":"An unknown error occurred. Please try again."}extractConfigUrl(err){if(!err||!err.message)return null;const hrefMatch=err.message.match(/href="([^"]+)"/);return hrefMatch&&hrefMatch[1]?hrefMatch[1]:null}cleanup(){this.closeCurrentStream()}destroy(){this.cleanup()}}return{init:function(root,uniqueId,courseId,cmId,userId){return new TutorIAChat(root,uniqueId,courseId,cmId,userId)}}}));

//# sourceMappingURL=tutor_ia_chat.min.js.map