/**
 * Position configurator for Tutor-IA avatar placement settings
 *
 * @module     local_dttutor/position_configurator
 * @copyright  2025 Datacurso
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_dttutor/position_configurator",[],(function(){return{init:function(){const presetRadios=document.querySelectorAll('input[name="position_preset"]'),customCoordsDiv=document.getElementById("custom-coords"),xInput=document.getElementById("position_x"),yInput=document.getElementById("position_y"),xRefRadios=document.querySelectorAll('input[name="ref_x"]'),yRefRadios=document.querySelectorAll('input[name="ref_y"]'),drawerSideSelect=document.getElementById("drawer_side"),previewAvatar=document.getElementById("preview-avatar"),previewContainer=document.querySelector(".position-preview"),coordsDisplay=document.getElementById("coords-display"),hiddenInput=document.getElementById("id_s_local_dttutor_avatar_position_data");if(!previewAvatar||!previewContainer)return;let isDragging=!1,startX=0,startY=0,initialLeft=0,initialTop=0;function pixelsToRem(pixels){return(pixels/parseFloat(getComputedStyle(document.documentElement).fontSize)).toFixed(2)+"rem"}function cssValueToPixels(value,containerSize){if(value.endsWith("px"))return parseFloat(value);if(value.endsWith("rem")){const fontSize=parseFloat(getComputedStyle(document.documentElement).fontSize);return parseFloat(value)*fontSize}if(value.endsWith("em")){const fontSize=parseFloat(getComputedStyle(previewAvatar).fontSize);return parseFloat(value)*fontSize}return value.endsWith("%")?parseFloat(value)/100*containerSize:value.endsWith("vh")?parseFloat(value)/100*window.innerHeight:value.endsWith("vw")?parseFloat(value)/100*window.innerWidth:0}function updatePreview(){var _document$querySelect,_document$querySelect2;const preset=document.querySelector('input[name="position_preset"]:checked').value,drawerSide=drawerSideSelect.value,xRef=(null===(_document$querySelect=document.querySelector('input[name="ref_x"]:checked'))||void 0===_document$querySelect?void 0:_document$querySelect.value)||"left",yRef=(null===(_document$querySelect2=document.querySelector('input[name="ref_y"]:checked'))||void 0===_document$querySelect2?void 0:_document$querySelect2.value)||"bottom";let x=xInput.value,y=yInput.value;if("custom"===preset?customCoordsDiv.classList.add("active"):(customCoordsDiv.classList.remove("active"),("right"===preset||"left"===preset)&&(x="2rem",y="6rem")),"right"===preset)previewAvatar.style.right=x,previewAvatar.style.left="auto",previewAvatar.style.bottom=y,previewAvatar.style.top="auto";else if("left"===preset)previewAvatar.style.left=x,previewAvatar.style.right="auto",previewAvatar.style.bottom=y,previewAvatar.style.top="auto";else{const rect=previewContainer.getBoundingClientRect(),avatarWidth=previewAvatar.offsetWidth,avatarHeight=previewAvatar.offsetHeight,xSide=x.startsWith("-")?"right":"left",ySide=y.startsWith("-")?"top":"bottom",xValue=x.replace("-",""),yValue=y.replace("-",""),xPx=cssValueToPixels(xValue,rect.width),yPx=cssValueToPixels(yValue,rect.height);let leftPx,topPx;leftPx="left"===xSide?xPx:rect.width-xPx-avatarWidth,topPx="bottom"===ySide?rect.height-yPx-avatarHeight:yPx,previewAvatar.style.left=leftPx+"px",previewAvatar.style.top=topPx+"px",previewAvatar.style.right="auto",previewAvatar.style.bottom="auto"}const xDisplay="custom"===preset?"".concat(x," (from ").concat(xRef,")"):x,yDisplay="custom"===preset?"".concat(y," (from ").concat(yRef,")"):y;coordsDisplay.textContent="Position: ".concat("custom"===preset?"X: ".concat(xDisplay,", Y: ").concat(yDisplay):preset+" corner"," | Drawer: ").concat(drawerSide);const data={preset:preset,x:x,y:y,drawerside:drawerSide,xref:xRef,yref:yRef};hiddenInput.value=JSON.stringify(data),document.querySelectorAll(".preset-option").forEach((opt=>opt.classList.remove("selected")));const selectedOption=document.querySelector('.preset-option[data-preset="'.concat(preset,'"]'));selectedOption&&selectedOption.classList.add("selected")}function handleMouseMove(e){var _document$querySelect3,_document$querySelect4;if(!isDragging)return;e.preventDefault();const rect=previewContainer.getBoundingClientRect(),deltaX=e.clientX-startX,deltaY=e.clientY-startY;let newLeft=initialLeft+deltaX,newTop=initialTop+deltaY;const avatarWidth=previewAvatar.offsetWidth,avatarHeight=previewAvatar.offsetHeight;newLeft=Math.max(0,Math.min(newLeft,rect.width-avatarWidth)),newTop=Math.max(0,Math.min(newTop,rect.height-avatarHeight));const fromRight=rect.width-newLeft-avatarWidth,fromBottom=rect.height-newTop-avatarHeight,xRef=(null===(_document$querySelect3=document.querySelector('input[name="ref_x"]:checked'))||void 0===_document$querySelect3?void 0:_document$querySelect3.value)||"left",yRef=(null===(_document$querySelect4=document.querySelector('input[name="ref_y"]:checked'))||void 0===_document$querySelect4?void 0:_document$querySelect4.value)||"bottom";xInput.value="left"===xRef?pixelsToRem(newLeft):"-"+pixelsToRem(fromRight),yInput.value="bottom"===yRef?pixelsToRem(fromBottom):"-"+pixelsToRem(newTop),previewAvatar.style.left=newLeft+"px",previewAvatar.style.top=newTop+"px",previewAvatar.style.right="auto",previewAvatar.style.bottom="auto",coordsDisplay.textContent="Position: X: "+xInput.value+" (from "+xRef+"), Y: "+yInput.value+" (from "+yRef+") | Drawer: "+drawerSideSelect.value}function handleMouseUp(){isDragging&&(isDragging=!1,previewAvatar.classList.remove("dragging"),document.removeEventListener("mousemove",handleMouseMove),document.removeEventListener("mouseup",handleMouseUp),updatePreview())}previewAvatar.addEventListener("mousedown",(function(e){e.preventDefault(),isDragging=!0,previewAvatar.classList.add("dragging");const rect=previewContainer.getBoundingClientRect(),avatarRect=previewAvatar.getBoundingClientRect();startX=e.clientX,startY=e.clientY,initialLeft=avatarRect.left-rect.left,initialTop=avatarRect.top-rect.top;const customRadio=document.querySelector('input[name="position_preset"][value="custom"]');customRadio&&(customRadio.checked=!0,customCoordsDiv.classList.add("active")),document.addEventListener("mousemove",handleMouseMove),document.addEventListener("mouseup",handleMouseUp)})),presetRadios.forEach((radio=>{radio.addEventListener("change",updatePreview)})),xInput.addEventListener("input",updatePreview),yInput.addEventListener("input",updatePreview),drawerSideSelect.addEventListener("change",updatePreview),xRefRadios.forEach((radio=>{radio.addEventListener("change",updatePreview)})),yRefRadios.forEach((radio=>{radio.addEventListener("change",updatePreview)})),document.querySelectorAll(".preset-option").forEach((opt=>{opt.addEventListener("click",(function(){const preset=this.dataset.preset;document.querySelector('input[name="position_preset"][value="'.concat(preset,'"]')).checked=!0,updatePreview()}))})),updatePreview()}}}));

//# sourceMappingURL=position_configurator.min.js.map