define("mod_interactivevideo/player/viostream",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Bunny Stream Player class
   *
   * @module     mod_interactivevideo/player/viostream
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var player={};var _default=class{constructor(){this.useAnimationFrame=!1,this.type="viostream",this.frequency=.25,this.support={playbackrate:!1,quality:!1}}async getInfo(url,node){this.node=node}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const node=opts.node||"player";this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked",{requireVideoBlock:!0});let self=this;var match=/(?:https?:\/\/)?(?:share\.viostream\.com)\/([a-zA-Z0-9]+)/i.exec(url),videoId=match?match[1]:null;this.videoId=videoId,self.aspectratio=16/9,opts.editform&&await new Promise(((resolve,reject)=>{_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text",data:{action:"get_from_url",contextid:M.cfg.contextid,url:url,sesskey:M.cfg.sesskey},complete:function(res){let text=res.responseText,titleMatch=text.match(/<meta\s+name=["']twitter:title["']\s+content=["']([^"']+)["']/i),title=titleMatch?titleMatch[1]:"",posterMatch=text.match(/<meta\s+(?:property|name)=["']og:image["']\s+content=["']([^"']+)["']/i),poster=posterMatch?posterMatch[1]:"",widthMatch=text.match(/<meta\s+(?:property|name)=["']twitter:player:width["']\s+content=["']([^"']+)["']/i),width=widthMatch?widthMatch[1]:"",heightMatch=text.match(/<meta\s+(?:property|name)=["']twitter:player:height["']\s+content=["']([^"']+)["']/i),height=heightMatch?heightMatch[1]:"";self.title=title,self.posterImage=poster,self.aspectratio=width/height,resolve(title)},error:function(xhr,status,error){reject(error)}})}));let iframe='<iframe src="https://play.viostream.com/iframe/'.concat(videoId,'" id="').concat(node,'"\n        referrerpolicy="strict-origin-when-cross-origin" webkitallowfullscreen mozallowfullscreen allowfullscreen\n         frameborder="0" ></iframe>'),$parent=(0,_jquery.default)("#".concat(node)).parent();(0,_jquery.default)("#".concat(node)).replaceWith(iframe),$parent.removeClass("d-none w-0"),(0,_jquery.default)(".video-block, #video-block").remove(),player[node]=new window.playerjs.Player(document.getElementById(node)),player[node].on("ready",(()=>{self.start=start||0,player[node].play();let interval=setInterval((()=>{player[node].getDuration((duration=>{if(!duration)return;let totaltime=Number(duration.toFixed(2))-self.frequency;end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=Number(totaltime.toFixed(2)),self.duration=self.end-self.start,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),clearInterval(interval)}))}),500);player[node].on("play",(()=>{self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay")})),player[node].on("pause",(()=>{self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")})),player[node].on("ended",(()=>{self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")})),player[node].on("timeupdate",(data=>{(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),data.seconds>=self.end&&(self.ended=!0,player[node].pause(),(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")),data.seconds<self.start&&self.seek(self.start)})),player[node].on("seeked",(()=>{player[node].getCurrentTime((value=>{(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:value})}))}))}))}play(){player[this.node]&&(player[this.node].play(),this.paused=!1)}pause(){player[this.node]&&(player[this.node].pause(),this.paused=!0)}stop(starttime){player[this.node]&&(player[this.node].setCurrentTime(starttime),player[this.node].pause())}seek(time){return player[this.node]?new Promise((resolve=>{player[this.node].getCurrentTime((value=>{let currentTime=value;(0,_event_dispatcher.dispatchEvent)("iv:playerSeekStart",{time:currentTime}),this.ended=!1,player[this.node].setCurrentTime(time,!0),resolve(!0)}))})):time}getCurrentTime(){return player[this.node]?new Promise((resolve=>{player[this.node].getCurrentTime((value=>resolve(value)))})):0}getDuration(){return player[this.node]?new Promise((resolve=>{player[this.node].getDuration((value=>resolve(value)))})):0}isPaused(){return!player[this.node]||new Promise((resolve=>{player[this.node].getPaused((value=>resolve(!0===value)))}))}isPlaying(){return!!player[this.node]&&new Promise((resolve=>{player[this.node].getPaused((value=>resolve(!1===value)))}))}isEnded(){return!!player[this.node]&&this.ended}ratio(){return player[this.node]?this.aspectratio:16/9}destroy(){(0,_jquery.default)("#".concat(this.node)).remove(),player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}getState(){return player[this.node]?new Promise((resolve=>{player[this.node].getPaused((value=>resolve(value?"paused":"playing")))})):"paused"}setRate(rate){return player[this.node],rate}mute(){player[this.node]&&(player[this.node].mute(),player[this.node].setVolume(0),this.muted=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:0}))}unMute(){player[this.node]&&(player[this.node].unmute(),player[this.node].setVolume(100),this.muted=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:1}))}isMuted(){return!!player[this.node]&&new Promise((resolve=>{player[this.node].getMuted((value=>resolve(value)))}))}originalPlayer(){return player[this.node]}setCaption(track){return player[this.node]?track:null}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=viostream.min.js.map