define("mod_interactivevideo/player/peertube",["exports","core/event_dispatcher","jquery","mod_interactivevideo/libraries/peertube","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_peertube,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * PeerTube Player class
   * https://docs.joinpeertube.org/api/embed-player#embed-methods
   *
   * @module     mod_interactivevideo/player/peertube
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);let player={};var _default=class{constructor(){this.useAnimationFrame=!1,this.type="peertube",this.frequency=.7,this.support={playbackrate:!0,quality:!0,password:!0}}async getInfo(url,node){this.node=node;let self=this;const match=url.match(/https:\/\/([^/]+)\/w\/([^/]+)/),domain=match[1];let videoId=match[2].split("?")[0],password=url.split("?password=")[1];const myHeaders=new Headers;password&&""!==password&&myHeaders.append("x-peertube-video-password",password);let videoInfo=await fetch("https://".concat(domain,"/api/v1/videos/").concat(videoId),{method:"GET",headers:myHeaders});videoInfo=await videoInfo.json(),self.duration=Number(videoInfo.duration.toFixed(2)),self.title=videoInfo.name,self.videoId=videoInfo.uuid,self.posterImage="https://"+domain+videoInfo.thumbnailPath;let iframeURL="https://".concat(domain).concat(videoInfo.embedPath,"?api=1&autoplay=0");return iframeURL+="&warningTitle=0&controls=1&peertubeLink=0&p2p=0&muted=0&controlBar=1&title=0",password&&""!==password&&(iframeURL+="&waitPasswordFromEmbedAPI=1"),(0,_jquery.default)("#".concat(node)).replaceWith('<iframe id="'.concat(node,'" src="').concat(iframeURL,'" width="100%" height="100%" allow="autoplay"\n             frameborder="0" allowfullscreen="" sandbox="allow-same-origin allow-scripts allow-popups allow-forms"></iframe>')),player[node]=new _peertube.PeerTubePlayer(document.getElementById(node)),player[node].setVideoPassword(password),await player[node].ready,player[node].addEventListener("playbackStatusUpdate",(status=>{self.currentTime=status.position})),new Promise((resolve=>{resolve({duration:self.duration,title:self.title,posterImage:self.posterImage})}))}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},reloaded=arguments.length>4&&void 0!==arguments[4]&&arguments[4];const showControls=opts.showControls||!1,node=opts.node||"player";this.start=start,this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||((0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked"),(0,_jquery.default)("#video-block, .video-block").remove());const match=url.match(/https:\/\/([^/]+)\/w\/([^/]+)/),domain=match[1];let videoId=match[2].split("?")[0],password=url.split("?password=")[1];const myHeaders=new Headers;password&&""!==password&&myHeaders.append("x-peertube-video-password",password);let videoInfo=await fetch("https://".concat(domain,"/api/v1/videos/").concat(videoId),{method:"GET",headers:myHeaders});if(videoInfo=await videoInfo.json(),"video_requires_password"===videoInfo.code||"incorrect_video_password"===videoInfo.code){let string="video_requires_password"===videoInfo.code?"This video is password protected":"Incorrect password";const pwd=window.prompt(string,"");return null===pwd||(url=url.split("?password=")[0],this.load(url+"?password="+pwd,start,end,opts)),!1}if(!videoInfo.duration)return alert("The video is not available"),!1;let self=this,ready=!1,videoFile=videoInfo.files.pop();if(this.aspectratio=16/9,videoFile){(0,_jquery.default)("<video>").attr("src",videoFile.fileDownloadUrl).attr("preload","metadata").on("loadedmetadata",(function(){self.aspectratio=this.videoWidth/this.videoHeight}))}const totaltime=Number(videoInfo.duration.toFixed(2))-self.frequency;end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start,self.title=videoInfo.name,self.videoId=videoInfo.uuid,self.posterImage="https://"+domain+videoInfo.thumbnailPath;let iframeURL="https://".concat(domain).concat(videoInfo.embedPath,"?api=1&autoplay=1&end=").concat(end,"&start=").concat(start);iframeURL+="&warningTitle=0&controls=".concat(showControls||!self.allowAutoplay?1:0,"&peertubeLink=0&p2p=0&muted=0&controlBar=").concat(showControls?1:0,"&title=0"),password&&""!==password&&(iframeURL+="&waitPasswordFromEmbedAPI=1"),(0,_jquery.default)("#".concat(node)).replaceWith('<iframe id="'.concat(node,'" src="').concat(iframeURL,'" width="100%" height="100%" allow="autoplay"\n             frameborder="0" allowfullscreen="" sandbox="allow-same-origin allow-scripts allow-popups allow-forms"></iframe>')),player[node]=new _peertube.PeerTubePlayer(document.getElementById(node)),player[node].setVideoPassword(password),await player[node].ready,player[node].pause(),player[node].setVolume(0),player[node].seek(start);let captions=await player[node].getCaptions();captions.length>0&&(captions=captions.map((caption=>({label:caption.label,code:caption.id})))),(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:captions,qualities:self.getQualities(),reloaded:reloaded});return player[node].addEventListener("playbackStatusChange",(status=>{ready?"paused"===status?(self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")):"playing"===status&&(self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay")):player[node].setVolume(0)})),player[node].addEventListener("playbackStatusUpdate",(status=>{if(!self.ended)if(ready)(status=>{let currentTime=status.position;switch(self.currentTime=currentTime,status.playbackState){case"playing":self.paused=!1,self.ended=!1,currentTime<self.start&&self.seek(self.start),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),currentTime>=self.end&&(self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"));break;case"ended":self.ended||(self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")),self.paused=!0}})(status);else{player[node].setVolume(0);const goToStart=setInterval((()=>{(status.position>self.start||status.position>=self.end||status.position<=self.start)&&(clearInterval(goToStart),player[node].seek(self.start),player[node].pause(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),player[node].setVolume(1))}),100)}})),player[node].addEventListener("volumeChange",(function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerVolumeChange",{volume:e})})),!0}async getQualities(){if(!player[this.node])return null;let qualities=await player[this.node].getResolutions();return 0!==qualities.length&&{qualities:qualities.map((q=>q.id)),qualitiesLabel:qualities.map((q=>q.label)),currentQuality:qualities.find((q=>q.active)).id}}async setQuality(quality){return player[this.node]?(await player[this.node].setResolution(quality),quality):quality}play(){player[this.node]&&(player[this.node].play(),this.paused=!1)}pause(){return!!player[this.node]&&(player[this.node].pause(),this.paused=!0,!0)}stop(starttime){player[this.node]&&(player[this.node].seek(starttime),player[this.node].pause())}async seek(time){if(!player[this.node])return time;let currentTime=this.getCurrentTime();return(0,_event_dispatcher.dispatchEvent)("iv:playerSeekStart",{time:currentTime}),this.ended=!1,await player[this.node].seek(time),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),!0}getCurrentTime(){return player[this.node]?this.currentTime:0}async getDuration(){return player[this.node]?this.totaltime:0}async isPaused(){return!player[this.node]||this.paused}async isPlaying(){return!!player[this.node]&&!this.paused}isEnded(){return!!player[this.node]&&(!!this.ended||this.currentTime>=this.end)}ratio(){return player[this.node]?this.aspectratio:16/9}destroy(){(0,_jquery.default)("#".concat(this.node)).remove(),player[this.node].removeEventListener(),player[this.node]=null,(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}getState(){return player[this.node]?this.isPaused()?"paused":"playing":"paused"}async setRate(rate){return player[this.node]?(await player[this.node].setPlaybackRate(rate),rate):rate}mute(){player[this.node]&&player[this.node].setVolume(0)}unMute(){player[this.node]&&player[this.node].setVolume(1)}async isMuted(){if(!player[this.node])return!0;return 0===await player[this.node].getVolume()}originalPlayer(){return player[this.node]}async setCaption(track){player[this.node]&&await player[this.node].setCaption(track)}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=peertube.min.js.map