define("tiny_styles/form_preview",["exports","core/modal_factory","core/modal_events"],function(_exports,_modal_factory,_modal_events){function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}
/**
   * Enables a popup preview window in the element creation.
   *
   * @package tiny_styles
   * @author Karri Pajarinen
   * @copyright Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events);_exports.init=()=>{const previewBtn=document.getElementById("btn-preview-element");previewBtn?previewBtn.addEventListener("click",async e=>{e.preventDefault();const nameField=document.getElementById("id_name"),typeField=document.getElementById("id_type"),cssClassesField=document.getElementById("id_cssclasses"),manualConfigField=document.getElementById("id_manualconfig");if(!nameField||!typeField||!cssClassesField)return void console.error("Required form fields not found");const nameVal=nameField.value,typeVal=typeField.value;let cssVal=cssClassesField.value;"Manual style"===cssVal&&manualConfigField&&(cssVal=manualConfigField.value);const isFullCssDefinition=cssVal.includes("{")&&cssVal.includes("}"),previewhtml=((name,cssclasses,type)=>{const snippetBlock="\n        <p>Lorem ipsum <strong>dolor</strong> sit amet, consetetur sadipscing elitr,\n           sed diam nonumy eirmod tempor.</p>\n        <p>Invidunt ut labore et dolore magna aliquyam erat:</p>\n        <ul>\n           <li>Auto</li>\n           <li>Auto</li>\n        </ul>",isFullCssDefinition=cssclasses.includes("{")&&cssclasses.includes("}");let className="";if(isFullCssDefinition){const classMatch=cssclasses.match(/[.][a-zA-Z0-9_-]+/);if(classMatch&&classMatch.length>0&&(className=classMatch[0].substring(1)),className)return"inline"===type?snippetBlock.replace("<strong>dolor</strong>",`<span class="${className}">dolor</span>`):`<div class="${className}">${snippetBlock}</div>`}let attribute=`class="${cssclasses}"`;return cssclasses.includes(":")&&cssclasses.includes(";")&&!isFullCssDefinition&&(attribute=`style="${cssclasses}"`),"inline"===type?snippetBlock.replace("<strong>dolor</strong>",`<span ${attribute}>dolor</span>`):`<div ${attribute}>${snippetBlock}</div>`})(0,cssVal,typeVal);try{const modal=await _modal_factory.default.create({type:_modal_factory.default.types.DEFAULT,title:`Preview "${nameVal}"`,body:previewhtml});if(isFullCssDefinition){const styleEl=document.createElement("style");styleEl.textContent=cssVal;const modalRoot=modal.getRoot();modalRoot&&modalRoot[0]?modalRoot[0].appendChild(styleEl):modalRoot&&modalRoot.appendChild(styleEl)}modal.show();const modalElement=modal.getRoot();modalElement&&modalElement[0]?modalElement[0].addEventListener(_modal_events.default.hidden,()=>{}):modalElement&&modalElement.addEventListener(_modal_events.default.hidden,()=>{})}catch(error){console.error("Failed to create preview modal:",error)}}):console.debug("Preview button not found with ID btn-preview-element")}});

//# sourceMappingURL=form_preview.min.js.map