define("tiny_styles/commands",["exports","editor_tiny/utils","core/ajax","core/str","./common"],function(_exports,_utils,_ajax,_str,_common){var e;
/**
   * Commands for the editor.
   * 
   * @package tiny_styles
   * @author Karri Pajarinen
   * @copyright Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */async function fetchCategories(){const requests=[{methodname:"tiny_styles_fetch_categories",args:{}}];try{const[data]=await _ajax.default.call(requests);return data}catch(err){return[]}}function buildCategoryItems(editor,categories,icons){const items=[];return categories.forEach(cat=>{if("divider"===cat.menumode)return void items.push({type:"separator"});if("inline"===cat.menumode&&Array.isArray(cat.elements))return void cat.elements.forEach(elem=>{items.push({type:"menuitem",text:elem.name,onAction:()=>{applyStyle(editor,{className:elem.cssclasses,block:"block"===elem.type,custom:1===elem.custom,id:elem.name})}})});const subItems=[];if(Array.isArray(cat.elements)&&cat.elements.forEach(elem=>{subItems.push({type:"menuitem",text:elem.name,onAction:()=>{applyStyle(editor,{className:elem.cssclasses,block:"block"===elem.type,custom:1===elem.custom,id:elem.name})}})}),subItems.length>0){let caticon=icons.default;const symbolname=(cat.symbol?cat.symbol:"").replace(".svg","").trim();icons[symbolname]&&(caticon=icons[symbolname]),items.push({type:"nestedmenuitem",icon:caticon,text:cat.name,title:"tooltip",getSubmenuItems:()=>subItems})}}),items.push({type:"separator"}),items.push({type:"menuitem",text:"Clear Styling",icon:icons.remove,onAction:()=>{!function(editor){const selection=editor.selection,selectedNode=selection.getNode();let styledSpanParent=null;styledSpanParent=selectedNode&&"SPAN"===selectedNode.tagName&&isStyledInlineElement(selectedNode)?selectedNode:editor.dom.getParent(selectedNode,function(node){return isStyledInlineElement(node)});if(!styledSpanParent){const range=selection.getRng();if(range&&range.startContainer){const spanParent=editor.dom.getParent(range.startContainer,function(node){return isStyledInlineElement(node)});spanParent&&(styledSpanParent=spanParent)}}if(styledSpanParent){const textContent=styledSpanParent.textContent||styledSpanParent.innerText,textNode=document.createTextNode(textContent);editor.dom.replace(textNode,styledSpanParent);const range=editor.dom.createRng();return range.setStartAfter(textNode),range.setEndAfter(textNode),selection.setRng(range),editor.focus(),!0}const blockParent=editor.dom.getParent(selectedNode,function(node){const isStyled=function(node){if(!node||!node.tagName)return!1;if(!["DIV","P","SECTION","ARTICLE","ASIDE"].includes(node.tagName.toUpperCase()))return!1;if(node.className)return!0;if(node.style&&node.style.getPropertyValue("--custom-style-id"))return!0;if(node.getAttribute&&node.getAttribute("data-mce-style")){if(node.getAttribute("data-mce-style").includes("--custom-style-id"))return!0}return!1}(node);return isStyled});if(blockParent){const innerHTML=blockParent.innerHTML;if(innerHTML.includes("<br><br>")){const parts=innerHTML.split("<br><br>"),firstParagraph=editor.dom.create("p",{},parts[0]);editor.dom.insertAfter(firstParagraph,blockParent);let currentParagraph=firstParagraph;for(let i=1;i<parts.length;i++){const newParagraph=editor.dom.create("p",{},parts[i]);editor.dom.insertAfter(newParagraph,currentParagraph),currentParagraph=newParagraph}editor.dom.remove(blockParent),selection.setCursorLocation(firstParagraph,0)}else{const cleanParagraph=editor.dom.create("p",{},innerHTML);editor.dom.insertAfter(cleanParagraph,blockParent),editor.dom.remove(blockParent),selection.setCursorLocation(cleanParagraph,0)}return editor.focus(),!0}}(editor)}}),items}function applyStyle(editor,styleDef){const{className:className,block:block,custom:custom,id:id}=styleDef;if(!editor.selection.getContent({format:"html"}).trim()&&!block)return;const selectedNode=editor.selection.getNode();if(block)return function(editor,styleDef){const{className:className,custom:custom,id:id}=styleDef,selection=editor.selection,targetBlockTypes=["P","DIV","H1","H2","H3","H4","H5","H6","BLOCKQUOTE","PRE","SECTION","ARTICLE","ASIDE"],targetBlocks=selection.getSelectedBlocks().filter(block=>targetBlockTypes.includes(block.tagName)),textContents=targetBlocks.map(block=>block.innerHTML.trim()).filter(content=>content.length>0);if(textContents.length>0){const combinedContent=textContents.join("<br><br>"),newParagraph=editor.dom.create("p",{},combinedContent);custom?(newParagraph.style.cssText=className,newParagraph.style.setProperty("--custom-style-id",id)):newParagraph.className=className;const firstBlock=targetBlocks[0];editor.dom.insertAfter(newParagraph,firstBlock),targetBlocks.forEach(block=>{editor.dom.remove(block)});const nextParagraph=editor.dom.create("p",{},"");editor.dom.insertAfter(nextParagraph,newParagraph),selection.setCursorLocation(nextParagraph,0)}editor.focus()}(editor,styleDef);const styledSpanParent=editor.dom.getParent(selectedNode,function(node){return isStyledInlineElement(node)});if(styledSpanParent){const spanTextContent=styledSpanParent.textContent||styledSpanParent.innerText,newWrapper=document.createElement("span");custom?(newWrapper.style.cssText=className,newWrapper.style.setProperty("--custom-style-id",id)):newWrapper.className=className,newWrapper.textContent=spanTextContent,editor.dom.replace(newWrapper,styledSpanParent);const spaceNode=document.createTextNode(" ");editor.dom.insertAfter(spaceNode,newWrapper);const range=editor.dom.createRng();return range.setStartAfter(spaceNode),range.setEndAfter(spaceNode),editor.selection.setRng(range),void editor.focus()}const cleanSelectedHtml=editor.selection.getContent({format:"html"});return function(editor,styleDef,selectedHtml){const{className:className,custom:custom,id:id}=styleDef,container=document.createElement("div");container.innerHTML=selectedHtml,Array.from(container.childNodes).forEach(stripText);const newWrapper=document.createElement("span");custom?(newWrapper.style.cssText=className,newWrapper.style.setProperty("--custom-style-id",id)):newWrapper.className=className;for(;container.firstChild;)newWrapper.appendChild(container.firstChild);newWrapper.setAttribute("data-temp-inline-style","true"),editor.selection.setContent(newWrapper.outerHTML+"&nbsp;");const insertedSpan=editor.dom.select('[data-temp-inline-style="true"]')[0];if(insertedSpan){editor.dom.setAttrib(insertedSpan,"data-temp-inline-style",null);const nextNode=insertedSpan.nextSibling;if(nextNode&&nextNode.nodeType===Node.TEXT_NODE){const range=editor.dom.createRng();range.setStart(nextNode,1),range.setEnd(nextNode,1),editor.selection.setRng(range)}}editor.focus()}(editor,styleDef,cleanSelectedHtml)}function isStyledInlineElement(node){if(!node||"SPAN"!==node.tagName)return!1;if(node.className)return!0;if(node.style&&node.style.getPropertyValue("--custom-style-id"))return!0;if(node.getAttribute&&node.getAttribute("data-mce-style")){if(node.getAttribute("data-mce-style").includes("--custom-style-id"))return!0}return!1}function stripText(root){root.nodeType===Node.ELEMENT_NODE&&(root.removeAttribute("class"),root.style&&(root.style.cssText=""),root.removeAttribute("style"),root.removeAttribute("data-mce-style"),Array.from(root.childNodes).forEach(stripText))}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.editCustomStyles=async function(editor){const categoriesResponse=await fetchCategories();let categories=[];Array.isArray(categoriesResponse)?categories=categoriesResponse:categoriesResponse&&Array.isArray(categoriesResponse.categories)&&(categories=categoriesResponse.categories);const customStylesMap={};categories.forEach(cat=>{Array.isArray(cat.elements)&&cat.elements.forEach(elem=>{1===elem.custom&&(customStylesMap[elem.name]=elem)})});editor.getBody().querySelectorAll('[style*="--custom-style-id"]').forEach(element=>{const customStyleId=window.getComputedStyle(element).getPropertyValue("--custom-style-id").trim();if(!customStyleId)return;const styleDefinition=customStylesMap[customStyleId];if(styleDefinition){if(element.style.cssText!==styleDefinition.cssclasses){const newCss=styleDefinition.cssclasses+"; --custom-style-id: "+styleDefinition.name;editor.dom.setAttrib(element,"style",newCss),editor.dom.setAttrib(element,"data-mce-style",newCss)}}else{const minimalCss=`--custom-style-id: ${customStyleId};`;editor.dom.setAttrib(element,"style",minimalCss),editor.dom.setAttrib(element,"data-mce-style",minimalCss)}})},_exports.getSetup=void 0,_ajax=(e=_ajax)&&e.__esModule?e:{default:e};_exports.getSetup=async()=>{const[categories,buttonImage,labelImage,boxImage,defaultImage,mainMenuLabel,previewImage,applyImage,checkImage,graduateImage,laptopImage,magnifyingImage,penImage,schoolImage,squareImage,flagImage,brushImage,infoImage,downloadImage,bookImage,folderImage,removeImage]=await Promise.all([fetchCategories(),(0,_utils.getButtonImage)("icon","tiny_styles"),(0,_utils.getButtonImage)("label","tiny_styles"),(0,_utils.getButtonImage)("box","tiny_styles"),(0,_utils.getButtonImage)("default","tiny_styles"),(0,_str.get_string)("menuitem_styles","tiny_styles"),(0,_utils.getButtonImage)("preview","tiny_styles"),(0,_utils.getButtonImage)("paint","tiny_styles"),(0,_utils.getButtonImage)("check","tiny_styles"),(0,_utils.getButtonImage)("graduate","tiny_styles"),(0,_utils.getButtonImage)("laptop","tiny_styles"),(0,_utils.getButtonImage)("magnify","tiny_styles"),(0,_utils.getButtonImage)("pen","tiny_styles"),(0,_utils.getButtonImage)("school","tiny_styles"),(0,_utils.getButtonImage)("square","tiny_styles"),(0,_utils.getButtonImage)("flag","tiny_styles"),(0,_utils.getButtonImage)("brush","tiny_styles"),(0,_utils.getButtonImage)("info","tiny_styles"),(0,_utils.getButtonImage)("download","tiny_styles"),(0,_utils.getButtonImage)("book","tiny_styles"),(0,_utils.getButtonImage)("folder","tiny_styles"),(0,_utils.getButtonImage)("remove","tiny_styles")]);return editor=>{editor.ui.registry.addIcon(_common.icon,buttonImage.html),editor.ui.registry.addIcon("labelIcon",labelImage.html),editor.ui.registry.addIcon("boxIcon",boxImage.html),editor.ui.registry.addIcon("defaultIcon",defaultImage.html),editor.ui.registry.addIcon("previewIcon",previewImage.html),editor.ui.registry.addIcon("applyIcon",applyImage.html),editor.ui.registry.addIcon("checkIcon",checkImage.html),editor.ui.registry.addIcon("graduateIcon",graduateImage.html),editor.ui.registry.addIcon("laptopIcon",laptopImage.html),editor.ui.registry.addIcon("magnifyingIcon",magnifyingImage.html),editor.ui.registry.addIcon("penIcon",penImage.html),editor.ui.registry.addIcon("schoolIcon",schoolImage.html),editor.ui.registry.addIcon("squareIcon",squareImage.html),editor.ui.registry.addIcon("flagIcon",flagImage.html),editor.ui.registry.addIcon("brushIcon",brushImage.html),editor.ui.registry.addIcon("infoIcon",infoImage.html),editor.ui.registry.addIcon("downloadIcon",downloadImage.html),editor.ui.registry.addIcon("bookIcon",bookImage.html),editor.ui.registry.addIcon("folderIcon",folderImage.html),editor.ui.registry.addIcon("removeIcon",removeImage.html);const icons={label:"labelIcon",box:"boxIcon",default:"defaultIcon",preview:"previewIcon",paint:"applyIcon",check:"checkIcon",graduate:"graduateIcon",laptop:"laptopIcon",magnify:"magnifyingIcon",pen:"penIcon",school:"schoolIcon",square:"squareIcon",flag:"flagIcon",brush:"brushIcon",info:"infoIcon",download:"downloadIcon",book:"bookIcon",folder:"folderIcon",remove:"removeIcon"};editor.ui.registry.addMenuButton("tiny_styles_button",{icon:_common.icon,tooltip:mainMenuLabel,fetch:callback=>{callback(buildCategoryItems(editor,categories,icons))}}),editor.ui.registry.addNestedMenuItem("tiny_styles_nestedmenu",{icon:_common.icon,text:mainMenuLabel,getSubmenuItems:()=>buildCategoryItems(editor,categories,icons)})}}});

//# sourceMappingURL=commands.min.js.map