<?php
// This file is part of VPL for Moodle - http://vpl.dis.ulpgc.es/
//
// VPL for Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// VPL for Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VPL for Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @var array $string
 */
$string['vpl'] = 'Virtual Programming Lab';
$string['novpls'] = 'Kein virtual programming lab definiert';
$string['moduleconfigtitle'] = 'VPL Module Konfiguration';
$string['modulename'] = 'Virtual programming lab';
$string['pluginname'] = 'Virtual programming lab';
$string['modulenameplural'] = 'Virtual programming labs';
$string['pluginadministration'] = 'VPL Administration';
$string['shortdescription'] = 'Kurzbeschreibung';
$string['fulldescription'] = 'Beschreibung';
$string['submissionperiod'] = 'Abgabezeitraum';
$string['startdate'] = 'Verfügbar von';
$string['duedate'] = 'Abgabetermin';
$string['averageperiods'] = 'Durchschn. Überarbeitungen {$a}';
$string['averagetime'] = 'Durchschnittszeit {$a}';
$string['maximumperiod'] = 'Max. Überarbeitungen {$a}';
$string['workingperiods'] = 'Arbeitszeiten';
$string['submissionrestrictions'] = 'Abgabeeinschränkungen';
$string['maxfiles'] = 'Maximale Anzahl an Dateien';
$string['maxfilesexceeded'] = 'Maximale Anzahl an Dateien überschritten';
$string['maxfilesize'] = 'Maximale Upload Dateigröße';
$string['defaultfilesize'] = 'Standard maximale Upload Dateigröße';
$string['maxfilesizeexceeded'] = 'Maximale Dateigröße überschritten';
$string['requirednet'] = 'Erlaubte Online-Abgabe';
$string['gradeoptions'] = 'Benotungseinstellungen';
$string['visiblegrade'] = 'Sichtbar';
$string['nojailavailable'] = 'Kein Jail-Server verfügbar';
$string['noright'] = 'Keine ausreichenden Zugriffsberechtigungen';
$string['requestedfiles'] = 'Erforderliche Dateien';
$string['execution'] = 'Ausführung';
$string['editing'] = 'Bearbeiten';
$string['basic'] = 'Einfach';
$string['advanced'] = 'Erweitert';
$string['comments'] = 'Kommentare';
$string['compilation'] = 'Kompilierung';
$string['anyfile'] = 'Beliebige Datei';
$string['submission'] = 'Abgabe';
$string['nsubmissions'] = '{$a} abgaben';
$string['submissions'] = 'Abgaben';
$string['submittedon'] = 'Abgegeben am';
$string['submittedonp'] = 'Abgegeben am {$a}';
$string['submittedby'] = 'Abgegeben von {$a}';

$string['gradercomments'] = 'Kommentare zur Bewertung';
$string['automaticgrading'] = 'Automatische Bewertung';
$string['open'] = 'Offen';
$string['closed'] = 'Geschlossen';
$string['timelimited'] = 'Zeitlich begrenzt';
$string['timeunlimited'] = 'Zeitlich unbegrenzt';
$string['manualgrading'] = 'Manuelle Bewertung';

$string['automaticevaluation'] = 'Automatische Evaluierung';
$string['submissionslist'] = 'Abgabeliste';
$string['previoussubmissionslist'] = 'Vorige Abgabeliste';
$string['description'] = 'Beschreibung';
$string['download'] = 'Herunterladen';
$string['edit'] = 'Bearbeiten';
$string['submissionview'] = 'Abgabesicht';
$string['nosubmission'] = 'Keine Abgabe verfügbar';
$string['notexecuted'] = 'Nicht ausgeführt';
$string['addfile'] = 'Datei hinzufügen';
$string['uploadfile'] = 'Datei hochladen';
$string['save'] = 'Speichern';
$string['saved'] = 'Gespeichert';
$string['savedfile'] = "Die Datei '{\$a}' wurde gespeichert";
$string['saveoptions'] = 'Einstellungen speichern';
$string['optionssaved'] = 'Einstellungen wurden gespeichert';
$string['optionsnotsaved'] = 'Einstellungen wurden nicht gespeichert';
$string['savecontinue'] = 'Speichern und fortfahren';
$string['changesNotSaved'] = 'Änderungen wurden nicht gespeichert';
$string['fileNotChanged'] = 'Datei ist unverändert';
$string['filesNotChanged'] = 'Dateien sind unverändert';
$string['filesChangedNotSaved'] = 'Dateien sind verändert aber sie wurden nicht gespeichert';
$string['menuexecutionfiles'] = 'Ausführungsdateien';
$string['executionfiles'] = 'Ausführungsdateien';
$string['filerenamed'] = "Die Datei '{\$a->from}' wurde auf '{\$a->to}' umbenannt";
$string['filenotrenamed'] = 'Die Datei \'{$a}\' wurde NICHT umbenannt';
$string['filedeleted'] = "Die Datei '{\$a}' wurde gelöscht";
$string['filenotdeleted'] = 'Die Datei \'{$a}\' wurde NICHT gelöscht';
$string['fileadded'] = "Die Datei '{\$a}' wurde hinzugefügt";
$string['fileupdated'] = "Die Datei '{\$a}' wurde aktualisiert";
$string['filenotadded'] = 'Datei wurde nicht hinzugefügt';
$string['fullscreen'] = 'Vollbildmodus';
$string['regularscreen'] = 'Fenstermodus';
$string['resetfiles'] = 'Dateien zurücksetzen';
$string['sureresetfiles'] = 'Wollen Sie Ihre Änderungen wirklich verwerfen?';
$string['test'] = 'Testaktivität';
$string['testcases'] = 'Testfälle';
$string['datesubmitted'] = 'Abgabedatum';
$string['restrictededitor'] = 'Abgabe durch eingeschränkten Code Editor';
$string['isexample'] = 'Dies ist eine Beispielaktivität';
$string['examples'] = 'Beispiele';
$string['gradedonby'] = 'Bewertet am {$a->date} von {$a->gradername}';
$string['grader'] = "Bewerter";
$string['gradedon'] = "Bewertet am";
$string['run'] = 'Ausführen';
$string['debug'] = 'Debuggen';
$string['evaluate'] = 'Evaluieren';
$string['evaluation'] = 'Evaluierung';
$string['evaluateonsubmission'] = 'Nur bei Abgabe evaluieren';
$string['basedon'] = 'basiert auf';
$string['maxexetime'] = 'Maximale Ausführungszeit';
$string['defaultexetime'] = 'Standard maximale Ausführungszeit';
$string['maxexememory'] = 'Maximaler Speicherbedarf';
$string['defaultexememory'] = 'Standard maximaler Speicherbedarf';
$string['maxexefilesize'] = 'Maximale Größe der Ausführungsdatei';
$string['defaultexefilesize'] = 'Standard maximale Größe der Ausführungsdatei';
$string['maxexeprocesses'] = 'Maximale Anzahl an Prozessen';
$string['defaultexeprocesses'] = 'Standard maximale Anzahl an Prozessen';
$string['executionoptions'] = 'Ausführungsoptionen';
$string['menuexecutionoptions'] = 'Optionen';
$string['maxresourcelimits'] = 'Maximaler Ressourcenverbrauch bei Ausführung';
$string['defaultresourcelimits'] = 'Standard maximaler Ressourcenverbrauch bei Ausführung';
$string['resourcelimits'] = 'Ressourcenbeschränkungen';
$string['menuresourcelimits'] = 'Ressourcenbeschränkungen';
$string['keepfiles'] = 'Dateien, die beim Ausführen behalten werden';
$string['menukeepfiles'] = 'Zu behaltene Dateien';
$string['submissionselection'] = 'Abgabeauswahl';
$string['instanceselection'] = 'VPL Auswahl';
$string['graded'] = 'Bewertet';
$string['notgraded'] = 'Nicht bewertet';
$string['allsubmissions'] = 'Alle Abgaben';
$string['gradedbyuser'] = 'Bewertet durch Benutzer';
$string['variation_n'] = 'Variation {$a}';
$string['variation_n_i'] = 'Variation {$a->number}: {$a->identification}';
$string['variations'] = 'Variationen';
$string['usevariations'] = 'Verwende Variationen';
$string['variationtitle'] = 'Variationsname';
$string['varidentification'] = 'Identifikation';
$string['variation_options'] = 'Variationsoptionen';
$string['variations_unused'] = 'Diese Aktivität hat Variationen, die deaktiviert sind';
$string['deleteallsubmissions'] = 'Alle Abgaben löschen';
$string['maxsimilarityoutput'] = 'Maximale Ausgabe durch Ähnlichkeit';
$string['resetvpl'] = '{$a} zurücksetzen';
$string['numcluster'] = 'Gruppe {$a}';
$string['inconsistentgroup'] = 'Sie sind nicht Mitglied nur einer Gruppe (0 o >1)';
$string['worktype'] = 'Arbeitstyp';
$string['individualwork'] = 'Einzelarbeit';
$string['groupwork'] = 'Gruppenarbeit';
$string['downloadsubmissions'] = 'Alle Abgaben herunterladen';

$string['similarity'] = 'Ähnlichkeit';
$string['listwatermarks'] = 'Wasserzeichen-Liste';
$string['nowatermark'] = 'Eigene Wasserzeichen {$a}';
$string['origin'] = 'Ursprung';
$string['filestoscan'] = 'Zu prüfende Dateien';
$string['scanoptions'] = 'Prüfeinstellungen';
$string['allfiles'] = 'Alle Dateien';
$string['joinedfiles'] = 'Zusammengefügte ausgewählte Dateien';
$string['minsimlevel'] = 'Minimale angezeigte Ähnlichkeit';
$string['othersources'] = 'Andere zu prüfende Quellen';
$string['scanactivity'] = 'Aktivität';
$string['scanzipfile'] = 'Zip-Datei';
$string['scandirectory'] = 'Ordner';
$string['scanother'] = 'Prüfe Ähnlichkeit in hinzugefügten Quellen';
$string['listsimilarity'] = 'Liste der gefundenen Ähnlichkeiten';
$string['similarto'] = 'Ähnlich wie';
$string['diff'] = 'diff';
$string['scanningdir'] = 'Prüfe Ordner ...';
$string['unzipping'] = 'Entpacke ...';

$string['requiredpassword'] = 'Ein Passwort wird benötigt';
$string['attemptnumber'] = 'Versuch Nummer {$a}';
$string['opnotallowfromclient'] = 'Aktion ist von diesem Rechner nicht erlaubt';
$string['listofcomments'] = 'Kommentarliste';
$string['removegrade'] = 'Bewertung löschen';
$string['graderemoved'] = 'Die Bewertung wurde gelöscht';
$string['gradenotremoved'] = 'Die Bewertung wurde NICHT gelöscht. Überprüfen Sie die Aktivitätskonfiguration in der Bewertungsverwaltung.';
$string['gradenotsaved'] = 'Die Bewertung wurde NICHT gespeichert. Überprüfen Sie die Aktivitätskonfiguration in der Bewertungsverwaltung.';
$string['calculate'] = 'Berechnen';
$string['gradeandnext'] = 'Bewerten & nächstes';

$string['vpl_run.sh'] = 'Dieses Skript bereitet das abgegebene Programm zur Ausführung vor';
$string['vpl_debug.sh'] = 'Dieses Skript bereitet das abgegebene Programm zum Debuggen vor';
$string['vpl_evaluate.sh'] = 'Dieses Skript evaluiert das abgegebene Programm';
$string['vpl_evaluate.cases'] = 'Hier werden die Testfälle zur Evaluierung des abgegebenen Programms angegeben';
$string['VPL_COMPILATIONFAILED'] = 'Die Kompilierung oder Vorbereitung zur Ausführung ist fehlgeschlagen';
$string['jail_servers_config'] = 'Jail-Server Konfiguration';
$string['jail_servers'] = 'Jail-Server Liste';
$string['local_jail_servers'] = 'Lokale Jail-Server';
$string['menulocal_jail_servers'] = 'Lokale Jail-Server';
$string['check_jail_servers'] = 'Jail-Server überprüfen';
$string['menucheck_jail_servers'] = 'Jail-Server überprüfen';
$string['jail_servers_description'] = 'Jeder Server in eine eigene Zeile';
$string['server'] = 'Server';
$string['currentstatus'] = 'Aktueller Status';
$string['lasterror'] = 'Letzte Fehlerbeschreibung';
$string['lasterrordate'] = 'Letzter Fehlerzeitpunkt';
$string['totalnumberoferrors'] = "Fehler";

$string['proposedgrade'] = 'Bewertungsvorschlag: {$a}';
$string['discard_submission_period'] = 'Abgabenspeicherungsperiode';
$string['discard_submission_period_description'] = 'Pro Student und Aufgabe behält das System immer die letzte Abgabe sowie zumindest eine für jede Periode.';
$string['direct_applet'] = 'Direktes Applet Deployment';
$string['direct_applet_description'] = 'Verwende HTML tags, um das Applet zu deployen. Diese Option wird benötigt, wenn Clients keinen Zugriff auf www.java.com haben.';

$string['serverexecutionerror'] = 'Server Ausführungsfehler';

$string['vpl:addinstance'] = 'Neue VPL Instanzen hinzufügen';
$string['vpl:view'] = 'Komplette VPL Aufgabenbeschreibung anzeigen';
$string['vpl:submit'] = 'VPL Aufgabe abgeben';
$string['vpl:grade'] = 'VPL Aufgabe bewerten';
$string['vpl:manage'] = 'VPL Aufgabe verwalten';
$string['vpl:similarity'] = 'VPL Aufgaben Ähnlichkeit prüfen';
$string['vpl:setjails'] = 'Jail-Server speziellen VPL Instanzen zuweisen';

// Code Editor.
$string['previous_page'] = 'Vorige Seite';
$string['return_to_previous_page'] = 'Züruck zur vorigen Seite';
$string['next_page'] = 'Nächste Seite';
$string['go_next_page'] = 'Weiter zur nächsten Seite';
$string['help'] = 'Hilfe';
$string['contextual_help'] = 'Kontextuelle Hilfe';
$string['general_help'] = 'Allgemeine Hilfe zur Sprache';
$string['file'] = 'Datei';
$string['options'] = 'Optionen';
$string['new'] = 'Neu';
$string['create_new_file'] = 'Neue Datei erstellen';
$string['file_name'] = 'Dateiname';
$string['incorrect_file_name'] = 'Falscher Dateiname';
$string['rename'] = 'Umbenennen';
$string['renameFile'] = 'Datei umbenennen';
$string['new_file_name'] = 'Neuer Dateiname';
$string['delete'] = 'Löschen';
$string['delete_file'] = 'Datei löschen';
$string['delete_file_q'] = 'Datei wirklich löschen?';
$string['delete_file_fq'] = "Datei '{\$a}' löschen?";
$string['save'] = 'Speichern';
$string['undo'] = 'Rückgängung';
$string['undo_change'] = 'Änderung rückgängig machen';
$string['redo'] = 'Wiederholen';
$string['redo_undone'] = 'Änderungen wiederherstellen';
$string['cut'] = 'Ausschneiden';
$string['cut_text'] = 'Ausgewählten Text in die Zwischenablage verschieben';
$string['copy'] = 'Kopieren';
$string['copy_text'] = 'Ausgewählten Text in die Zwischenablage kopieren';
$string['paste'] = 'Einfügen';
$string['paste_text'] = 'Text aus der Zwischenablage einfügen';
$string['select_all'] = 'Alles markieren';
$string['select_all_text'] = 'Gesamten Text markieren';
$string['find_replace'] = 'Suchen/Ersetzen';
$string['find_find_replace'] = 'Suchen oder suchen und ersetzen';
$string['program_help'] = 'Programmhilfe';
$string['page_unaccessible'] = 'Unerreichbare Seite';
$string['about'] = 'Über';
$string['help_about'] = 'Hilfe über';
$string['figure'] = 'Abbildung';
$string['line_number'] = 'Zeilennummer';
$string['toggle_show_line_number'] = 'Zeilennummern anzeigen';
$string['next'] = 'Weiter';
$string['find_next_search_string'] = 'Finde den nächsten Suchtext im Text';
$string['replace'] = 'Ersetzen';
$string['replace_selection_if_match'] = 'Ersetze Auswahl, wenn sie dem Suchtext entspricht';
$string['replace_find'] = 'Ersetzen/Finden';
$string['replace_find_next'] = 'Ersetzen und den nächsten Suchtext finden';
$string['replace_all'] = 'Alle ersetzen';
$string['replace_all_next'] = 'Alle weiteren ersetzen';
$string['language_help'] = 'Sprachenspezifische Hilfe';
$string['console'] = 'Konsole';
$string['find'] = 'Finden';
$string['case_sensitive'] = 'Groß-/Kleinschreibung beachten';
$string['replace_find'] = 'Ersetzen/Finden';
$string['font_size'] = 'Schriftgröße';
$string['connecting'] = 'Verbinde';
$string['connection_fail'] = 'Verbindungsfehler';
$string['connected'] = 'Verbunden';
$string['connection_closed'] = 'Verbindung geschlossen';

// Edit status.
$string['notsaved'] = 'Nicht gespeichert';
$string['saving'] = 'Speichert';
$string['running'] = 'Läuft';
$string['evaluating'] = 'Evaluiert';
$string['debugging'] = 'Debuggt';
$string['check_jail_servers_help'] = '<p>Diese Seite überprüft und zeigt den Status der Jail-Server,
        die für diese Aktivität verwendet werden.</p>';
$string['executionfiles_help'] = '<h2>Einleitung</h2>
<p>Hier definiert man die Dateien, die für die Vorbereitung der Ausführung, des Debuggens oder der Bewertung einer Abgabe benötigt werden. Dazu zählen unter anderem Skripts, Test-Dateien oder Daten.</p>
<h2>Standard Skript zum Ausführen oder Debuggen</h2>
<p>Wenn kein Skript zum Ausführen oder Debuggen von Abgaben angegeben wird, verwendet das System automatisch ein Standardskript für die verwendete Sprache (abhängig von der angegebenen Dateiendung). Die folgende Tabelle zeigt die unterstützten Programmiersprachen mit den zugehörigen Dateiendungen und den verwendeten compiler/interpreter/debugger, der im Skript verwendet wird.</p>
<table>
<tr><th>Sprache</th>
<th>Dateiname<br />
Endung</th>
<th>ausführen</th>
<th>debuggen</th>
<th>Compiler/<br />interpreter</th>
<th>Kommentar</th>
</tr>
<tr>
<td>Ada</td><td>ada, adb, ads</td><td>X</td><td>X</td><td>gnat (Ada 2005)/gdb</td><td>Erste Datei wird als main verwendet</td>
</tr>
<tr>
<td>C</td><td>c</td><td>X</td><td>X</td><td>gcc C99/gdb</td><td>Alle Quelldateien werden kompiliert</td>
</tr>
<tr>
<td>C++</td><td>cpp, C</td><td>X</td><td>X</td><td>g++/gdb</td><td>Alle Quelldateien werden kompiliert</td>
</tr>
<tr>
<td>C#</td><td>cs</td><td>X</td><td>X</td><td>gmcs+mono/mdb</td><td>Alle Quelldateien werden kompiliert</td>
</tr>
<tr>
<td>Fortran</td><td>f, f77</td><td>X</td><td>X</td><td>gfortran/gdb</td><td>Alle Quelldateien werden kompiliert</td>
</tr>
<tr>
<td>Haskell</td><td>hs</td><td>X</td><td></td><td>hugs</td><td>Erste Datei wird ausgeführt</td>
</tr>
<tr>
<td>Java</td><td>java</td><td>X</td><td>X</td><td>javac+java/jdb</td><td>Alle Quelldateien werden kompiliert<br />main-Klasse wird automatisch gefunden</td>
</tr>
<tr>
<td>Matlab/Octave</td><td>m</td><td>X</td><td>-</td><td>matlab, octave</td><td>Erste Datei wird ausgeführt<br>Verwende vpl_replot nach dem Zeichnen.</td>
</tr>
<tr>
<td>Pascal</td><td>pas, p</td><td>X</td><td>X</td><td>fpc or gpc/gdb</td><td>Erste Datei wird kompiliert (fpc) oder alle Dateien (gpc)</td>
</tr>
<tr>
<td>Perl</td><td>perl, prl</td><td>X</td><td>X</td><td>perl</td><td>Erste Datei wird ausgeführt</td>
</tr>
<tr>
<td>PHP</td><td>php</td><td>X</td><td>-</td><td>php5</td><td>Erste Datei wird ausgeführt</td>
</tr>
<tr>
<td>Prolog</td><td>pl, pro</td><td>X</td><td>-</td><td>swipl</td><td>Erste Datei wird ausgeführt</td>
</tr>
<tr>
<td>Python</td><td>py</td><td>X</td><td>X</td><td>python</td><td>Erste Datei wird ausgeführt</td>
</tr>
<tr>
<td>Ruby</td><td>rb</td><td>X</td><td>X</td><td>ruby</td><td>Erste Datei wird ausgeführt</td>
</tr>
<tr>
<td>Scheme</td><td>scm, s</td><td>X</td><td>-</td><td>mzscheme</td><td>Erste Datei wird ausgeführt</td>
</tr>
<tr>
<td>Shell script</td><td>sh</td><td>X</td><td>-</td><td>bash</td><td>Erste Datei wird ausgeführt</td>
</tr>
<tr>
<td>SQL</td><td>sql</td><td>X</td><td>-</td><td>sqlite3</td><td>Alle Dateien werden ausgeführt<br />Ausführungsdateien zuerst</td>
</tr>
<tr>
<td>VHDL</td><td>vhd, vhdl</td><td>X</td><td>-</td><td>ghdl</td><td>Alle Dateien werden kompiliert; die erste Datei muss die Main-Methode definieren</td>
</tr>
</table>
<h2>Automatische Evaluierung</h2>
<p>Seit VPL 1.4 gibt es eine Funktion, um Abgaben automatisch zu bewerten. Diese Funktion führt ein abgegebenes Programm aus und vergleicht die Ausgabe zu einer vorgegebenen Eingabe. Diese Testfälle müssen in der Datei &quot;vpl_evaluate.cases&quot; definiert werden.</p>
<p>Die Datei &quot;vpl_evaluate.cases&quot; ist folgendermaßen aufgebaut:
<ul>
<li> &quot;<strong>case </strong>= Beschreibung des Testfalls&quot;: Optional. Definiert den Start eines Anwendungsfalls.</li>
<li> &quot;<strong>input </strong>= text&quot;: kann mehrere Zeilen umfassen und wird mit der nächsten Instruktion abgeschlossen.</li>
<li> &quot;<strong>output </strong>= text&quot;: kann mehrere Zeilen umfassen und wird mit der nächsten Instruktion abgeschlossen. Ein Testfall kann mehrere richtige Ausgaben haben. Dazu gibt es drei verschiedene Arten: Zahlen, Text und exakter Text:
<ul>
<li> <strong>number</strong>: definiert als eine Folge von Zahlen (ganze und fließkomma). Es werden in der Ausgabe nur Zahlen beachten und anderer Text ignoriert. Fließkommazahlen besitzen eine gewisse Toleranz.</li>
<li> <strong>text</strong>: definiert als ein Text ohne Anführungszeichen. Es werden in der Ausgabe nur Wörter beachtet und die restlichen Zeichen ignoriert. Groß- und Kleinschreibung wird auch ignoriert.</li>
<li> <strong>exact text</strong>: definiert als ein Text mit Anführungszeichen. Jedes Zeichen der Ausgabe muss übereinstimmen.</li>
</ul>
</li>
<li> &quot;<strong>grade reduction</strong> = [Wert|Prozentsatz%]&quot; : Standardmäßig reduziert ein fehlgeschlagener Testfall die Punkte der Abgabe anteilsmäßig (Gesamtpunkte/Anzahl der Testfälle). Diese Anweisung ändert jedoch den Punkteabzug.</li>
</ul>
</p>
<h2>Allgemeine Verwendung</h2>
<p>Eine neue Datei kann hinzugefügt werden, indem man ihren Namen in das Eingabefeld unter &quot;<b>Datei hinzufügen</b>&quot; schreibt, und auf die Schaltfläche &quot;<b>Datei hinzufügen</b>&quot; klickt.</p>
<p>Eine existierende Datei kann hochgeladen werden, indem man auf &quot;<b>Datei hochladen </b>&quot; klickt.</p>
<p>Alle hinzugefügten oder hochgeladenen Dateien können geändert werden und alle, außer den drei unten genannten Skripts können umbenannt oder gelöscht werden.</p>
<h2>Manuelle Ausführung, Debugging oder Evaluierung</h2>
<p>Es können drei Skripts zur Vorbereitung jeder dieser Aktionen definiert werden. Diese Skripts besitzen vordefinierte Namen: <b>vpl_run.sh</b> (Ausführung),
<b>vpl_debug.sh</b>  (Debugging) and <b>vpl_evaluate.sh</b> (Evaluierung).</p>
<p>Die Ausführung eines dieser Skripts soll eine Datei namens <b>vpl_execution</b> generieren. Diese Datei muss eine ausführbare Binärdatei sein oder ein Skript, das mit &quot;#!/bin/sh &quot; beginnt. Wenn diese Datei nicht erstellt wird, kann die Aktion nicht weiter ausgeführt werden.</p>
<p>Wenn die konfigurierte Aktivität auf einer anderen Aktivität basiert, werden die referenzierten Basisdateien automatisch hinzugefügt.</p>
<p>Schließlich wird die Datei <b>vpl_environment.sh</b> automatisch hinzugefügt. Dieses Skript beinhaltet Informationen über die Abgabe und bietet diese als Umgebungsvariablen an:</p>
<ul> <li> LANG:  verwendete Sprache. </li>
<li> LC_ALL: gleicher Wert wie LANG. </li>
<li> VPL_MAXTIME: maximale Ausführungszeit in Sekunden. </li>
<li> VPL_FILEBASEURL: URL, um auf die Dateien des Kurses zuzugreifen to access the files of the course. </li>
<li> VPL_SUBFILE#: jeder Name von Dateien der Abgabe. Das #-Symbol stellt Zahlen zwischen 0 und der Anzahl der abgegebenen Dateien. </li>
<li> VPL_SUBFILES: Liste aller abgegebenen Dateien. </li>
<li> VPL_VARIATION + id: wobei die id die Variationsreihenfolge angibt und mit 0 anfängt und der Variablenwert den Wert der Variation angibt.</li>
</ul>
Wenn die Aktion Evaluierung ausgeführt wird, werden die folgenden Variablen auch hinzugefügt.
<ul>
	<li>VPL_MAXTIME: maximale Ausführungszeit in Sekunden.</li>
	<li>VPL_MAXMEMORY: maximale Hauptspeicherverwendung</li>
	<li>VPL_MAXFILESIZE: maximale Dateigröße in byte, die erstellt werden kann.</li>
	<li>VPL_MAXPROCESSES: maximale Anzahl an Prozessen, die gleichzeitig ausgeführt werden.</li>
	<Li>VPL_FILEBASEURL: URL zu den Kursdateien.</Li>
	<li>VPL_GRADEMIN: Minimale Bewertung für diese Aktivität</li>
	<li>VPL_GRADEMAX: Maximale Bewertung für diese Aktivität</li>
</ul>
<h2>Bewertungsergebnis</h2>
<p>Die Evaluierungsausgabe wird verarbeitet, um Kommentare und eine vorgeschlagene Bewertung für die Aufgabe zu erhalten. Kommentare können über zwei Arten hinzugefügt werden: mit einem Zeilenkommentar, das mit \'Comment :=&gt;&gt;\' beginnt oder mit einem Blockkommentar, das mit der Zeile \'&lt;|--\' beginnt und mit der Zeile \'--|&gt;\' endet. Die Bewertung wird von der letzten Zeile die mit \'Grade :=&gt;&gt;\' beginnt genommen.</p>';
$string['executionoptions_help'] = '<p>Auf dieser Seite können verschiedene Ausführungsoptionen konfiguriert werden.</p>
<ul>
<li><b>Basiert auf</b>: selektiert eine andere VPL Instanz, von der einige Eigenschaften importiert werden:
<ul><li>Ausführungsdateien (Vordefinierte Skripts werden zusammengefügt)</li>
<li>Grenzen für die Ausführungsressourcen.</li>
<li>Variationen, die zusammengefügt werden, um Multivariationen zu erzeugen.</li>
<li>Maximale Größe jeder Datei, die mit der Abgabe hochgeladen wurde.</li>
</ul>
</li>
<li><b>Ausführen</b>, <b>Debuggen</b> and <b>Evalauieren</b>: Muss auf &quot;Ja&quot; gesetzt werden wenn die jeweilige Aktion beim bearbeiten der Abgabe für Studenten auswählbar sein soll.</li>
<li><b>Nur bei Abgabe evaluieren</b>: Die Abgabe wird automatisch evaluiert, sobald sie hochgeladen wird.</li>
<li><b>Automatische Bewertung</b>: Wenn das Evaluierungsergebnis Bewertungen enthält, werden diese automatisch als Bewertung für die Abgabe angewandt.</li>
</ul>';
$string['fulldescription_help'] = '<p>Hier wird die komplette Beschreibung für diese Aktivität eingetragen.</p>
<p>Wenn hier nichts angegeben wird, wird stattdessen die Kurzbeschreibung angezeigt.</p>
<p>Wenn automatisch evaluiert werden soll, müssen die Interfacebeschreibungen für die Aufgabenstellungen detailliert und eindeutig sein.</p>';
$string['keepfiles_help'] = '<p>Aufgrund von Sicherheitsrisiken werden Dateien, die als &quot;Ausführungsdateien&quot; hinzugefügt wurden,
gelöscht bevor das Skript vpl_execution ausgeführt wird.</p>
Falls einige dieser Dateien während der Ausführung benötigt werden (zum Beispiel als Testdaten) müssen sie hier markiert werden.';
$string['local_jail_servers_help'] = '<p>Hier können die lokalen Jail-Server für diese Aktivität definiert werden.</p>
<p>Jede Zeile beinhaltet die komplette URL eines Servers. Leere Zeilen und Kommentare die mit &quot;#&quot; starten können verwendet werden.</p>
<p>Diese Aktivität wird als Jail-Server Liste verwenden: die Server, die hier gesetzt werden plus die Server der Aktivität auf der diese Aktivität
basiert plus die allgemeinen Jail-Server. Wenn diese Aktivität und jene, die auf dieser Aktivität basieren, keine anderen Jail-Server benutzen sollen, kann man am Ende die Zeile &quot;end_of_jails&quot; anfügen.</p>';
$string['modulename_help'] = '<p>VPL ist ein Aktivitätsmodul für Moodle, das Programmieraufgaben verwaltet und folgende Eigenschaften aufweist:
</p>
<ul>
<li>Möglichkeit, den Programmcode im Browser</li>
<li>Studenten können Programme interaktiv im Browser ausführen</li>
<li>Automatische Tests zur Bewertung von Programmen können ausgeführt werden</li>
<li>Möglichkeit, Ähnlichkeiten zwischen Dateien zu suchen</li>
<li>Möglichkeit, Änderungseinschränkungen und externe Einfügeoptionen zu konfigurieren</li>
</ul>
<p><a href="http://vpl.dis.ulpgc.es">Virtual Programming lab</a></p>';
$string['modulename_link'] = 'mod/vpl/view';
$string['requestedfiles_help'] = '<p>Hier können Namen für die erforderlichen Dateien gesetzt werden.</p>
<p>Wenn nicht für alle erforderlichen Dateien Namen gesetzt werden sind die unbenannten Dateien optionen und können beliebige Namen erhalten.</p>
<p>Man kann zusätzlich bereits Inhalte für die erforderlichen Dateien erzeugen, die beim ersten Öffnen mit dem Editor sichtbar werden, wenn noch keine andere Abgabe vorhanden ist.</p>';
$string['resourcelimits_help'] = '<p>Grenzen für das Maximum können für die Ausführungszeit, den benutzten Arbeitsspeicher, die Ausführungsdateigrößen und die Anzahl der gleichzeitigen Prozesse gesetzt werden.</p>
<p>Diese Grenzen werden verwendet, wenn die Skripts vpl_run.sh, vpl_debug.sh, vpl_evaluate.sh und vpl_execution ausgeführt werden.</p>
<p>Wenn diese Aktivität auf einer anderen Aktivität basiert können diese Grenzen von denen der Basisaktivität und der globalen Konfiguration beeinflusst werden.</p>';
$string['testcases_help'] = '<p>Dieses Feature erlaubt es, Studentenprogramme auszuführen und die Ausgabe für eine gegebene Eingabe zu überprüfen. Um die Testfälle zu konfigurieren, muss die Datei &quot;vpl_evaluate.cases&quot; befüllt werden.</p>
<p>Die Datei &quot;vpl_evaluate.cases&quot; ist folgendermaßen aufgebaut:
<ul>
<li> &quot;<strong>case </strong>= Beschreibung des Testfalls&quot;: Optional. Definiert den Start eines Anwendungsfalls.</li>
<li> &quot;<strong>input </strong>= text&quot;: kann mehrere Zeilen umfassen und wird mit der nächsten Instruktion abgeschlossen.</li>
<li> &quot;<strong>output </strong>= text&quot;: kann mehrere Zeilen umfassen und wird mit der nächsten Instruktion abgeschlossen. Ein Testfall kann mehrere richtige Ausgaben haben. Dazu gibt es drei verschiedene Arten: Zahlen, Text und exakter Text:
<ul>
<li> <strong>number</strong>: definiert als eine Folge von Zahlen (ganze und fließkomma). Es werden in der Ausgabe nur Zahlen beachten und anderer Text ignoriert. Fließkommazahlen besitzen eine gewisse Toleranz.</li>
<li> <strong>text</strong>: definiert als ein Text ohne Anführungszeichen. Es werden in der Ausgabe nur Wörter beachtet und die restlichen Zeichen ignoriert. Groß- und Kleinschreibung wird auch ignoriert.</li>
<li> <strong>exact text</strong>: definiert als ein Text mit Anführungszeichen. Jedes Zeichen der Ausgabe muss übereinstimmen.</li>
</ul>
</li>
<li> &quot;<strong>grade reduction</strong> = [Wert|Prozentsatz%]&quot; : Standardmäßig reduziert ein fehlgeschlagener Testfall die Punkte der Abgabe anteilsmäßig (Gesamtpunkte/Anzahl der Testfälle). Diese Anweisung ändert jedoch den Punkteabzug.</li>
</ul>
</p>';
$string['variations_help'] = '<p>Eine Menge von Variationen können für eine Aktivität definiert werden, die dann zufällig Studenten zugewiesen werden.</p>
<p>Hier kann festgelegt werden, ob diese Aktivität Variationen hat und welche Bezeichnung die Menge trägt und es können die Variationen selbst hinzugefügt werden.</p>
<p>Jede Variation hat eine Identifizierungsnummer und eine Beschreibung. Die Identifizierungsnummer wird von der Datei <b>vpl_enviroment.sh</b> benutzt, um die Variation
jedes Studenten an die Skriptdatei weiterzugeben. Die Beschreibung, in HTML formatiert, wird für die jeweiligen Studenten angezeigt.</p>';
