/**
 * Terminal control
 *
 * @copyright 2014 Juan Carlos Rodríguez-del-Pino
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @author Juan Carlos Rodríguez-del-Pino <jcrodriguez@dis.ulpgc.es>
 */
define("mod_vpl/vplterminal",["jquery","jqueryui","mod_vpl/vplutil","mod_vpl/vplui","mod_vpl/vplclipboard"],(function($,jqui,VPLUtil,VPLUI,VPLClipboard){if(void 0!==VPLTerminal)return VPLTerminal;var VPLTerminal=function(dialogId,terminalId,str){var terminal,self=this,ws=null,onCloseAction=VPLUtil.doNothing,title="",message="",tdialog=$("#"+dialogId),tIde=$("#vplide"),titleText="",clipboard=null,clipboardData="",terminalTag=$("#"+terminalId);function receiveClipboard(data){if((clipboardData+=data).length>64e3){var from=clipboardData.length-32e3;clipboardData=clipboardData.substr(from)}}function updateClipboard(){clipboard.setEntry1(clipboardData)}function openClipboard(){updateClipboard(),clipboard.show()}this.updateTitle=function(){var text=title;""!==message&&(text+=" ("+message+")"),titleText.text(str("console")+": "+text)},this.setTitle=function(t){title=t,this.updateTitle()},this.setMessage=function(t){message=t,this.updateTitle()},this.write=function(text){return terminal.write(text),text},this.connect=function(server,onClose){onCloseAction=onClose,"WebSocket"in window?(terminal.reset(),terminal.startBlink(),self.show(),ws&&ws.close(),clipboardData="",self.setMessage(""),self.setTitle(str("connecting")),(ws=new WebSocket(server)).writeBuffer="",ws.writeIt=function(){terminal.write(ws.writeBuffer),receiveClipboard(ws.writeBuffer),ws.writeBuffer=""},ws.onmessage=function(event){ws.writeBuffer.length>0?ws.writeBuffer+=event.data:(ws.writeBuffer=event.data,setTimeout(ws.writeIt,35))},ws.onopen=function(){self.setMessage(""),self.setTitle(str("connected"))},ws.onclose=function(){self.setTitle(str("connection_closed")),terminal.blur(),terminal.stopBlink(),onClose(),ws.stopOutput=!0}):terminal.write("WebSocket not available: Upgrade your browser")},this.writeLocal=function(text){return ws.onmessage({data:text}),text},this.setDataCallback=function(call){ws.onData=call},this.closeLocal=function(){ws&&(ws.writeIt(),ws.close(),terminal.stopBlink(),self.setTitle(str("connection_closed")))},this.connectLocal=function(onClose,onData){onCloseAction=onClose,terminal.reset(),terminal.startBlink(),self.show(),ws&&ws.close(),clipboardData="",self.setMessage(""),self.setTitle(str("running")),(ws={}).onData=onData,ws.writeBuffer="",ws.readBuffer="",ws.readyState=1,ws.OPEN=1,ws.close=function(){ws=!1},ws.onmessage=function(event){ws.writeBuffer=event.data,ws.writeIt()},ws.writeIt=function(){ws&&(terminal.write(ws.writeBuffer),receiveClipboard(ws.writeBuffer),ws.writeBuffer="")},ws.send=function(text){""==text?ws.readBuffer.length>0&&(self.writeLocal("\b \b"),ws.readBuffer=ws.readBuffer.substr(0,ws.readBuffer.length-1)):(self.writeLocal(text),ws.readBuffer+=text);var pos=ws.readBuffer.indexOf("\r");if(-1!=pos){var data=ws.readBuffer.substr(0,pos);ws.readBuffer=ws.readBuffer.substr(pos+1),ws.onData(data)}}},this.isOpen=function(){return tdialog.dialog("isOpen")},this.close=function(){tdialog.dialog("close")},this.isConnected=function(){return ws&&ws.readyState!=ws.CLOSED},this.disconnect=function(){ws&&ws.readyState==ws.OPEN&&(onCloseAction(),ws&&ws.close(),terminal.stopBlink())};var HTMLUpdateClipboard=VPLUI.genIcon("copy","sw")+" "+str("copy"),HTMLPaste=VPLUI.genIcon("paste","sw")+" "+str("paste");function setTheme(theme){var cbase="vpl_terminal_theme";tdialog.data("terminal_theme",theme),VPLUtil.setUserPreferences({terminalTheme:theme});for(var i=0;i<5;i++)tdialog.removeClass(cbase+i);tdialog.addClass(cbase+theme)}function controlDialogSize(){var bw=tIde.width(),bh=tIde.height();tdialog.width()>bw&&tdialog.dialog("option","width",bw),tdialog.parent().height()>bh&&tdialog.dialog("option","height",bh-tdialog.prev().outerHeight())}clipboard=new VPLClipboard("vpl_dialog_terminal_clipboard",HTMLUpdateClipboard,(function(){updateClipboard(),document.execCommand("copy")}),HTMLPaste,(function(){ws&&ws.readyState==ws.OPEN&&ws.send(clipboard.getEntry2())})),this.closeDialog=function(){clipboard.hide(),self.disconnect()},tdialog.dialog({closeOnEscape:!1,autoOpen:!1,width:"auto",height:"auto",resizable:!0,dragStop:controlDialogSize,open:controlDialogSize,focus:function(){controlDialogSize(),terminal.focus()},classes:{"ui-dialog":"vpl_ide vpl_vnc"},create:function(){titleText=VPLUI.setTitleBar(tdialog,"console","console",["clipboard","keyboard","theme"],[openClipboard,function(){terminal.focus()},function(){setTheme((tdialog.data("terminal_theme")+1)%5)}])},close:function(){self.closeDialog()},resizeStop:function(){tdialog.width(tdialog.parent().width()),tdialog.height(tdialog.parent().height()-tdialog.prev().outerHeight()),controlDialogSize(),terminal.focus()}}),this.setFontSize=function(size){terminalTag.css("font-size",size+"px")},VPLUtil.getUserPreferences((function(data){setTheme(data.preferences.terminalTheme)})),tdialog.css("padding","1px"),tdialog.parent().css("z-index",2e3),this.show=function(){tdialog.dialog("open"),terminal.focus()},this.init=function(){"undefined"!=typeof Terminal?((terminal=new Terminal({cols:80,rows:24,useStyle:!0,screenKeys:!0})).on("data",(function(data){ws&&ws.readyState==ws.OPEN&&ws.send(data)})),terminal.open(terminalTag[0]),terminal.reset(),terminal.stopBlink(),terminal.setLineCallback((function(line,nlines){var height=terminalTag.height(),offset=tdialog.scrollTop(),viewHeight=tdialog.innerHeight();if(!(viewHeight>=height)){var lineHeight=height/nlines,pos=line*lineHeight;pos>=offset&&pos<viewHeight+offset-lineHeight||(pos<offset?tdialog.scrollTop(pos):tdialog.scrollTop(pos-viewHeight+2*lineHeight))}}))):VPLUtil.loadScript(["/xterm/term.js"],(function(){self.init()}))},this.init()};return window.VPLTerminal=VPLTerminal,VPLTerminal}));

//# sourceMappingURL=vplterminal.min.js.map