/**
 * @module     local_deepler/deepler
 * @file       amd/src/local/ui.js
 * @copyright  2025 Bruno Baudry <bruno.baudry@bfh.ch>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_deepler/local/ui",["core/log","editor_tiny/editor","core/modal","./selectors","./translation","./utils","./customevents","./scrollspy"],((Log,TinyMCE,Modal,Selectors,Translation,Utils,Events,ScrollSpy)=>{let config={},langstrings={},autotranslateButton={},saveAllBtn={},selectAllBtn={},checkboxes=[],format=new Intl.NumberFormat,saveAllModal={},errordbtitle="",glossaryId={};const onDBFailed=(error,status)=>{showModal("".concat(errordbtitle," ").concat(status),"DB failed to save translations. ".concat(error),"Alert")},onDbSavedSuccess=errors=>{if(null!==saveAllModal&&saveAllModal.isVisible&&saveAllModal.hide(),errors.length>0){let s=config.uistrings.errordbpartial;s.replace("{$a}",errors.length),showModal(errordbtitle,s,"Alert")}},handleChangeEvent=e=>{e.target.closest(Selectors.actions.targetSwitcher)&&switchTarget(e),e.target.closest(Selectors.actions.sourceSwitcher)&&switchSource(e),e.target.closest(Selectors.actions.showUpdated)&&showRows(Selectors.statuses.updated,e.target.checked),e.target.closest(Selectors.actions.showNeedUpdate)&&showRows(Selectors.statuses.needsupdate,e.target.checked),e.target.closest(Selectors.actions.showHidden)&&showRows(Selectors.statuses.hidden,e.target.checked),e.target.closest(Selectors.actions.checkBoxes)&&onItemChecked(e),e.target.closest(Selectors.actions.sourceselect)&&onSourceChange(e)},handleClickEvent=e=>{e.target.closest(Selectors.actions.toggleMultilang)&&(e=>{let keyid=e.getAttribute("aria-controls"),key=Utils.keyidToKey(keyid);if(null===key)Log.error("KEY ".concat(keyid," BAD FORMAT should be TABLE-ID-FIELD-CMID"));else{let source=domQuery(Selectors.sourcetexts.keys,key),multilang=domQuery(Selectors.sourcetexts.multilangs,keyid);source.classList.toggle("show"),multilang.classList.toggle("show")}})(e.target.closest(Selectors.actions.toggleMultilang)),e.target.closest(Selectors.actions.autoTranslateBtn)&&(config.deeplsourcelang===config.targetlang||void 0===config.targetlang?showModal("Cannot call deepl","<p>Both languages are the same ".concat(config.targetlang,"</p>")):doAutotranslate()),e.target.closest(Selectors.actions.selectAllBtn)&&toggleAllCheckboxes(e),e.target.closest(Selectors.actions.checkBoxes)&&toggleAutotranslateButton(),e.target.closest(Selectors.actions.saveAll)&&saveTranslations(),e.target.closest(Selectors.actions.validatorsBtns)&&saveSingleTranslation(e)},saveTranslations=()=>{const selectedCheckboxes=domQueryAll(Selectors.statuses.checkedCheckBoxes);if(0===selectedCheckboxes.length)return;saveAllBtn.disabled=!0,(async()=>{saveAllModal=await Modal.create({title:config.uistrings.saveallmodaltitle,body:config.uistrings.saveallmodalbody}),await saveAllModal.show()})().then((r=>Log.info("SaveAll Modal launched "+r))).catch((reason=>{Log.error(reason)}));const data=[];Array.from(selectedCheckboxes).map((e=>e.dataset.key)).forEach((key=>{getIconStatus(key)===Selectors.statuses.tosave&&(hideErrorMessage(key),data.push(prepareDBitem(key)))})),Translation.saveTranslations(data,config)},saveSingleTranslation=e=>{const key=e.target.closest(Selectors.actions.validatorsBtns).dataset.keyValidator;getIconStatus(key)===Selectors.statuses.tosave&&(hideErrorMessage(key),Translation.saveTranslations([prepareDBitem(key)],config))},prepareDBitem=key=>{const element=domQuery(Selectors.editors.multiples.editorsWithKey,key);return{key:key,courseid:config.courseid,id:parseInt(element.getAttribute("data-id")),tid:element.getAttribute("data-tid"),table:element.getAttribute("data-table"),field:element.getAttribute("data-field"),cmid:element.getAttribute("data-cmid")}},onSourceChange=e=>{Log.info(e.target.getAttribute("data-key"))},onItemChecked=e=>{"local_deepler/checkbox"===e.target.getAttribute("data-action")&&(toggleStatus(e.target.getAttribute("data-key"),e.target.checked),countWordAndChar())},toggleAllCheckboxes=e=>{e.target.checked?checkboxes.forEach((i=>{i.checked=!getParentRow(i).classList.contains("d-none"),toggleStatus(i.getAttribute("data-key"),i.checked)})):checkboxes.forEach((i=>{i.checked=!1,toggleStatus(i.getAttribute("data-key"),!1)})),toggleAutotranslateButton(),countWordAndChar()},toggleAutotranslateButton=()=>{autotranslateButton.disabled=!0;for(let i in checkboxes){if(checkboxes[i].checked){autotranslateButton.disabled=!1;break}}},getIconStatus=key=>domQuery(Selectors.actions.validatorBtn,key).getAttribute("data-status"),setIconStatus=function(key){let status=arguments.length>1&&void 0!==arguments[1]?arguments[1]:Selectors.statuses.wait,isBtn=arguments.length>2&&void 0!==arguments[2]&&arguments[2],icon=domQuery(Selectors.actions.validatorBtn,key);isBtn?(icon.classList.contains("btn")||(icon.classList.add("btn"),icon.classList.add("btn-outline-secondary")),icon.classList.contains("disable")&&icon.classList.remove("disable")):(icon.classList.contains("disable")||icon.classList.add("disable"),icon.classList.contains("btn")&&(icon.classList.remove("btn"),icon.classList.remove("btn-outline-secondary"))),icon.setAttribute("role",isBtn?"button":"status"),icon.setAttribute("data-status",status),icon.setAttribute("title",langstrings.statusstrings[status.replace("local_deepler/","")])},getParentRow=node=>node.closest(Utils.replaceKey(Selectors.sourcetexts.parentrow,node.getAttribute("data-key"))),showModal=function(title,body){let type=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"default";Modal.create({title:title,body:body,type:type,show:!0,removeOnClose:!0})},onTranslationFailed=error=>{let s=langstrings.uistrings.deeplapiexception;showModal(s,error,"Alert")},onItemTranslated=key=>{setIconStatus(key,Selectors.statuses.tosave,!0)},doAutotranslate=()=>{const keys=[];saveAllBtn.disabled=!1,domQueryAll(Selectors.statuses.checkedCheckBoxes).forEach((ckBox=>{const key=ckBox.getAttribute("data-key"),sourceText=domQuery(Selectors.sourcetexts.keys,key),editor=findEditor(key);Translation.initTempForKey(key,editor,sourceText.getAttribute("data-sourcetext-raw"),sourceText.getAttribute("data-filedtext-raw"),domQuery(Selectors.sourcetexts.sourcelangdd,key).value),keys.push(key)})),Translation.callTranslations(keys)},toggleStatus=(key,checked)=>{switch(domQuery(Selectors.actions.validatorBtn,key).dataset.status){case Selectors.statuses.wait:Translation.initTemp(key),checked&&setIconStatus(key,Selectors.statuses.totranslate);break;case Selectors.statuses.totranslate:checked&&Translation.translated[key]?setIconStatus(key,Selectors.statuses.tosave,!0):setIconStatus(key,Selectors.statuses.wait);break;case Selectors.statuses.tosave:checked||setIconStatus(key,Selectors.statuses.totranslate);break;case Selectors.statuses.failed:case Selectors.statuses.success:break;case Selectors.statuses.saved:Translation.initTemp(key)}},showRows=(selector,selected)=>{const items=domQueryAll(selector),shoudlcheck=domQuery(Selectors.actions.selectAllBtn).checked&&selected;items.forEach((item=>{let k=item.getAttribute("data-row-id");selected?item.classList.remove("d-none"):item.classList.add("d-none");try{const single=domQuery(Selectors.editors.multiples.checkBoxesWithKey,k);null!==single&&(single.checked=shoudlcheck,toggleStatus(k,!1));const allchilds=domQueryAll(Selectors.editors.multiples.checkBoxesWithKeyHidden,k);null!==allchilds&&allchilds.length>0&&allchilds.forEach((c=>{const key=c.getAttribute("data-key");c.checked=shoudlcheck,toggleStatus(key,!1)}))}catch(e){Log.warn("".concat(k," translation is disalbled"))}})),toggleAutotranslateButton(),countWordAndChar()},onErrorMessageItem=(key,error)=>{Log.warn("ui/errorMessageItem"),Log.warn(key),Log.warn(error);domQuery(Selectors.editors.multiples.editorsWithKey,key).classList.add("local_deepler__error"),setIconStatus(key,Selectors.statuses.failed);if(-1===error.indexOf("Data too long"))showErrorMessageForEditor(key,error);else{let s=langstrings.uistrings.errortoolong;showErrorMessageForEditor(key,"".concat(error.substring(0,error.indexOf("WHERE id=?"))," ").concat(s))}},hideErrorMessage=key=>{let parent=domQuery(Selectors.editors.multiples.editorsWithKey,key),alertChild=domQuery(".alert-danger","",parent);alertChild&&parent.removeChild(alertChild)},onSuccessMessageItem=(key,savedText)=>{Log.info("ui/successMessageItem > savedText"),Log.info(savedText),domQuery(Selectors.editors.multiples.editorsWithKey,key).classList.add("local_deepler__success"),setIconStatus(key,Selectors.statuses.success);domQuery(Selectors.editors.multiples.textAreas,key).innerHTML=savedText,domQuery(Selectors.editors.multiples.checkBoxesWithKey,key).checked=!1,setTimeout((()=>{let multilangPill=domQuery(Selectors.statuses.multilang,key);domQuery(Selectors.statuses.prevTransStatus,key).classList="badge badge-pill badge-success",multilangPill.classList.contains("disabled")&&multilangPill.classList.remove("disabled"),setIconStatus(key,Selectors.statuses.saved)}))},showErrorMessageForEditor=(key,message)=>{let parent=domQuery(Selectors.editors.multiples.editorsWithKey,key);const errorMsg=document.createElement("div");errorMsg.id="local_deepler__errormsg",errorMsg.classList=["alert alert-danger"],errorMsg.innerHTML=message,parent.appendChild(errorMsg)},switchTarget=e=>{let url=new URL(window.location.href);url.searchParams.set("target_lang",e.target.value),window.location=url.toString()},switchSource=e=>{let url=new URL(window.location.href);url.searchParams.set("lang",e.target.value),window.location=url.toString()},countWordAndChar=()=>{let wrdsc=0,cws=0,cwos=0;domQueryAll(Selectors.statuses.checkedCheckBoxes).forEach((ckBox=>{let key=ckBox.getAttribute("data-key"),results=getCount(key);wrdsc+=results.wordCount,cwos+=results.charNumWithOutSpace,cws+=results.charNumWithSpace}));const wordCount=domQuery(Selectors.statuses.wordcount),charWithSpace=domQuery(Selectors.statuses.charNumWithSpace),charWOSpace=domQuery(Selectors.statuses.charNumWithOutSpace),deeplUseSpan=domQuery(Selectors.statuses.deeplUsage),deeplMaxSpan=domQuery(Selectors.statuses.deeplMax),parent=domQuery(Selectors.statuses.deeplStatusContainer);let current=cwos+config.usage.character.count;wordCount.innerText=wrdsc,charWithSpace.innerText=cws,charWOSpace.innerText=cwos,deeplUseSpan.innerText=format.format(current),deeplMaxSpan.innerText=null===config.usage.character.limit?"∞":format.format(config.usage.character.limit),current>=config.usage.character.limit?(parent.classList.remove("alert-success"),parent.classList.add("alert-danger")):(parent.classList.add("alert-success"),parent.classList.remove("alert-danger"))},findEditor=key=>{let e=domQuery(Selectors.editors.types.basic,key);if(null===e){let r=null;if(-1===["atto","tiny","marklar","textarea"].indexOf(config.userPrefs))Log.warn("Unsupported editor "+config.userPrefs);else try{r=findEditorByType(key,config.userPrefs)}catch(error){Log.trace("Editor not found: ".concat(config.userPrefs," for key ").concat(key))}return r}return{editor:e,editorType:"basic"}},findEditorByType=(key,editorType)=>{let et="basic",ed=null;switch(editorType){case"atto":et="iframe",ed=domQuery(Selectors.editors.types.atto,key);break;case"tiny":et="iframe",ed=findTinyInstanceByKey(key);break;case"marklar":case"textarea":ed=domQuery(Selectors.editors.types.other,key)}return{editor:ed,editorType:et}},findTinyInstanceByKey=key=>{let editor=null;return TinyMCE.getAllInstances().every(((k,v)=>0!=v.attributes.name.value.indexOf(key)||(editor=k.getBody(),!1))),editor},getCount=key=>{const raw=domQuery(Selectors.sourcetexts.keys,key).getAttribute("data-sourcetext-raw"),trimmedVal=Utils.stripHTMLTags(Utils.fromBase64(raw)).trim();return{wordCount:(trimmedVal.match(/\S+/g)||[]).length,charNumWithSpace:trimmedVal.length,charNumWithOutSpace:trimmedVal.replace(/\s+/g,"").length}},domQuery=function(selector){let key=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",target=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;const el=null!=target?target:document,q=""===key?selector:selector.replace("<KEY>",key);return el.querySelector(q)},domQueryAll=function(selector){let key=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",target=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;const el=null!=target?target:document,q=""===key?selector:selector.replace("<KEY>",key);return el.querySelectorAll(q)};return{init:cfg=>{ScrollSpy.init(".local_deepler__form","#local_deepler-scrollspy",{highestLevel:3,fadingDistance:60,offsetEndOfScope:1,offsetTop:100}),Translation.init(cfg),config=cfg,Log.info(cfg),(()=>{try{langstrings=JSON.parse(domQuery(Selectors.config.langstrings).getAttribute("data-langstrings")),errordbtitle=langstrings.uistrings.errordbtitle,saveAllBtn=domQuery(Selectors.actions.saveAll),selectAllBtn=domQuery(Selectors.actions.selectAllBtn),autotranslateButton=domQuery(Selectors.actions.autoTranslateBtn),checkboxes=domQueryAll(Selectors.actions.checkBoxes),glossaryId=domQuery(Selectors.deepl.glossaryId);const glossaryCookie=Utils.getCookie(Utils.COOKIE_PREFIX+config.currentlang+config.targetlang+config.courseid);null!==glossaryCookie&&(glossaryId.value=glossaryCookie)}catch(e){config.debug&&Log.error(e.message)}})(),document.addEventListener("change",handleChangeEvent),document.addEventListener("click",handleClickEvent),Events.on(Translation.ON_ITEM_TRANSLATED,onItemTranslated),Events.on(Translation.ON_TRANSLATION_FAILED,onTranslationFailed),Events.on(Translation.ON_DB_SAVE_SUCCESS,onDbSavedSuccess),Events.on(Translation.ON_DB_FAILED,onDBFailed),Events.on(Translation.ON_ITEM_SAVED,onSuccessMessageItem),Events.on(Translation.ON_ITEM_NOT_SAVED,onErrorMessageItem),toggleAutotranslateButton(),saveAllBtn.disabled=!0,selectAllBtn.disabled=!Translation.isTranslatable(),checkboxes.forEach((node=>{node.disabled=selectAllBtn.disabled})),showRows(Selectors.statuses.updated,domQuery(Selectors.actions.showUpdated).checked),showRows(Selectors.statuses.needsupdate,domQuery(Selectors.actions.showNeedUpdate).checked)},setIconStatus:setIconStatus,findEditor:findEditor,findEditorByType:findEditorByType}}));

//# sourceMappingURL=ui.min.js.map