/**
 * @module     local_deepler/deepler
 * @file       amd/src/local/translation.js
 * @copyright  2025 Bruno Baudry <bruno.baudry@bfh.ch>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_deepler/local/translation",["core/log","./api","./utils","./selectors","./tokeniser","./customevents"],((Log,Api,Utils,Selectors,Tokeniser,Events)=>{let tempTranslations={},escapePatterns={},mainSourceLang="",targetLang="",courseid=0,userid=0,settings={};const setMainLangs=function(){let source=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",target=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"";""!==source&&(mainSourceLang=source),""!==target&&(targetLang=target.toLowerCase())},onTrDbSuccess=data=>{if(Log.info(data),0===data.length)Log.error(data),Events.emit("onDbFailed","no data returned","");else{const errors=data.filter((item=>""!==item.error));data.forEach((item=>{Log.debug("translation/:54"),Log.debug(item),""===item.error?Events.emit("onItemSaved",item.keyid,item.text):Events.emit("onItemNotSaved",item.keyid,item.error)})),Events.emit("onDbSuccess",errors)}},onTrDbFailed=(status,error)=>{Events.emit("onDbFailed",error,status),Log.trace(status),Log.trace(error)},prepareDbUpdateItem=(item,maineditorIsTextArea)=>{const key=item.key,textTosave=getupdatedtext(key,maineditorIsTextArea);return item.text=textTosave,{id:item.id,tid:item.tid,field:item.field,table:item.table,text:textTosave,cmid:item.cmid,keyid:key}},getupdatedtext=(key,maineditorIsTextArea)=>{const sourceItemLang=tempTranslations[key].sourceLang.toLowerCase(),fieldText=tempTranslations[key].fieldText,translation=getEditorText(tempTranslations[key].editor,maineditorIsTextArea),source=getSourceText(key),isFirstTranslation=-1===fieldText.indexOf("{mlang"),isSourceOther=sourceItemLang===mainSourceLang,tagPatterns={other:"({mlang other)(.*?){mlang}",target:"({mlang ".concat(targetLang,"}(.*?){mlang})"),source:"({mlang ".concat(sourceItemLang,"}(.*?){mlang})")},langsItems={fullContent:fieldText,other:"{mlang other}".concat(source,"{mlang}"),target:"{mlang ".concat(targetLang,"}").concat(translation,"{mlang}"),source:"{mlang ".concat(sourceItemLang,"}").concat(source,"{mlang}")};return isFirstTranslation?isSourceOther?langsItems.other+langsItems.target:langsItems.other+langsItems.source+langsItems.target:additionalUpdate(isSourceOther,tagPatterns,langsItems)},additionalUpdate=(isSourceOther,tagPatterns,langsItems)=>{let manipulatedText=langsItems.fullContent;const targetReg=new RegExp(tagPatterns.target,"sgi");if(manipulatedText.match(targetReg))manipulatedText=manipulatedText.replace(targetReg,Tokeniser.escapeReplacementString(langsItems.target));else{const lastMlangClosingTagEnd=manipulatedText.lastIndexOf("{mlang}")+"{mlang}".length;manipulatedText=[manipulatedText.slice(0,lastMlangClosingTagEnd),langsItems.target,manipulatedText.slice(lastMlangClosingTagEnd)].join("")}const otherReg=new RegExp(tagPatterns.other,"sgi"),hasTagOther=manipulatedText.match(otherReg),sourceReg=new RegExp(tagPatterns.other,"sgi"),hasTagSource=manipulatedText.match(sourceReg);if(isSourceOther)manipulatedText=manipulatedText.replace(otherReg,Tokeniser.escapeReplacementString(langsItems.other)),hasTagSource&&manipulatedText.replace(sourceReg,"");else{if(!hasTagOther){const firstMlangClosingTagEnd=manipulatedText.indexOf("{mlang");manipulatedText=[manipulatedText.slice(0,firstMlangClosingTagEnd),langsItems.other,manipulatedText.slice(firstMlangClosingTagEnd)].join("")}hasTagSource||manipulatedText.replace(sourceReg,Tokeniser.escapeReplacementString(langsItems.source))}return manipulatedText},getEditorText=(editor,maineditorIsTextArea)=>{let text=editor.innerHTML;return maineditorIsTextArea&&(text=Utils.decodeHTML(text)),text},getSourceText=key=>{const sourceTokenised=tempTranslations[key].source;return Tokeniser.postprocess(sourceTokenised,tempTranslations[key].tokens)},onTranslateSuccess=response=>{Log.info("translation//onTranslateSuccess::response"),Log.info(response),response.forEach((tr=>{if(""===tr.error){let key=tr.key,translation=Tokeniser.postprocess(tr.translated_text,tempTranslations[key].tokens);Log.debug("translation/onTranslateSuccess/each::translation Tokeniser.postprocess"),Log.debug(translation),tempTranslations[key].editor.innerHTML=translation,Log.debug("translation/onTranslateSuccess::tempTranslations[key].editor.innerHTML"),Log.debug(tempTranslations[key].editor.innerHTML),tempTranslations[key].translation=translation,Events.emit("onItemTranslated",key)}else Events.emit("onTranslationFailed",tr.error)}))},onTranslateFailed=(status,error)=>{Events.emit("onTranslationFailed",status,error)},prepareAdvancedSettings=targetLang=>{var _document$querySelect,_document$querySelect2;escapePatterns.LATEX=document.querySelector(Selectors.actions.escapeLatex).checked,escapePatterns.PRETAG=document.querySelector(Selectors.actions.escapePre).checked,settings.tag_handling=document.querySelector(Selectors.deepl.tagHandling).checked?"html":"xml",settings.context=null!==(_document$querySelect=document.querySelector(Selectors.deepl.context).value)&&void 0!==_document$querySelect?_document$querySelect:null,settings.split_sentences=document.querySelector(Selectors.deepl.splitSentences).value,settings.preserve_formatting=document.querySelector(Selectors.deepl.preserveFormatting).checked,settings.formality=document.querySelector('[name="local_deepler/formality"]:checked').value,settings.glossary_id=document.querySelector(Selectors.deepl.glossaryId).value,""!==settings.glossary_id&&Utils.setCookie(Utils.COOKIE_PREFIX+mainSourceLang+targetLang+courseid,settings.glossary_id,703),settings.outline_detection=document.querySelector(Selectors.deepl.outlineDetection).checked,settings.non_splitting_tags=Utils.toJsonArray(document.querySelector(Selectors.deepl.nonSplittingTags).value),settings.splitting_tags=Utils.toJsonArray(document.querySelector(Selectors.deepl.splittingTags).value),settings.ignore_tags=Utils.toJsonArray(document.querySelector(Selectors.deepl.ignoreTags).value),settings.target_lang=targetLang.toUpperCase(),settings.model_type=null!==(_document$querySelect2=document.querySelector(Selectors.deepl.modelType).value)&&void 0!==_document$querySelect2?_document$querySelect2:"prefer_quality_optimized",settings.show_billed_characters=!0};return{init:cfg=>{Api.APP_VERSION=cfg.version,courseid=cfg.courseid,userid=cfg.userid,setMainLangs(cfg.currentlang,cfg.targetlang)},callTranslations:keys=>{const translations=[];prepareAdvancedSettings(targetLang),keys.forEach((key=>{translations.push((key=>({text:tempTranslations[key].source,source_lang:tempTranslations[key].sourceLang,key:key}))(key))})),Events.on(Api.DEEPL_SUCCESS,onTranslateSuccess),Events.on(Api.DEEPL_FAILED,onTranslateFailed),Api.translate(translations,settings,Api.APP_VERSION)},saveTranslations:(items,config)=>{const data=items.map((item=>prepareDbUpdateItem(item,"textarea"===config.userPrefs)));Events.on(Api.TR_DB_SUCCESS,onTrDbSuccess),Events.on(Api.TR_DB_FAILED,onTrDbFailed),Api.updateTranslationsInDb(data,userid,courseid)},initTempForKey:(key,editorSettings,sourceTextEncoded,multilangRawTextEncoded,sourceLang)=>{const sourceText=Utils.fromBase64(sourceTextEncoded),fieldText=Utils.fromBase64(multilangRawTextEncoded),tokenised=Tokeniser.preprocess(sourceText,escapePatterns,escapePatterns);tempTranslations[key]={editorType:editorSettings.editorType,editor:editorSettings.editor,source:tokenised.tokenizedText,sourceLang:sourceLang,fieldText:fieldText,status:Selectors.statuses.wait,translation:"",tokens:tokenised.expressions}},initTemp:key=>{tempTranslations[key]={editorType:null,editor:null,source:"",sourceLang:"",fieldText:"",status:"",translation:"",tokens:[]}},ON_ITEM_TRANSLATED:"onItemTranslated",ON_DB_FAILED:"onDbFailed",ON_ITEM_SAVED:"onItemSaved",ON_ITEM_NOT_SAVED:"onItemNotSaved",ON_TRANSLATION_FAILED:"onTranslationFailed",ON_TRANSLATION_SUCCESS:"onDbSuccess",setMainLangs:setMainLangs,isTranslatable:function(){let sourceLang=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"";return Log.info(targetLang,sourceLang,targetLang===(""===sourceLang?mainSourceLang:sourceLang)),""!==targetLang},translated:key=>{var _tempTranslations$key,_tempTranslations$key2;return(null===(_tempTranslations$key=tempTranslations[key])||void 0===_tempTranslations$key||null===(_tempTranslations$key2=_tempTranslations$key.translation)||void 0===_tempTranslations$key2?void 0:_tempTranslations$key2.length)>0}}}));

//# sourceMappingURL=translation.min.js.map