/**
 * Port of the scrollspy script from Angelika Cathor (angelikatyborska) to AMD.
 * Utilizes the scroll event to update the breadcrumbs based on the current scroll position.
 *
 * @module     local_deepler/deepler
 * @file       amd/src/local/scrollspy.js
 * @copyright  2025 Bruno Baudry <bruno.baudry@bfh.ch>
 * @copyright  2025 Angelika Cathor <https://angelika.me>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @see https://github.com/angelikatyborska
 */
define("local_deepler/local/scrollspy",["core/log"],(Log=>{let OFFSET_TOP,ARTICLE,CONTAINER,END_OF_ARTICLE,HIGHEST_LEVEL,FADING_DISTANCE,OFFSET_END_OF_SCOPE;const makeBreadcrumbs=headingsPerLevel=>{CONTAINER.innerHTML=getBreadcrumbs(headingsPerLevel,scrollTop()),""===CONTAINER.innerHTML.trim()?CONTAINER.style.display="none":CONTAINER.style.display="block"},scrollTop=()=>window.scrollY+OFFSET_TOP,getBreadcrumbs=(headingsPerLevel,scrollTop)=>{const breadcrumbs=[];return findHeadingsInScope(headingsPerLevel,scrollTop).forEach((heading=>{const opacity=calculateOpacity(heading.beginningOfScope,heading.endOfScope,scrollTop),html='<a href="#'+heading.id+'" class="'+heading.tag+'" style="opacity:'+opacity+"; pointer-events: "+(opacity>.5?"auto":"none")+'">'+heading.text+"</a>";breadcrumbs.push(html)})),breadcrumbs.join("<small>&nbsp;&gt;&nbsp;</small>")},findHeadingsInScope=(headingsPerLevel,scrollTop)=>{const headingsInScope=[];let previousHeadingOffset=0;return headingsPerLevel.forEach(((headings,level)=>{const heading=headings.find((node=>node.offsetTop<scrollTop&&node.offsetTop>previousHeadingOffset));if(heading){const nextHeadingOfSameLevel=headingsPerLevel[level][headingsPerLevel[level].indexOf(heading)-1],currentHeadingOfHigherLevel=headingsInScope[headingsInScope.length-1],endOfScope=calculateEndOfScope(nextHeadingOfSameLevel,currentHeadingOfHigherLevel);headingsInScope.push({id:heading.id,tag:heading.tagName.toLowerCase(),text:heading.textContent.trim(),beginningOfScope:heading.offsetTop+heading.offsetHeight,endOfScope:endOfScope}),previousHeadingOffset=heading.offsetTop}else previousHeadingOffset=END_OF_ARTICLE})),headingsInScope},calculateEndOfScope=(nextHeadingOfSameLevel,currentHeadingOfHigherLevel)=>{let endOfScope;return endOfScope=currentHeadingOfHigherLevel?nextHeadingOfSameLevel?Math.min(nextHeadingOfSameLevel.offsetTop,currentHeadingOfHigherLevel.endOfScope):currentHeadingOfHigherLevel.endOfScope:nextHeadingOfSameLevel?nextHeadingOfSameLevel.offsetTop:END_OF_ARTICLE,endOfScope},calculateOpacity=(top,bottom,scrollTop)=>{const diffTop=scrollTop-top,opacityTop=diffTop>FADING_DISTANCE?1:diffTop/(diffTop/FADING_DISTANCE),diffBottom=bottom-scrollTop-OFFSET_END_OF_SCOPE,opacityBottom=diffBottom>FADING_DISTANCE?1:diffBottom/FADING_DISTANCE;return Math.min(opacityTop,opacityBottom)};return{init:(article,breadcrumbsContainer,options)=>{Log.debug("local_deepler/scrollspy/init"),ARTICLE=document.querySelector(article),CONTAINER=document.querySelector(breadcrumbsContainer),END_OF_ARTICLE=ARTICLE.offsetTop+ARTICLE.offsetHeight,HIGHEST_LEVEL=options.highestLevel||2,FADING_DISTANCE=0==options.fadingDistance?1:options.fadingDistance||100,OFFSET_END_OF_SCOPE=options.offsetEndOfScope||100,OFFSET_TOP=options.offsetTop||0;const headingsPerLevel=(()=>{const headingsPerLevel=[];for(let level=HIGHEST_LEVEL;level<=6;level++){let headings=Array.prototype.slice.call(ARTICLE.querySelectorAll("span.h"+level));headings=headings.sort(((a,b)=>b.offsetTop-a.offsetTop)),headingsPerLevel.push(headings)}return headingsPerLevel})();makeBreadcrumbs(headingsPerLevel),window.addEventListener("scroll",(()=>{makeBreadcrumbs(headingsPerLevel)}))}}}));

//# sourceMappingURL=scrollspy.min.js.map