define("tiny_htmlblock/ui",["exports","core/modal_events","core/modal_factory","core/mustache","core/str","./common","./options"],(function(_exports,_modal_events,_modal_factory,_mustache,_str,_common,_options){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Javascript functions to handle the action inside the editor when clicking
   * the toolbar button or the menu item.
   *
   * @module      tiny_htmlblock
   * @copyright   2023 Stephan Robotta <stephan.robotta@bfh.ch>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.handleAction=void 0,_modal_events=_interopRequireDefault(_modal_events),_modal_factory=_interopRequireDefault(_modal_factory),_mustache=_interopRequireDefault(_mustache);const isNull=a=>null==a,TEMPLATE_LIST='<div class="tiny_htmlblock"><p>{{intro}}</p><ul>{{#list}}<li class="hbitem" title="{{name}}">{{{html}}}</li>{{/list}}</ul></div>',TEMPLATE_FOOTER='<button type="button" class="btn btn-secondary" data-action="cancel">{{cancel}}</button><button type="button" class="btn btn-primary" data-action="save">{{submit}}</button>';let STR={};let _modal,_editor;_exports.handleAction=async function(editor){_editor||(_editor=editor,await(async()=>{const res=await Promise.all([(0,_str.get_string)("cancel","core"),(0,_str.get_string)("dlgintro",_common.component),(0,_str.get_string)("dlginsert",_common.component),(0,_str.get_string)("pluginname",_common.component)]);["btn_cancel","dlg_intro","btn_insert","title"].map(((l,i)=>(STR[l]=res[i],"")))})()),_modal=await _modal_factory.default.create({title:STR.title,templateContext:{elementid:_editor.id},removeOnClose:!0,large:!0});const footer=_mustache.default.render(TEMPLATE_FOOTER,{cancel:STR.btn_cancel,submit:STR.btn_insert}),contentText=_mustache.default.render(TEMPLATE_LIST,{intro:STR.dlg_intro,list:(0,_options.getHtmlBlocks)(_editor)});_modal.setBody(contentText),_modal.setFooter(footer),_modal.show(),_modal.registerEventListeners(),_modal.registerCloseOnSave(),_modal.registerCloseOnCancel();const $root=_modal.getRoot();$root.on(_modal_events.default.save,insertHandler),$root.on(_modal_events.default.cancel,closeHandler),$root.get(0).querySelectorAll("li").forEach((el=>{el.addEventListener("click",(evt=>{evt.preventDefault();const liSel=getTargetLi(evt);isNull(liSel)||liSel.parentNode.querySelectorAll("li").forEach((li=>{li===liSel?isNull(li.classList)?li.setAttribute("class","selected"):li.classList.add("selected"):isNull(li.classList)||li.classList.remove("selected")}))}))}))};const insertHandler=function(){const li=document.querySelector("li.hbitem.selected");if(!isNull(li)){li.querySelectorAll('*[id^="yui_"]').forEach((e=>e.removeAttribute("id"))),_editor.execCommand("mceInsertContent",!1,'<span class="marker_insert_htmlblock">marker</span>');const span=_editor.dom.select("span.marker_insert_htmlblock");_editor.dom.setOuterHTML(span,li.innerHTML+" ")}closeHandler()},closeHandler=function(){_modal.destroy(),_modal=null},getTargetLi=e=>{let p=e.target;for(;!isNull(p)&&1===p.nodeType&&"LI"!==p.tagName;)p=p.parentNode;return isNull(p.classList)?null:p.classList.contains("hbitem")?p:null}}));

//# sourceMappingURL=ui.min.js.map