<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

// general strings
$string['messageprovider:bookingconfirmation'] = "Booking confirmations";

// index.php
$string['week'] = "Week";
$string['question'] = "Question";
$string['answer'] = "Answer";
$string['topic'] = "Topic";

// teacher_added.php
$string['eventteacher_added'] = 'Teacher added';
$string['eventteacher_removed'] = 'Teacher removed';

// renderer.php
$string['showonlymyinstitutions'] = "My institution";
$string['addusertogroup'] = 'Add user to group: ';

// view.php
$string['addmorebookings'] = 'Add more bookings';
$string['allowupdate'] = 'Allow booking to be updated';
$string['answered'] = 'Answered';
$string['attachical'] = 'Attach single ical event per booking';
$string['attachicaldesc'] = 'Email notifications will include an attached ical event, if this is enabled. The ical will include only one start time and one end time either defined
in the booking option settings or start time of the first session to end time of the last session';
$string['attachicalsess'] = 'Attach all session dates as ical events';
$string['attachicalsessdesc'] = 'Email notifications will include all session dates defined for a booking option as ical attachment.';
$string['icalcancel'] = 'Include ical event when booking is cancelled as cancelled event';
$string['icalcanceldesc'] = 'When a users cancels a booking or is removed from the booked users list, then attach an ical attachment as cancelled event.';
$string['booking'] = 'Booking';
$string['booking:addinstance'] = 'Add new booking';
$string['booking:choose'] = 'Book';
$string['booking:deleteresponses'] = 'Delete responses';
$string['booking:downloadresponses'] = 'Download responses';
$string['booking:readresponses'] = 'Read responses';
$string['booking:rate'] = 'Rate chosen booking options';
$string['booking:sendpollurl'] = 'Send poll url';
$string['booking:sendpollurltoteachers'] = 'Send poll url to teachers';
$string['booking:subscribeusers'] = 'Make bookings for other users';
$string['booking:updatebooking'] = 'Manage booking options';
$string['booking:viewallratings'] = 'View all raw ratings given by individuals';
$string['booking:viewanyrating'] = 'View total ratings that anyone received';
$string['booking:viewrating'] = 'View the total rating you received';
$string['booking:addeditownoption'] = 'Add new option and edit own options.';
$string['booking:comment'] = 'Add comments';
$string['booking:managecomments'] = 'Manage comments';
$string['bookingclose'] = 'Until';
$string['bookingfull'] = 'There are no available places';
$string['bookingname'] = 'Booking name';
$string['bookingoptionsmenu'] = 'Booking options';
$string['bookingopen'] = 'Open';
$string['bookingtext'] = 'Booking text';
$string['datenotset'] = 'Date not set';
$string['daystonotify'] = 'Number of days in advance of the event-start to notify participatants';
$string['daystonotify2'] = 'Second notification before start of event to notify participatants.';
$string['eventbooking_cancelled'] = 'Booking cancelled';
$string['eventbookingoption_booked'] = 'Booking option booked';
$string['bookingoption_created'] = 'Booking option created';
$string['bookingoption_updated'] = 'Booking option updated';
$string['bookingoption_deleted'] = 'Booking option deleted';
$string['eventreport_viewed'] = 'Report viewed';
$string['eventuserprofilefields_updated'] = 'Userprofile updated';
$string['existingsubscribers'] = 'Existing subscribers';
$string['expired'] = 'Sorry, this activity closed on {$a} and is no longer available';
$string['fillinatleastoneoption'] = 'You need to provide at least two possible answers.';
$string['full'] = 'Full';
$string['goenrol'] = 'Go to registration';
$string['gotop'] = 'Go to top';
$string['havetologin'] = 'You have to log in before you can submit your booking';
$string['infonobookingoption'] = 'Please use the block {$a} in order to add your first booking option';
$string['limit'] = 'Limit';
$string['modulename'] = 'Booking';
$string['modulenameplural'] = 'Bookings';
$string['mustchooseone'] = 'You must choose an option before saving. Nothing was saved.';
$string['myoptions'] = 'My options ({$a})';
$string['noguestchoose'] = 'Sorry, guests are not allowed to enter data';
$string['noresultsviewable'] = 'The results are not currently viewable.';
$string['nosubscribers'] = 'There are no teachers assigned!';
$string['notificationsubject'] = 'Upcoming course...';
$string['notopenyet'] = 'Sorry, this activity is not available until {$a} ';
$string['pluginadministration'] = 'Booking administration';
$string['pluginname'] = 'Booking';
$string['potentialsubscribers'] = 'Potential subscribers';
$string['removeresponses'] = 'Remove all responses';
$string['responses'] = 'Responses';
$string['responsesto'] = 'Responses to {$a} ';
$string['spaceleft'] = 'space available';
$string['spacesleft'] = 'spaces available';
$string['subscribersto'] = 'Teachers for \'{$a}\'';
$string['taken'] = 'Taken';
$string['teachers'] = 'Teachers';
$string['timerestrict'] = 'Restrict answering to this time period: This is deprecated and will be removed. Please use "Restrict Access" settings for making the booking activity available for a certain period';
$string['timecloseoption'] = 'Limit the availability of this booking option until a certain date';
$string['to'] = 'to';
$string['viewallresponses'] = 'Manage {$a} responses';
$string['yourselection'] = 'Your selection';

// subscribeusers.php
$string['cannotremovesubscriber'] = 'You have to remove the activity completion prior to cancel the booking. Booking was not cancelled!';
$string['allchangessave'] = 'All changes have been saved.';
$string['backtoresponses'] = '<< Back to responses';
$string['allusersbooked'] = 'All {$a} selected users have successfully been assigned to this booking option.';
$string['notallbooked'] = 'The following users could not be booked due to reaching the max number of bookings per user or lack of available places for the booking option: {$a}';
$string['enrolledinoptions'] = "alredy booked in booking options: ";

// Bookingform
$string['address'] = 'Address';
$string['advancedoptions'] = 'Advanced options';
$string['btnbooknowname'] = 'Name of button "Book now"';
$string['btncacname'] = 'Name of button "Confirm activity completion"';
$string['btncancelname'] = 'Name of button "Cancel booking"';
$string['disablebookingusers'] = 'Disable booking of users - hide Book now button.';
$string['howmanyusers'] = 'How many users you can book?';
$string['howmanyusers_help'] = '';
$string['institution'] = 'Institution';
$string['lblsputtname'] = 'Name of label "Send poll url to teachers"';
$string['lblteachname'] = 'Name of label "Teachers"';
$string['limitanswers_help'] = 'If you change this option and you have booked people, you can remove them without notification!';
$string['location'] = 'Location';
$string['removeafterminutes'] = 'Remove activity completion after N minutes';
$string['banusernames'] = "Ban usernames";
$string['banusernames_help'] = "To limit which usernames can't apply just write in this field, and separate with coma. To ban usernames, that end with gmail.com and yahoo.com just write: gmail.com, yahoo.com";
$string['showhelpfullnavigationlinks'] = 'Show navigation links.';
$string['showhelpfullnavigationlinks_helt'] = 'Show "Go to registration" and "Go to top" links.';
$string['disabled'] = 'Disabled';
$string['completionmodule'] = 'Activity completed';
$string['completionmodule_help'] = 'Delete all users, that completed this activity. Users will be deleted with a click of button on report page!';

// Categories
$string['category'] = 'Category';
$string['categories'] = 'Categories';
$string['addcategory'] = 'Edit categories';
$string['forcourse'] = 'for course';
$string['addnewcategory'] = 'Add new category';
$string['categoryname'] = 'Category name';
$string['rootcategory'] = 'Root';
$string['selectcategory'] = 'Select category';
$string['editcategory'] = 'Edit';
$string['deletecategory'] = 'Delete';
$string['deletesubcategory'] = 'Please, first delete all subcategories of this category!';
$string['usedinbooking'] = 'You can\'t delete this category, because you\'re using it in booking!';
$string['successfulldeleted'] = 'Category was deleted!';

// view.php
$string['agreetobookingpolicy'] = 'I have read and agree to the following booking policies';
$string['allbookingoptions'] = 'Download users for all booking options';
$string['attachedfiles'] = 'Attached files';
$string['availability'] = 'Still available';
$string['available'] = 'Places available';
$string['booked'] = 'Booked';
$string['bookedpast'] = 'Booked (course finished)';
$string['bookingdeleted'] = 'Your booking was cancelled';
$string['bookingmeanwhilefull'] = 'Meanwhile someone took already the last place';
$string['bookingsaved'] = 'Your booking was successfully saved. You can now proceed to book other courses.';
$string['booknow'] = 'Book now';
$string['bookotherusers'] = 'Book other users';
$string['cancelbooking'] = 'Cancel booking';
$string['closed'] = 'Booking closed';
$string['confirmbookingoffollowing'] = 'Please confirm the booking of following course';
$string['confirmdeletebookingoption'] = 'Do you really want to delete this booking option?';
$string['coursedate'] = 'Date';
$string['createdby'] = 'Booking module created by edulabs.org';
$string['deletebooking'] = 'Do you really want to unsubscribe from following course? <br /><br /> <b>{$a} </b>';
$string['deletebookingoption'] = 'Delete this booking option';
$string['deleteuserfrombooking'] = 'Do you really want to delete the users from the booking?';
$string['download'] = 'Download';
$string['downloadusersforthisoptionods'] = 'Download users as .ods';
$string['downloadusersforthisoptionxls'] = 'Download users as .xls';
$string['endtimenotset'] = 'End date not set';
$string['mustfilloutuserinfobeforebooking'] = 'Befor proceeding to the booking form, please fill in some personal booking information';
$string['subscribeuser'] = 'Do you really want to enrol the users in the following course';
$string['deleteuserfrombooking'] = 'Do you really want to delete the users from the booking?';
$string['showallbookings'] = 'All bookings';
$string['showmybookingsonly'] = 'My bookings';
$string['showactive'] = 'Active bookings';
$string['mailconfirmationsent'] = 'You will shortly receive a confirmation e-mail';
$string['deletebookingoption'] = 'Delete this booking option';
$string['confirmdeletebookingoption'] = 'Do you really want to delete this booking option?';
$string['norighttobook'] = 'Booking is not possible for your user role. Please contact the site administrator to give you the appropriate rights or sign in.';
$string['createdby'] = 'Booking module created by edulabs.org';
$string['maxperuserwarning'] = 'You currently have used {$a->count} out of {$a->limit} maximum available bookings ({$a->eventtype}) for your user account';
$string['bookedpast'] = 'Booked (course terminated)';
$string['bookotherusers'] = 'Book other users';
$string['attachedfiles'] = 'Attached files';
$string['eventduration'] = 'Event duration';
$string['eventpoints'] = 'Points';
$string['mailconfirmationsent'] = 'You will shortly receive a confirmation e-mail';
$string['managebooking'] = 'Manage';
$string['mustfilloutuserinfobeforebooking'] = 'Befor proceeding to the booking form, please fill in some personal booking information';
$string['nobookingselected'] = 'No booking option selected';
$string['norighttobook'] = 'Booking is not possible for your user role. Please contact the site administrator to give you the appropriate rights or sign in.';
$string['notbooked'] = 'Not yet booked';
$string['onwaitinglist'] = 'You are on the waiting list';
$string['organizatorname'] = 'Organizer name';
$string['placesavailable'] = 'Places available: {$a->available} of {$a->maxanswers}';
$string['pollurl'] = 'Poll url';
$string['pollurlteachers'] = 'Teachers poll url';
$string['select'] = 'Selection';
$string['showactive'] = 'Active bookings';
$string['showallbookings'] = 'All bookings';
$string['starttimenotset'] = 'Start date not set';
$string['subscribetocourse'] = 'Enrol users in the course';
$string['subscribeuser'] = 'Do you really want to enrol the users in the following course';
$string['tagtemplates'] = 'Tag templates';
$string['unlimited'] = 'Number of available places is not limited';
$string['updatebooking'] = 'Edit this booking option';
$string['userdownload'] = 'Download users';
$string['waitinglist'] = 'Waiting list';
$string['waitingplacesavailable'] = 'Waiting list places available: {$a->overbookingavailable} of {$a->maxoverbooking}';
$string['waitspaceavailable'] = 'Places on waiting list available';
$string['banusernameswarning'] = "Your username is banned so you can't book.";
$string['duplicatebooking'] = 'Duplicate this booking option';

// tag templates
$string['cancel'] = 'Cancel';
$string['addnewtagtemplate'] = 'Add new';
$string['addnewtagtemplate'] = 'Add new tag template';
$string['savenewtagtemplate'] = 'Save';
$string['tagtag'] = 'Tag';
$string['tagtext'] = 'Text';
$string['wrongdataallfields'] = 'Please, fill out all fields!';
$string['tagsuccessfullysaved'] = 'Tag was saved.';
$string['edittag'] = 'Edit';

// all_options
$string['showdescription'] = 'Show description';
$string['hidedescription'] = 'Hide description';
$string['editteacherslink'] = 'Edit teachers';

// mod_form
$string['signinlogoheader'] = 'Logo in header to display on the sign-in sheet';
$string['signinlogofooter'] = 'Logo in footer to display on the sign-in sheet';
$string['bookingoptiontext'] = "Booking option text depending on booking status";
$string['beforebookedtext'] = 'Before booked';
$string['beforecompletedtext'] = 'After booked';
$string['aftercompletedtext'] = 'After activity completed';
$string['conectedbooking'] = 'Connected booking';
$string['errorpagination'] = 'Please enter a number bigger than 0';
$string['notconectedbooking'] = 'Not connected';
$string['conectedbooking_help'] = 'Booking instance eligible for transferring booked users. You can define from which option within the selected booking instance and how many users you will accept.';
$string['cancancelbook'] = 'Allow user to cancel or book their booking when it is started?';
$string['addtocalendar'] = 'Add to calendar';
$string['limitanswers'] = 'Limit the number of participants';
$string['maxparticipantsnumber'] = 'Max. number of participants';
$string['maxoverbooking'] = 'Max. number of places on waiting list';
$string['defaultbookingoption'] = 'Default booking options';
$string['sendconfirmmail'] = 'Send confirmation e-mail';
$string['sendconfirmmailtobookingmanger'] = 'Send confirmation e-mail to booking manager';
$string['allowdelete'] = 'Allow users to cancel their booking themselves';
$string['bookingpolicy'] = 'Booking policy';
$string['confirmationmessagesettings'] = 'Confirmation e-mail settings';
$string['usernameofbookingmanager'] = 'Username of the booking manager';
$string['usernameofbookingmanager_help'] = 'Username of the user who will be displayed in the "From" field of the confirmation notifications. If the option "Send confirmation e-mail to booking manager" is enabled, this is the user who receives a copy of the confirmation notifications.';
$string['bookingmanagererror'] = 'The username entered is not valid. Either it does not exist or there are more then one users with this username (example: if you have mnet and local authentication enabled)';
$string['autoenrol'] = 'Automatically enrol users';
$string['autoenrol_help'] = 'If selected, users will be enrolled onto the relevant course as soon as they make the booking and unenrolled from that course as soon as the booking is cancelled.';
$string['bookedtext'] = 'Booking confirmation';
$string['userleave'] = 'User has cancelled his/her own booking';
$string['waitingtext'] = 'Waiting list confirmation';
$string['statuschangetext'] = 'Status change message';
$string['deletedtext'] = 'Cancelled booking message';
$string['comments'] = 'Comments';
$string['nocomments'] = 'Commenting disabled';
$string['allcomments'] = 'Everybody can comment';
$string['enrolledcomments'] = 'Only enrolled';
$string['completedcomments'] = 'Only with completed activity';
$string['ratings'] = 'Bookingoption ratings';
$string['noratings'] = 'Ratings disabled';
$string['allratings'] = 'Everybody can rate';
$string['enrolledratings'] = 'Only enrolled';
$string['completedratings'] = 'Only with completed activity';
$string['shorturl'] = 'Short URL of this option';
$string['generatenewurl'] = 'Generate new short url';
$string['notes'] = 'Booking notes';

$string['pollurlteachers_help'] = 'You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['pollurl_help'] = 'You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['bookedtext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['userleave_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['waitingtext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['notifyemail_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['statuschangetext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['deletedtext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['pollurltext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['pollurlteacherstext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['notificationtext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['beforebookedtext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['beforecompletedtext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['aftercompletedtext_help'] = 'Leave this blank to use the site default text. You can use any of the following placeholders in the text:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{email} - User email</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
<li>{times} - Session times</li>
<li>{shorturl} - Short url ob option</li>
</ul>';

$string['daystonotify_help'] = "Will work only if start and end date of option are set! 0 for disabling this functionality.";

$string['fields'] = 'Fields to display in different contexts';
$string['reportfields'] = 'Downlodable responses fields (csv, xls-Download)';
$string['responsesfields'] = 'Fields on the "manage responses" page';
$string['optionsfields'] = 'Fields on the booking options overview page';
$string['signinsheetfields'] = 'Sign-in sheet fields (PDF)';
$string['signinonesession'] = 'Display selected session time on the sign-in sheet';
$string['signinaddemptyrows'] = 'Number of empty rows to add for people who did not sign up';
$string['includeteachers'] = 'Include teachers in the sign-in sheet';
$string['choosepdftitle'] = 'Select a title for the sign-in sheet';
$string['addtogroup'] = 'Automatically enrol users in group';
$string['addtogroup_help'] = 'Automatically enrol users in group - group will be created automatically with name "Bookin name - Option name"';
$string['bookingattachment'] = 'Attachment';
$string['bookingcategory'] = 'Category';
$string['bookingduration'] = 'Duration';
$string['bookingorganizatorname'] = 'Organizer name';
$string['bookingpoints'] = 'Course points';
$string['bookingpollurl'] = 'Poll url';
$string['bookingpollurlteachers'] = 'Teachers poll url';
$string['bookingtags'] = 'Tags';
$string['customlabels'] = 'Custom labels';
$string['editinstitutions'] = 'Edit institutions';
$string['entervalidurl'] = 'Please, enter a valid URL!';
$string['eventtype'] = 'Event type';
$string['groupname'] = 'Group name';
$string['lblacceptingfrom'] = 'Name of label "Accepting from"';
$string['lblbooking'] = 'Name of label "Booking"';
$string['lblinstitution'] = 'Name of label "Institution"';
$string['lbllocation'] = 'Name of label "Location"';
$string['lblname'] = 'Name of label "Name"';
$string['lblnumofusers'] = 'Name of label "Num. of users"';
$string['lblsurname'] = 'Name of label "Surname"';
$string['maxperuser'] = 'Max current bookings per user';
$string['maxperuser_help'] = 'The maximum number of bookings an individual user can make in this activity at once. After an event end time has passed, it is no longer counted against this limit.';
$string['notificationtext'] = 'Notification message';
$string['numgenerator'] = 'Enable rec. number generation?';
$string['paginationnum'] = "N. of records - pagination";
$string['pollurlteacherstext'] = 'Message for the poll url sent to teachers';
$string['pollurltext'] = 'Message for sending poll url to booked users';
$string['reset'] = 'Reset';
$string['searchtag'] = 'Search tags';
$string['showinapi'] = 'Show in API?';
$string['whichview'] = 'Default view for booking options';
$string['enablepresence'] = 'Enable presence';
$string['removeuseronunenrol'] = 'Remove user from booking, when unenrol from course?';

// editoptions.php
$string['addeditbooking'] = 'Edit booking';
$string['addnewbookingoption'] = 'Add a new booking option';
$string['choosecourse'] = 'Choose a course';
$string['courseendtime'] = 'End time of the course';
$string['coursestarttime'] = 'Start time of the course';
$string['donotselectcourse'] = 'No course selected';
$string['importcsvbookingoption'] = 'Import CSV with booking options';
$string['importexcelbutton'] = 'Import activity completion';
$string['notificationtext'] = 'Notification text shown on activity completion.';
$string['sendmailtobooker'] = 'Book other users page: Send mail to user who books instead to users who are booked';
$string['sendmailtobooker_help'] = 'Activate this option in order to send booking confirmation mails to the user who books other users instead to users, who have been added to a booking option. This is only relevant for bookings made on the page "book other users".';
$string['startendtimeknown'] = 'Start and end time of course are known';
$string['submitandaddnew'] = 'Save and add new';
$string['waitinglisttaken'] = 'On the waiting list';
$string['groupexists'] = 'The group already exists in the target course, please choose another name for the booking option';
$string['groupdeleted'] = 'This booking instance creates groups automatically in the target course. But the group has been manually deleted in the target course. Activate the following checkbox in order to recreate the group';
$string['recreategroup'] = 'Recreate group in the target course and enrol users in group';

// importoptions.php
$string['csvfile'] = 'CSV file';
$string['dateerror'] = 'Wrong date in line {$a}: ';
$string['dateparseformat'] = 'Date parse format';
$string['dateparseformat_help'] = 'Please, use date format like specified in CSV file. Help with <a href="http://php.net/manual/en/function.date.php">this</a> resource for options.';
$string['defaultdateformat'] = 'j.n.Y H:i:s';
$string['importcsvtitle'] = 'Import CSV';
$string['importfinished'] = 'Importing finished!';
$string['noteacherfound'] = 'No teacher found in line {$a}: ';
$string['nouserfound'] = 'No user found: ';
$string['wrongfile'] = 'Wrong file!';

// Confirmation mail
$string['days'] = '{$a} days';
$string['hours'] = '{$a} hours';
$string['minutes'] = '{$a} minutes';

$string['deletedbookingsubject'] = 'Deleted booking: {$a->title} by {$a->participant}';
$string['deletedbookingmessage'] = 'Booking for following course deleted: {$a->title}

User: {$a->participant}
Title: {$a->title}
Date: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
Course: {$a->courselink}
Booking link: {$a->bookinglink}

';

$string['confirmationsubject'] = 'Booking confirmation for {$a->title}';
$string['confirmationsubjectbookingmanager'] = 'New booking for {$a->title} by {$a->participant}';
$string['confirmationmessage'] = 'Your booking has been registered


Booking status: {$a->status}
Participant:   {$a->participant}
Course:   {$a->title}
Date: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
To view all your booked courses click on the following link: {$a->bookinglink}
The associated course can be found here: {$a->courselink}

';
$string['confirmationsubjectwaitinglist'] = 'Booking status for {$a->title}';
$string['confirmationsubjectwaitinglistmanager'] = 'Booking status for {$a->title}';
$string['confirmationmessagewaitinglist'] = 'Hello {$a->participant},

Your booking request has been registered

Booking status: {$a->status}
Participant:   {$a->participant}
Course:   {$a->title}
Date: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
To view all your booked courses click on the following link: {$a->bookinglink}

';

$string['notifyemaildefaultmessage'] = 'Your booking has been registered


Booking status: {$a->status}
Participant:   {$a->participant}
Course:   {$a->title}
Date: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
To view all your booked courses click on the following link: {$a->bookinglink}
The associated course can be found here: {$a->courselink}

';
$string['notifyemail'] = 'Notification before start';

$string['userleavebookedsubject'] = 'You successfully unsubscribed from {$a->title}';
$string['userleavebookedmessage'] = 'Hello {$a->participant},

You have been unsubscribed from {$a->title}.
';

$string['statuschangebookedsubject'] = 'Booking status changed for {$a->title}';
$string['statuschangebookedmessage'] = 'Hello {$a->participant},

Your booking status has changed. You are now registered in {$a->title}.

Booking status: {$a->status}
Participant:   {$a->participant}
Course:   {$a->title}
Date: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
To view all your booked courses click on the following link: {$a->bookinglink}
The associated course can be found here: {$a->courselink}
';
$string['deletedbookingusersubject'] = 'Booking for {$a->title} cancelled';
$string['deletedbookingusermessage'] = 'Hello {$a->participant},

Your booking for {$a->title} ({$a->startdate} {$a->starttime}) has been cancelled.
';

$string['error:failedtosendconfirmation'] = 'The following user did not receive a confirmation mail

Booking status: {$a->status}
Participant:   {$a->participant}
Course:   {$a->title}
Date: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
Link: {$a->bookinglink}
Associated course: {$a->courselink}

';

$string['pollurltextsubject'] = 'Please, take the survey';
$string['pollurltextmessage'] = 'Please, take the survey

Survey url {pollurl}
';

$string['pollurlteacherstextsubject'] = 'Please, take the survey';
$string['pollurlteacherstextmessage'] = 'Please, take the survey

Survey url {pollurlteachers}
';

$string['notificationtextsubject'] = 'Info about course start!';
$string['notificationtextmessage'] = 'Course will start:

Course:   {$a->title}
Date: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}';

// report.php
$string['activitycompleted'] = 'Activity completed';
$string['addteachers'] = 'Add teachers';
$string['allmailssend'] = 'All e-mails to the users have been sent!';
$string['associatedcourse'] = 'Associated course';
$string['bookedusers'] = 'Booked users';
$string['bookingfulldidntregister'] = 'Option is full, so I didn\'t transfer all users!';
$string['booktootherbooking'] = 'Book users to other booking option';
$string['downloadallresponses'] = 'Download all responses for all booking options';
$string['copyonlythisbookingurl'] = 'Copy this booking URL';
$string['copypollurl'] = 'Copy poll URL';
$string['copytoclipboard'] = 'Copy to clipboard: Ctrl+C, Enter';
$string['editotherbooking'] = 'Other booking rules';
$string['editteachers'] = 'Edit';
$string['generaterecnum'] = "Generate numbers";
$string['generaterecnumareyousure'] = "This will generate new numbers and permanently delete the old one!";
$string['generaterecnumnotification'] = "New numbers have been generated.";
$string['gotobooking'] = '<< Bookings';
$string['lblbooktootherbooking'] = 'Name of button "Book users to other booking"';
$string['no'] = 'No';
$string['nocourse'] = 'No course selected for this booking option';
$string['nodateset'] = 'Course date not set';
$string['nousers'] = 'No users!';
$string['numrec'] = "Rec. num.";
$string['onlythisbookingurl'] = 'Link to this booking URL';
$string['optiondates'] = 'Multiple dates session';
$string['optionid'] = 'Option ID';
$string['optionmenu'] = 'This booking option';
$string['searchdate'] = 'Date';
$string['searchfinished'] = 'Course completed';
$string['searchname'] = 'First name';
$string['searchsurname'] = 'Last name';
$string['yes'] = 'Yes';
$string['no'] = 'No';
$string['onlythisbookingurl'] = 'Link to this booking URL';
$string['copyonlythisbookingurl'] = 'Copy this booking URL';
$string['copypollurl'] = 'Copy poll URL';
$string['gotobooking'] = '<< Bookings';
$string['nousers'] = 'No users!';
$string['booktootherbooking'] = 'Book users to other booking';
$string['lblbooktootherbooking'] = 'Name of button "Book users to other booking option"';
$string['toomuchusersbooked'] = 'The max number of users you can book is: {$a}';
$string['transfer'] = 'Transfer';
$string['transferheading'] = 'Transfer selected users to the selected booking option';
$string['transfersuccess'] = 'The users have successfully been transferred to the new booking option';
$string['transferproblem'] = 'The following could not be transferred due to booking option limitation or user limitation: {$a}';
$string['searchwaitinglist'] = 'On waiting list';
$string['selectatleastoneuser'] = 'Please, select at least 1 user!';
$string['selectanoption'] = 'Please, select a booking option';
$string['delnotification'] = 'You deleted {$a->del} of {$a->all} users. Users, that have completed activity, can\'t be deleted!';
$string['delnotificationactivitycompletion'] = 'You deleted {$a->del} of {$a->all} users. Users, that have completed activity, can\'t be deleted!';
$string['selectoptionid'] = 'Please, select option!';
$string['sendcustommessage'] = 'Send custom message';
$string['sendpollurltoteachers'] = 'Send poll url';
$string['toomuchusersbooked'] = 'The max number of users you can book is: {$a}';
$string['userid'] = 'UserID';
$string['userssuccessfullenrolled'] = 'All users have been enrolled!';
$string['userssuccessfullybooked'] = 'All users have been booked to the other booking option.';
$string['waitinglistusers'] = 'Users on waiting list';
$string['withselected'] = 'With selected users:';
$string['editotherbooking'] = 'Other booking rules';
$string['bookingfulldidntregister'] = 'Option is full, so I didn\'t transfer all users!';
$string['numrec'] = "Rec. num.";
$string['generaterecnum'] = "Generate numbers";
$string['generaterecnumareyousure'] = "This will generate new numbers and permanently delete the old one!";
$string['generaterecnumnotification'] = "New numbers have been generated.";
$string['activitycompleted'] = 'Activity completed';
$string['waitinglist'] = 'Waiting list';
$string['searchwaitinglist'] = 'On waiting list';
$string['ratingsuccess'] = 'The ratings were successfully updated';
$string['userid'] = 'UserID';
$string['nodateset'] = 'Course date not set';
$string['editteachers'] = 'Edit';
$string['sendpollurltoteachers'] = 'Send poll url';
$string['copytoclipboard'] = 'Copy to clipboard: Ctrl+C, Enter';
$string['yes'] = 'Yes';
$string['sendreminderemailsuccess'] = 'Notification e-mail has been sent!';
$string['sign_in_sheet_download'] = 'Download Sign in Sheet';
$string['status_complete'] = "Complete";
$string['status_incomplete'] = "Incomplete";
$string['status_noshow'] = "No show";
$string['status_failed'] = "Failed";
$string['status_unknown'] = "Unknown";
$string['status_attending'] = "Attending";
$string['presence'] = "Presence";
$string['confirmpresence'] = "Confirm presence";
$string['selectpresencestatus'] = "Choose presence status";
$string['userssuccessfullygetnewpresencestatus'] = 'All users have a new presence status.';
$string['deleteresponsesactivitycompletion'] = 'Delete all users with completed activity: {$a}';
$string['signature'] = 'Signature';
$string['userssucesfullygetnewpresencestatus'] = 'Presence status for selected users successfully updated';


// Send message
$string['activitycompletionsuccess'] = 'All selected users have been marked for activity completion';
$string['booking:communicate'] = 'Can communicate';
$string['confirmactivitycompletion'] = 'Confirm activity completion';
$string['enablecompletion'] = 'Enable manual activity completion in booking option responses';
$string['enablecompletiongroup'] = 'Manual activity completion';
$string['messagesend'] = 'Your message has been sent.';
$string['messagesubject'] = 'Subject';
$string['messagetext'] = 'Message';

// teachers.php
$string['users'] = '<< Manage responses';

// lib.php
$string['pollstrftimedate'] = '%Y-%m-%d';

// all_users.php
$string['completed'] = 'Completed';
$string['usersonlist'] = 'User on list';
$string['fullname'] = 'Full name';
$string['timecreated'] = 'Time created';
$string['sendreminderemail'] = "Send reminder e-mail";

// importexcel.php
$string['importexceltitle'] = 'Import activity completion';

// importexcel_file.php
$string['excelfile'] = 'CSV file with activity completion';

// institutions.php
$string['institutions'] = 'Institutions';
$string['addnewinstitution'] = 'Add new institution';

// institutionform.class.php
$string['institutionname'] = 'Institution name';
$string['addnewinstitution'] = 'Add new institution';
$string['successfulldeletedinstitution'] = 'Institution was deleted';
$string['csvfile_help'] = 'CSV file must contain only one column named Institution.';

// otherbooking.php
$string['otherbookingoptions'] = 'Accepting from';
$string['otherbookingnumber'] = 'Num. of users';
$string['otherbookingaddrule'] = 'Add new rule';
$string['editrule'] = "Edit";
$string['deleterule'] = 'Delete';
$string['deletedrule'] = 'Rule deleted.';

// otherbookingaddrule_form.php
$string['selectoptioninotherbooking'] = "Option";
$string['otherbookinglimit'] = "Limit";
$string['otherbookinglimit_help'] = "How many users you accept from option. If 0, you can accept unlimited users.";
$string['otherbookingsuccessfullysaved'] = 'Rule saved!';

// optiondates.php
$string['optiondatestime'] = 'Session time';
$string['optiondatesmessage'] = 'Session {$a->number}: {$a->date} <br> From: {$a->starttime} <br> To: {$a->endtime}';
$string['optiondatessuccessfullysaved'] = "Session time was saved.";
$string['optiondatessuccessfullydelete'] = "Session time was deleted.";
$string['leftandrightdate'] = '{$a->leftdate} to {$a->righttdate}';
$string['editingoptiondate'] = 'You are currently editing this session';

// locallib.php
$string['pdfdate'] = 'Booking Date(s): ';
$string['pdflocation'] = 'Location: ';
$string['pdfroom'] = 'Room: ';
$string['pdfstudentname'] = "Student Name";
$string['pdfsignature'] = "Signature";
$string['pdftodaydate'] = 'Date: ';

$string['booking:readallinstitutionusers'] = 'Show all users';

// File: settings.php
$string['icalcfg'] = 'Configuration of the ical attachements';
$string['icalcfgdesc'] = 'Configure the ical.ics files that are attached to e-mail messages. These files alow adding the booking dates to the personal calendar.';
$string['icalfieldlocation'] = 'Text to display in ical field location';
$string['icalfieldlocationdesc'] = 'Choose from the dropdown list what what text should be used for the calendar field "location"';
$string['customfield'] = 'Custom field to be set in the booking option settings. It will then be shown in the booking option overview.';
$string['customfielddesc'] = 'After adding a custom field, you can define the value for the field in the booking option settings. The value will be shown in the booking option description.';
$string['customfieldconfigure'] = 'Custom booking option fields';
$string['customfielddef'] = 'Custom booking option field';
$string['customfieldtype'] = 'Field type';
$string['textfield'] = 'Single line text input';
$string['delcustfield'] = 'Delete this field and all associated field settings in the booking options';
$string['signinlogo'] = 'Logo to display on the sign-in sheet';
$string['cfgsignin'] = 'Sign-In Sheet Configuration';
$string['cfgsignin_desc'] = 'Configure the sign-in sheet settings';
$string['pdfportrait'] = 'Portrait';
$string['pdflandscape'] = 'Landscape';
$string['signincustfields'] = 'Custom profile fields';
$string['signincustfields_desc'] = 'Select the custom profiles fields to be shown on the sign-in sheet';
$string['showcustomfields'] = 'Custom booking option fields';
$string['showcustomfields_desc'] = 'Select the custom booking option fields to be shown on the sign-in sheet';
$string['signinextracols_heading'] = 'Additional columns on the sign-in sheet';
$string['signinextracols'] = 'Additional column';
$string['signinextracols_desc'] = 'You can print up to 3 additional columns on the sign-in sheet. Fill in the column title or leave it blank for no additional column';
$string['googleapikey'] = 'Google API key';
$string['googleapikey_desc'] = 'API key for Google URL Shortener. Get it here: https://developers.google.com/url-shortener/v1/getting_started#APIKey';
$string['numberrows'] = 'Number rows';
$string['numberrowsdesc'] = 'Number each row of the sign-in sheet. Number will be displayed left of the name in the same column';
$string['multiicalfiles'] = 'Attach one ical file per date for MS Outlook 2010 compatibility';
$string['multiicalfilesdesc'] = 'Only MS Outlook 2010 does not support multiple dates within one ical file. Previous and later version do support it (Ex. Outlook365). If you want to send MS Outlook compatible dates, then activate this option in order to attach multiple ical files (one per date/event)';

// Mobile
$string['next'] = 'Next';
$string['previous'] = 'Previous';
// Privacy API.
$string['privacy:metadata:booking_answers'] = 'Represents a booking to an event';
$string['privacy:metadata:booking_answers:userid'] = 'User that is booked for this event';
$string['privacy:metadata:booking_answers:bookingid'] = 'ID of the event';
$string['privacy:metadata:booking_answers:optionid'] = 'Specifies which version of an event, eg summerterm or winterterm';
$string['privacy:metadata:booking_answers:timemodified'] = 'Timestamp when booking was last modified';
$string['privacy:metadata:booking_answers:timecreated'] = 'Timestamp when booking was created';
$string['privacy:metadata:booking_answers:waitinglist'] = 'If this user is on a waitinglist';
$string['privacy:metadata:booking_answers:status'] = 'Statusinfo for this booking';
$string['privacy:metadata:booking_answers:notes'] = 'Additional notes';
$string['privacy:metadata:booking_ratings'] = 'Represents your rating of an event';
$string['privacy:metadata:booking_ratings:userid'] = 'User that rated this event';
$string['privacy:metadata:booking_ratings:optionid'] = 'Which version of an event was rated';
$string['privacy:metadata:booking_ratings:rate'] = 'Rate that was assigned';
$string['privacy:metadata:booking_teachers'] = 'Represents the teacher of an event';
$string['privacy:metadata:booking_teachers:userid'] = 'User that is teaching this event';
$string['privacy:metadata:booking_teachers:optionid'] = 'Which version of an event is taught';
$string['privacy:metadata:booking_teachers:completed'] = 'If task is completed';
