<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

// general strings
$string['messageprovider:bookingconfirmation'] = "Buchungsbestätigungen";

// renderer.php
$string['showonlymyinstitutions'] = "Meine Institution";

// view.php
$string['addmorebookings'] = 'Buchungen hinzufügen';
$string['allowupdate'] = 'Buchungen dürfen gelöscht/aktualisiert werden';
$string['answered'] = 'Beantwortet';
$string['attachical'] = 'Einen Ical Kalendereintrag für die gesamte Dauer einer Buchung als Dateianhang in der E-Mail Benachrichtigung einfügen';
$string['attachicaldesc'] = 'E-Mail Benachrichtigungen im ical Kalenderformat hinzufügen, wenn diese Option aktiviert wird. Es wir entweder der in den Buchungsoptionen festgelegte
Termin eingefügt oder ein Event mit dem Anfangsdatum des ersten Termins einer Terminserie und dem Enddatum des letzten Termins der Terminserie.';
$string['attachicalsess'] = 'Von einer Terminserie alle Einzeltermine im ical Anhang hinzufügen';
$string['attachicalsessdesc'] = 'Im Ical-Anhang der E-Mail Benachrichtigungen werden alle einzelnen Termine einer Terminserie angeführt.';
$string['icalcancel'] = 'Einen Ical Anhang in die Benachrichtigungsmail einfügen, wenn eine Buchung storniert wurde.';
$string['icalcanceldesc'] = 'Wenn ein User eine Buchung storniert oder von der Buchungsliste entfernt wurde, ein Ical-Event mit dem stornierten Event anhängen. (Das fügt den Termin als abgesagten Termin in den Kalender ein bzw. berichtigt den Termin)';
$string['booking'] = 'Buchung';
$string['booking:addinstance'] = 'Neue Buchung anlegen';
$string['booking:choose'] = 'Buchen';
$string['booking:deleteresponses'] = 'Anworten löschen';
$string['booking:downloadresponses'] = 'Antworten herunterladen';
$string['booking:readresponses'] = 'Antworten lesen';
$string['booking:rate'] = 'Rate chosen booking options';
$string['booking:sendpollurl'] = 'Umfragelink senden';
$string['booking:sendpollurltoteachers'] = 'Umfragelink and Trainer/innen senden';
$string['booking:subscribeusers'] = 'Für andere Teilnehmer/innen Buchungen durchführen';
$string['booking:updatebooking'] = 'Buchungen verwalten';
$string['booking:viewallratings'] = 'View all raw ratings given by individuals';
$string['booking:viewanyrating'] = 'View total ratings that anyone received';
$string['booking:viewrating'] = 'View the total rating you received';
$string['bookingclose'] = 'Bis';
$string['bookingfull'] = 'Ausgebucht';
$string['bookingname'] = 'Buchungsbezeichnung';
$string['bookingopen'] = 'Offen';
$string['bookingoptionsmenu'] = 'Buchungsoptionen';
$string['bookingtext'] = 'Buchungsbeschreibung';
$string['datenotset'] = 'Datum nicht angegeben';
$string['daystonotify'] = 'Wie viele Tage vor Kursbeginn soll an die Teilnehmenden eine Benachrichtigung gesendet werden?';
$string['eventbooking_cancelled'] = 'Buchung wurde storniert';
$string['eventbookingoption_booked'] = 'Buchung durchgeführt';
$string['eventreport_viewed'] = 'Übersicht über Buchungen für eine Buchungsoption angesehen';
$string['eventuserprofilefields_updated'] = 'Nutzerprofil aktualisiert';
$string['existingsubscribers'] = 'Vorhandene Nutzer/innen';
$string['expired'] = 'Diese Aktivität wurde leider am {$a} beendet und steht nicht mehr zur Verfügung';
$string['fillinatleastoneoption'] = 'Geben Sie mindestens 2 mögliche Antworten an.';
$string['full'] = 'Ausgebucht';
$string['goenrol'] = 'Gehe zu "Buchung vornehmen"';
$string['gotop'] = 'Nach oben';
$string['havetologin'] = 'Sie müssen sich einloggen, um eine Buchung vorzunehmen';
$string['infonobookingoption'] = 'Bitte nutzen Sie den Block {$a}, um die erste Buchungsoption zu erstellen';
$string['limit'] = 'Maximale Anzahl';
$string['modulename'] = 'Buchung';
$string['modulenameplural'] = 'Buchungen';
$string['mustchooseone'] = 'Sie müssen eine Option auswählen';
$string['myoptions'] = 'Von mir verwaltete Buchungsoptionen ({$a})';
$string['noguestchoose'] = 'Gäste dürfen keine Buchungen vornehmen';
$string['noresultsviewable'] = 'Die Ergebnisse sind momentan nicht einsehbar';
$string['nosubscribers'] = 'Keine Trainer/innen zugewiesen!';
$string['notificationsubject'] = 'Demnächst stattfindender Kurs';
$string['notopenyet'] = 'Diese Aktivität ist bis {$a} nicht verfügbar';
$string['pluginadministration'] = 'Booking administration';
$string['pluginname'] = 'Booking';
$string['potentialsubscribers'] = 'Mögliche Nutzer/innen';
$string['removeresponses'] = 'Alle Antworten löschen';
$string['responses'] = 'Antworten';
$string['responsesto'] = 'Antworten zu {$a} ';
$string['spaceleft'] = 'Platz verfügbar';
$string['spacesleft'] = 'Plätze verfügbar';
$string['subscribersto'] = 'Trainer/innen für \'{$a}\'';
$string['taken'] = 'gebucht';
$string['teachers'] = 'Trainer/innen: ';
$string['timerestrict'] = 'Buchungsmöglichkeit auf diesen Zeitraum beschränken: Diese Option ist veraltet und sollte nicht mehr verwendet werden. Stattdessen verwenden Sie bitte die Optionen unter "Voraussetzungen", um die Buchungen für einen bestimmten Zeitraum zu beschränken.';
$string['timecloseoption'] = 'Buchungsmöglichkeit nur bis zu einem bestimmten Zeitpunkt ermöglichen';
$string['to'] = 'bis';
$string['viewallresponses'] = '{$a} Antworten verwalten';
$string['yourselection'] = 'Ihre Auswahl';

// subscribeusers.php
$string['cannotremovesubscriber'] = 'Um die Buchung zu stornieren, muss zuvor der Aktivitätsabschluss entfernt werden. Die Buchung wurde nicht storniert';
$string['allchangessave'] = 'Alle Änderungen wurden gespeichert.';
$string['backtoresponses'] = '<< Zurück zu den Antworten';
$string['allusersbooked'] = 'Alle {$a} Nutzer/innen wurden erfolgreich für diese Buchungsoption gebucht.';
$string['notallbooked'] = 'Folgende Nutzer/innen konnten aufgrund nicht mehr verfügbarer Plätze oder durch das Überschreiten des vorgegebenen Buchungslimits pro Nutzer/in nicht gebucht werden: {$a}';

// Bookingform
$string['address'] = 'Adresse';
$string['advancedoptions'] = 'Erweiterte Einstellungen';
$string['btnbooknowname'] = 'Bezeichnung des Buttons "Jetzt buchen"';
$string['btncacname'] = 'Bezeichnung des Buttons "Aktivitätsabschluss bestätigen"';
$string['btncancelname'] = 'Bezeichnung des Buttons "Buchung stornieren"';
$string['disablebookingusers'] = 'Buchung von Teilnehmer/innen deaktivieren - "Jetzt buchen" Button unsichtbar schalten.';
$string['howmanyusers'] = 'Wie viele Teilnehmer/innen können gebucht werden?';
$string['howmanyusers_help'] = '';
$string['institution'] = 'Institution';
$string['lblsputtname'] = 'Alternative Bezeichnung für "Umfragelink an Trainer/innen senden" verwenden';
$string['lblteachname'] = 'Alternative Bezeichnung für "Trainer/in" verwenden';
$string['limitanswers_help'] = 'Bei Änderung dieser Einstellung und vorhandenen Buchungen, werden die Buchungen für die betroffenen Nutzer/innen ohne Benachrichtigung entfernt.';
$string['location'] = 'Ort';
$string['removeafterminutes'] = 'Aktivitätsabschluss nach N Minuten entfernen';

// Categories
$string['category'] = 'Kategorie';
$string['categories'] = 'Kategorien';
$string['addcategory'] = 'Kategorien bearbeiten';
$string['forcourse'] = 'für Kurs';
$string['addnewcategory'] = 'Neue Kategorie hinzufügen';
$string['categoryname'] = 'Kategoriename';
$string['rootcategory'] = 'Übergeordnete Kategorie';
$string['selectcategory'] = 'Kategorie auswählen';
$string['editcategory'] = 'Bearbeiten';
$string['deletecategory'] = 'Löschen';
$string['deletesubcategory'] = 'Löschen Sie zuerst alle Unterkategorien dieser Kategorie!';
$string['usedinbooking'] = 'Das Löschen dieser Kategorie/n ist nicht möglich, da sie verwendet werden!';
$string['successfulldeleted'] = 'Kategorie wurde erfolgreich gelöscht!';

// view.php
$string['agreetobookingpolicy'] = 'Ich habe folgende Buchungsbedingungen gelesen und erkläre mich damit einverstanden';
$string['allbookingoptions'] = 'Nutzer/innen für alle Buchungsmöglichkeiten herunterladen';
$string['attachedfiles'] = 'Dateianhänge';
$string['availability'] = 'Noch verfügbar ';
$string['available'] = 'Plätze verfügbar';
$string['booked'] = 'Gebucht';
$string['bookedpast'] = 'Gebucht (Kurs wurde bereits beendet)';
$string['bookingdeleted'] = 'Ihre Buchung wurde erfolgreich storniert';
$string['bookingmeanwhilefull'] = 'Leider hat inzwischen jemand anderer den letzten Platz gebucht';
$string['bookingsaved'] = '<b>Vielen Dank für Ihre Buchung!</b> <br /> Ihre Buchung wurde erfolgreich gespeichert und ist somit abgeschlossen. Sie können nun weitere Online-Seminare buchen oder bereits getätigte Buchungen verwalten';
$string['booknow'] = 'Jetzt buchen';
$string['bookotherusers'] = 'Buchung für andere Nutzer/innen durchführen';
$string['cancelbooking'] = 'Buchung stornieren';
$string['closed'] = 'Buchung beendet';
$string['confirmbookingoffollowing'] = 'Bitte bestätigen Sie folgende Buchung';
$string['confirmdeletebookingoption'] = 'Möchten Sie diese Buchung wirklich löschen?';
$string['coursedate'] = 'Kurstermin';
$string['createdby'] = 'Dieses Buchungsmodul wurde von edulabs.org entwickelt';
$string['deletebooking'] = 'Wollen Sie wirklich folgende Buchung stornieren? <br /><br /> <b>{$a} </b>';
$string['deletebookingoption'] = 'Diese Buchungsoption löschen';
$string['deleteuserfrombooking'] = 'Buchung für Nutzer/innen wirklich stornieren?';
$string['download'] = 'Download';
$string['downloadusersforthisoptionods'] = 'Nutzer/innen im .ods-Format herunterladen';
$string['downloadusersforthisoptionxls'] = 'Nutzer/innen im  .xls-Format herunterladen';
$string['endtimenotset'] = 'Kursende nicht festgelegt';
$string['eventduration'] = 'Dauer';
$string['eventpoints'] = 'Punkte';
$string['mailconfirmationsent'] = 'Sie erhalten in Kürze ein Bestätigungsmail an die in Ihrem Profil angegebene E-Mail Adresse';
$string['managebooking'] = 'Verwalten';
$string['maxperuserwarning'] = 'Sie haben zur Zeit ein Limit von {$a->count}/{$a->limit} Buchungen';
$string['mustfilloutuserinfobeforebooking'] = 'Bevor Sie buchen, füllen Sie bitte noch Ihre persönlichen Buchungsdaten aus';
$string['nobookingselected'] = 'Keine Buchungsmöglichkeit ausgewählt';
$string['norighttobook'] = 'Sie können keine Buchung durchführen. Kontaktieren Sie den Administrator der Website, oder loggen Sie sich ein.';
$string['notbooked'] = 'Noch nicht gebucht';
$string['onwaitinglist'] = 'Sie sind auf der Warteliste';
$string['organizatorname'] = 'Name des Organisators';
$string['placesavailable'] = 'Verfügbare Plätze: {$a->available} von {$a->maxanswers}';
$string['pollurl'] = 'Link zur Umfrage';
$string['pollurlteachers'] = 'Trainer/innen Umfragelink';
$string['select'] = 'Auswahl';
$string['showactive'] = 'Nur buchbare Buchungsoptionen anzeigen';
$string['showallbookings'] = 'Alle Buchungsmöglichkeiten anzeigen';
$string['starttimenotset'] = 'Kursbeginn nicht festgelegt';
$string['subscribetocourse'] = 'Nutzer/innen in den Kurs einschreiben';
$string['subscribeuser'] = 'Wollen Sie diese User wirklich in diesen Kurs einschreiben';
$string['tagtemplates'] = 'Schlagwort Vorlagen';
$string['unlimited'] = 'Unbegrenzte Anzahl an Plätzen verfügbars';
$string['updatebooking'] = 'Diese Buchung bearbeiten';
$string['userdownload'] = 'Nutzer/innenliste herunterladen';
$string['waitinglist'] = 'Auf der Warteliste';
$string['waitingplacesavailable'] = 'Verfügbare Wartelistenplätze:  {$a->overbookingavailable} von {$a->maxoverbooking}';
$string['waitspaceavailable'] = 'Wartelistenplätze verfügbar';
$string['duplicatebooking'] = 'Diese Buchungsoption duplizieren';
$string['showmybookingsonly'] = 'Meine Buchungen anzeigen';


// tag templates
$string['cancel'] = 'Abbrechen';
$string['addnewtagtemplate'] = 'Hinzufügen';
$string['addnewtagtemplate'] = 'Neue Schlagwort-Vorlage hinzufügen';
$string['savenewtagtemplate'] = 'Speichern';
$string['tagtag'] = 'Schlagwort';
$string['tagtext'] = 'Schlagwort-Text';
$string['wrongdataallfields'] = 'Bitte alle Felder ausfüllen!';
$string['tagsuccessfullysaved'] = 'Schlagwort erfolgreich gespeichert.';
$string['edittag'] = 'Bearbeiten';

// mod_form
$string['signinlogoheader'] = 'Logo in der Kopfzeile auf der Unterschriftenliste';
$string['signinlogofooter'] = 'Logo in der Fußzeile auf der Unterschriftenliste';
$string['bookingoptiontext'] = 'Statusabhängiger Buchungsoptionstext';
$string['beforebookedtext'] = 'Vor der Buchung';
$string['beforecompletedtext'] = 'Nach der Buchung';
$string['aftercompletedtext'] = 'Nach Aktivitätsabschluss';
$string['conectedbooking'] = 'Vorgeschaltete Buchung';
$string['errorpagination'] = 'Geben Sie ein Zahl ein, die größer als 0 ist';
$string['notconectedbooking'] = 'Nicht vorgeschaltete Buchung';
$string['conectedbooking_help'] = 'Buchung von der Teilnehmer/innen übernommen werden. Es kann bestimmt werden wie viele Teilnehmer/innen übernommen werden.';
$string['cancancelbook'] = 'Nutzer/innen das Stornieren und buchen nach dem Buchungsstart erlauben?';
$string['addtocalendar'] = 'Zum Kalender hinzufügen';
$string['limitanswers'] = 'Teilnehmeranzahl beschränken';
$string['maxparticipantsnumber'] = 'Maximale Teilnehmeranzahl';
$string['maxoverbooking'] = 'Maximale Anzahl der Wartelistenplätze';
$string['defaultbookingoption'] = 'Standardeinstellungen für Buchungsoptionen';
$string['sendconfirmmail'] = 'Bestätigungsmail versenden';
$string['sendconfirmmailtobookingmanger'] = 'Eine Kopie des Bestätigungsmail an Buchungsverwalter senden';
$string['allowdelete'] = 'Teilnehmer/innen dürfen Buchungen selbst stornieren';
$string['bookingpolicy'] = 'Buchungsbedingungen - bookingpolicy';
$string['confirmationmessagesettings'] = 'Buchungsbestätigungseinstellungen';
$string['usernameofbookingmanager'] = 'Username des Buchungsverwalters';
$string['usernameofbookingmanager_help'] = 'Benutzername des/der Nutzer/in, der als Absender/in der Buchungsbestätigunsmitteilungen angeführt wird. Wenn die Option "Eine Kopie des Bestätigungsmail an Buchungsverwalter senden" aktiviert ist, wird die Kopie der Buchungsbestätigung an diese/n Nutzer/in gesendet.';
$string['bookingmanagererror'] = 'Der angegebene Benutzername ist ungültig. Entweder existiert der/die Nutzer/in nicht oder es gibt mehrere Nutzer/innen mit dem selben Benutzernamen (Dies ist zum Beispiel der Fall, wenn Sie MNET und lokale Authentifizierung gleichzeitig aktiviert haben)';
$string['autoenrol'] = 'Nutzer/innen automatisch einschreiben';
$string['autoenrol_help'] = 'Fals ausgewählt werden Nutzter/innen automatisch in den Kurs eingeschrieben sobald sie die Buchung durchgeführt haben und wieder ausgetragen, wenn die Buchung storniert wird.';
$string['bookedtext'] = 'Buchungsbestätigung';
$string['userleave'] = 'Nutzer/in hat Buchung storniert';
$string['waitingtext'] = 'Wartelistenbestätigung';
$string['statuschangetext'] = 'Statusänderungsbenachrichtigung';
$string['deletedtext'] = 'Stornierungsbenachrichtigung';
$string['comments'] = 'Kommentare';
$string['nocomments'] = 'Kommentare deaktiviert';
$string['allcomments'] = 'Jede/r kann kommentieren';
$string['enrolledcomments'] = 'Nur Eingeschriebene können kommentieren';
$string['completedcomments'] = 'Nur diejenigen, die Aktivität abgeschlossen haben';
$string['ratings'] = 'Bewertung der Buchungsoption';
$string['noratings'] = 'Bewertungen deaktiviert';
$string['allratings'] = 'Jede/r kann bewerten';
$string['enrolledratings'] = 'Nur Eingeschriebene können bewerten';
$string['completedratings'] = 'Nur diejenigen, die Aktivität abgeschlossen haben';
$string['shorturl'] = 'Verkürzter Link zu dieser Buchungsoption';
$string['generatenewurl'] = 'Neue Kurz-URL generieren';
$string['notes'] = 'Anmerkungen zur Buchung';

$string['pollurlteachers_help'] = 'Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer. Zum Beispiel: {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
</ul>';

$string['pollurl_help'] = 'Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer. Zum Beispiel: {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
</ul>';

$string['bookedtext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer. Zum Beispiel: {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
</ul>';

$string['userleave_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
</ul>';

$string['waitingtext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer. Zum Beispiel: {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
</ul>';

$string['statuschangetext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer. Zum Beispiel: {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
</ul>';

$string['deletedtext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer. Zum Beispiel: {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
</ul>';

$string['pollurltext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer. Zum Beispiel: {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
</ul>';

$string['pollurlteacherstext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N ist die Trainernummer. Zum Beispiel: {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - QR Code der Userid einfügen</li>
<li>{qr_username} - QR Code des Usernamen einfügen</li>
</ul>';

$string['notificationtext_help'] = 'Lassen Sie dieses Feld leer, um den Standardtext der Website zu verwenden. Folgende Platzhalter können im Text verwendet werden:
<ul>
<li>{status}</li>
<li>{participant}</li>
<li>{title}</li>
<li>{duration}</li>
<li>{starttime}</li>
<li>{endtime}</li>
<li>{startdate}</li>
<li>{enddate}</li>
<li>{courselink}</li>
<li>{bookinglink}</li>
<li>{pollurl}</li>
<li>{pollurlteachers}</li>
<li>{location}</li>
<li>{institution}</li>
<li>{address}</li>
<li>{eventtype}</li>
<li>{teacher}</li>
<li>{teacherN} - N is number of teacher ex. {teacher1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - Insert QR code with user id</li>
<li>{qr_username} - Insert QR code with user username</li>
</ul>';

$string['fields'] = 'In bestimmten Bereichen anzuzeigende Informationen';
$string['reportfields'] = 'Buchungsdatenload als csv, xls, usw.';
$string['responsesfields'] = 'Auf der "Antworten verwalten"-Seite';
$string['optionsfields'] = 'Auf der Seite der Buchungsoptionsübersicht';
$string['signinsheetfields'] = 'Auf der Unterschriftenliste (PDF-Download)';
$string['signinonesession'] = 'Ausfgewählte Session-Zeiten auf der Unterschriftenliste anzeigen';
$string['signinaddemptyrows'] = 'Anzahl an hinzuzufügenden leeren Zeilen, für Personen die sich nicht registriert haben';
$string['includeteachers'] = 'Trainer/innen in Unterschriftenliste anführen';
$string['choosepdftitle'] = 'Wählen Sie einen Titel für die Unterschriftenliste';
$string['additionalfields'] = 'Zusätzliche Felder';
$string['addtogroup'] = 'Nutzer/innen automatisch in Gruppe einschreiben';
$string['addtogroup_help'] = 'Nutzer/innen automatisch in Gruppe eintragen. Die Gruppe wird nach folgendem Schema automatisch erstellt: "Aktivitätsname - Name der Buchungsoption"';
$string['bookingattachment'] = 'Anhänge';
$string['bookingcategory'] = 'Kategorie';
$string['bookingduration'] = 'Dauer';
$string['bookingorganizatorname'] = 'Name des Veranstalters';
$string['bookingpoints'] = 'Kurspunkte';
$string['bookingpollurl'] = 'Link zur Umfrage';
$string['bookingpollurlteachers'] = 'Link zur Trainer/innen-Umfrage';
$string['bookingtags'] = 'Schlagwörter';
$string['customlabels'] = 'Benutzerdefinierte Bezeichnungen';
$string['editinstitutions'] = 'Institutionen bearbeiten';
$string['entervalidurl'] = 'Bitte geben Sie eine gültige URL an!';
$string['eventtype'] = 'Art des Ereignisses';
$string['groupname'] = 'Gruppenname';
$string['lblacceptingfrom'] = 'Bezeichnung für "Annehmen von"';
$string['lblbooking'] = 'Bezeichnung für "Buchung"';
$string['lblinstitution'] = 'Bezeichnung für "Institution"';
$string['lbllocation'] = 'Bezeichnung für "Ort"';
$string['lblname'] = 'Bezeichnung für "Name"';
$string['lblnumofusers'] = 'Bezeichnung für "Benutzer/innenanzahl"';
$string['lblsurname'] = 'Bezeichnung für "Nachname"';
$string['maxperuser'] = 'Maximale Anzahl an Buchungen pro User';
$string['maxperuser_help'] = 'Die maximale Anzahl an Buchungen, die ein/e Nutzer/in auf einmal buchen kann. Nach dem Ende des gebuchten Kurses, zählt dieser nicht mehr zum Buchungslimit.';
$string['notificationtext'] = 'Benachrichtigungstext';
$string['numgenerator'] = 'Automatische Seitennummerierung aktivieren?';
$string['paginationnum'] = "Anzahl der Einträge pro Seite";
$string['pollurlteacherstext'] = 'Umfragetext für Trainer/innen';
$string['pollurltext'] = 'Umfragelink senden';
$string['reset'] = 'Zrücksetzen';
$string['searchtag'] = 'Schlagwortsuche';
$string['showinapi'] = 'In API anzeigen?';

// editoptions.php
$string['addeditbooking'] = 'Buchung bearbeiten';
$string['addnewbookingoption'] = 'Neue Buchungsoption hinzufügen';
$string['choosecourse'] = 'Einen Kurs auswählen';
$string['courseendtime'] = 'Kursende';
$string['coursestarttime'] = 'Kursbeginn';
$string['donotselectcourse'] = 'Kein Kurs ausgewählt';
$string['importcsvbookingoption'] = 'Buchungsoptionen via CSV-Datei importieren';
$string['importexcelbutton'] = 'Aktivitätsabschluss importieren';
$string['notificationtext'] = 'Benachrichtungstext bei Aktivitätsabschluss';
$string['sendmailtobooker'] = 'Buchung für andere User durchführen: Mail an User, der Buchung durchführt, anstatt an gebuchte User senden';
$string['sendmailtobooker_help'] = 'Diese Option aktivieren, um Buchungsbestätigungsmails anstatt an die gebuchten Nutzer/innen zu senden an den/die Nutzer/in senden, die die Buchung durchgeführt hat. Dies betrifft nur Buchungen, die auf der Seite "Buchung für andere Nutzer/innen durchführen" getätigt wurden';
$string['startendtimeknown'] = 'Kursbeginn und Kursende sind bekannt';
$string['submitandaddnew'] = 'Speichern und neue Buchung hinzufügen';
$string['waitinglisttaken'] = 'Auf der Warteliste';
$string['groupexists'] = 'Die Gruppe existiert bereits im Zielkurs. Bitte verwenden Sie einen anderen Namen für die Buchungsoption';
$string['groupdeleted'] = 'Diese Buchung erstellt automatisch Gruppen im Zielkurs. Aber die Gruppe wurde im Zielkurs manuell gelöscht. Aktivieren Sie folgende Checkbox, um die Gruppe erneut zu erstellen';
$string['recreategroup'] = 'Gruppe erneut anlegen und Nutzer/innen der Gruppe zuordnen';

// importoptions.php
$string['csvfile'] = 'CSV Datei';
$string['dateerror'] = 'Falsche Datumsangabe in Zeile {$a}: ';
$string['dateparseformat'] = 'Datumsformat';
$string['dateparseformat_help'] = 'Bitte Datum so wie es im CSV definiert wurde verwenden. Hilfe unter <a href="http://php.net/manual/en/function.date.php">Datumsdokumentation</a> für diese Einstellung.';
$string['defaultdateformat'] = 'j.n.Y H:i:s';
$string['importcsvtitle'] = 'CSV-Datei importieren';
$string['importfinished'] = 'Importieren beendet!';
$string['noteacherfound'] = 'Kein/e Trainer/in gefunden: ';
$string['nouserfound'] = 'Kein/e User/in gefunden: ';
$string['wrongfile'] = 'Falsche Datei!';

// Confirmation mail
$string['days'] = '{$a} Tage';
$string['hours'] = '{$a} Stunden';
$string['minutes'] = '{$a} Minuten';

$string['deletedbookingsubject'] = 'Storno von {$a->title}, User: {$a->participant}';
$string['deletedbookingmessage'] = 'Folgende Buchung wurde storniert: {$a->title}

Nutzer/in: {$a->participant}
Titel: {$a->title}
Datum: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
Kurs: {$a->courselink}
Link: {$a->bookinglink}


';

$string['confirmationsubject'] = 'Buchungsbestätigung für {$a->title}';
$string['confirmationsubjectbookingmanager'] = 'Neue Buchung für {$a->title} von {$a->participant}';
$string['confirmationmessage'] = 'Guten Tag {$a->participant}

vielen Dank für die Buchung von {$a->title}.

Termin: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
Ihr Buchungsstatus: {$a->status}
Name:   {$a->participant}
Um eine Übersicht über alle Buchungen zu erhalten, klicken Sie auf folgenden Link:
{$a->bookinglink}

';
$string['confirmationsubjectwaitinglist'] = 'Buchung auf Warteliste für {$a->title}';
$string['confirmationsubjectwaitinglistmanager'] = 'Wartelistenbuchung für {$a->title} von {$a->participant}';
$string['confirmationmessagewaitinglist'] = 'Guten Tag {$a->participant}

vielen Dank für die Buchung von {$a->title}.

Termin: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
Ihr Buchungsstatus: {$a->status}
Name:   {$a->participant}
Um eine Übersicht über alle Buchungen zu erhalten, klicken Sie auf folgenden Link:
{$a->bookinglink}

';

$string['userleavebookedsubject'] = 'Sie wurden erfolgreich abgemeldet von: {$a->title}';
$string['userleavebookedmessage'] = 'Hallo {$a->participant},

Sie wurden erfolgreich von {$a->title} abgemeldet.
';

$string['statuschangebookedsubject'] = 'Buchungstatus für {$a->title} geändert';
$string['statuschangebookedmessage'] = 'Guten Tag {$a->participant},

Ihr Buchungsstatus hat sich geändert.
Sie sind nun fix in {$a->title} als Teilnehmer/in eingetragen.

Über folgenden Link gelangen Sie in Ihren Buchungsbereich, in dem Sie jederzeit alle Ihre Buchungen einsehen können:
{$a->bookinglink}

Termin:  {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
Ihr Buchungsstatus: {$a->status}
Teilnehmer/in:   {$a->participant}
Kurs:   {$a->title}
';

$string['deletedbookingusersubject'] = 'Stornobestätigung für {$a->title}';
$string['deletedbookingusermessage'] = 'Guten Tag {$a->participant},

Die Buchung für {$a->title} wurde erfolgreich storniert
';

$string['error:failedtosendconfirmation'] = 'Folgender User hat kein Bestätigungsmail erhalten
Die Buchung wurde erfolgreich durchgeführt, das Senden des Bestätigungsmails ist aber fehlgeschlagen.

Buchungsstatus: {$a->status}
User:   {$a->participant}
Gebuchter Kurs:   {$a->title}
Kurstermin: {$a->date}
Link: {$a->bookinglink}

';

$string['pollurltextsubject'] = 'Nehmen Sie bitte an der Umfrage teil';
$string['pollurltextmessage'] = 'Füllen Sie die Umfrage unter

Survey url {pollurl}

aus.
';

$string['pollurlteacherstextsubject'] = 'Bitte nehmen Sie an der Umfrage teil';
$string['pollurlteacherstextmessage'] = 'Bitte nehmen Sie an der Umfrage teil:

Link zur Umfrage: {pollurlteachers}
';

$string['notificationtextsubject'] = 'Information über den Kursstart!';
$string['notificationtextmessage'] = 'Kursbeginn:

Kurs:   {$a->title}
Datum: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}';

// report.php and bookingmanagusers.class.php
$string['addteachers'] = 'Trainer/innen hinzufügen';
$string['allmailssend'] = 'Alle Benachrichtigungen wurden erfolgreich versandt!';
$string['associatedcourse'] = 'Dazu gehörender Kurs';
$string['bookedusers'] = 'Gebuchte Nutzer/innen';
$string['bookingfulldidntregister'] = 'Es wurden nicht alle Nutzer/innen übertragen, da die Option bereits ausgebucht ist!';
$string['booktootherbooking'] = 'Nutzer/innen umbuchen / zu anderer Buchungsoption hinzufügen';
$string['downloadallresponses'] = 'Alle Antworten herunterladen';
$string['editotherbooking'] = 'Andere Buchungsmöglichkeiten';
$string['generaterecnum'] = "Eintragsnummern erstellen";
$string['generaterecnumareyousure'] = "Neue Nummern erstellen und die alten verwerfen!";
$string['generaterecnumnotification'] = "Neue Nummern erfolgreich erstellt.";
$string['gotobooking'] = '<< Zu den Buchungen';
$string['lblbooktootherbooking'] = 'Bezeichnung für den Button "Zu anderer Buchungsoption hinzufügen"';
$string['no'] = 'Nein';
$string['nocourse'] = 'Kein Kurs für Buchungsoption ausgewählt';
$string['nousers'] = 'Keine Nutzer/innen!';
$string['numrec'] = "Eintragsnummer.";
$string['onlythisbookingurl'] = 'Nur dieser Buchungslink';
$string['optionid'] = 'Option ID';
$string['optiondates'] = 'Mehrere Termine pro Buchungsoption';
$string['optionmenu'] = 'Diese Buchungsoption';
$string['ratingsuccess'] = 'Die Bewrtungen wurden erfolgreich aktualisiert';
$string['searchdate'] = 'Datum';
$string['searchfinished'] = 'Kurs abgeschlossen';
$string['searchname'] = 'Vorname';
$string['searchsurname'] = 'Nachname';
$string['selectatleastoneuser'] = 'Mindestens 1 Nutzer/in auswählen!';
$string['selectanoption'] = 'Wählen Sie eine Buchungsoption aus!';
$string['selectoptionid'] = 'Eine Auswahl treffen';
$string['sendcustommessage'] = 'Persönliche Nachricht senden';
$string['sendreminderemailsuccess'] = 'Benachrichtung wurde per E-Mail versandt';
$string['sign_in_sheet_download'] = 'Download Anwesenheitsliste (PDF)';
$string['status_complete'] = "Abgeschlossen";
$string['status_incomplete'] = "Nicht abgeschlossen";
$string['status_noshow'] = "Nicht aufgetaucht";
$string['status_failed'] = "Nicht erfolgreich";
$string['status_unknown'] = "Unbekannt";
$string['status_attending'] = "Teilgenommen";
$string['presence'] = "Anwesenheit";
$string['toomuchusersbooked'] = 'Maximale Anzahl an Benutzern, die Sie buchen können: {$a}';
$string['transfer'] = 'Umbuchen';
$string['transferheading'] = 'Ausgewählte Nutzer/innen in die ausgewählte Buchungsoption umbuchen';
$string['transfersuccess'] = 'Die Nutzer/innen wurden erfolgreich umgebucht';
$string['transferproblem'] = 'Die folgenden Nuther/innen konnten aufgrund einer limitierten Anzahl an Plätzen der Buchungsoption oder aufgrund individueller Limitierungen seitens des/der Nutzer/in nicht umgebucht werden: {$a}';
$string['userssuccessfullenrolled'] = 'Alle Nutzer/innen wurden erfolgreich eingeschrieben!';
$string['userssuccessfullybooked'] = 'Alle Nutzer/innen wurden erfolgreich in die andere Buchungsoption eingeschrieben.';
$string['waitinglistusers'] = 'Nutzer/innen auf der Warteliste';
$string['withselected'] = 'Ausgewählte Nutzer/innen';
$string['yes'] = 'Ja';
$string['signature'] = 'Unterschrift';
$string['userssucesfullygetnewpresencestatus'] = 'Anwesenheitsstatus für ausgewählte Nutzer/innen erfolgreich aktualisiert';

// Send message
$string['activitycompletionsuccess'] = 'Alle Nutzer/innen wurden für den Aktivitätsabschluss ausgewählt';
$string['booking:communicate'] = 'Can communicate';
$string['confirmactivitycompletion'] = 'Aktivitätsabschluss bestätigen';
$string['enablecompletion'] = 'Aktivitätsabschluss aktivieren.';
$string['enablecompletiongroup'] = 'Aktivitätsabschluss';
$string['messagesend'] = 'Die Nachricht wurde erfolgreich versandt.';
$string['messagesubject'] = 'Betreff';
$string['messagetext'] = 'Nachricht';

// teachers.php
$string['teachers'] = 'Trainer/innen';
$string['users'] = '<< Antworten bearbeiten';

// lib.php
$string['pollstrftimedate'] = '%Y-%m-%d';

// all_users.php
$string['completed'] = 'Abgeschlossen';
$string['usersonlist'] = 'Nutzer/innen';
$string['fullname'] = 'Voller Name';
$string['timecreated'] = 'Erstellungsdatum';

// importexcel.php
$string['importexceltitle'] = 'Aktivitätsabschluss importieren';

// importexcel_file.php
$string['excelfile'] = 'CSV Datei mit Aktivitätsabschluss';

// institutions.php
$string['institutions'] = 'Institutionen';
$string['addnewinstitution'] = 'Institution hinzufügen';

// institutionform.class.php
$string['institutionname'] = 'Name der Institution';
$string['addnewinstitution'] = 'Institution hinzufügen';
$string['successfulldeletedinstitution'] = 'Institution erfolgreich gelöscht';
$string['csvfile_help'] = 'CSV Datei darf nur eine Spalte mit dem Namen der Institution beinhalten.';

// otherbooking.php
$string['otherbookingoptions'] = 'Nutzer/innen dieser Buchungsoption zulassen';
$string['otherbookingnumber'] = 'Nutzer/innen-Anzahl';
$string['otherbookingaddrule'] = 'Neue Buchungsmöglichkeit hinzufügen';
$string['editrule'] = "Bearbeiten";
$string['deleterule'] = 'Löschen';
$string['deletedrule'] = 'Buchungsmöglichkeit erfolgreich gelöscht';

// otherbookingaddrule_form.php
$string['selectoptioninotherbooking'] = "Auswahl";
$string['otherbookinglimit'] = "Limit";
$string['otherbookinglimit_help'] = "Anzahl der Nutzer/innen die von dieser Buchungsoption akzeptiert werden. 0 bedeutet unlimitiert.";
$string['otherbookingsuccessfullysaved'] = 'Buchungsmöglichkeit gespeichert!';

// optiondates.php
$string['optiondatestime'] = 'Termine';
$string['optiondatesmessage'] = 'Termin {$a->number}: {$a->date} <br> Von: {$a->starttime} <br> Bis: {$a->endtime}';
$string['optiondatessuccessfullysaved'] = "Termin wurde bearbeitet";
$string['optiondatessuccessfullydelete'] = "Termin wurde gelöscht";
$string['leftandrightdate'] = '{$a->leftdate} bis {$a->righttdate}';
$string['editingoptiondate'] = 'Sie bearbeiten gerade diesen Termin';

// File: settings.php
$string['customfield'] = 'Benutzerdefiniertes Feld, dessen Wert in den Buchungsoptionseinstellungen angegeben wird und in der Buchungsoptionsübersicht angezeigt wird';
$string['customfielddesc'] = 'Definieren Sie den Wert dieses Feldes in den Buchungsoptionseinstellungen.';
$string['customfieldconfigure'] = 'Benutzerdefinierte Buchungsoptionsfelder';
$string['customfielddef'] = 'Benutzerdefiniertes Buchungsoptionsfeld';
$string['customfieldtype'] = 'Feldtyp';
$string['textfield'] = 'Eingabezeile';
$string['delcustfield'] = 'Dieses Feld und alle dazugehörenden Einstellungen in den Buchungsoptionen löschen';
$string['signinlogo'] = 'Logo für die Unterschriftenliste';
$string['cfgsignin'] = 'Einstellungen für die Unterschriftenliste';
$string['cfgsignin_desc'] = 'Konfiguration der Unterschriftenliste';
$string['pdfportrait'] = 'Hochformat';
$string['pdflandscape'] = 'Querformat';
$string['signincustfields'] = 'Anzuzeigende Profilfelder';
$string['signincustfields_desc'] = 'Wählen Sie die Profilfelder, die auf der Unterschriftenliste abgedruckt werden sollen';
$string['showcustomfields'] = 'Anzuzeigende benutzerdefnierte Buchungsoptionsfelder';
$string['showcustomfields_desc'] = 'Wählen Sie die benutzerdefinierte Buchungsoptionfelder, die auf der Unterschriftenliste abgedruckt werden sollen';
$string['signinextracols_heading'] = 'Zusätzliche Spalten auf der Unterschriftenliste';
$string['signinextracols'] = 'Extra Spalte auf der Unterschriftenliste';
$string['signinextracols_desc'] = 'Sie können bis zu 3 extra Spalten auf der Unterschriftenliste abbilden. Geben Sie den Titel der Spalte ein, oder lassen Sie das Feld leer, um keine extra Spalte anzuzeigen';
$string['numberrows'] = 'Zeilen nummerieren';
$string['numberrowsdesc'] = 'Nummerierung der Zeilen in der Unterschriftenliste aktivieren. Die Nummer wird links des Namens dargestellt';
$string['multiicalfiles'] = 'Pro Event/Termin eine ical-Datei anhängen um Kompatibilität mit MS Outlook 2010 zu gewährleisten.';
$string['multiicalfilesdesc'] = 'MS Outlook unterstützt keine Mehrfach-Termine in einer-Datei. Um mehrere Termine auch in Outlook importieren zu können, muss pro Termin eine Datei angehängt werden. Es werden dann in einem Mail mehrere ical-Dateien angehängt.';

// locallib.php
$string['pdfdate'] = 'Buchungsdaten: ';
$string['pdflocation'] = 'Ort: ';
$string['pdfroom'] = 'Raum: ';
$string['pdfstudentname'] = "Name Student/in";
$string['pdfsignature'] = "Unterschrift";
$string['pdftodaydate'] = 'Datum: ';
