# Moodle Booking Module (mod_booking)

[![Build Status](https://secure.travis-ci.org/dasistwas/moodle-mod_booking.png)](https://travis-ci.org/dasistwas/moodle-mod_booking/)


This Moodle plugin allows provides users the possibility to book moodle-courses or other offline courses or any other events. It 
has powerful features in order to manage and create booking options. 
Please contact info@edulabs.org for improvements bug reports etc.

## What Does It Do?

The booking module provides an easy to setup tool to manage course and event bookings. A typical use case would be to an event, with limited number of participants. You can setup the max. number of participants on the waitinglist. You can also automatically create sign-in sheets and mark the attendance in the module. 
Another usecase would be to offer a management system for bookings for your online courses in Moodle. You can define the max. number of participants, enrol all users automatically to the course and move users from the waitinglist to another booking option, when there is need for an additional course.
The tool also offers the possibility for specific users to manage their own event and to subscribe users to a course. Also you can limit the max. number of bookings a single user can make.

Interested in more features? [Contact us for a quote.](mailto:info@edulabs.org)

## Features
+ Max number of participants
+ Waitinglist
+ Move users to other booking options
+ Create a booking policy users have to agree to before making a booking
+ Booking confirmation e-mails with custom texts and placeholder for schedules
+ Add schedules as ical attachment to confirmation e-mails
+ Automatic course enrolments for users who successfully completed a booking
+ Manage bookings: Download all participants as CSV, Excel, PDF. Send custom messages. Send a reminder. Add notes to individual bookings
+ Customised e-mail messages for users in waitnglist or users with regular bookings. Cancellation mesages, confirmation messages.
+ Add start and end time for booking periode
+ Automatic unenrolment
+ Create and prin sign-in sheets with custom logo and text
+ Customise the information included on the sign-in sheets and the bookings overview
+ Import participants from CSV files
+ Automaitcally add events to the Moodle calendar
+ Event/course description: Add location, poll url, duration, additional files and tags
+ Organize booking instances in categories
+ Automatically enrol users in groups
+ Sort bookings by dates, etc.
+ Sending poll urls to users


## Documentation
[Visit Moodle docs wiki](http://docs.moodle.org/22/en/Booking_module) for documentation. Installation documentaion see [installation](https://docs.moodle.org/35/en/Installing_plugins)

## Communication
+ [Twitter: @edulabs_org](https://twitter.com/edulabs_org)
+ [Github: @dasistwas](https://github.com/dasistwas)

## Contributing to the booking module

Contact me on github (see above)

## Troubleshooting, Bugs, and Feedback
+ To report a bug, please [GitHub Issues](https://github.com/dasistwas/moodle-mod_booking/issues).
+ To provide feedback, please use the [GitHub Issues](https://github.com/dasistwas/moodle-mod_booking/issues).

## License
<a href="https://docs.moodle.org/dev/License" target="_blank"><img src="https://upload.wikimedia.org/wikipedia/commons/thumb/9/93/GPLv3_Logo.svg/220px-GPLv3_Logo.svg.png" alt="GPL Logo" align="right"></a>  The Moodle booking module is licensed under the [GNU General Public License, Version 3](http://www.gnu.org/licenses/gpl-3.0.html).



## Contributors
Main contributers are David Bogner and Andraž Prinčič and many others.